/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.modules.JSModuleDescriptorFactory;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerObjectType;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddAugmentationImportFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    @NotNull
    private final String myModuleName;

    public TypeScriptAddAugmentationImportFix(@NotNull PsiElement context2, @NotNull @NlsSafe String moduleName) {
        if (context2 == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(1);
        }
        super(context2);
        this.myModuleName = moduleName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        return TypeScriptAddAugmentationImportFix.getFixText(this.myModuleName);
    }

    @NotNull
    @IntentionName
    public static String getFixText(@NlsSafe String moduleName) {
        String string = JavaScriptBundle.message((String)"intention.name.import.augmentation", (Object[])new Object[]{moduleName});
        if (string == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiFile externalModule;
        if (project == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(7);
        }
        if ((externalModule = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement)) == null) {
            return;
        }
        PsiFile placePsiFile = startElement.getContainingFile();
        if (placePsiFile == null) {
            return;
        }
        String unquotedModuleName = TypeScriptAddAugmentationImportFix.getUnquotedModuleName(project, startElement, placePsiFile, externalModule);
        if (unquotedModuleName == null) {
            return;
        }
        JSAddImportExecutor executor = JSHandlersFactory.forElement(startElement).createAddImportExecutor(startElement);
        if (executor == null) {
            return;
        }
        JSModuleDescriptor.SimpleModuleDescriptor module = new JSModuleDescriptor.SimpleModuleDescriptor((PsiElement)externalModule, unquotedModuleName);
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(null, externalModule.getName(), ES6ImportPsiUtil.ImportExportType.BARE, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        executor.createImportOrUpdateExisting(new JSSimpleImportDescriptor((JSModuleDescriptor)module, info));
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
        if (target2 == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    private static String getUnquotedModuleName(@NotNull Project project, @NotNull PsiElement context2, @NotNull PsiFile placePsiFile, @NotNull PsiFile augmentationModule) {
        String path2;
        VirtualFile dstFile;
        JSNodeModuleStructure structure;
        if (project == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(10);
        }
        if (placePsiFile == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(11);
        }
        if (augmentationModule == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(12);
        }
        if ((structure = JSNodeModuleStructure.getStructure(project, dstFile = augmentationModule.getVirtualFile())) != null && StringUtil.isNotEmpty((String)(path2 = structure.getNodeModulePath(dstFile)))) {
            JSModuleDescriptor info = JSModuleDescriptorFactory.createModuleDescriptor(path2, dstFile, context2);
            return info.getModuleName();
        }
        JSModuleNameInfo moduleInfo = ES6CreateImportUtil.getExactExternalFileModuleName((PsiElement)placePsiFile, dstFile);
        return moduleInfo == null ? null : moduleInfo.getModuleName();
    }

    public static String getImportedModuleName(@NotNull PsiElement startElement) {
        PsiFile module;
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(13);
        }
        if ((module = TypeScriptAddAugmentationImportFix.getAugmentationModule(startElement)) == null) {
            return null;
        }
        String unquotedModuleName = TypeScriptAddAugmentationImportFix.getUnquotedModuleName(startElement.getProject(), startElement, startElement.getContainingFile(), module);
        if (unquotedModuleName == null) {
            return null;
        }
        PsiElement placeModule = ES6CreateImportUtil.getScopeToAdd(startElement, true);
        if (placeModule == null || module.getContainingFile().equals((Object)placeModule)) {
            return null;
        }
        JSSimpleImportDescriptor descriptor = new JSSimpleImportDescriptor((PsiElement)module, unquotedModuleName, ES6ImportPsiUtil.BARE_INFO);
        if (ES6ImportPsiUtil.findExistingES6Import(placeModule, descriptor) != null) {
            return null;
        }
        return JSCodeStyleSettings.wrapWithQuotes((PsiElement)startElement, (String)unquotedModuleName);
    }

    @Nullable
    public static PsiFile getAugmentationModule(@NotNull PsiElement startElement) {
        if (startElement == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(14);
        }
        if (!(startElement instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression expression = (JSReferenceExpression)startElement;
        List elements = JSResolveResult.toElements((ResolveResult[])expression.multiResolve(false));
        if (elements.size() == 1) {
            TypeScriptModule typeScriptModule;
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem((List)elements);
            PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)item);
            if (!(module instanceof TypeScriptModule) || !(typeScriptModule = (TypeScriptModule)module).isAugmentation()) {
                return null;
            }
            return module.getContainingFile();
        }
        if (elements.isEmpty()) {
            String name = expression.getReferenceName();
            if (name == null) {
                return null;
            }
            JSExpression qualifier = expression.getQualifier();
            if (!TypeScriptUtil.isStrictResolveQualifier((JSExpression)qualifier)) {
                return null;
            }
            JSType type2 = JSResolveUtil.getExpressionJSType((JSExpression)qualifier);
            if (type2 instanceof TypeScriptCompilerObjectType) {
                TypeScriptCompilerObjectType compilerObjectType = (TypeScriptCompilerObjectType)type2;
                type2 = compilerObjectType.getBaseType();
            }
            if (!(type2 instanceof JSTypeImpl)) {
                return null;
            }
            JSTypeImpl typeImpl = (JSTypeImpl)type2;
            JSQualifiedName qualifiedName = typeImpl.getQualifiedName();
            Collection declarations = typeImpl.getDeclarations();
            HashSet modules = new HashSet();
            for (PsiElement declaration : declarations) {
                ContainerUtil.addIfNotNull(modules, (Object)ES6PsiUtil.findExternalModule((PsiElement)declaration));
            }
            if (modules.isEmpty()) {
                return null;
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)startElement);
            if (file == null) {
                return null;
            }
            final Condition scope2 = TypeScriptConfigService.Provider.get((Project)startElement.getProject()).getAccessScope(file);
            SmartList candidates = new SmartList();
            GlobalSearchScope preScope = TypeScriptUtil.createScopeWithFilterByNodeModules((PsiElement)startElement, (PsiElement)startElement);
            DelegatingGlobalSearchScope searchScope = new DelegatingGlobalSearchScope(preScope){

                public boolean contains(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!super.contains(file)) {
                        return false;
                    }
                    return !scope2.value((Object)file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix$1", "contains"));
                }
            };
            JSClassResolver.processElementsByNameIncludingImplicit((String)name, (GlobalSearchScope)searchScope, (boolean)false, (StubIndexKey)JSIndexKeys.JS_NON_GLOBAL_SYMBOL_INDEX_KEY, el -> {
                if (TypeScriptAddAugmentationImportFix.isPrefixOfAugmentation(qualifiedName, el.getNamespace())) {
                    candidates.add(el);
                }
                return true;
            });
            for (JSPsiElementBase candidate : candidates) {
                Collection resolvedElements;
                TypeScriptModule typeScriptModule;
                PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)candidate);
                if (!(module instanceof TypeScriptModule) || !(typeScriptModule = (TypeScriptModule)module).isAugmentation() || !modules.containsAll(resolvedElements = TypeScriptAugmentationUtil.resolveAugmentation((PsiElement)module))) continue;
                return candidate.getContainingFile();
            }
        }
        return null;
    }

    private static boolean isPrefixOfAugmentation(@NotNull JSQualifiedName parent, @Nullable JSQualifiedName element2) {
        if (parent == null) {
            TypeScriptAddAugmentationImportFix.$$$reportNull$$$0(15);
        }
        if (element2 == null) {
            return false;
        }
        while (parent != null) {
            if (!Objects.equals(parent.getName(), element2.getName())) {
                return false;
            }
            parent = parent.getParent();
            if ((element2 = element2.getParent()) != null || parent == null) continue;
            return false;
        }
        return element2 != null && element2.getParent() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placePsiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "augmentationModule";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddAugmentationImportFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedModuleName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getImportedModuleName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAugmentationModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixOfAugmentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

