/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.reference.NodePathManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSNodeServicesProfilerActionKt;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptorKt;
import com.intellij.lang.typescript.lsp.LspServerActivationRule;
import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0014J\n\u0010#\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0004J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010%\u001a\u00020\u0007H\u0014J\u001a\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010+2\u0006\u0010%\u001a\u00020\u0007H\u0007J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010-\u001a\u00020.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/intellij/lang/typescript/lsp/JSNodeLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "activationRule", "Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "presentableName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;Ljava/lang/String;)V", "nodeTarget", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "value", "Lcom/intellij/util/text/SemVer;", "version", "getVersion", "()Lcom/intellij/util/text/SemVer;", "setVersion", "(Lcom/intellij/util/text/SemVer;)V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "registerRequiredDirsForRemote", "", "targetRun", "executablePath", "findPackageRootDir", "Ljava/nio/file/Path;", "fileOrDirStr", "isTargetRunInitialized", "", "addNodeOptions", "commandLineBuilder", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLineArgsFromRegistry", "convertLocalPathToTargetPath", "path", "getFilePath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findLocalFileByPath", "findLocalFileByPathAsync", "Ljava/util/concurrent/CompletableFuture;", "isSupportedFile", "lspServerListener", "Lcom/intellij/platform/lsp/api/LspServerListener;", "getLspServerListener", "()Lcom/intellij/platform/lsp/api/LspServerListener;", "intellij.javascript.backend"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJSNodeLspServerDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSNodeLspServerDescriptor.kt\ncom/intellij/lang/typescript/lsp/JSNodeLspServerDescriptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n11879#2,9:193\n13805#2:202\n13806#2:204\n11888#2:205\n1#3:203\n1#3:206\n*S KotlinDebug\n*F\n+ 1 JSNodeLspServerDescriptor.kt\ncom/intellij/lang/typescript/lsp/JSNodeLspServerDescriptor\n*L\n67#1:193,9\n67#1:202\n67#1:204\n67#1:205\n67#1:203\n*E\n"})
public abstract class JSNodeLspServerDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final LspServerActivationRule activationRule;
    @Nullable
    private NodeTargetRun nodeTarget;
    @Nullable
    private SemVer version;
    @NotNull
    private final LspServerListener lspServerListener;

    public JSNodeLspServerDescriptor(@NotNull Project project, @NotNull LspServerActivationRule activationRule, @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activationRule, (String)"activationRule");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        super(project, presentableName);
        this.activationRule = activationRule;
        this.lspServerListener = new LspServerListener(this){
            final /* synthetic */ JSNodeLspServerDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void serverInitialized(InitializeResult params) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    ServerInfo serverInfo = params.getServerInfo();
                    SemVer semVer = SemVer.parseFromText((String)(serverInfo != null ? serverInfo.getVersion() : null));
                    if (semVer == null) break block0;
                    SemVer semVer2 = semVer;
                    JSNodeLspServerDescriptor jSNodeLspServerDescriptor = this.this$0;
                    SemVer it = semVer2;
                    boolean bl = false;
                    jSNodeLspServerDescriptor.setVersion(it);
                }
            }
        };
    }

    @Nullable
    public final SemVer getVersion() {
        return this.version;
    }

    protected final void setVersion(@Nullable SemVer semVer) {
        this.version = semVer;
    }

    @NotNull
    public final GeneralCommandLine createCommandLine() {
        throw new RuntimeException();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OSProcessHandler startServerProcess() {
        void $this$mapNotNullTo$iv$iv;
        NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterManager.getInstance(this.getProject()).getInterpreterOrThrow();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"getInterpreterOrThrow(...)");
        NodeJsInterpreter interpreter2 = nodeJsInterpreter;
        LspServerLoader loader = this.activationRule.getLspServerLoader();
        NodePackageRef selectedPackageRef = loader.getSelectedPackageRef(this.getProject());
        NodePackage nodePackage = selectedPackageRef.getConstantPackage();
        if (nodePackage == null) {
            Object[] objectArray = new Object[]{this.getPresentableName()};
            throw new ExecutionException(JavaScriptBundle.message((String)"lsp.executable.error", (Object[])objectArray));
        }
        NodePackage nodePackage2 = nodePackage;
        String executablePath = loader.getAbsolutePath(this.getProject());
        if (executablePath == null) {
            Object[] objectArray = new Object[]{nodePackage2.getName()};
            throw new ExecutionException(JavaScriptBundle.message((String)"lsp.executable.error", (Object[])objectArray));
        }
        NodeTargetRun target2 = new NodeTargetRun(interpreter2, this.getProject(), null, NodeTargetRunOptions.Companion.of$default(NodeTargetRunOptions.Companion, false, null, null, 6, null), null, 16, null);
        TargetedCommandLineBuilder builder2 = target2.getCommandLineBuilder();
        if (!(target2.getRequest() instanceof LocalTargetEnvironmentRequest)) {
            this.registerRequiredDirsForRemote(target2, executablePath);
        }
        VirtualFile[] $this$mapNotNull$iv = this.getRoots();
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile = it.findChild("node_modules");
            if ((virtualFile != null ? virtualFile.getPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nodePaths = (List)destination$iv$iv;
        NodePathManager.prependNodePaths(target2, nodePaths);
        this.addNodeOptions(builder2);
        String string = this.getProject().getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            builder2.setWorkingDirectory(target2.path(it));
        }
        builder2.addParameter(target2.path(executablePath));
        builder2.addParameter("--stdio");
        builder2.setCharset(Charsets.UTF_8);
        LspServerDescriptor.LOG.info("Starting " + this.getPresentableName() + " LSP server. Node.js version " + interpreter2.getCachedVersion() + ", path: " + interpreter2.getPresentableName());
        ProcessWithCmdLine process2 = (ProcessWithCmdLine)NodeProgressUtil.withInvisibleProgress(() -> JSNodeLspServerDescriptor.startServerProcess$lambda$2(target2));
        this.nodeTarget = target2;
        if (this.version == null) {
            this.version = nodePackage2.getVersion();
        }
        return (OSProcessHandler)process2.getProcessHandler();
    }

    private final void registerRequiredDirsForRemote(NodeTargetRun targetRun, String executablePath) {
        for (VirtualFile root : this.getRoots()) {
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            targetRun.requestUploadProjectRootAndGetPath(string);
        }
        String it = PathUtil.toSystemIndependentName((String)executablePath);
        boolean bl = false;
        String nodeModulesSubPath = "/node_modules/";
        Intrinsics.checkNotNull((Object)it);
        int ind = StringsKt.lastIndexOf$default((CharSequence)it, (String)nodeModulesSubPath, (int)0, (boolean)false, (int)6, null);
        if (ind >= 0) {
            String string = it.substring(0, ind);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            targetRun.path(string);
        } else {
            Path lspPackageDir = this.findPackageRootDir(executablePath);
            if (lspPackageDir != null) {
                targetRun.path(it);
            }
        }
        targetRun.path((String)ActionsKt.runReadAction(() -> JSNodeLspServerDescriptor.registerRequiredDirsForRemote$lambda$1(this)));
    }

    private final Path findPackageRootDir(String fileOrDirStr) {
        Path dir;
        Path path2 = NioFiles.toPath((String)fileOrDirStr);
        if (path2 == null) {
            return null;
        }
        Path file = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path path3 = dir = Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? file.getParent() : file;
        while (dir != null) {
            Path path4;
            Intrinsics.checkNotNullExpressionValue((Object)dir.resolve("package.json"), (String)"resolve(...)");
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(path4, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return dir;
            }
            dir = dir.getParent();
        }
        return null;
    }

    public final boolean isTargetRunInitialized() {
        return this.nodeTarget != null;
    }

    protected void addNodeOptions(@NotNull TargetedCommandLineBuilder commandLineBuilder) {
        Intrinsics.checkNotNullParameter((Object)commandLineBuilder, (String)"commandLineBuilder");
        JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(commandLineBuilder, this.getPresentableName(), this::getCommandLineArgsFromRegistry);
        if (JSNodeServicesProfilerActionKt.isNodeServicesProfilerEnabled(this.getProject())) {
            commandLineBuilder.addParameter("--prof");
        }
    }

    @Nullable
    protected String getCommandLineArgsFromRegistry() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected final String convertLocalPathToTargetPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            v0 = this.nodeTarget;
            Intrinsics.checkNotNull((Object)v0);
            var2_2 = v0.convertLocalPathToTargetPath(path);
        }
        catch (IllegalArgumentException e) {
            v1 = this.nodeTarget;
            Intrinsics.checkNotNull((Object)v1);
            if (v1.getRequest() instanceof LocalTargetEnvironmentRequest) ** GOTO lbl-1000
            v2 = e.getMessage();
            if (v2 == null) {
                v2 = "";
            }
            if (StringsKt.startsWith$default((String)v2, (String)"No upload root registered for ", (boolean)false, (int)2, null)) {
                LspServerDescriptor.LOG.warn("Cannot convert local " + path + " to remote: " + e.getMessage());
            } else lbl-1000:
            // 2 sources

            {
                LspServerDescriptor.LOG.error((Throwable)e);
            }
            var2_2 = path;
        }
        return var2_2;
    }

    @NotNull
    public String getFilePath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return this.convertLocalPathToTargetPath(string);
    }

    @Nullable
    protected VirtualFile findLocalFileByPath(@NotNull String path2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            NodeTargetRun nodeTargetRun = this.nodeTarget;
            Intrinsics.checkNotNull((Object)nodeTargetRun);
            string = nodeTargetRun.convertTargetPathToLocalPath(path2);
        }
        catch (IllegalArgumentException e) {
            LspServerDescriptor.LOG.error((Throwable)e);
            string = path2;
        }
        String convertedPath = string;
        return super.findLocalFileByPath(convertedPath);
    }

    @ApiStatus.Internal
    @Nullable
    public final CompletableFuture<VirtualFile> findLocalFileByPathAsync(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        NodeTargetRun nodeTargetRun = this.nodeTarget;
        Intrinsics.checkNotNull((Object)nodeTargetRun);
        Promise<String> localPath = nodeTargetRun.convertTargetPathToLocal(path2);
        Promise promise = localPath.then(arg_0 -> JSNodeLspServerDescriptor.findLocalFileByPathAsync$lambda$1(arg_0 -> JSNodeLspServerDescriptor.findLocalFileByPathAsync$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return Promises.asCompletableFuture((Promise)promise);
    }

    public final boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.activationRule.isFileAcceptable(file);
    }

    @NotNull
    public LspServerListener getLspServerListener() {
        return this.lspServerListener;
    }

    private static final ProcessWithCmdLine startServerProcess$lambda$2(NodeTargetRun $target) {
        return $target.startProcessEx();
    }

    private static final String registerRequiredDirsForRemote$lambda$1(JSNodeLspServerDescriptor this$0) {
        return JSFrameworkLspServerDescriptorKt.getTypeScriptServiceDirectory(this$0.getProject());
    }

    private static final VirtualFile findLocalFileByPathAsync$lambda$0(JSNodeLspServerDescriptor this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        return super.findLocalFileByPath(it);
    }

    private static final VirtualFile findLocalFileByPathAsync$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

