/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.typescript.lsp.TypeScriptGoServiceUtilKt;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/typescript/lsp/TypeScriptGoEmbeddedService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "downloadEmbeddedTSGo", "Lkotlinx/coroutines/Deferred;", "", "project", "Lcom/intellij/openapi/project/Project;", "setExecutable", "binary", "Ljava/nio/file/Path;", "getDownloadUrl", "", "isDownloaded", "", "getEmbeddedTSGoTargetPath", "createIfNotExists", "getEmbeddedTSGoVersion", "Companion", "intellij.javascript.backend"})
@ApiStatus.Internal
public final class TypeScriptGoEmbeddedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private static final Logger myLogger;

    public TypeScriptGoEmbeddedService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @NotNull
    public final Deferred<Unit> downloadEmbeddedTSGo(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BuildersKt.async$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, this, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ TypeScriptGoEmbeddedService this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new Object[]{this.this$0.getDownloadUrl()};
                        String string = JavaScriptBundle.message((String)"typescript.compiler.configurable.options.tsGoFork.downloading", (Object[])objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.label = 1;
                        Object object2 = TasksKt.withModalProgress((Project)this.$project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$project, null){
                            int label;
                            final /* synthetic */ TypeScriptGoEmbeddedService this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Object it;
                                        E element$iv;
                                        boolean bl;
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (this.this$0.isDownloaded()) {
                                            return Unit.INSTANCE;
                                        }
                                        String downloadUrl = this.this$0.getDownloadUrl();
                                        if (downloadUrl == null) {
                                            TypeScriptGoEmbeddedService.Companion.getMyLogger$intellij_javascript_backend().error("Current architecture is not supported for TypeScript Go");
                                            return Unit.INSTANCE;
                                        }
                                        Path targetDir = this.this$0.getEmbeddedTSGoTargetPath(true);
                                        char[] cArray = new char[]{'/'};
                                        List $this$last$iv = StringsKt.split$default((CharSequence)downloadUrl, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                                        boolean $i$f$last = false;
                                        ListIterator<E> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                                        do {
                                            if (!iterator$iv.hasPrevious()) throw new NoSuchElementException("List contains no element matching the predicate.");
                                            element$iv = iterator$iv.previous();
                                            it = (String)element$iv;
                                            boolean bl2 = false;
                                            if (((CharSequence)it).length() > 0) {
                                                bl = true;
                                                continue;
                                            }
                                            bl = false;
                                        } while (!bl);
                                        String zipFileBasename = (String)element$iv;
                                        Path zipFile = targetDir.resolve(zipFileBasename);
                                        try {
                                            List<T> list;
                                            GithubDownloadUtil.downloadAtomically(null, (String)downloadUrl, (File)zipFile.toFile(), (String)"JetBrains", (String)"TypeScript-Go");
                                            new Decompressor.Zip(zipFile).extract(targetDir);
                                            Path binaryExec = TypeScriptGoServiceUtilKt.getBinaryExecutable(targetDir);
                                            if (binaryExec != null) {
                                                this.this$0.setExecutable(binaryExec);
                                            }
                                            AutoCloseable autoCloseable = Files.list(targetDir);
                                            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                                            Throwable throwable = null;
                                            try {
                                                it = (Stream)autoCloseable;
                                                boolean bl3 = false;
                                                list = it.toList();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable = throwable2;
                                                throw throwable2;
                                            }
                                            finally {
                                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                                            }
                                            localFileSystem.refreshNioFiles((Iterable)list);
                                            return Unit.INSTANCE;
                                        }
                                        catch (Exception e) {
                                            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("language.service.stopped.or.restarted");
                                            String string = e.getMessage();
                                            if (string == null) {
                                                String string2 = JavaScriptBundle.message((String)"typescript.compiler.configurable.options.tsGoFork.download.defaultFailedMessage", (Object[])new Object[0]);
                                                string = string2;
                                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                            }
                                            notificationGroup.createNotification(string, NotificationType.ERROR).notify(this.$project);
                                            TypeScriptGoEmbeddedService.Companion.getMyLogger$intellij_javascript_backend().error("Failed to download TypeScript Go fork", (Throwable)e);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void setExecutable(@NotNull Path binary) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        if (!Files.getFileStore(binary).supportsFileAttributeView("posix")) {
            return;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Set<PosixFilePermission> set = Files.getPosixFilePermissions(binary, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
        Set permissions = CollectionsKt.toMutableSet((Iterable)set);
        PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};
        CollectionsKt.addAll((Collection)permissions, (Object[])posixFilePermissionArray);
        Files.setPosixFilePermissions(binary, permissions);
    }

    @Nullable
    public final String getDownloadUrl() {
        String pattern = Registry.Companion.stringValue("typescript.embedded.ts-go.url");
        if (TypeScriptGoServiceUtilKt.getTsGoPlatform() == null || TypeScriptGoServiceUtilKt.getTsGoArch() == null) {
            myLogger.error("Current hardware is not supported by TypeScript Go: OS=" + OS.CURRENT + ", CpuArch=" + CpuArch.CURRENT);
            return null;
        }
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)pattern, (String)"${version}", (String)this.getEmbeddedTSGoVersion(), (boolean)false, (int)4, null), (String)"${platform}", (String)TypeScriptGoServiceUtilKt.getTsGoPlatform(), (boolean)false, (int)4, null), (String)"${arch}", (String)TypeScriptGoServiceUtilKt.getTsGoArch(), (boolean)false, (int)4, null);
    }

    public final boolean isDownloaded() {
        return TypeScriptGoServiceUtilKt.getBinaryExecutable(TypeScriptGoEmbeddedService.getEmbeddedTSGoTargetPath$default(this, false, 1, null)) != null;
    }

    @NotNull
    public final Path getEmbeddedTSGoTargetPath(boolean createIfNotExists) {
        Path path2 = PathManager.getSystemDir().resolve("ts-go-fork-embedded").resolve(this.getEmbeddedTSGoVersion());
        if (createIfNotExists && !Files.exists(path2, new LinkOption[0])) {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        Intrinsics.checkNotNull((Object)path2);
        return path2;
    }

    public static /* synthetic */ Path getEmbeddedTSGoTargetPath$default(TypeScriptGoEmbeddedService typeScriptGoEmbeddedService, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return typeScriptGoEmbeddedService.getEmbeddedTSGoTargetPath(bl);
    }

    @NotNull
    public final String getEmbeddedTSGoVersion() {
        return Registry.Companion.stringValue("typescript.embedded.ts-go.version");
    }

    static {
        Logger logger = Logger.getInstance(TypeScriptGoEmbeddedService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        myLogger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/typescript/lsp/TypeScriptGoEmbeddedService$Companion;", "", "<init>", "()V", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getMyLogger$intellij_javascript_backend", "()Lcom/intellij/openapi/diagnostic/Logger;", "get", "Lcom/intellij/lang/typescript/lsp/TypeScriptGoEmbeddedService;", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getMyLogger$intellij_javascript_backend() {
            return myLogger;
        }

        @NotNull
        public final TypeScriptGoEmbeddedService get() {
            Object object = ApplicationKt.getApplication().getService(TypeScriptGoEmbeddedService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TypeScriptGoEmbeddedService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

