/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSSimplifyIfStatementFix
extends InspectionJSFix {
    private final boolean myConditionAlwaysFalse;

    public JSSimplifyIfStatementFix(boolean conditionAlwaysFalse) {
        this.myConditionAlwaysFalse = conditionAlwaysFalse;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionJSBundle.message("statement.simplify.quickfix", new Object[0]);
        if (string == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element2 = descriptor.getPsiElement();
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, JSStatement.class);
        if (statement == null) {
            return;
        }
        JSSimplifyIfStatementFix.simplifyConstantStatement(statement, this.myConditionAlwaysFalse);
    }

    public static void simplifyConstantStatement(@NotNull JSStatement statement, boolean isFalse) {
        if (statement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(1);
        }
        if (statement instanceof JSIfStatement) {
            JSSimplifyIfStatementFix.simplifyConstantIf((JSIfStatement)statement, isFalse);
        }
        if (statement instanceof JSWhileStatement) {
            JSSimplifyIfStatementFix.simplifyConstantWhile((JSWhileStatement)statement, isFalse);
        }
        if (statement instanceof JSDoWhileStatement) {
            JSSimplifyIfStatementFix.simplifyConstantDoWhile((JSDoWhileStatement)statement, isFalse);
        }
    }

    private static void simplifyConstantWhile(@NotNull JSWhileStatement statement, boolean isFalse) {
        if (statement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(2);
        }
        if (isFalse) {
            JSSimplifyIfStatementFix.deleteElement((PsiElement)statement);
        }
    }

    private static void simplifyConstantDoWhile(@NotNull JSDoWhileStatement statement, boolean isFalse) {
        if (statement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(3);
        }
        if (statement.getBody() != null && isFalse) {
            JSSimplifyIfStatementFix.replaceStatementWithUnwrapping(statement.getBody(), (JSStatement)statement);
        }
    }

    private static void simplifyConstantIf(@NotNull JSIfStatement statement, boolean isFalse) {
        if (statement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(4);
        }
        JSStatement thenBranch = (JSStatement)statement.getThenBranch();
        JSStatement elseBranch = (JSStatement)statement.getElseBranch();
        if (isFalse) {
            if (elseBranch != null) {
                JSSimplifyIfStatementFix.replaceStatementWithUnwrapping(elseBranch, (JSStatement)statement);
            } else {
                JSSimplifyIfStatementFix.deleteElement((PsiElement)statement);
            }
        } else if (thenBranch != null) {
            JSSimplifyIfStatementFix.replaceStatementWithUnwrapping(thenBranch, (JSStatement)statement);
        }
    }

    private static void replaceStatementWithUnwrapping(@NotNull JSStatement branch, @NotNull JSStatement statement) throws IncorrectOperationException {
        String branchText;
        if (branch == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(5);
        }
        if (statement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(6);
        }
        if ((branchText = branch.getText()).startsWith("{") && branchText.endsWith("}")) {
            branchText = branchText.substring(1, branchText.length() - 1).trim();
        }
        JSSimplifyIfStatementFix.replaceStatementOrRemove(statement, branchText);
    }

    private static void replaceStatementOrRemove(@NotNull JSStatement statement, @NonNls @NotNull String newStatement) throws IncorrectOperationException {
        if (statement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(7);
        }
        if (newStatement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(8);
        }
        ASTNode fromText = StringUtil.isEmptyOrSpaces((String)newStatement) ? null : JSChangeUtil.createJSTreeFromTextWithContext((String)newStatement, (PsiElement)statement);
        PsiElement statementToAdd = fromText != null ? fromText.getPsi() : null;
        JSStatement anchor = statement;
        PsiElement parent = anchor.getParent();
        while (statementToAdd != null) {
            anchor = parent.addAfter(statementToAdd, (PsiElement)anchor);
            statementToAdd = PsiTreeUtil.getNextSiblingOfType((PsiElement)statementToAdd, JSStatement.class);
        }
        statement.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/control/JSSimplifyIfStatementFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/control/JSSimplifyIfStatementFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "simplifyConstantStatement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "simplifyConstantWhile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "simplifyConstantDoWhile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "simplifyConstantIf";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementWithUnwrapping";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementOrRemove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

