/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class ThrowFromFinallyBlockJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("throw.inside.finally.block.error.string", new Object[0]);
        if (string == null) {
            ThrowFromFinallyBlockJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/exception/ThrowFromFinallyBlockJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSThrowStatement(@NotNull JSThrowStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSThrowStatement(statement);
            if (!ControlFlowUtils.isInFinallyBlock((JSElement)statement)) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, new Object[0]);
        }

        public void visitJSThrowExpression(@NotNull JSThrowExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSThrowExpression(node);
            if (!ControlFlowUtils.isInFinallyBlock((JSElement)node)) {
                return;
            }
            this.registerError((PsiElement)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/exception/ThrowFromFinallyBlockJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSThrowStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSThrowExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

