/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.rider.cpp;

import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.EnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionEventsReporter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.AbstractFullLineContext;
import com.jetbrains.rd.ide.model.CheckSemanticArgs;
import com.jetbrains.rd.ide.model.CheckSemanticResult;
import com.jetbrains.rd.ide.model.CorrectnessErrorModel;
import com.jetbrains.rd.ide.model.CppContext;
import com.jetbrains.rd.ide.model.CppFullLineModel;
import com.jetbrains.rd.ide.model.CppFullLineModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.IntRangeModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.SemanticErrorSeverity;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.SpecialRangeModel;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002JX\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014H\u0016J(\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/ml/inline/completion/rider/cpp/CppSuggestionEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricher;", "<init>", "()V", "createContext", "Lcom/jetbrains/rd/ide/model/CppContext;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "enrich", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricher$Enrichment;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "suggestionOffset", "suggestion", "", "suffix", "aspectsToEnrich", "", "Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool$Aspect;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "matchedEnclosuresIndices", "createCheckResult", "result", "Lcom/jetbrains/rd/ide/model/CheckSemanticResult;", "suggestionRange", "Lcom/jetbrains/rd/ide/model/IntRangeModel;", "extraPrefixLen", "toIdea", "Lcom/intellij/ml/inline/completion/features/correctness/Severity;", "Lcom/jetbrains/rd/ide/model/SemanticErrorSeverity;", "intellij.fullLine.rider.cpp"})
@SourceDebugExtension(value={"SMAP\nCppSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/rider/cpp/CppSuggestionEnricher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n11879#2,9:103\n13805#2:112\n13806#2:114\n11888#2:115\n1#3:113\n1563#4:116\n1634#4,3:117\n*S KotlinDebug\n*F\n+ 1 CppSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/rider/cpp/CppSuggestionEnricher\n*L\n80#1:103,9\n80#1:112\n80#1:114\n80#1:115\n80#1:113\n80#1:116\n80#1:117,3\n*E\n"})
public final class CppSuggestionEnricher
implements SuggestionEnricher {
    private final CppContext createContext(PsiFile file, int offset) {
        int lineNumber = file.getFileDocument().getLineNumber(offset);
        TextRange lineRange = new TextRange(file.getFileDocument().getLineStartOffset(lineNumber), file.getFileDocument().getLineEndOffset(lineNumber));
        String string = file.getFileDocument().getText(lineRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String lineText = string;
        CppContext context = new CppContext(lineNumber, lineText);
        return context;
    }

    @Override
    @NotNull
    public SuggestionEnricher.Enrichment enrich(@NotNull Editor editor2, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull String suffix, @NotNull Set<? extends EnrichmentTool.Aspect> aspectsToEnrich, @Nullable MLCompletionSessionEventsReporter sessionLogger, @Nullable Set<Integer> matchedEnclosuresIndices) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter(aspectsToEnrich, (String)"aspectsToEnrich");
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CppFullLineModel fullLineModel = CppFullLineModel_PregeneratedKt.getCppFullLineModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
        List errors = new ArrayList();
        TextRange errorRange = new TextRange(suggestionOffset, suggestionOffset);
        Document document = FileDocumentManager.getInstance().getDocument(originalFile.getVirtualFile());
        if (document == null) {
            return new SuggestionEnricher.Enrichment(errors, originalFile, errorRange);
        }
        Document document2 = document;
        Project project2 = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId((Document)document2, (Project)project2);
        RdFrontendDocumentId rdFrontendDocumentId = rdDocumentId instanceof RdFrontendDocumentId ? (RdFrontendDocumentId)rdDocumentId : null;
        if (rdFrontendDocumentId == null) {
            return new SuggestionEnricher.Enrichment(errors, originalFile, errorRange);
        }
        RdFrontendDocumentId documentId = rdFrontendDocumentId;
        String extraPrefix = "";
        int lineIndex = document2.getLineNumber(suggestionOffset);
        String text2 = originalFile.getText();
        Intrinsics.checkNotNull((Object)text2);
        String string = text2.substring(document2.getLineStartOffset(lineIndex), document2.getLineEndOffset(lineIndex));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string)).toString(), (String)"#", (boolean)false, (int)2, null)) {
            int ppDirectiveIndex = StringsKt.indexOf$default((CharSequence)text2, (String)"#", (int)document2.getLineStartOffset(lineIndex), (boolean)false, (int)4, null);
            if (ppDirectiveIndex < suggestionOffset) {
                String string2 = text2.substring(ppDirectiveIndex, suggestionOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                extraPrefix = string2;
            }
        } else if (!CharsKt.isWhitespace((char)text2.charAt(suggestionOffset - 1))) {
            int extraPrefixOffset;
            for (extraPrefixOffset = suggestionOffset - 1; extraPrefixOffset > 0 && !CharsKt.isWhitespace((char)text2.charAt(extraPrefixOffset - 1)); --extraPrefixOffset) {
            }
            String string3 = text2.substring(extraPrefixOffset, suggestionOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            extraPrefix = string3;
        }
        IntRangeModel suggestionRange = new IntRangeModel(suggestionOffset, suggestionOffset + suggestion2.length());
        Set<Integer> set = matchedEnclosuresIndices;
        CheckSemanticArgs cppFullLineContext = new CheckSemanticArgs(documentId, extraPrefix + suggestion2, suffix, suggestionOffset - extraPrefix.length(), suggestionRange, set != null ? CollectionsKt.toList((Iterable)set) : null, (AbstractFullLineContext)this.createContext(originalFile, suggestionOffset), null);
        CheckSemanticResult checkResult = (CheckSemanticResult)RdTaskUtilKt.callWithCancellation$default((IRdCall)((IRdCall)fullLineModel.getCheckSemantic()), (Object)cppFullLineContext, (long)0L, (int)2, null);
        return this.createCheckResult(checkResult, originalFile, suggestionRange, extraPrefix.length());
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestionEnricher.Enrichment createCheckResult(CheckSemanticResult result2, PsiFile file, IntRangeModel suggestionRange, int extraPrefixLen) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Object $this$mapNotNull$iv = result2.getSpecialRanges();
        boolean $i$f$mapNotNull = false;
        SpecialRangeModel[] specialRangeModelArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            CorrectnessErrorModel it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof CorrectnessErrorModel ? (CorrectnessErrorModel)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CorrectnessErrorModel correctnessErrorModel = (CorrectnessErrorModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextRange errorRange = new TextRange(RangesKt.coerceAtLeast((int)(it.getRange().getStartRange() - extraPrefixLen), (int)0), RangesKt.coerceAtLeast((int)(it.getRange().getEndRange() - extraPrefixLen), (int)0));
            collection.add(new CorrectnessError(errorRange, this.toIdea(it.getSeverity()), it.getDebugName()));
        }
        List errors = (List)destination$iv$iv;
        return new SuggestionEnricher.Enrichment(errors, file, new TextRange(suggestionRange.getStartRange(), suggestionRange.getEndRange()));
    }

    private final Severity toIdea(SemanticErrorSeverity $this$toIdea) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toIdea.ordinal()]) {
            case 1 -> Severity.CRITICAL;
            case 2 -> Severity.ACCEPTABLE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SemanticErrorSeverity.values().length];
            try {
                nArray[SemanticErrorSeverity.CRITICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SemanticErrorSeverity.ACCEPTABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

