/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion;

import com.intellij.ml.inline.completion.execution.MLCompletionContext;
import com.intellij.ml.llm.completion.cloud.CloudCompletionRequest;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.openapi.DocumentPrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.terminal.completion.TerminalCloudCompletionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.session.TerminalOutputBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext;", "Lcom/intellij/ml/inline/completion/execution/MLCompletionContext;", "commandHistory", "Lcom/intellij/ml/llm/privacy/PSString;", "commandWithOutputHistory", "commandPrefix", "clipboardContent", "fileTree", "requestSnapshot", "Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest$Snapshot;", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest$Snapshot;)V", "getCommandHistory", "()Lcom/intellij/ml/llm/privacy/PSString;", "getCommandWithOutputHistory", "getCommandPrefix", "getClipboardContent", "getFileTree", "getRequestSnapshot", "()Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest$Snapshot;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "intellij.ml.llm.terminal.completion"})
public final class TerminalCloudCompletionContext
extends MLCompletionContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PSString commandHistory;
    @NotNull
    private final PSString commandWithOutputHistory;
    @NotNull
    private final PSString commandPrefix;
    @NotNull
    private final PSString clipboardContent;
    @NotNull
    private final PSString fileTree;
    @NotNull
    private final CloudCompletionRequest.Snapshot requestSnapshot;
    private static final int TOTAL_CHAR_LIMIT = 8000;
    private static final int CLIPBOARD_LIMIT = 500;
    private static final int FILE_TREE_LIMIT = 2000;
    private static final int COMMAND_PREFIX_LIMIT = 500;
    private static final int DETAILED_HISTORY_LIMIT = 3000;
    private static final int DETAILED_HISTORY_OUTPUT_LIMIT = 1000;

    public TerminalCloudCompletionContext(@NotNull PSString commandHistory, @NotNull PSString commandWithOutputHistory, @NotNull PSString commandPrefix, @NotNull PSString clipboardContent, @NotNull PSString fileTree, @NotNull CloudCompletionRequest.Snapshot requestSnapshot) {
        Intrinsics.checkNotNullParameter((Object)commandHistory, (String)"commandHistory");
        Intrinsics.checkNotNullParameter((Object)commandWithOutputHistory, (String)"commandWithOutputHistory");
        Intrinsics.checkNotNullParameter((Object)commandPrefix, (String)"commandPrefix");
        Intrinsics.checkNotNullParameter((Object)clipboardContent, (String)"clipboardContent");
        Intrinsics.checkNotNullParameter((Object)fileTree, (String)"fileTree");
        Intrinsics.checkNotNullParameter((Object)requestSnapshot, (String)"requestSnapshot");
        this.commandHistory = commandHistory;
        this.commandWithOutputHistory = commandWithOutputHistory;
        this.commandPrefix = commandPrefix;
        this.clipboardContent = clipboardContent;
        this.fileTree = fileTree;
        this.requestSnapshot = requestSnapshot;
    }

    @NotNull
    public final PSString getCommandHistory() {
        return this.commandHistory;
    }

    @NotNull
    public final PSString getCommandWithOutputHistory() {
        return this.commandWithOutputHistory;
    }

    @NotNull
    public final PSString getCommandPrefix() {
        return this.commandPrefix;
    }

    @NotNull
    public final PSString getClipboardContent() {
        return this.clipboardContent;
    }

    @NotNull
    public final PSString getFileTree() {
        return this.fileTree;
    }

    @Override
    @NotNull
    public CloudCompletionRequest.Snapshot getRequestSnapshot() {
        return this.requestSnapshot;
    }

    @NotNull
    public final PSString component1() {
        return this.commandHistory;
    }

    @NotNull
    public final PSString component2() {
        return this.commandWithOutputHistory;
    }

    @NotNull
    public final PSString component3() {
        return this.commandPrefix;
    }

    @NotNull
    public final PSString component4() {
        return this.clipboardContent;
    }

    @NotNull
    public final PSString component5() {
        return this.fileTree;
    }

    @NotNull
    public final CloudCompletionRequest.Snapshot component6() {
        return this.requestSnapshot;
    }

    @NotNull
    public final TerminalCloudCompletionContext copy(@NotNull PSString commandHistory, @NotNull PSString commandWithOutputHistory, @NotNull PSString commandPrefix, @NotNull PSString clipboardContent, @NotNull PSString fileTree, @NotNull CloudCompletionRequest.Snapshot requestSnapshot) {
        Intrinsics.checkNotNullParameter((Object)commandHistory, (String)"commandHistory");
        Intrinsics.checkNotNullParameter((Object)commandWithOutputHistory, (String)"commandWithOutputHistory");
        Intrinsics.checkNotNullParameter((Object)commandPrefix, (String)"commandPrefix");
        Intrinsics.checkNotNullParameter((Object)clipboardContent, (String)"clipboardContent");
        Intrinsics.checkNotNullParameter((Object)fileTree, (String)"fileTree");
        Intrinsics.checkNotNullParameter((Object)requestSnapshot, (String)"requestSnapshot");
        return new TerminalCloudCompletionContext(commandHistory, commandWithOutputHistory, commandPrefix, clipboardContent, fileTree, requestSnapshot);
    }

    public static /* synthetic */ TerminalCloudCompletionContext copy$default(TerminalCloudCompletionContext terminalCloudCompletionContext, PSString pSString, PSString pSString2, PSString pSString3, PSString pSString4, PSString pSString5, CloudCompletionRequest.Snapshot snapshot2, int n, Object object) {
        if ((n & 1) != 0) {
            pSString = terminalCloudCompletionContext.commandHistory;
        }
        if ((n & 2) != 0) {
            pSString2 = terminalCloudCompletionContext.commandWithOutputHistory;
        }
        if ((n & 4) != 0) {
            pSString3 = terminalCloudCompletionContext.commandPrefix;
        }
        if ((n & 8) != 0) {
            pSString4 = terminalCloudCompletionContext.clipboardContent;
        }
        if ((n & 0x10) != 0) {
            pSString5 = terminalCloudCompletionContext.fileTree;
        }
        if ((n & 0x20) != 0) {
            snapshot2 = terminalCloudCompletionContext.requestSnapshot;
        }
        return terminalCloudCompletionContext.copy(pSString, pSString2, pSString3, pSString4, pSString5, snapshot2);
    }

    @NotNull
    public String toString() {
        return "TerminalCloudCompletionContext(commandHistory=" + this.commandHistory + ", commandWithOutputHistory=" + this.commandWithOutputHistory + ", commandPrefix=" + this.commandPrefix + ", clipboardContent=" + this.clipboardContent + ", fileTree=" + this.fileTree + ", requestSnapshot=" + this.requestSnapshot + ")";
    }

    public int hashCode() {
        int result2 = this.commandHistory.hashCode();
        result2 = result2 * 31 + this.commandWithOutputHistory.hashCode();
        result2 = result2 * 31 + this.commandPrefix.hashCode();
        result2 = result2 * 31 + this.clipboardContent.hashCode();
        result2 = result2 * 31 + this.fileTree.hashCode();
        result2 = result2 * 31 + this.requestSnapshot.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerminalCloudCompletionContext)) {
            return false;
        }
        TerminalCloudCompletionContext terminalCloudCompletionContext = (TerminalCloudCompletionContext)other;
        if (!Intrinsics.areEqual((Object)this.commandHistory, (Object)terminalCloudCompletionContext.commandHistory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.commandWithOutputHistory, (Object)terminalCloudCompletionContext.commandWithOutputHistory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.commandPrefix, (Object)terminalCloudCompletionContext.commandPrefix)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clipboardContent, (Object)terminalCloudCompletionContext.clipboardContent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileTree, (Object)terminalCloudCompletionContext.fileTree)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestSnapshot, (Object)terminalCloudCompletionContext.requestSnapshot);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ7\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0018J+\u0010\u0019\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext$Companion;", "", "<init>", "()V", "TOTAL_CHAR_LIMIT", "", "CLIPBOARD_LIMIT", "FILE_TREE_LIMIT", "COMMAND_PREFIX_LIMIT", "DETAILED_HISTORY_LIMIT", "DETAILED_HISTORY_OUTPUT_LIMIT", "composeFrom", "Lcom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext;", "request", "Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;", "(Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildDetailedHistory", "Lkotlin/Pair;", "", "blocks", "", "Lcom/intellij/terminal/session/TerminalOutputBlock;", "text", "limit", "buildDetailedHistory$intellij_ml_llm_terminal_completion", "buildCommandHistory", "buildCommandHistory$intellij_ml_llm_terminal_completion", "generateFileTree", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "generateFileTree$intellij_ml_llm_terminal_completion", "intellij.ml.llm.terminal.completion"})
    @SourceDebugExtension(value={"SMAP\nTerminalCloudCompletionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCloudCompletionContext.kt\ncom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,151:1\n967#2,7:152\n1563#2:159\n1634#2,3:160\n1#3:163\n6572#4:164\n*S KotlinDebug\n*F\n+ 1 TerminalCloudCompletionContext.kt\ncom/intellij/ml/llm/terminal/completion/TerminalCloudCompletionContext$Companion\n*L\n36#1:152,7\n40#1:159\n40#1:160,3\n146#1:164\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final Object composeFrom(@NotNull CloudCompletionRequest request, @NotNull Continuation<? super TerminalCloudCompletionContext> $completion) {
            if (!($completion instanceof composeFrom.1)) ** GOTO lbl-1000
            var26_3 = $completion;
            if ((var26_3.label & -2147483648) != 0) {
                var26_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    Object L$13;
                    Object L$14;
                    Object L$15;
                    Object L$16;
                    Object L$17;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.composeFrom(null, (Continuation<? super TerminalCloudCompletionContext>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var33_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = request.getParameters().getFile().getViewProvider().getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDocument(...)");
                    documentContent = ExtensionsKtKt.privacySafe((Document)v0, (Project)request.getProject());
                    text = documentContent.getText();
                    blocksModel = (TerminalBlocksModel)request.getParameters().getEditor().getUserData(TerminalBlocksModel.Companion.getKEY());
                    v1 /* !! */  = blocksModel;
                    if (v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .getBlocks()) != null) {
                        $this$takeWhile$iv = (Iterable)v1 /* !! */ ;
                        $i$f$takeWhile = false;
                        list$iv = new ArrayList<E>();
                        for (T item$iv : $this$takeWhile$iv) {
                            it = (TerminalOutputBlock)item$iv;
                            $i$a$-takeWhile-TerminalCloudCompletionContext$Companion$composeFrom$blocks$1 = false;
                            if (!(it.getStartOffset() < request.getParameters().getOffset())) break;
                            list$iv.add(item$iv);
                        }
                        v2 = (List)list$iv;
                    } else {
                        v2 = CollectionsKt.emptyList();
                    }
                    blocks = v2;
                    lastBlock = (TerminalOutputBlock)CollectionsKt.lastOrNull((List)blocks);
                    if (((Collection)blocks).isEmpty() == false) {
                        $this$map$iv = blocks.subList(0, blocks.size() - 1);
                        $i$f$map = false;
                        list$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        it = $this$mapTo$iv$iv.iterator();
                        while (it.hasNext()) {
                            item$iv$iv = it.next();
                            var16_25 = (TerminalOutputBlock)item$iv$iv;
                            var18_31 = destination$iv$iv;
                            $i$a$-map-TerminalCloudCompletionContext$Companion$composeFrom$historyBlocks$1 = false;
                            var18_31.add(new TerminalOutputBlock(it.getId(), it.getStartOffset(), it.getCommandStartOffset() == -1 ? it.getStartOffset() : it.getCommandStartOffset(), it.getOutputStartOffset() == -1 ? it.getEndOffset() : it.getOutputStartOffset(), it.getEndOffset(), it.getExitCode()));
                        }
                        v3 = (List)destination$iv$iv;
                    } else {
                        v3 = CollectionsKt.emptyList();
                    }
                    historyBlocks = v3;
                    commandPrefix = lastBlock != null ? (CharSequence)text.substring(lastBlock.getCommandStartOffset(), request.getParameters().getOffset()).takeLast(500).removeSuffix("\n") : (CharSequence)"";
                    try {
                        v4 = TerminalUiUtilsKt.getClipboardText((boolean)true);
                        if (v4 == null || (v4 = StringsKt.take((String)v4, (int)500)) == null) {
                            v4 = "";
                        }
                        $this$mapTo$iv$iv = v4;
                    }
                    catch (Exception <unused var>) {
                        $this$mapTo$iv$iv = "";
                    }
                    clipboard = $this$mapTo$iv$iv;
                    projectDir = ProjectUtil.guessProjectDir((Project)request.getProject());
                    v5 = projectDir;
                    if (v5 == null) ** GOTO lbl80
                    it = v5;
                    $i$a$-let-TerminalCloudCompletionContext$Companion$composeFrom$fileTree$1 = false;
                    v6 = TerminalCloudCompletionContext.Companion.generateFileTree$intellij_ml_llm_terminal_completion(it);
                    v5 = v6;
                    if (v6 == null) ** GOTO lbl80
                    tree = v5;
                    $i$a$-let-TerminalCloudCompletionContext$Companion$composeFrom$fileTree$2 = false;
                    v7 = tree.length() > 2000 ? StringsKt.take((String)tree, (int)2000) + "..." : tree;
                    v5 = v7;
                    if (v7 != null) ** GOTO lbl81
lbl80:
                    // 3 sources

                    v5 = "";
lbl81:
                    // 2 sources

                    fileTree = v5;
                    var13_17 = this.buildDetailedHistory$intellij_ml_llm_terminal_completion(historyBlocks, text.toString(), 3000);
                    commandWithOutputHistory = (String)var13_17.component1();
                    includedCommandCount = ((Number)var13_17.component2()).intValue();
                    remainingChars = 8000 - commandPrefix.length() - clipboard.length() - fileTree.length() - commandWithOutputHistory.length();
                    commandHistory = this.buildCommandHistory$intellij_ml_llm_terminal_completion(historyBlocks.subList(0, historyBlocks.size() - includedCommandCount), text.toString(), remainingChars);
                    var23_33 = ConstantsKt.getPrivacyConst((String)fileTree);
                    var22_34 = ConstantsKt.getPrivacyConst((String)clipboard);
                    var21_35 = ConstantsKt.getPrivacyConst((String)commandPrefix.toString());
                    var20_36 = ConstantsKt.getPrivacyConst((String)commandWithOutputHistory);
                    var19_37 = ConstantsKt.getPrivacyConst((String)commandHistory);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)documentContent);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)text);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)blocksModel);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)blocks);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)lastBlock);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)historyBlocks);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)commandPrefix);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)clipboard);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)projectDir);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)fileTree);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)commandWithOutputHistory);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)commandHistory);
                    $continuation.L$13 = var19_37;
                    $continuation.L$14 = var20_36;
                    $continuation.L$15 = var21_35;
                    $continuation.L$16 = var22_34;
                    $continuation.L$17 = var23_33;
                    $continuation.I$0 = includedCommandCount;
                    $continuation.I$1 = remainingChars;
                    $continuation.label = 1;
                    v8 = request.snapshot((Continuation<? super CloudCompletionRequest.Snapshot>)$continuation);
                    if (v8 == var33_5) {
                        return var33_5;
                    }
                    ** GOTO lbl140
                }
                case 1: {
                    remainingChars = $continuation.I$1;
                    includedCommandCount = $continuation.I$0;
                    var23_33 = (PSString)$continuation.L$17;
                    var22_34 = (PSString)$continuation.L$16;
                    var21_35 = (PSString)$continuation.L$15;
                    var20_36 = (PSString)$continuation.L$14;
                    var19_37 = (PSString)$continuation.L$13;
                    commandHistory = (String)$continuation.L$12;
                    commandWithOutputHistory = (String)$continuation.L$11;
                    fileTree = (String)$continuation.L$10;
                    projectDir = (VirtualFile)$continuation.L$9;
                    clipboard = (String)$continuation.L$8;
                    commandPrefix = (CharSequence)$continuation.L$7;
                    historyBlocks = (List)$continuation.L$6;
                    lastBlock = (TerminalOutputBlock)$continuation.L$5;
                    blocks = (List)$continuation.L$4;
                    blocksModel = (TerminalBlocksModel)$continuation.L$3;
                    text = (PSString)$continuation.L$2;
                    documentContent = (DocumentPrivacyWrapper)$continuation.L$1;
                    request = (CloudCompletionRequest)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl140:
                    // 2 sources

                    var24_38 = v8;
                    var27_39 = (CloudCompletionRequest.Snapshot)var24_38;
                    var28_40 = var23_33;
                    var29_41 = var22_34;
                    var30_42 = var21_35;
                    var31_43 = var20_36;
                    var32_44 = var19_37;
                    return new TerminalCloudCompletionContext(var32_44, var31_43, var30_42, var29_41, var28_40, var27_39);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final Pair<String, Integer> buildDetailedHistory$intellij_ml_llm_terminal_completion(@NotNull List<TerminalOutputBlock> blocks, @NotNull String text2, int limit) {
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (blocks.isEmpty() || limit <= 0) {
                return new Pair((Object)"", (Object)0);
            }
            StringBuilder result2 = new StringBuilder();
            int usedChars = 0;
            int includedBlocks = 0;
            int n = ((Collection)blocks).size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    TerminalOutputBlock block = blocks.get(i);
                    String string = text2.substring(block.getStartOffset(), block.getOutputStartOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String command = StringsKt.removeSuffix((String)string, (CharSequence)"\n");
                    String string2 = text2.substring(block.getOutputStartOffset(), block.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    Object output = StringsKt.removeSuffix((String)string2, (CharSequence)"\n");
                    int commandLen = command.length();
                    int remainingLimit = limit - usedChars;
                    if (Math.min(commandLen + ((String)output).length() + 1, commandLen + 1 + 1000) > remainingLimit) break;
                    ++includedBlocks;
                    if (((String)output).length() > 1000) {
                        String trimmedMarker = "\n...[trimmed]...\n";
                        int availableForOutput = 1000 - trimmedMarker.length();
                        int prefixLen = availableForOutput / 2;
                        int suffixLen = availableForOutput - prefixLen;
                        output = StringsKt.take((String)output, (int)prefixLen) + trimmedMarker + StringsKt.takeLast((String)output, (int)suffixLen);
                    }
                    String toAdd = ((CharSequence)output).length() == 0 ? command + "\n" : command + "\n" + (String)output + "\n";
                    result2.insert(0, toAdd);
                    usedChars += toAdd.length();
                } while (0 <= n);
            }
            return new Pair((Object)result2.toString(), (Object)includedBlocks);
        }

        @NotNull
        public final String buildCommandHistory$intellij_ml_llm_terminal_completion(@NotNull List<TerminalOutputBlock> blocks, @NotNull String text2, int limit) {
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (blocks.isEmpty() || limit <= 0) {
                return "";
            }
            List result2 = new ArrayList();
            int usedChars = 0;
            int n = ((Collection)blocks).size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    TerminalOutputBlock block = blocks.get(i);
                    String string = text2.substring(block.getStartOffset(), block.getOutputStartOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String command = StringsKt.removeSuffix((String)string, (CharSequence)"\n");
                    int commandLen = command.length() + 1;
                    if (usedChars + commandLen > limit) break;
                    result2.add(command);
                    usedChars += commandLen;
                } while (0 <= n);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)result2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String generateFileTree$intellij_ml_llm_terminal_completion(@NotNull VirtualFile root) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                    object = root.getChildren();
                    if (object == null) break block2;
                    Object[] $this$sortedBy$iv = object;
                    boolean $i$f$sortedBy = false;
                    object = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            VirtualFile it = (VirtualFile)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (VirtualFile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                        }
                    });
                    if (object != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, Companion::generateFileTree$lambda$1, (int)30, null)) != null) break block3;
                }
                object = "";
            }
            return object;
        }

        private static final CharSequence generateFileTree$lambda$1(VirtualFile child) {
            return child.getName() + (child.isDirectory() ? "/" : "");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

