/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TextLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "()V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "minimumKeySize", "plot-base"})
public final class TextLegendKeyElementFactory
implements LegendKeyElementFactory {
    @Override
    @NotNull
    public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        SvgRectElement rect2 = new SvgRectElement(0.0, 0.0, size2.getX(), size2.getY());
        AestheticsUtil.INSTANCE.updateFill(rect2, p);
        Label label2 = new Label("a", 0, false, 6, null);
        TextUtil.decorate$default(TextUtil.INSTANCE, label2, p, 0.0, false, 12, null);
        label2.setLineHeight(TextUtil.INSTANCE.fontSize(p, 1.0));
        label2.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
        label2.setVerticalAnchor(Text.VerticalAnchor.CENTER);
        label2.rotate(TextUtil.INSTANCE.angle(p));
        label2.moveTo(size2.getX() / (double)2, size2.getY() / (double)2);
        SvgGElement g = new SvgGElement();
        g.children().add(rect2);
        g.children().add(label2.getRootGroup());
        return g;
    }

    @Override
    @NotNull
    public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
        return new DoubleVector(4.0, strokeWidth + (double)4);
    }
}

