/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesInitValue;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.TextGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.TextLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.CompositeLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.TextRepelSegmentLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.DoubleCircle;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.LabelForceLayout;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.TransformedRectangle;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.geom.util.DataPointAestheticsDelegate;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.NamedLineType;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 Q2\u00020\u0001:\u0001QB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\nH\u0002J0\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0014J \u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u001c\u0010I\u001a\u0004\u0018\u00010F2\b\u0010J\u001a\u0004\u0018\u00010F2\u0006\u0010=\u001a\u00020>H\u0002J*\u0010K\u001a\u0004\u0018\u00010F2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020P2\u0006\u00104\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u00104\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\n2\u0006\u00104\u001a\u00020\nH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001fR\u001e\u0010$\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b%\u0010\f\"\u0004\b&\u0010\u000eR\u001e\u0010'\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010\u000eR\u001e\u0010*\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b+\u0010\f\"\u0004\b,\u0010\u000eR\u001e\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00103\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006R"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TextRepelGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom;", "()V", "arrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "getArrowSpec", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "setArrowSpec", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;)V", "boxPadding", "", "getBoxPadding", "()Ljava/lang/Double;", "setBoxPadding", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "direction", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;", "getDirection", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;", "setDirection", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "maxIter", "", "getMaxIter", "()Ljava/lang/Integer;", "setMaxIter", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "maxOverlaps", "getMaxOverlaps", "setMaxOverlaps", "maxTime", "getMaxTime", "setMaxTime", "minSegmentLength", "getMinSegmentLength", "setMinSegmentLength", "pointPadding", "getPointPadding", "setPointPadding", "seed", "", "getSeed", "()Ljava/lang/Long;", "setSeed", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "scale", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildSegmentComponent", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "dp", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "segment", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "svgHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper$SvgElementHelper;", "getSegment", "segmentLocation", "getSegmentLocation", "pointLocation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "pointRadius", "rect", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;", "Companion", "plot-base"})
public class TextRepelGeom
extends TextGeom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Long seed;
    @Nullable
    private Integer maxIter;
    @Nullable
    private Double maxTime;
    @Nullable
    private LabelForceLayout.Direction direction;
    @Nullable
    private Double pointPadding;
    @Nullable
    private Double boxPadding;
    @Nullable
    private Integer maxOverlaps;
    @Nullable
    private Double minSegmentLength;
    @Nullable
    private ArrowSpec arrowSpec;

    @Nullable
    public final Long getSeed() {
        return this.seed;
    }

    public final void setSeed(@Nullable Long l) {
        this.seed = l;
    }

    @Nullable
    public final Integer getMaxIter() {
        return this.maxIter;
    }

    public final void setMaxIter(@Nullable Integer n) {
        this.maxIter = n;
    }

    @Nullable
    public final Double getMaxTime() {
        return this.maxTime;
    }

    public final void setMaxTime(@Nullable Double d) {
        this.maxTime = d;
    }

    @Nullable
    public final LabelForceLayout.Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@Nullable LabelForceLayout.Direction direction) {
        this.direction = direction;
    }

    @Nullable
    public final Double getPointPadding() {
        return this.pointPadding;
    }

    public final void setPointPadding(@Nullable Double d) {
        this.pointPadding = d;
    }

    @Nullable
    public final Double getBoxPadding() {
        return this.boxPadding;
    }

    public final void setBoxPadding(@Nullable Double d) {
        this.boxPadding = d;
    }

    @Nullable
    public final Integer getMaxOverlaps() {
        return this.maxOverlaps;
    }

    public final void setMaxOverlaps(@Nullable Integer n) {
        this.maxOverlaps = n;
    }

    @Nullable
    public final Double getMinSegmentLength() {
        return this.minSegmentLength;
    }

    public final void setMinSegmentLength(@Nullable Double d) {
        this.minSegmentLength = d;
    }

    @Nullable
    public final ArrowSpec getArrowSpec() {
        return this.arrowSpec;
    }

    public final void setArrowSpec(@Nullable ArrowSpec arrowSpec) {
        this.arrowSpec = arrowSpec;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        LegendKeyElementFactory[] legendKeyElementFactoryArray = new LegendKeyElementFactory[]{new TextLegendKeyElementFactory(), new TextRepelSegmentLegendKeyElementFactory()};
        return new CompositeLegendKeyElementFactory(legendKeyElementFactoryArray);
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper svgHelper2 = new GeomHelper.SvgElementHelper((Function2<? super DoubleVector, ? super DataPointAesthetics, DoubleVector>)((Function2)new Function2<DoubleVector, DataPointAesthetics, DoubleVector>(coord){
            final /* synthetic */ CoordinateSystem $coord;
            {
                this.$coord = $coord;
                super(2, Intrinsics.Kotlin.class, "toClient", "buildIntern$toClient(Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", 0);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DoubleVector p0, @NotNull DataPointAesthetics p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return TextRepelGeom.access$buildIntern$toClient(this.$coord, p0, p1);
            }
        })).setStrokeAlphaEnabled(true).setArrowSpec(this.arrowSpec);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.TEXT, ctx2);
        DoubleRectangle doubleRectangle = coord.toClient(ctx2.getAesBounds());
        DoubleVector aesBoundsCenter = doubleRectangle != null ? doubleRectangle.getCenter() : null;
        DoubleRectangle bounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), ctx2.getContentBounds().getDimension());
        HashMap boxes = new HashMap();
        HashMap circles = new HashMap();
        HashMap hjusts = new HashMap();
        HashMap vjusts = new HashMap();
        HashMap boxPaddings = new HashMap();
        for (DataPointAesthetics dp : aesthetics2.dataPoints()) {
            DoubleVector loc;
            PointShape shape;
            String text2;
            DoubleVector pointLocation;
            DoubleVector point2;
            if (dp.finiteVectorOrNull(Aes.Companion.getX(), Aes.Companion.getY()) == null || helper2.toClient(point2, dp) == null || coord.toClient(point2) == null || !bounds.contains(pointLocation) || ((CharSequence)(text2 = this.toString(dp.label(), ctx2))).length() == 0) continue;
            DataPointAesthetics pointDp = Companion.toPointAes$plot_base(dp);
            Intrinsics.checkNotNull((Object)pointDp.shape());
            double sizeUnitRatio = AesScaling.INSTANCE.sizeUnitRatio(point2, coord, this.getSizeUnit(), 2.2);
            double pointRadius = (shape.size(pointDp, sizeUnitRatio) + shape.strokeWidth(pointDp)) / (double)2;
            ((Map)circles).put(dp.index(), new DoubleCircle(pointLocation, pointRadius + this.pointPadding(sizeUnitRatio)));
            double hjust = Text.INSTANCE.toDouble(TextUtil.INSTANCE.hAnchor(dp, loc, aesBoundsCenter));
            double vjust = Text.INSTANCE.toDouble(TextUtil.INSTANCE.vAnchor(dp, loc, aesBoundsCenter));
            TransformedRectangle box = new TransformedRectangle(this.getRect(dp, loc, text2, 1.0, ctx2, aesBoundsCenter));
            ((Map)boxes).put(dp.index(), box);
            Double d = hjust;
            ((Map)hjusts).put(dp.index(), d);
            d = vjust;
            ((Map)vjusts).put(dp.index(), d);
            ((Map)boxPaddings).put(dp.index(), this.boxPadding(sizeUnitRatio));
        }
        Map map2 = boxes;
        Map map3 = circles;
        Map map4 = hjusts;
        Map map5 = vjusts;
        Map map6 = boxPaddings;
        Integer n = this.maxOverlaps;
        int n2 = n != null ? n : 10;
        Integer n3 = this.maxIter;
        int n4 = n3 != null ? n3 : 2000;
        Double d = this.maxTime;
        double d2 = d != null ? d : 5000.0;
        LabelForceLayout.Direction direction = this.direction;
        if (direction == null) {
            direction = LabelForceLayout.Direction.BOTH;
        }
        LabelForceLayout replacer = new LabelForceLayout(map2, map3, map4, map5, map6, bounds, n2, this.seed, n4, d2, direction);
        List<LabelForceLayout.LabelItem> results = replacer.doLayout();
        int n5 = results.size();
        for (int i = 0; i < n5; ++i) {
            DoubleVector pointLocation;
            PointShape shape;
            DoubleVector point3;
            DataPointAesthetics dp;
            LabelForceLayout.LabelItem result2 = results.get(i);
            if (result2.getHidden() || (dp = aesthetics2.dataPointAt(result2.getDpIndex())).finiteVectorOrNull(Aes.Companion.getX(), Aes.Companion.getY()) == null || coord.toClient(point3) == null) continue;
            String text3 = this.toString(dp.label(), ctx2);
            SvgGElement tc = this.buildTextComponent(Companion.toLabelAes$plot_base(dp), result2.getPosition(), text3, 1.0, ctx2, aesBoundsCenter);
            root.add(tc);
            DataPointAesthetics pointDp = Companion.toPointAes$plot_base(dp);
            Intrinsics.checkNotNull((Object)pointDp.shape());
            double sizeUnitRatio = AesScaling.INSTANCE.sizeUnitRatio(point3, coord, this.getSizeUnit(), 2.2);
            double pointRadius = (shape.size(pointDp, sizeUnitRatio) + shape.strokeWidth(pointDp)) / (double)2;
            DoubleSegment segmentLocation = this.getSegmentLocation(pointLocation, pointRadius, result2.getBox(), sizeUnitRatio);
            DoubleSegment segment2 = this.getSegment(segmentLocation, coord);
            if (segment2 != null) {
                root.add(this.buildSegmentComponent(Companion.toSegmentAes$plot_base(dp), segment2, svgHelper2));
            }
            targetCollector.addPoint(dp.index(), result2.getPosition(), AesScaling.INSTANCE.textSize(dp) / (double)2, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)dp), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
        }
    }

    private final SvgGElement buildSegmentComponent(DataPointAesthetics dp, DoubleSegment segment2, GeomHelper.SvgElementHelper svgHelper2) {
        SvgGElement g = new SvgGElement();
        Pair pair2 = GeomHelper.SvgElementHelper.createLine$default(svgHelper2, segment2, dp, null, 4, null);
        Intrinsics.checkNotNull((Object)pair2);
        SvgNode svg = (SvgNode)pair2.component1();
        g.children().add(svg);
        return g;
    }

    private final DoubleSegment getSegmentLocation(DoubleVector pointLocation, double pointRadius, TransformedRectangle rect2, double scale) {
        Object object = rect2.shortestSegmentToRectangleEdgeCenter(pointLocation);
        if (object == null || (object = ((DoubleSegment)object).getEnd()) == null) {
            return null;
        }
        Object locEnd = object;
        DoubleVector locStart = pointLocation.add(TransformedRectangle.Companion.savedNormalize(((DoubleVector)locEnd).subtract(pointLocation)).mul(pointRadius));
        if (locStart.subtract((DoubleVector)locEnd).length() < this.minSegmentLength(scale)) {
            return null;
        }
        return new DoubleSegment(locStart, (DoubleVector)locEnd);
    }

    private final DoubleSegment getSegment(DoubleSegment segmentLocation, CoordinateSystem coord) {
        if (segmentLocation == null) {
            return null;
        }
        DoubleVector doubleVector = coord.fromClient(segmentLocation.getStart());
        if (doubleVector == null) {
            return null;
        }
        DoubleVector start2 = doubleVector;
        DoubleVector doubleVector2 = coord.fromClient(segmentLocation.getEnd());
        if (doubleVector2 == null) {
            return null;
        }
        DoubleVector end = doubleVector2;
        return new DoubleSegment(start2, end);
    }

    private final double boxPadding(double scale) {
        Double d = this.boxPadding;
        return (d != null ? d : 0.0) * 2.2 * scale;
    }

    private final double pointPadding(double scale) {
        Double d = this.pointPadding;
        return (d != null ? d : 0.0) * 2.2 * scale;
    }

    private final double minSegmentLength(double scale) {
        Double d = this.minSegmentLength;
        return (d != null ? d : 0.0) * 2.2 * scale;
    }

    private static final DoubleVector buildIntern$toClient(CoordinateSystem $coord, DoubleVector point2, DataPointAesthetics dp) {
        return $coord.toClient(point2);
    }

    public static final /* synthetic */ DoubleVector access$buildIntern$toClient(CoordinateSystem $coord, DoubleVector point2, DataPointAesthetics dp) {
        return TextRepelGeom.buildIntern$toClient($coord, point2, dp);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0006J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TextRepelGeom$Companion;", "", "()V", "toLabelAes", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "p", "toLabelAes$plot_base", "toPointAes", "toPointAes$plot_base", "toSegmentAes", "toSegmentAes$plot_base", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataPointAesthetics toPointAes$plot_base(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return new DataPointAestheticsDelegate(p){

                @Nullable
                public <T> T get(@NotNull Aes<T> aes2) {
                    Intrinsics.checkNotNullParameter(aes2, (String)"aes");
                    Aes<T> aes3 = aes2;
                    Double value = Intrinsics.areEqual(aes3, Aes.Companion.getSIZE()) ? super.get(Aes.Companion.getPOINT_SIZE()) : (Intrinsics.areEqual(aes3, Aes.Companion.getSTROKE()) ? super.get(Aes.Companion.getPOINT_STROKE()) : super.get(aes2));
                    return (T)value;
                }
            };
        }

        @NotNull
        public final DataPointAesthetics toLabelAes$plot_base(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return new DataPointAestheticsDelegate(p){

                @Nullable
                public <T> T get(@NotNull Aes<T> aes2) {
                    Intrinsics.checkNotNullParameter(aes2, (String)"aes");
                    NamedLineType value = Intrinsics.areEqual(aes2, Aes.Companion.getLINETYPE()) ? NamedLineType.SOLID : super.get(aes2);
                    return (T)value;
                }
            };
        }

        @NotNull
        public final DataPointAesthetics toSegmentAes$plot_base(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return new DataPointAestheticsDelegate(p){

                @Nullable
                public <T> T get(@NotNull Aes<T> aes2) {
                    Intrinsics.checkNotNullParameter(aes2, (String)"aes");
                    Aes<T> aes3 = aes2;
                    Double value = Intrinsics.areEqual(aes3, Aes.Companion.getCOLOR()) ? (Intrinsics.areEqual((Object)super.get(Aes.Companion.getSEGMENT_COLOR()), (Object)AesInitValue.INSTANCE.getDEFAULT_SEGMENT_COLOR()) ? super.get(Aes.Companion.getCOLOR()) : super.get(Aes.Companion.getSEGMENT_COLOR())) : (Intrinsics.areEqual(aes3, Aes.Companion.getSIZE()) ? super.get(Aes.Companion.getSEGMENT_SIZE()) : (Intrinsics.areEqual(aes3, Aes.Companion.getALPHA()) ? (Intrinsics.areEqual((Double)super.get(Aes.Companion.getSEGMENT_ALPHA()), (double)0.999887) ? super.get(Aes.Companion.getALPHA()) : super.get(Aes.Companion.getSEGMENT_ALPHA())) : super.get(aes2)));
                    return (T)value;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

