/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.ide.TextCopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.CallTreeFilterListener;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.CalleesListItem;
import com.intellij.profiler.model.CalleesListModel;
import com.intellij.profiler.model.RichCallTreeModel;
import com.intellij.profiler.statistics.FusAwareSpeedSearchListener;
import com.intellij.profiler.statistics.FusAwareTreeExpansionListener;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.CalleesListComponent;
import com.intellij.profiler.ui.CascadeExpansion;
import com.intellij.profiler.ui.CommonProfilerTabNameWithId;
import com.intellij.profiler.ui.IdentifiableProfilerTabComponentKt;
import com.intellij.profiler.ui.MainCallTreeDataComponent;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.calltree.CallWithValueTreeTableKt;
import com.intellij.profiler.ui.callusage.ActionsKt;
import com.intellij.profiler.ui.callusage.CallUsageNodeKt;
import com.intellij.profiler.ui.callusage.CallUsagePopup;
import com.intellij.profiler.ui.callusage.CallUsageTableCellRenderer;
import com.intellij.profiler.ui.callusage.CallUsageTreeCellRenderer;
import com.intellij.profiler.ui.callusage.ExpandGroupsTreeSpeedSearch;
import com.intellij.profiler.ui.callusage.MainCallTreeUIModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010.\u001a\u00020/2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002J\b\u00100\u001a\u00020/H\u0016J\u0010\u00101\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010$H\u0002J\u0018\u00102\u001a\u00020/2\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010$H\u0002J\u0010\u00108\u001a\u0002092\u0006\u00103\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020/2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020/H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000RK\u0010\"\u001a?\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\b&\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0(0'\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\b&0#\u00a2\u0006\u0002\b%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u001d\"\u0004\b6\u00107\u00a8\u0006>"}, d2={"Lcom/intellij/profiler/ui/callusage/CallTreeComponent;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/api/CallTreeFilterListener;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/openapi/Disposable;", "parentComponent", "Lcom/intellij/profiler/ui/MainCallTreeDataComponent;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/ui/MainCallTreeDataComponent;Lcom/intellij/profiler/api/ValueMetric;)V", "value", "Lcom/intellij/profiler/model/RichCallTreeModel;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "model", "getModel", "()Lcom/intellij/profiler/model/RichCallTreeModel;", "setModel", "(Lcom/intellij/profiler/model/RichCallTreeModel;)V", "componentId", "Lcom/intellij/profiler/ui/CommonProfilerTabNameWithId;", "myFusAwareTreeExpansionListener", "Lcom/intellij/profiler/statistics/FusAwareTreeExpansionListener;", "treeTable", "Lcom/intellij/ui/components/JBTreeTable;", "getTreeTable", "()Lcom/intellij/ui/components/JBTreeTable;", "isDiff", "", "()Z", "popup", "Lcom/intellij/profiler/ui/callusage/CallUsagePopup;", "bottomCalleesList", "Lcom/intellij/profiler/ui/CalleesListComponent;", "calleesListCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/profiler/model/CalleesListModel;", "Lcom/intellij/profiler/model/CalleesListItem;", "lastCalleesListNode", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "messages", "Lcom/intellij/util/messages/MessageBusConnection;", "update", "", "settingsChanged", "selectedCallTreeNode", "updateBottomCalleesList", "node", "calleesListVisible", "getCalleesListVisible", "setCalleesListVisible", "(Z)V", "nodeText", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "dispose", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCallTreeComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTreeComponent.kt\ncom/intellij/profiler/ui/callusage/CallTreeComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,213:1\n1#2:214\n1#2:217\n72#3,2:215\n*S KotlinDebug\n*F\n+ 1 CallTreeComponent.kt\ncom/intellij/profiler/ui/callusage/CallTreeComponent\n*L\n173#1:217\n173#1:215,2\n*E\n"})
public final class CallTreeComponent
extends BorderLayoutPanel
implements CallTreeFilterListener,
UiDataProvider,
Disposable {
    @NotNull
    private final MainCallTreeDataComponent parentComponent;
    @NotNull
    private final ValueMetric metric;
    @Nullable
    private RichCallTreeModel<BaseCallStackElement> model;
    @NotNull
    private final CommonProfilerTabNameWithId componentId;
    @NotNull
    private final FusAwareTreeExpansionListener myFusAwareTreeExpansionListener;
    @NotNull
    private final JBTreeTable treeTable;
    @NotNull
    private final CallUsagePopup popup;
    @NotNull
    private final CalleesListComponent bottomCalleesList;
    @NotNull
    private final ConcurrentMap<CallTreeNode<BaseCallStackElement>, CalleesListModel<BaseCallStackElement, CalleesListItem<BaseCallStackElement>>> calleesListCache;
    @Nullable
    private volatile CallTreeNode<? extends BaseCallStackElement> lastCalleesListNode;
    @NotNull
    private final OnePixelSplitter splitter;
    @NotNull
    private final MessageBusConnection messages;

    /*
     * WARNING - void declaration
     */
    public CallTreeComponent(@NotNull MainCallTreeDataComponent parentComponent, @NotNull ValueMetric metric) {
        void $this$_init__u24lambda_u240;
        Object $this$splitter_u24lambda_u240;
        JBTreeTable $this$treeTable_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.parentComponent = parentComponent;
        this.metric = metric;
        this.componentId = CommonProfilerTabNameWithId.Companion.getCallTree(this.parentComponent.isSubComponent());
        this.myFusAwareTreeExpansionListener = new FusAwareTreeExpansionListener(this.parentComponent.getProject(), this.componentId);
        JBTreeTable jBTreeTable = object = new JBTreeTable((TreeTableModel)new MainCallTreeUIModel(null, null, null, false, 15, null));
        CallTreeComponent callTreeComponent = this;
        boolean bl = false;
        $this$treeTable_u24lambda_u240.setDefaultRenderer(Object.class, (TableCellRenderer)new CallUsageTableCellRenderer(this.metric, null, 2, null));
        $this$treeTable_u24lambda_u240.getTree().putClientProperty((Object)Control.Painter.KEY, (Object)Control.Painter.COMPACT);
        $this$treeTable_u24lambda_u240.getTree().setCellRenderer((TreeCellRenderer)new CallUsageTreeCellRenderer($this$treeTable_u24lambda_u240, this.parentComponent));
        ProfilerUIUtilsKt.applyDefaultBackground($this$treeTable_u24lambda_u240);
        MouseAdapter listener2 = new MouseAdapter($this$treeTable_u24lambda_u240, this){
            final /* synthetic */ JBTreeTable $this_apply;
            final /* synthetic */ CallTreeComponent this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handlePopupMouseEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handlePopupMouseEvent(e);
            }

            private final void handlePopupMouseEvent(MouseEvent e) {
                int row;
                if (!e.isPopupTrigger()) {
                    return;
                }
                Object object = e.getSource();
                int n = object instanceof JTable ? this.$this_apply.getTable().rowAtPoint(e.getPoint()) : (row = object instanceof JTree ? this.$this_apply.getTree().getClosestRowForLocation(e.getX(), e.getY()) : -1);
                if (row < 0) {
                    return;
                }
                this.$this_apply.getTree().setSelectionRow(row);
                ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, CallTreeComponent.access$getParentComponent$p(this.this$0).getProject(), ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_CONTEXT_MENU, CallTreeComponent.access$getComponentId$p(this.this$0), null, 8, null);
                CallUsagePopup callUsagePopup = CallTreeComponent.access$getPopup$p(this.this$0);
                Object object2 = e.getSource();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.awt.Component");
                callUsagePopup.show((Component)object2, e.getX(), e.getY());
            }
        };
        $this$treeTable_u24lambda_u240.getTree().addMouseListener((MouseListener)listener2);
        $this$treeTable_u24lambda_u240.getTable().addMouseListener((MouseListener)listener2);
        $this$treeTable_u24lambda_u240.getTree().addTreeExpansionListener((TreeExpansionListener)new CascadeExpansion(this.myFusAwareTreeExpansionListener));
        Alarm navigationDelayedAlarm = new Alarm((Disposable)this.parentComponent);
        $this$treeTable_u24lambda_u240.getTree().addTreeSelectionListener(arg_0 -> CallTreeComponent.treeTable$lambda$0$0(this, navigationDelayedAlarm, $this$treeTable_u24lambda_u240, arg_0));
        callTreeComponent.treeTable = object;
        this.popup = CallUsagePopup.Companion.of((Component)((Object)this), this.parentComponent);
        this.bottomCalleesList = new CalleesListComponent(this.parentComponent, this, this.metric, null, null, 24, null);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.calleesListCache = concurrentMap;
        $this$treeTable_u24lambda_u240 = object = new OnePixelSplitter(true, 0.5f);
        callTreeComponent = this;
        boolean bl2 = false;
        $this$splitter_u24lambda_u240.setFirstComponent((JComponent)this.treeTable);
        $this$splitter_u24lambda_u240.setSecondComponent((JComponent)((Object)this.bottomCalleesList));
        $this$splitter_u24lambda_u240.getSecondComponent().setVisible(((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getCallTreeState().getShowCalleesList());
        callTreeComponent.splitter = object;
        this.messages = ApplicationManager.getApplication().getMessageBus().connect();
        Disposer.register((Disposable)this.parentComponent, (Disposable)this);
        $this$splitter_u24lambda_u240 = object = ActionsKt.createActionToolbar(this).getComponent();
        callTreeComponent = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u240.setBorder(JBUI.Borders.compound((Border)IdeBorderFactory.createBorder((int)4), (Border)$this$_init__u24lambda_u240.getBorder()));
        callTreeComponent.addToLeft((Component)object);
        this.addToCenter((Component)this.splitter);
        Object $this$_init__u24lambda_u242 = object = new ExpandGroupsTreeSpeedSearch(this.parentComponent.getGroupingController(), this.treeTable, (Function1<? super TreePath, String>)((Function1)arg_0 -> CallTreeComponent._init_$lambda$1(this, arg_0)));
        boolean bl4 = false;
        $this$_init__u24lambda_u242.addChangeListener((PropertyChangeListener)new FusAwareSpeedSearchListener(this.parentComponent.getProject(), this.componentId));
        this.messages.subscribe(CallTreeFilterListener.Companion.getTOPIC(), (Object)this);
        this.update(this.model);
    }

    @Nullable
    public final RichCallTreeModel<BaseCallStackElement> getModel() {
        return this.model;
    }

    public final void setModel(@Nullable RichCallTreeModel<BaseCallStackElement> value) {
        if (Intrinsics.areEqual(this.model, value)) {
            return;
        }
        this.model = value;
        this.calleesListCache.clear();
        this.update(value);
    }

    @NotNull
    public final JBTreeTable getTreeTable() {
        return this.treeTable;
    }

    public final boolean isDiff() {
        return this.parentComponent.isDiff();
    }

    private final void update(RichCallTreeModel<BaseCallStackElement> model2) {
        if (model2 == null) {
            this.setCalleesListVisible(false);
            this.treeTable.setModel((TreeTableModel)new MainCallTreeUIModel(null, null, null, false, 15, null));
            return;
        }
        this.treeTable.setModel((TreeTableModel)new MainCallTreeUIModel(model2, this.metric, null, this.isDiff(), 4, null));
        if (!this.treeTable.getTree().isEmpty()) {
            this.treeTable.getTree().setSelectionRow(0);
            if (this.treeTable.getTree().getRowCount() == 1) {
                Tree tree = this.treeTable.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
                FusAwareTreeExpansionListener.Companion.underSuppressedExpansion((JTree)tree, () -> CallTreeComponent.update$lambda$0(this));
            }
        }
    }

    @Override
    public void settingsChanged() {
        ActionsKt.settingsChanged(this.treeTable, (Function1<? super MainCallTreeUIModel, Unit>)((Function1)CallTreeComponent::settingsChanged$lambda$0));
    }

    private final CallTreeNode<BaseCallStackElement> selectedCallTreeNode() {
        TreeTableModel treeTableModel = this.treeTable.getModel();
        MainCallTreeUIModel mainCallTreeUIModel = treeTableModel instanceof MainCallTreeUIModel ? (MainCallTreeUIModel)treeTableModel : null;
        if (mainCallTreeUIModel == null) {
            return null;
        }
        MainCallTreeUIModel uiModel = mainCallTreeUIModel;
        Object object = this.treeTable.getTree().getLastSelectedPathComponent();
        if (object == null) {
            return null;
        }
        Object selectedUINode = object;
        return uiModel.getUIVisibleNodeView((CallTreeNode)selectedUINode).getMaybeWrappedVisibleTreeNode();
    }

    private final void updateBottomCalleesList(CallTreeNode<? extends BaseCallStackElement> node) {
        this.bottomCalleesList.setDataAsync((Function1<? super ProgressIndicator, ? extends CalleesListModel<BaseCallStackElement, CalleesListItem<BaseCallStackElement>>>)((Function1)arg_0 -> CallTreeComponent.updateBottomCalleesList$lambda$0(node, this, arg_0)));
    }

    public final boolean getCalleesListVisible() {
        return this.splitter.getSecondComponent().isVisible();
    }

    public final void setCalleesListVisible(boolean value) {
        this.splitter.getSecondComponent().setVisible(value);
        ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getCallTreeState().setShowCalleesList(value);
        CallTreeNode<BaseCallStackElement> selectedNode = this.selectedCallTreeNode();
        if (selectedNode != this.lastCalleesListNode) {
            this.updateBottomCalleesList(selectedNode);
        }
    }

    private final String nodeText(BaseCallStackElement node) {
        return this.parentComponent.getCallStackElementRenderer().getText(node);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(IdentifiableProfilerTabComponentKt.getSELECTED_TAB_COMPONENT_ID(), (Object)this.componentId);
        sink.set(CallUsageNodeKt.getSELECTED_CALL_USAGE(), this.selectedCallTreeNode());
        RichCallTreeModel<BaseCallStackElement> richCallTreeModel = this.model;
        sink.set(CallUsageNodeKt.getMODEL_ROOT(), richCallTreeModel != null ? richCallTreeModel.getCallTree() : null);
        sink.set(CallWithValueTreeTableKt.getSELECTED_ELEMENT(), (object = this.selectedCallTreeNode()) != null && (object = (CallWithValue)object.getData()) != null ? (BaseCallStackElement)object.getCall() : null);
        Object usage = this.treeTable.getTree().getLastSelectedPathComponent();
        DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
        sink.set(dataKey, (Object)new TextCopyProvider(usage, this){
            final /* synthetic */ Object $usage;
            final /* synthetic */ CallTreeComponent this$0;
            {
                this.$usage = $usage;
                this.this$0 = $receiver;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public List<String> getTextLinesToCopy() {
                if (this.$usage == null) {
                    return null;
                }
                TreeModel treeModel = this.this$0.getTreeTable().getTree().getModel();
                Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.callusage.MainCallTreeUIModel");
                MainCallTreeUIModel mainCallTreeUIModel = (MainCallTreeUIModel)((Object)treeModel);
                Object object = this.$usage;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.profiler.model.CallTreeNode<com.intellij.profiler.api.BaseCallStackElement>");
                CallUsageTreeCellRenderer.Companion.TreeNodeUIData treeNodeUIData = CallUsageTreeCellRenderer.Companion.createUIData(mainCallTreeUIModel, (CallTreeNode)object);
                if (treeNodeUIData == null) {
                    return null;
                }
                CallUsageTreeCellRenderer.Companion.TreeNodeUIData uiData = treeNodeUIData;
                return CollectionsKt.listOf((Object)CallTreeComponent.access$nodeText(this.this$0, uiData.getVisibleNode()));
            }
        });
    }

    public void dispose() {
        this.messages.disconnect();
    }

    private static final void treeTable$lambda$0$0(CallTreeComponent this$0, Alarm $navigationDelayedAlarm, JBTreeTable $this_apply, TreeSelectionEvent it) {
        if (this$0.getCalleesListVisible()) {
            this$0.updateBottomCalleesList(this$0.selectedCallTreeNode());
        }
        if (this$0.parentComponent.getCurrentTabInfo$intellij_profiler_common() == CommonProfilerTabNameWithId.CALL_TREE && ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getCallTreeState().getNavigateToSelected()) {
            BaseCallStackElement call;
            CallTreeNode<BaseCallStackElement> callTreeNode = this$0.selectedCallTreeNode();
            BaseCallStackElement baseCallStackElement = callTreeNode != null && (callTreeNode = (CallWithValue)callTreeNode.getData()) != null ? (BaseCallStackElement)callTreeNode.getCall() : (call = null);
            if (call != null) {
                $navigationDelayedAlarm.cancelAllRequests();
                $navigationDelayedAlarm.addRequest(() -> CallTreeComponent.treeTable$lambda$0$0$0(this$0, call, $this_apply), 250);
            }
        }
    }

    private static final void treeTable$lambda$0$0$0(CallTreeComponent this$0, BaseCallStackElement $call, JBTreeTable $this_apply) {
        Project project = this$0.parentComponent.getProject();
        Tree tree = $this_apply.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
        UtilsKt.navigateToSourceWithSingleClick$default(project, $call, (JComponent)tree, null, 8, null);
    }

    private static final String _init_$lambda$1(CallTreeComponent this$0, TreePath treePath) {
        String string;
        String string2;
        BaseCallStackElement call;
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        Object object = treePath.getLastPathComponent();
        Object object2 = object instanceof CallTreeNode ? (CallTreeNode)object : null;
        BaseCallStackElement baseCallStackElement = call = object2 != null && (object2 = (CallWithValue)object2.getData()) != null ? (BaseCallStackElement)object2.getCall() : null;
        if (baseCallStackElement != null) {
            BaseCallStackElement p0 = baseCallStackElement;
            boolean bl = false;
            string2 = this$0.nodeText(p0);
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    private static final Unit update$lambda$0(CallTreeComponent this$0) {
        TreeUtil.expand((JTree)((JTree)this$0.treeTable.getTree()), (int)2);
        return Unit.INSTANCE;
    }

    private static final Unit settingsChanged$lambda$0(MainCallTreeUIModel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.fireModelChanged();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final CalleesListModel updateBottomCalleesList$lambda$0(CallTreeNode $node, CallTreeComponent this$0, ProgressIndicator it) {
        CalleesListModel calleesListModel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($node == null) {
            calleesListModel = CalleesListModel.Companion.empty();
            return calleesListModel;
        }
        RichCallTreeModel<BaseCallStackElement> richCallTreeModel = this$0.model;
        if (richCallTreeModel != null) {
            CalleesListModel calleesListModel2;
            void $this$getOrPut$iv;
            RichCallTreeModel<BaseCallStackElement> it2 = richCallTreeModel;
            boolean bl = false;
            ConcurrentMap<CallTreeNode<BaseCallStackElement>, CalleesListModel<BaseCallStackElement, CalleesListItem<BaseCallStackElement>>> concurrentMap = this$0.calleesListCache;
            CallTreeNode key$iv = $node;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                CalleesListModel<BaseCallStackElement, CalleesListItem<BaseCallStackElement>> default$iv = it2.calleesList((BaseCallStackElement)((Object)$node));
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            if ((calleesListModel2 = (CalleesListModel)object) != null) {
                CalleesListModel calleesListModel3;
                CalleesListModel it3 = calleesListModel3 = calleesListModel2;
                boolean bl4 = false;
                this$0.lastCalleesListNode = $node;
                calleesListModel = calleesListModel3;
                return calleesListModel;
            }
        }
        calleesListModel = CalleesListModel.Companion.empty();
        return calleesListModel;
    }

    public static final /* synthetic */ String access$nodeText(CallTreeComponent $this, BaseCallStackElement node) {
        return $this.nodeText(node);
    }

    public static final /* synthetic */ MainCallTreeDataComponent access$getParentComponent$p(CallTreeComponent $this) {
        return $this.parentComponent;
    }

    public static final /* synthetic */ CommonProfilerTabNameWithId access$getComponentId$p(CallTreeComponent $this) {
        return $this.componentId;
    }

    public static final /* synthetic */ CallUsagePopup access$getPopup$p(CallTreeComponent $this) {
        return $this.popup;
    }
}

