/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.CommonProfilerTabNameWithId;
import com.intellij.profiler.ui.IdentifiableProfilerTabComponentKt;
import com.intellij.profiler.ui.MainCallTreeDataComponent;
import com.intellij.profiler.ui.calltree.CallWithValueTreeTableKt;
import com.intellij.profiler.ui.callusage.ActionsKt;
import com.intellij.profiler.ui.callusage.CallUsageNodeKt;
import com.intellij.profiler.ui.callusage.CallUsagePopup;
import com.intellij.profiler.ui.callusage.FlameChartColorsRenderer;
import com.intellij.profiler.ui.callusage.FlameGraphComponent;
import com.intellij.profiler.ui.diff.DifferentialFlameGraphTypeManager;
import com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphTooltip;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphMouseListener;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanelKt;
import com.intellij.profiler.ui.flamegraph.FlameGraphRenderer;
import com.intellij.profiler.ui.flamegraph.FlameGraphTooltip;
import com.intellij.profiler.ui.grouping.GroupingController;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u00012B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-J\u001c\u0010.\u001a\u00020(2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aj\u0004\u0018\u0001`\u001cJ*\u0010/\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c002\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001cH\u0002J\b\u00101\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R@\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aj\u0004\u0018\u0001`\u001c2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aj\u0004\u0018\u0001`\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00063"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameGraphComponent;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Lcom/intellij/profiler/ui/MainCallTreeDataComponent;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ui/MainCallTreeDataComponent;Lcom/intellij/profiler/api/ValueMetric;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "popup", "Lcom/intellij/profiler/ui/callusage/CallUsagePopup;", "baseRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "differentialFlameGraphTypeManager", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphTypeManager;", "getDifferentialFlameGraphTypeManager", "()Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphTypeManager;", "componentId", "Lcom/intellij/profiler/ui/CommonProfilerTabNameWithId;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "getFlameGraphPanel", "()Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "filterSlider", "Ljavax/swing/JSlider;", "value", "model", "getModel", "()Lcom/intellij/profiler/model/CallTreeNode;", "setModel", "(Lcom/intellij/profiler/model/CallTreeNode;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "setFilterSliderVisible", "isVisible", "", "update", "createFlameGraphModel", "Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel;", "dispose", "Companion", "intellij.profiler.common"})
public final class FlameGraphComponent
extends BorderLayoutPanel
implements Disposable,
UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MainCallTreeDataComponent parentComponent;
    @NotNull
    private final CallUsagePopup popup;
    @NotNull
    private final BaseCallStackElementRenderer baseRenderer;
    @Nullable
    private final DifferentialFlameGraphTypeManager differentialFlameGraphTypeManager;
    @NotNull
    private final CommonProfilerTabNameWithId componentId;
    @NotNull
    private final FlameGraphPanel<CallTreeNode<BaseCallStackElement>> flameGraphPanel;
    @Nullable
    private JSlider filterSlider;
    @Nullable
    private CallTreeNode<? extends BaseCallStackElement> model;

    /*
     * WARNING - void declaration
     */
    public FlameGraphComponent(@NotNull Project project, @NotNull MainCallTreeDataComponent parentComponent, @NotNull ValueMetric metric) {
        void $this$_init__u24lambda_u240;
        Object $this$flameGraphPanel_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.project = project;
        this.parentComponent = parentComponent;
        this.popup = CallUsagePopup.Companion.of((Component)((Object)this), this.parentComponent);
        this.baseRenderer = this.parentComponent.getCallStackElementRenderer();
        this.differentialFlameGraphTypeManager = this.parentComponent.isDiff() ? new DifferentialFlameGraphTypeManager(this, this.baseRenderer, metric) : null;
        this.componentId = CommonProfilerTabNameWithId.Companion.getFlameGraph(this.parentComponent.isSubComponent());
        Object object = this.project;
        GroupingController groupingController = this.parentComponent.getGroupingController();
        CommonProfilerTabNameWithId commonProfilerTabNameWithId = this.componentId;
        object = new FlameGraphPanel<CallTreeNode<? extends BaseCallStackElement>>(this, object, groupingController, commonProfilerTabNameWithId){
            final /* synthetic */ FlameGraphComponent this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, null, $super_call_param$3, 4, null);
            }

            public void onNodeSelected(MouseEvent event) {
                CallTreeNode<T> usage;
                Object object;
                FlameGraphNode<T> flameGraphNode = this.getSearchResultNode();
                if (flameGraphNode == null) {
                    flameGraphNode = this.getSelectedNode();
                }
                if ((object = (usage = flameGraphNode != null ? (CallTreeNode<T>)flameGraphNode.getContent() : null)) == null || (object = (CallWithValue)object.getData()) == null || (object = (BaseCallStackElement)object.getCall()) == null) {
                    return;
                }
                Object element = object;
                if (((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getNavigateWithSingleClick()) {
                    UtilsKt.navigateToSourceWithSingleClick(this.this$0.getProject(), (BaseCallStackElement)element, (JComponent)((Object)this), event);
                }
            }
        };
        groupingController = object;
        FlameGraphComponent flameGraphComponent = this;
        boolean bl = false;
        $this$flameGraphPanel_u24lambda_u240.setModel(FlameGraphModel.Companion.createEmptyModel());
        Object object2 = this.differentialFlameGraphTypeManager;
        $this$flameGraphPanel_u24lambda_u240.setRenderer(object2 != null && (object2 = ((DifferentialFlameGraphTypeManager)object2).createRenderer()) != null ? (FlameGraphRenderer)object2 : (FlameGraphRenderer)new FlameChartColorsRenderer(this.baseRenderer, metric));
        $this$flameGraphPanel_u24lambda_u240.setTooltip(new DefaultFlameGraphTooltip((FlameGraphPanel)((Object)$this$flameGraphPanel_u24lambda_u240), $this$flameGraphPanel_u24lambda_u240.getRenderer()));
        $this$flameGraphPanel_u24lambda_u240.setInverted(((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getIcicleGraph());
        $this$flameGraphPanel_u24lambda_u240.addMouseListener((MouseListener)new FlameGraphMouseListener((FlameGraphPanel)((Object)$this$flameGraphPanel_u24lambda_u240), this.parentComponent.getProject(), (ActionGroup)this.popup));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)$this$flameGraphPanel_u24lambda_u240);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener((Object)$this$flameGraphPanel_u24lambda_u240){
            final /* synthetic */ flameGraphPanel.1 $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public void stateChanged(ToolWindowManager toolWindowManager, ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                    Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
                    if (changeType != ToolWindowManagerListener.ToolWindowManagerEventType.HideToolWindow) break block1;
                    FlameGraphTooltip<T> flameGraphTooltip = this.$this_apply.getTooltip();
                    if (flameGraphTooltip != null) {
                        flameGraphTooltip.hide();
                    }
                }
            }
        });
        flameGraphComponent.flameGraphPanel = (FlameGraphPanel)((Object)object);
        Disposer.register((Disposable)this.parentComponent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.flameGraphPanel);
        $this$flameGraphPanel_u24lambda_u240 = object = ActionsKt.createActionToolbar(this).getComponent();
        flameGraphComponent = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setBorder(JBUI.Borders.compound((Border)IdeBorderFactory.createBorder((int)4), (Border)$this$_init__u24lambda_u240.getBorder()));
        flameGraphComponent.addToLeft((Component)object);
        this.addToCenter(this.flameGraphPanel.createScrollPane());
        this.setFilterSliderVisible(((CommonProfilerUiOptions)CallUsageNodeKt.getSettings().getState()).getFlameGraphState().getFilterSlider());
        this.update(this.model);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final DifferentialFlameGraphTypeManager getDifferentialFlameGraphTypeManager() {
        return this.differentialFlameGraphTypeManager;
    }

    @NotNull
    public final FlameGraphPanel<CallTreeNode<BaseCallStackElement>> getFlameGraphPanel() {
        return this.flameGraphPanel;
    }

    @Nullable
    public final CallTreeNode<BaseCallStackElement> getModel() {
        return this.model;
    }

    public final void setModel(@Nullable CallTreeNode<? extends BaseCallStackElement> value) {
        if (Intrinsics.areEqual(this.model, value)) {
            return;
        }
        this.model = value;
        this.update(value);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> flameGraphNode = this.flameGraphPanel.getSearchResultNode();
        if (flameGraphNode == null) {
            flameGraphNode = this.flameGraphPanel.getSelectedNode();
        }
        CallTreeNode<BaseCallStackElement> usage = flameGraphNode != null ? flameGraphNode.getContent() : null;
        sink.set(IdentifiableProfilerTabComponentKt.getSELECTED_TAB_COMPONENT_ID(), (Object)this.flameGraphPanel.getComponentId());
        sink.set(CallUsageNodeKt.getSELECTED_CALL_USAGE(), usage);
        sink.set(CallUsageNodeKt.getMODEL_ROOT(), this.model);
        sink.set(CallWithValueTreeTableKt.getSELECTED_ELEMENT(), (object = usage) != null && (object = (CallWithValue)object.getData()) != null ? (BaseCallStackElement)object.getCall() : null);
        if (usage != null) {
            DataKey dataKey = PlatformDataKeys.CONTEXT_MENU_POINT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"CONTEXT_MENU_POINT");
            sink.set(dataKey, (Object)FlameGraphPanelKt.getContextMenuPointData(this.flameGraphPanel, usage));
        }
        DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
        sink.set(dataKey, (Object)new TextCopyProvider(usage, this){
            final /* synthetic */ CallTreeNode<BaseCallStackElement> $usage;
            final /* synthetic */ FlameGraphComponent this$0;
            {
                this.$usage = $usage;
                this.this$0 = $receiver;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public List<String> getTextLinesToCopy() {
                String string;
                CallTreeNode<BaseCallStackElement> callTreeNode = this.$usage;
                if (callTreeNode != null) {
                    CallTreeNode<BaseCallStackElement> callTreeNode2 = callTreeNode;
                    FlameGraphComponent flameGraphComponent = this.this$0;
                    CallTreeNode<BaseCallStackElement> it = callTreeNode2;
                    boolean bl = false;
                    string = flameGraphComponent.getFlameGraphPanel().getRenderer().getDisplayableText(flameGraphComponent.getFlameGraphPanel().getModel(), it);
                } else {
                    string = null;
                }
                String text = string;
                return CollectionsKt.listOfNotNull(text);
            }
        });
    }

    public final void setFilterSliderVisible(boolean isVisible) {
        if (this.filterSlider != null) {
            this.remove(this.filterSlider);
            this.filterSlider = null;
        }
        if (isVisible) {
            JSlider jSlider = this.filterSlider = Companion.createFilterSlider(this.flameGraphPanel);
            Intrinsics.checkNotNull((Object)jSlider);
            BorderLayoutPanel borderLayoutPanel = this.addToRight(jSlider);
            Intrinsics.checkNotNull((Object)borderLayoutPanel);
        } else {
            FlameGraphRenderer<CallTreeNode<BaseCallStackElement>> flameGraphRenderer = this.flameGraphPanel.getRenderer();
            FlameChartColorsRenderer flameChartColorsRenderer = flameGraphRenderer instanceof FlameChartColorsRenderer ? (FlameChartColorsRenderer)flameGraphRenderer : null;
            if (flameChartColorsRenderer != null) {
                flameChartColorsRenderer.setFilterValue(0.0);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public final void update(@Nullable CallTreeNode<? extends BaseCallStackElement> model2) {
        this.flameGraphPanel.setModel(model2 == null ? FlameGraphModel.Companion.createEmptyModel() : (FlameGraphModel)this.createFlameGraphModel(model2));
    }

    private final DefaultFlameGraphModel<CallTreeNode<BaseCallStackElement>> createFlameGraphModel(CallTreeNode<? extends BaseCallStackElement> model2) {
        Object object = this.differentialFlameGraphTypeManager;
        return object != null && (object = ((DifferentialFlameGraphTypeManager)object).createModel(model2)) != null ? (DefaultFlameGraphModel)object : (DefaultFlameGraphModel)new CallUsageNodeFlameGraphModel<BaseCallStackElement>(model2);
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J%\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameGraphComponent$Companion;", "", "<init>", "()V", "createFilterSlider", "Ljavax/swing/JSlider;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "forEachFlameGraph", "", "action", "Lkotlin/Function1;", "Lcom/intellij/profiler/ui/callusage/FlameGraphComponent;", "forEachFlameGraph$intellij_profiler_common", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nFlameGraphComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameGraphComponent.kt\ncom/intellij/profiler/ui/callusage/FlameGraphComponent$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n10468#2:170\n10890#2,2:171\n11879#2,9:173\n13805#2:182\n13806#2:184\n11888#2:185\n10892#2,3:186\n1#3:183\n1374#4:189\n1460#4,5:190\n1869#4,2:195\n*S KotlinDebug\n*F\n+ 1 FlameGraphComponent.kt\ncom/intellij/profiler/ui/callusage/FlameGraphComponent$Companion\n*L\n162#1:170\n162#1:171,2\n163#1:173,9\n163#1:182\n163#1:184\n163#1:185\n162#1:186,3\n163#1:183\n165#1:189\n165#1:190,5\n166#1:195,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSlider createFilterSlider(@NotNull FlameGraphPanel<?> flameGraphPanel2) {
            JSlider filterSlider;
            block0: {
                Intrinsics.checkNotNullParameter(flameGraphPanel2, (String)"flameGraphPanel");
                filterSlider = new JSlider(1, 1, 100, 1);
                filterSlider.addChangeListener(arg_0 -> Companion.createFilterSlider$lambda$0(filterSlider, flameGraphPanel2, arg_0));
                float value = PropertiesComponent.getInstance().getFloat("idea.profiler.flame.chart.filter.value", 0.005f);
                filterSlider.setValue((int)((1.0 - (double)value / 0.05) * (double)filterSlider.getMaximum()));
                filterSlider.setBorder(IdeBorderFactory.createBorder((int)1));
                FlameGraphRenderer<?> flameGraphRenderer = flameGraphPanel2.getRenderer();
                FlameChartColorsRenderer flameChartColorsRenderer = flameGraphRenderer instanceof FlameChartColorsRenderer ? (FlameChartColorsRenderer)flameGraphRenderer : null;
                if (flameChartColorsRenderer == null) break block0;
                flameChartColorsRenderer.setFilterValue(com.intellij.profiler.ui.callusage.FlameGraphComponent$Companion.createFilterSlider$getFilterValue(filterSlider));
            }
            return filterSlider;
        }

        /*
         * WARNING - void declaration
         */
        public final void forEachFlameGraph$intellij_profiler_common(@NotNull Function1<? super FlameGraphComponent, Unit> action) {
            void $this$flatMapTo$iv$iv;
            Iterable list$iv$iv;
            void $this$flatMapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            boolean $i$f$forEachFlameGraph$intellij_profiler_common = false;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$flatMap$iv = projectArray;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                void $this$mapNotNullTo$iv$iv;
                Project project = (Project)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)project);
                Content[] $this$mapNotNull$iv = ProfilerToolWindowManager.Companion.getInstance(project).getAllTabs();
                boolean $i$f$mapNotNull = false;
                Content[] contentArray = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    AbstractProfilerToolWindowPanel it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl2 = false;
                    void it = element$iv$iv2;
                    boolean bl3 = false;
                    JComponent jComponent = it.getComponent();
                    if ((jComponent instanceof AbstractProfilerToolWindowPanel ? (AbstractProfilerToolWindowPanel)((Object)jComponent) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List allProfilerToolWindows = (List)destination$iv$iv;
            Iterable $this$flatMap$iv2 = allProfilerToolWindows;
            boolean $i$f$flatMap2 = false;
            destination$iv$iv = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                AbstractProfilerToolWindowPanel it = (AbstractProfilerToolWindowPanel)((Object)element$iv$iv);
                boolean bl = false;
                List list = UIUtil.findComponentsOfType((JComponent)((JComponent)((Object)it)), FlameGraphComponent.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findComponentsOfType(...)");
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List allFlameGraphs = (List)destination$iv$iv3;
            Iterable $this$forEach$iv = allFlameGraphs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke(element$iv);
            }
        }

        private static final double createFilterSlider$getFilterValue(JSlider $this$createFilterSlider_u24getFilterValue) {
            return 0.05 * (1.0 - (double)$this$createFilterSlider_u24getFilterValue.getValue() / (double)$this$createFilterSlider_u24getFilterValue.getMaximum());
        }

        private static final void createFilterSlider$lambda$0(JSlider $filterSlider, FlameGraphPanel $flameGraphPanel, ChangeEvent it) {
            double filterValue = com.intellij.profiler.ui.callusage.FlameGraphComponent$Companion.createFilterSlider$getFilterValue($filterSlider);
            FlameGraphRenderer flameGraphRenderer = $flameGraphPanel.getRenderer();
            FlameChartColorsRenderer flameChartColorsRenderer = flameGraphRenderer instanceof FlameChartColorsRenderer ? (FlameChartColorsRenderer)flameGraphRenderer : null;
            if (flameChartColorsRenderer != null) {
                flameChartColorsRenderer.setFilterValue(filterValue);
            }
            PropertiesComponent.getInstance().setValue("idea.profiler.flame.chart.filter.value", (float)filterValue, 0.005f);
            $flameGraphPanel.repaint();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

