/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.threadview;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ThreadListOptions;
import com.intellij.profiler.model.AllThreadsMerged;
import com.intellij.profiler.model.JVMThread;
import com.intellij.profiler.model.NativeThread;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.statistics.FusAwareThreadListSpeedSearchListener;
import com.intellij.profiler.ui.ProfilerTabComponentNameWithId;
import com.intellij.profiler.ui.threadview.ThreadInfoRenderer;
import com.intellij.profiler.ui.threadview.ThreadListActionsPopup;
import com.intellij.profiler.ui.threadview.ThreadListSynchronizer;
import com.intellij.profiler.ui.threadview.UIVisibleThreadInfo;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadList;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "synchronizer", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "componentId", "Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;", "<init>", "(Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;)V", "getSynchronizer", "()Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;", "list", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "kotlin.jvm.PlatformType", "getList", "()Lcom/intellij/ui/components/JBList;", "renderer", "Lcom/intellij/profiler/ui/threadview/ThreadInfoRenderer;", "actionsPopup", "Lcom/intellij/profiler/ui/threadview/ThreadListActionsPopup;", "uiOptions", "Lcom/intellij/profiler/ThreadListOptions;", "isVisible", "", "setVisible", "", "aFlag", "Companion", "intellij.profiler.common"})
public final class ThreadList
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadListSynchronizer synchronizer;
    @NotNull
    private final JBList<UIVisibleThreadInfo> list;
    @NotNull
    private final ThreadInfoRenderer renderer;
    @NotNull
    private final ThreadListActionsPopup actionsPopup;
    @NotNull
    private final ThreadListOptions uiOptions;
    @NotNull
    private static final Comparator<ThreadInfo> comparator;

    public ThreadList(@NotNull ThreadListSynchronizer synchronizer, @Nullable Project project, @Nullable ProfilerTabComponentNameWithId componentId) {
        ListSpeedSearch listSpeedSearch;
        JBList<UIVisibleThreadInfo> jBList;
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        this.synchronizer = synchronizer;
        this.list = new JBList((ListModel)this.synchronizer.getListModel());
        this.renderer = new ThreadInfoRenderer((Collection<UIVisibleThreadInfo>)this.synchronizer.getUiThreads());
        this.actionsPopup = new ThreadListActionsPopup(this);
        this.uiOptions = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getThreadListOptions();
        this.setVisible(this.uiOptions.getShow());
        JBList<UIVisibleThreadInfo> $this$_init__u24lambda_u240 = jBList = this.list;
        boolean bl = false;
        $this$_init__u24lambda_u240.setCellRenderer((ListCellRenderer)this.renderer.listCellRenderer());
        ListSpeedSearch $this$lambda_u240_u242 = listSpeedSearch = ListSpeedSearch.installOn((JList)((JList)$this$_init__u24lambda_u240), arg_0 -> ThreadList.lambda$0$1(arg_0 -> ThreadList.lambda$0$0(this, arg_0), arg_0));
        boolean bl2 = false;
        if (project != null && componentId != null) {
            $this$lambda_u240_u242.addChangeListener((PropertyChangeListener)new FusAwareThreadListSpeedSearchListener(project, componentId));
        }
        $this$_init__u24lambda_u240.getExpandableItemsHandler().setEnabled(false);
        this.synchronizer.register(this);
        this.actionsPopup.registerMouseAdapterInList();
        this.addToCenter(ScrollPaneFactory.createScrollPane((Component)((Component)this.list)));
    }

    public /* synthetic */ ThreadList(ThreadListSynchronizer threadListSynchronizer, Project project, ProfilerTabComponentNameWithId profilerTabComponentNameWithId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            profilerTabComponentNameWithId = null;
        }
        this(threadListSynchronizer, project, profilerTabComponentNameWithId);
    }

    @NotNull
    public final ThreadListSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @NotNull
    public final JBList<UIVisibleThreadInfo> getList() {
        return this.list;
    }

    public boolean isVisible() {
        return this.uiOptions.getShow();
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.uiOptions.setShow(aFlag);
    }

    private static final String lambda$0$0(ThreadList this$0, UIVisibleThreadInfo it) {
        ThreadInfoRenderer threadInfoRenderer = this$0.renderer;
        Intrinsics.checkNotNull((Object)it);
        return threadInfoRenderer.speedSearchText(it);
    }

    private static final String lambda$0$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final int comparator$lambda$0(ThreadInfo it) {
        ThreadInfo threadInfo = it;
        return threadInfo instanceof AllThreadsMerged ? 0 : (threadInfo instanceof JVMThread ? 1 : (threadInfo instanceof NativeThread ? 2 : 3));
    }

    private static final int comparator$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final Boolean comparator$lambda$2(ThreadInfo t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return ((CharSequence)t.getName()).length() == 0;
    }

    private static final Boolean comparator$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String comparator$lambda$4(ThreadInfo t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return t.getName();
    }

    private static final String comparator$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String comparator$lambda$6(ThreadInfo t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return t.getNativeId();
    }

    private static final String comparator$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> ThreadList.comparator$lambda$1(ThreadList::comparator$lambda$0, arg_0)).thenComparing(Comparator.comparing(arg_0 -> ThreadList.comparator$lambda$3(ThreadList::comparator$lambda$2, arg_0))).thenComparing(Comparator.comparing(arg_0 -> ThreadList.comparator$lambda$5(ThreadList::comparator$lambda$4, arg_0))).thenComparing(Comparator.comparing(arg_0 -> ThreadList.comparator$lambda$7(ThreadList::comparator$lambda$6, arg_0)));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
        ThreadList.comparator = comparator;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadList$Companion;", "", "<init>", "()V", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/ThreadInfo;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<ThreadInfo> getComparator() {
            return comparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

