/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jpa.jakarta.console.v32.remote.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.javaee.jpa.jakarta.console.v32.remote.impl.RemoteQueryResultImpl;
import com.intellij.jpa.remote.GroovyHelper;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.remote.RemoteQueryResult;
import com.intellij.jpa.remote.impl.QueryResultImpl;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import jakarta.persistence.TransactionRequiredException;
import java.rmi.RemoteException;
import java.util.List;

public class RemoteQueryImpl
extends JdbcRemoteObject
implements RemoteQuery {
    private final Query myDelegate;
    private final EntityManager myManager;
    private int myUpdateCount;
    private boolean myResultFlag;

    public RemoteQueryImpl(Query delegate, EntityManager manager) {
        this.myDelegate = delegate;
        this.myManager = manager;
    }

    public static RemoteQueryImpl wrap(Query query, EntityManager manager) {
        return new RemoteQueryImpl(query, manager);
    }

    @Override
    public void setParameter(String name, Object object) throws RemoteException {
        try {
            this.myDelegate.setParameter(name, GroovyHelper.makeParameter(object));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public void setParameter(int index, Object object) throws RemoteException {
        try {
            this.myDelegate.setParameter(index, GroovyHelper.makeParameter(object));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public boolean execute() throws RemoteException {
        try {
            this.myUpdateCount = 0;
            try {
                try {
                    this.myUpdateCount = this.myDelegate.executeUpdate();
                }
                catch (TransactionRequiredException e) {
                    EntityTransaction tx = this.myManager.getTransaction();
                    tx.begin();
                    try {
                        this.myUpdateCount = this.myDelegate.executeUpdate();
                    }
                    finally {
                        tx.commit();
                    }
                }
                this.myResultFlag = false;
            }
            catch (IllegalStateException e) {
                this.myResultFlag = true;
            }
            return this.myResultFlag;
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public int getUpdateCount() throws RemoteException {
        return this.myUpdateCount;
    }

    @Override
    public RemoteQueryResult getQueryResult() throws RemoteException {
        if (!this.myResultFlag) {
            return null;
        }
        try {
            final boolean openJPA = RemoteQueryImpl.isOpenJPAStuff(this.myManager.getClass());
            return (RemoteQueryResult)this.export(RemoteQueryResultImpl.wrap(new QueryResultImpl(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected List<Object> getResultList() {
                    RemoteQueryImpl.this.myManager.clear();
                    try {
                        return RemoteQueryImpl.this.myDelegate.getResultList();
                    }
                    catch (TransactionRequiredException tre) {
                        EntityTransaction tx = RemoteQueryImpl.this.myManager.getTransaction();
                        tx.begin();
                        try {
                            List list = RemoteQueryImpl.this.myDelegate.getResultList();
                            return list;
                        }
                        finally {
                            try {
                                tx.commit();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }

                @Override
                protected boolean shouldSkip(Class<?> type, String fieldName) {
                    return openJPA && (RemoteQueryImpl.isOpenJPAStuff(type) || "pcDetachedState".equals(fieldName));
                }
            }));
        }
        catch (RemoteException e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    private static boolean isOpenJPAStuff(Class<?> aClass) {
        return aClass.getName().startsWith("org.apache.openjpa.");
    }

    @Override
    public void close() throws RemoteException {
        this.unreferenced();
    }
}

