/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.execution.ExecutionException;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.jpa.engine.JakartaEngine;
import com.intellij.jpa.engine.JpaConsoleRunContext;
import com.intellij.jpa.jakarta.remote.JakartaFacade;
import com.intellij.jpa.remote.JpaConsoleCommon;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.util.PathsList;
import com.intellij.util.RunnableCallable;
import java.util.concurrent.Callable;

public class JakartaConsoleRunContext
extends JpaConsoleRunContext {
    private static final String PERSISTENCE_3_0_MAIN_CLASS = "com.intellij.javaee.jpa.jakarta.console.v30.server.RemoteJakartaServer";
    private static final String PERSISTENCE_3_1_MAIN_CLASS = "com.intellij.javaee.jpa.jakarta.console.v31.server.RemoteJakartaServer";
    private static final String PERSISTENCE_3_2_MAIN_CLASS = "com.intellij.javaee.jpa.jakarta.console.v32.server.RemoteJakartaServer";
    private static final String PERSISTENCE_3_1_MARKER_CLASS = "jakarta.persistence.spi.TransformerException";
    private static final String PERSISTENCE_3_2_MARKER_CLASS = "jakarta.persistence.CheckConstraint";
    private final PersistencePackagePointer myUnitFile;

    JakartaConsoleRunContext(PersistencePackagePointer unitFile) {
        super(unitFile);
        this.myUnitFile = unitFile;
    }

    @Override
    public String getMainClassName() {
        PersistenceFacet persistenceFacet = this.myUnitFile.getPersistenceFacet();
        if (persistenceFacet == null) {
            return PERSISTENCE_3_1_MAIN_CLASS;
        }
        Module module = persistenceFacet.getModule();
        if (JavaLibraryUtil.hasLibraryClass((Module)module, (String)PERSISTENCE_3_2_MARKER_CLASS)) {
            return PERSISTENCE_3_2_MAIN_CLASS;
        }
        if (JavaLibraryUtil.hasLibraryClass((Module)module, (String)PERSISTENCE_3_1_MARKER_CLASS)) {
            return PERSISTENCE_3_1_MAIN_CLASS;
        }
        return PERSISTENCE_3_0_MAIN_CLASS;
    }

    @Override
    public void collectClassPath(PathsList cp) {
        ReadAction.nonBlocking((Callable)new RunnableCallable(() -> {
            try {
                super.collectClassPath(cp);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            JdbcConsoleRunContext.addClassJar((PathsList)cp, JakartaEngine.class, (String)JpaConsoleCommon.class.getName());
            JdbcConsoleRunContext.addClassJar((PathsList)cp, JakartaEngine.class, (String)JakartaFacade.class.getName());
        })).executeSynchronously();
    }
}

