/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.jpa.model.annotations.mapping.EmbeddableImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.MappedSuperclassImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;

public final class JpaLineMarkersDetector {
    @Nullable
    public static MarkerEntityClass getMarkerEntityClass(@NotNull UClass uClass) {
        PersistenceClassRole[] roles;
        PsiClass psiClass;
        if (uClass == null) {
            JpaLineMarkersDetector.$$$reportNull$$$0(0);
        }
        if (EntityImpl.ENTITY_META.getJamElement((PsiModifierListOwner)(psiClass = uClass.getJavaPsi())) != null || MappedSuperclassImpl.MAPPED_SUPERCLASS_META.getJamElement((PsiModifierListOwner)psiClass) != null || EmbeddableImpl.EMBEDDABLE_META.getJamElement((PsiModifierListOwner)psiClass) != null) {
            return new AnnotatedMarkerEntityClass(uClass);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            JpaModuleConfiguration configuration = JpaConfigurationModel.getConfiguration(module);
            if (configuration == null) {
                return null;
            }
            List configFiles = configuration.getDescriptors();
            if (configFiles.isEmpty()) {
                return null;
            }
        }
        if ((roles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)).length > 0) {
            return new RoleMarkerEntityClass(uClass, roles);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uClass", "com/intellij/jpa/highlighting/JpaLineMarkersDetector", "getMarkerEntityClass"));
    }

    public static class AnnotatedMarkerEntityClass
    extends MarkerEntityClass {
        AnnotatedMarkerEntityClass(@NotNull UClass aClass) {
            if (aClass == null) {
                AnnotatedMarkerEntityClass.$$$reportNull$$$0(0);
            }
            super(aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/jpa/highlighting/JpaLineMarkersDetector$AnnotatedMarkerEntityClass", "<init>"));
        }
    }

    public static class RoleMarkerEntityClass
    extends MarkerEntityClass {
        private final PersistenceClassRole[] roles;

        RoleMarkerEntityClass(@NotNull UClass aClass, PersistenceClassRole[] roles) {
            if (aClass == null) {
                RoleMarkerEntityClass.$$$reportNull$$$0(0);
            }
            super(aClass);
            this.roles = roles;
        }

        public PersistenceClassRole[] getRoles() {
            return this.roles;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/jpa/highlighting/JpaLineMarkersDetector$RoleMarkerEntityClass", "<init>"));
        }
    }

    public static abstract class MarkerEntityClass {
        final UClass uClass;

        private MarkerEntityClass(@NotNull UClass uClass) {
            if (uClass == null) {
                MarkerEntityClass.$$$reportNull$$$0(0);
            }
            this.uClass = uClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uClass", "com/intellij/jpa/highlighting/JpaLineMarkersDetector$MarkerEntityClass", "<init>"));
        }
    }
}

