/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.javaee.constants.JpaAnnotationConstants;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.psibuilder.common.PsiMemberInsertionPlace;
import com.intellij.jpa.jpb.model.psibuilder.pojobean.PojoBeanAnnotatedModel;
import com.intellij.jpa.jpb.model.psibuilder.pojobean.PojoBeanAttributeModel;
import com.intellij.jpa.jpb.model.psibuilder.pojobean.PojoBeanConfiguration;
import com.intellij.jpa.jpb.model.psibuilder.pojobean.PojoBeanDslKt;
import com.intellij.jpa.jpb.model.psibuilder.pojobean.PojoBeanWriter;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.Query;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J*\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jpa/inspections/JpaMissingIdInspection;", "Lcom/intellij/jpa/inspections/AbstractUastJpaInspection;", "<init>", "()V", "checkClass", "", "aClass", "Lorg/jetbrains/uast/UClass;", "role", "Lcom/intellij/persistence/roles/PersistenceClassRole;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkObjectHasId", "uClass", "persistentEntity", "Lcom/intellij/persistence/model/PersistentEntity;", "AddIdAttributeFix", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nJpaMissingIdInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaMissingIdInspection.kt\ncom/intellij/jpa/inspections/JpaMissingIdInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1761#2,3:161\n*S KotlinDebug\n*F\n+ 1 JpaMissingIdInspection.kt\ncom/intellij/jpa/inspections/JpaMissingIdInspection\n*L\n58#1:161,3\n*E\n"})
public final class JpaMissingIdInspection
extends AbstractUastJpaInspection {
    @Override
    protected void checkClass(@Nullable UClass aClass, @NotNull PersistenceClassRole role, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PersistentObject persistentObject = role.getPersistentObject();
        if (persistentObject instanceof PersistentEntity && role.getType() == PersistenceClassRoleEnum.ENTITY) {
            this.checkObjectHasId(aClass, (PersistentEntity)persistentObject, role, holder);
        }
    }

    private final void checkObjectHasId(UClass uClass, PersistentEntity persistentEntity, PersistenceClassRole role, ProblemsHolder holder) {
        boolean hasId;
        PsiElement sourcePsi;
        block5: {
            sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)((UDeclaration)uClass));
            if (sourcePsi == null) {
                return;
            }
            PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
            Query query = browser.queryAttributes((PersistentObject)persistentEntity);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"queryAttributes(...)");
            Iterable $this$any$iv = (Iterable)query;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PersistentAttribute it = (PersistentAttribute)element$iv;
                    boolean bl = false;
                    if (!it.getAttributeModelHelper().isIdAttribute()) continue;
                    v1 = true;
                    break block5;
                }
                v1 = hasId = false;
            }
        }
        if (hasId) {
            return;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)sourcePsi.getProject()).createSmartPsiElementPointer(sourcePsi);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        SmartPsiElementPointer classPointer = smartPsiElementPointer;
        Object[] objectArray = new Object[]{persistentEntity.getName().getValue()};
        String string = JpaHighlightingMessages.message("persistent.entity.0.should.have.id", objectArray);
        objectArray = new LocalQuickFix[]{new AddIdAttributeFix((SmartPsiElementPointer<PsiElement>)classPointer, role)};
        holder.registerProblem(sourcePsi, string, (LocalQuickFix[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0010\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0011H\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0002R\u0018\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jpa/inspections/JpaMissingIdInspection$AddIdAttributeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "classPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "role", "Lcom/intellij/persistence/roles/PersistenceClassRole;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/persistence/roles/PersistenceClassRole;)V", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "getName", "", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "addIdAttribute", "intellij.javaee.jpa.impl"})
    private static final class AddIdAttributeFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final SmartPsiElementPointer<PsiElement> classPointer;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final PersistenceClassRole role;

        public AddIdAttributeFix(@NotNull SmartPsiElementPointer<PsiElement> classPointer, @NotNull PersistenceClassRole role) {
            Intrinsics.checkNotNullParameter(classPointer, (String)"classPointer");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            this.classPointer = classPointer;
            this.role = role;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            PsiElement sameElementInCopy = PsiTreeUtil.findSameElementInCopy((PsiElement)this.classPointer.getElement(), (PsiFile)target);
            if (sameElementInCopy == null) {
                return null;
            }
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)target.getProject()).createSmartPsiElementPointer(sameElementInCopy);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
            SmartPsiElementPointer classPointer = smartPsiElementPointer;
            return (FileModifier)new AddIdAttributeFix((SmartPsiElementPointer<PsiElement>)classPointer, this.role);
        }

        @NotNull
        public String getName() {
            return this.getFamilyName();
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("quick.fix.name.add.id.attribute", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.addIdAttribute(this.role, this.classPointer);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            PsiElement element = previewDescriptor.getStartElement();
            if (element == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            PsiFile file = element.getContainingFile();
            Intrinsics.checkNotNull((Object)file);
            FileModifier fileModifier = this.getFileModifierForPreview(file);
            LocalQuickFix localQuickFix = fileModifier instanceof LocalQuickFix ? (LocalQuickFix)fileModifier : null;
            if (localQuickFix == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                return intentionPreviewInfo;
            }
            LocalQuickFix fix = localQuickFix;
            fix.applyFix(project, (CommonProblemDescriptor)previewDescriptor);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
            return intentionPreviewInfo;
        }

        private final void addIdAttribute(PersistenceClassRole role, SmartPsiElementPointer<PsiElement> classPointer) {
            PsiElement targetClass = classPointer.getElement();
            if (targetClass == null) {
                return;
            }
            UClass uClass = (UClass)UastContextKt.getUastParentOfType$default((PsiElement)targetClass, UClass.class, (boolean)false, (int)2, null);
            if (uClass == null) {
                return;
            }
            PersistentObject persistentObject = role.getPersistentObject();
            Intrinsics.checkNotNullExpressionValue((Object)persistentObject, (String)"getPersistentObject(...)");
            PersistentObject persistentObject2 = persistentObject;
            if (!persistentObject2.isValid()) {
                return;
            }
            String attributeName = ApplicationManager.getApplication().isUnitTestMode() ? JpaUtil.getTestUserResponse().name : "id";
            PojoBeanWriter pojoBeanWriter = (PojoBeanWriter)PojoBeanWriter.Companion.getInstance(targetClass);
            if (pojoBeanWriter == null) {
                return;
            }
            PojoBeanWriter pojoBeanWriter2 = pojoBeanWriter;
            Function0 generation = () -> AddIdAttributeFix.addIdAttribute$lambda$0(pojoBeanWriter2, uClass, attributeName, targetClass);
            boolean isPreview = IntentionPreviewUtils.isPreviewElement((PsiElement)targetClass);
            if (isPreview) {
                generation.invoke();
            } else {
                PsiFile[] psiFileArray = new PsiFile[]{null};
                WriteCommandAction.runWriteCommandAction((Project)targetClass.getProject(), (String)JpaHighlightingMessages.message("quick.fix.name.add.id.attribute", new Object[0]), null, () -> AddIdAttributeFix.addIdAttribute$lambda$1(targetClass, generation), (PsiFile[])psiFileArray);
            }
            if (!isPreview) {
                PsiElement psiElement = uClass.getSourcePsi();
                Object object = psiElement != null ? UastContextKt.toUElement((PsiElement)psiElement) : null;
                UField uField = object instanceof UClass ? (UField)object : null;
                if (uField == null || (uField = uField.getFields()) == null || (uField = (UField)ArraysKt.firstOrNull((Object[])uField)) == null) {
                    return;
                }
                UField newField = uField;
                UTypeReferenceExpression uTypeReferenceExpression = newField.getTypeReference();
                if (uTypeReferenceExpression == null || (uTypeReferenceExpression = uTypeReferenceExpression.getSourcePsi()) == null) {
                    return;
                }
                int targetOffset = PsiTreeUtilKt.getEndOffset((PsiElement)uTypeReferenceExpression);
                Editor editor = FileEditorManager.getInstance((Project)targetClass.getProject()).getSelectedTextEditor();
                if (editor == null) {
                    return;
                }
                Editor editor2 = editor;
                editor2.getCaretModel().moveToOffset(targetOffset);
            }
        }

        private static final Unit addIdAttribute$lambda$0(PojoBeanWriter $pojoBeanWriter, UClass $uClass, String $attributeName, PsiElement $targetClass) {
            PojoBeanConfiguration pojoBeanConfiguration = PojoBeanConfiguration.Companion.guessForPsiClass($uClass.getJavaPsi());
            PsiClass psiClass = $uClass.getJavaPsi();
            Intrinsics.checkNotNull((Object)$attributeName);
            $pojoBeanWriter.addAttribute(pojoBeanConfiguration, psiClass, PojoBeanDslKt.field((String)$attributeName, (Fqn)new Fqn("Long", null, null, 4, null), arg_0 -> AddIdAttributeFix.addIdAttribute$lambda$0$0($targetClass, arg_0)), new PsiMemberInsertionPlace(null, null, true, 3, null));
            return Unit.INSTANCE;
        }

        private static final Unit addIdAttribute$lambda$0$0(PsiElement $targetClass, PojoBeanAttributeModel $this$field) {
            Intrinsics.checkNotNullParameter((Object)$this$field, (String)"$this$field");
            PojoBeanAnnotatedModel pojoBeanAnnotatedModel = (PojoBeanAnnotatedModel)$this$field;
            String string = JpaAnnotationConstants.ID_ANNO.fqn($targetClass.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqn(...)");
            PojoBeanDslKt.annotation$default((PojoBeanAnnotatedModel)pojoBeanAnnotatedModel, (String)string, null, (int)2, null);
            return Unit.INSTANCE;
        }

        private static final void addIdAttribute$lambda$1(PsiElement $targetClass, Function0 $generation) {
            if (ApplicationManager.getApplication().isUnitTestMode() && !$targetClass.getContainingFile().isWritable()) {
                $targetClass.getContainingFile().getVirtualFile().setWritable(true);
            }
            $generation.invoke();
        }
    }
}

