/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.deployment;

import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeDeploymentActionContext;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.util.List;

public abstract class DeploymentActionAdapter {
    public void processAction(AnActionEvent event) {
        JavaeeDeploymentActionContext context = (JavaeeDeploymentActionContext)event.getData(JavaeeDeploymentActionContext.KEY);
        if (context == null) {
            this.doSuppressAction(event);
            return;
        }
        J2EEServerInstance serverInstance = context.getServerInstance();
        if (serverInstance == null) {
            this.doSuppressAction(event);
            return;
        }
        CommonModel commonModel = serverInstance.getCommonModel();
        this.doProcessAction(event, serverInstance, commonModel, commonModel.getProject(), context.getSelectedDeployments());
    }

    protected void doSuppressAction(AnActionEvent event) {
    }

    protected abstract void doProcessAction(AnActionEvent var1, J2EEServerInstance var2, CommonModel var3, Project var4, List<DeploymentModel> var5);
}

