/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.lang.injection.general.SimpleInjection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.psi.SqlLanguage;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/hibernate/HibernateSqlAnnotationsLanguageInjector;", "Lcom/intellij/lang/injection/general/LanguageInjectionContributor;", "<init>", "()V", "HIBERNATE_MAVEN_COORDS", "", "", "SQL_ANNOTATIONS", "getInjection", "Lcom/intellij/lang/injection/general/Injection;", "context", "Lcom/intellij/psi/PsiElement;", "hasHibernateJars", "", "project", "Lcom/intellij/openapi/project/Project;", "isSqlAnnotationHost", "host", "intellij.hibernate"})
public final class HibernateSqlAnnotationsLanguageInjector
implements LanguageInjectionContributor {
    @NotNull
    private final List<String> HIBERNATE_MAVEN_COORDS;
    @NotNull
    private final List<String> SQL_ANNOTATIONS;

    public HibernateSqlAnnotationsLanguageInjector() {
        Object[] objectArray = new String[]{"org.hibernate:hibernate-core", "org.hibernate.orm:hibernate-core"};
        this.HIBERNATE_MAVEN_COORDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"org.hibernate.annotations.SQLInsert", "org.hibernate.annotations.SQLUpdate", "org.hibernate.annotations.SQLDelete", "org.hibernate.annotations.SQLDeleteAll"};
        this.SQL_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public Injection getInjection(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        Project project = ((PsiLanguageInjectionHost)context).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDefault()) {
            return null;
        }
        if (!this.hasHibernateJars(project2)) {
            return null;
        }
        return this.isSqlAnnotationHost(context) ? (Injection)new SimpleInjection((Language)SqlLanguage.INSTANCE, "", "", "java") : null;
    }

    private final boolean hasHibernateJars(Project project) {
        return JavaLibraryUtil.hasAnyLibraryJar((Project)project, (Collection)this.HIBERNATE_MAVEN_COORDS);
    }

    private final boolean isSqlAnnotationHost(PsiElement host) {
        UInjectionHost uElement = (UInjectionHost)UastContextKt.toUElement((PsiElement)host, UInjectionHost.class);
        Pair pair = UAnnotationUtils.getContainingUAnnotationEntry((UElement)((UElement)uElement), (Collection)this.SQL_ANNOTATIONS);
        if (pair == null) {
            return false;
        }
        Pair pair2 = pair;
        UAnnotation uAnnotation = (UAnnotation)pair2.component1();
        String paramName = (String)pair2.component2();
        if (!Intrinsics.areEqual((Object)paramName, (Object)"sql")) {
            return false;
        }
        UExpression callableAttr = uAnnotation.findAttributeValue("callable");
        if (callableAttr != null && Intrinsics.areEqual((Object)callableAttr.evaluate(), (Object)true)) {
            return false;
        }
        return CollectionsKt.contains((Iterable)this.SQL_ANNOTATIONS, (Object)uAnnotation.getQualifiedName());
    }
}

