/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.facet;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.hibernate.model.HibernateCommonClasses;
import org.jetbrains.annotations.NonNls;

public enum HibernateVersion {
    Hibernate_3_X("3.x", LibraryInfo.EMPTY_ARRAY, "hibernate-main-3.0.java"),
    Hibernate_4_X("4.x", LibraryInfo.EMPTY_ARRAY, "hibernate-main-4.0.java"),
    Hibernate_5_0("5.0", LibraryInfo.EMPTY_ARRAY, "hibernate-main-5.0.java", HibernateCommonClasses.NAMING_STRATEGY_50),
    Hibernate_5_2("5.2.x", LibraryInfo.EMPTY_ARRAY, "hibernate-main-5.2.java", HibernateCommonClasses.NAMING_STRATEGY_50);

    private final String myName;
    private final LibraryInfo[] myJars;
    private final String myMainTemplateName;
    private final String[] myNamingStrategies;

    private HibernateVersion(@NonNls String name, LibraryInfo[] jars, String mainTemplateName) {
        this(name, jars, mainTemplateName, "org.hibernate.cfg.NamingStrategy");
    }

    private HibernateVersion(@NonNls String name, LibraryInfo[] jars, String mainTemplateName, String ... namingStrategy) {
        this.myName = name;
        this.myJars = jars;
        this.myMainTemplateName = mainTemplateName;
        this.myNamingStrategies = namingStrategy;
    }

    public String getName() {
        return this.myName;
    }

    public LibraryInfo[] getJars() {
        return this.myJars;
    }

    public String toString() {
        return this.myName;
    }

    public String getMainTemplateName() {
        return this.myMainTemplateName;
    }

    public String[] getNamingStrategies() {
        return this.myNamingStrategies;
    }
}

