/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;

public interface HibernatePropertiesConstants {
    @NonNls
    public static final String HIBERNATE_PREFIX = "hibernate.";
    @NonNls
    public static final String EJB_NAMING_STRATEGY = "ejb.naming_strategy";
    @NonNls
    public static final String CONNECTION_PROVIDER = "connection.provider_class";
    @NonNls
    public static final String DRIVER = "connection.driver_class";
    @NonNls
    public static final String ISOLATION = "connection.isolation";
    @NonNls
    public static final String URL = "connection.url";
    @NonNls
    public static final String USER = "connection.username";
    @NonNls
    public static final String PASS = "connection.password";
    @NonNls
    public static final String AUTOCOMMIT = "connection.autocommit";
    @NonNls
    public static final String POOL_SIZE = "connection.pool_size";
    @NonNls
    public static final String DATASOURCE = "connection.datasource";
    @NonNls
    public static final String CONNECTION_PREFIX = "connection";
    @NonNls
    public static final String JNDI_CLASS = "jndi.class";
    @NonNls
    public static final String JNDI_URL = "jndi.url";
    @NonNls
    public static final String JNDI_PREFIX = "jndi";
    @NonNls
    public static final String SESSION_FACTORY_NAME = "session_factory_name";
    @NonNls
    public static final String DIALECT = "dialect";
    @NonNls
    public static final String DEFAULT_SCHEMA = "default_schema";
    @NonNls
    public static final String DEFAULT_CATALOG = "default_catalog";
    @NonNls
    public static final String SHOW_SQL = "show_sql";
    @NonNls
    public static final String FORMAT_SQL = "format_sql";
    @NonNls
    public static final String USE_SQL_COMMENTS = "use_sql_comments";
    @NonNls
    public static final String MAX_FETCH_DEPTH = "max_fetch_depth";
    @NonNls
    public static final String DEFAULT_BATCH_FETCH_SIZE = "default_batch_fetch_size";
    @NonNls
    public static final String USE_STREAMS_FOR_BINARY = "jdbc.use_streams_for_binary";
    @NonNls
    public static final String USE_SCROLLABLE_RESULTSET = "jdbc.use_scrollable_resultset";
    @NonNls
    public static final String USE_GET_GENERATED_KEYS = "jdbc.use_get_generated_keys";
    @NonNls
    public static final String STATEMENT_FETCH_SIZE = "jdbc.fetch_size";
    @NonNls
    public static final String STATEMENT_BATCH_SIZE = "jdbc.batch_size";
    @NonNls
    public static final String BATCH_STRATEGY = "jdbc.factory_class";
    @NonNls
    public static final String BATCH_VERSIONED_DATA = "jdbc.batch_versioned_data";
    @NonNls
    public static final String OUTPUT_STYLESHEET = "xml.output_stylesheet";
    @NonNls
    public static final String C3P0_MAX_SIZE = "c3p0.max_size";
    @NonNls
    public static final String C3P0_MIN_SIZE = "c3p0.min_size";
    @NonNls
    public static final String C3P0_TIMEOUT = "c3p0.timeout";
    @NonNls
    public static final String C3P0_MAX_STATEMENTS = "c3p0.max_statements";
    @NonNls
    public static final String C3P0_ACQUIRE_INCREMENT = "c3p0.acquire_increment";
    @NonNls
    public static final String C3P0_IDLE_TEST_PERIOD = "c3p0.idle_test_period";
    @NonNls
    public static final String PROXOOL_PREFIX = "proxool";
    @NonNls
    public static final String PROXOOL_XML = "proxool.xml";
    @NonNls
    public static final String PROXOOL_PROPERTIES = "proxool.properties";
    @NonNls
    public static final String PROXOOL_EXISTING_POOL = "proxool.existing_pool";
    @NonNls
    public static final String PROXOOL_POOL_ALIAS = "proxool.pool_alias";
    @NonNls
    public static final String AUTO_CLOSE_SESSION = "transaction.auto_close_session";
    @NonNls
    public static final String FLUSH_BEFORE_COMPLETION = "transaction.flush_before_completion";
    @NonNls
    public static final String RELEASE_CONNECTIONS = "connection.release_mode";
    @NonNls
    public static final String CURRENT_SESSION_CONTEXT_CLASS = "current_session_context_class";
    @NonNls
    public static final String TRANSACTION_STRATEGY = "transaction.factory_class";
    @NonNls
    public static final String TRANSACTION_MANAGER_STRATEGY = "transaction.manager_lookup_class";
    @NonNls
    public static final String USER_TRANSACTION = "jta.UserTransaction";
    @NonNls
    public static final String CACHE_PROVIDER = "cache.provider_class";
    @NonNls
    public static final String CACHE_PROVIDER_CONFIG = "cache.provider_configuration_file_resource_path";
    @NonNls
    public static final String CACHE_NAMESPACE = "cache.jndi";
    @NonNls
    public static final String USE_QUERY_CACHE = "cache.use_query_cache";
    @NonNls
    public static final String QUERY_CACHE_FACTORY = "cache.query_cache_factory";
    @NonNls
    public static final String USE_SECOND_LEVEL_CACHE = "cache.use_second_level_cache";
    @NonNls
    public static final String USE_MINIMAL_PUTS = "cache.use_minimal_puts";
    @NonNls
    public static final String CACHE_REGION_PREFIX = "cache.region_prefix";
    @NonNls
    public static final String USE_STRUCTURED_CACHE = "cache.use_structured_entries";
    @NonNls
    public static final String GENERATE_STATISTICS = "generate_statistics";
    @NonNls
    public static final String USE_IDENTIFIER_ROLLBACK = "use_identifier_rollback";
    @NonNls
    public static final String USE_REFLECTION_OPTIMIZER = "bytecode.use_reflection_optimizer";
    @NonNls
    public static final String QUERY_TRANSLATOR = "query.factory_class";
    @NonNls
    public static final String QUERY_SUBSTITUTIONS = "query.substitutions";
    @NonNls
    public static final String HBM2DDL_AUTO = "hbm2ddl.auto";
    @NonNls
    public static final String SQL_EXCEPTION_CONVERTER = "jdbc.sql_exception_converter";
    @NonNls
    public static final String WRAP_RESULT_SETS = "jdbc.wrap_result_sets";
    @NonNls
    public static final String ORDER_UPDATES = "order_updates";
    @NonNls
    public static final String DEFAULT_ENTITY_MODE = "default_entity_mode";
    @NonNls
    public static final String JACC_CONTEXTID = "jacc_context_id";
    @NonNls
    public static final String BYTECODE_PROVIDER = "bytecode.provider";
    @NonNls
    public static final String JPAQL_STRICT_COMPLIANCE = "query.jpaql_strict_compliance";

    public static List<String> allProperties() {
        return Stream.of(CONNECTION_PROVIDER, DRIVER, ISOLATION, URL, USER, PASS, AUTOCOMMIT, POOL_SIZE, DATASOURCE, CONNECTION_PREFIX, JNDI_CLASS, JNDI_URL, JNDI_PREFIX, SESSION_FACTORY_NAME, DIALECT, DEFAULT_SCHEMA, DEFAULT_CATALOG, SHOW_SQL, FORMAT_SQL, USE_SQL_COMMENTS, MAX_FETCH_DEPTH, DEFAULT_BATCH_FETCH_SIZE, USE_STREAMS_FOR_BINARY, USE_SCROLLABLE_RESULTSET, USE_GET_GENERATED_KEYS, STATEMENT_FETCH_SIZE, STATEMENT_BATCH_SIZE, BATCH_STRATEGY, BATCH_VERSIONED_DATA, OUTPUT_STYLESHEET, C3P0_MAX_SIZE, C3P0_MIN_SIZE, C3P0_TIMEOUT, C3P0_MAX_STATEMENTS, C3P0_ACQUIRE_INCREMENT, C3P0_IDLE_TEST_PERIOD, PROXOOL_PREFIX, PROXOOL_XML, PROXOOL_PROPERTIES, PROXOOL_EXISTING_POOL, PROXOOL_POOL_ALIAS, AUTO_CLOSE_SESSION, FLUSH_BEFORE_COMPLETION, RELEASE_CONNECTIONS, CURRENT_SESSION_CONTEXT_CLASS, TRANSACTION_STRATEGY, TRANSACTION_MANAGER_STRATEGY, USER_TRANSACTION, CACHE_PROVIDER, CACHE_PROVIDER_CONFIG, CACHE_NAMESPACE, USE_QUERY_CACHE, QUERY_CACHE_FACTORY, USE_SECOND_LEVEL_CACHE, USE_MINIMAL_PUTS, CACHE_REGION_PREFIX, USE_STRUCTURED_CACHE, GENERATE_STATISTICS, USE_IDENTIFIER_ROLLBACK, USE_REFLECTION_OPTIMIZER, QUERY_TRANSLATOR, QUERY_SUBSTITUTIONS, HBM2DDL_AUTO, SQL_EXCEPTION_CONVERTER, WRAP_RESULT_SETS, ORDER_UPDATES, DEFAULT_ENTITY_MODE, JACC_CONTEXTID, BYTECODE_PROVIDER, JPAQL_STRICT_COMPLIANCE).map(it -> HIBERNATE_PREFIX + it).collect(Collectors.toList());
    }
}

