/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.text;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.LanguageWithVariant;
import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.retokenizer.PatternRetokenizer;
import ai.grazie.nlp.tokenizer.retokenizer.QuotesRetokenizer;
import ai.grazie.nlp.tokenizer.retokenizer.pattern.PatternRetokenizers;
import ai.grazie.nlp.tokenizer.word.HeuristicWordTokenizer;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.spell.GermanCompoundChecker;
import ai.grazie.spell.GrazieSplittingSpeller;
import ai.grazie.spell.Speller;
import ai.grazie.spell.dictionary.rule.IgnoreRuleDictionary;
import ai.grazie.spell.text.Typo;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import ai.grazie.utils.CollectionsKt;
import ai.grazie.utils.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 52\u00020\u0001:\u0003567B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u001a\u001a\u00020\u001cH\u0004J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000eH\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J*\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0003H\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0\u0003H\u0002J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u000fH\u0016J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u000fH\u0002J\u001e\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u000e02j\b\u0012\u0004\u0012\u00020\u000e`32\u0006\u0010!\u001a\u00020\u000eJ\u0012\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\u000eH\u0004R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00068"}, d2={"Lai/grazie/spell/text/TextSpeller;", "", "spellers", "", "Lai/grazie/spell/Speller;", "<init>", "(Ljava/util/List;)V", "getSpellers", "()Ljava/util/List;", "languages", "Lai/grazie/nlp/langs/LanguageWithVariant;", "german", "spellCacheSplit", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "spellCachePlain", "sugCache", "", "Lai/grazie/spell/text/TextSpeller$Suggestions;", "suggestionLimit", "", "getSuggestionLimit", "()I", "checkText", "Lai/grazie/spell/text/Typo;", "text", "", "Lai/grazie/spell/text/TextSpeller$TokenizedText;", "lazyTypo", "token", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "ignoreInContext", "word", "ignoreGerman", "isShortenedGermanForm", "mayBeCorrectForSwiss", "isLowerCaseWithDifferentCaseSuggestions", "isOkWithPunctuationAround", "tokenize", "nonIgnoredTokens", "tokens", "ignoreRanges", "Lai/grazie/text/TextRange;", "mergeIntersectingRanges", "sorted", "isMisspelled", "allowSplitting", "computeIsMisspelled", "suggestions", "Ljava/util/LinkedHashSet;", "Lai/grazie/utils/LinkedSet;", "rankedSuggestions", "Companion", "TokenizedText", "Suggestions", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nTextSpeller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextSpeller.kt\nai/grazie/spell/text/TextSpeller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1368#2:206\n1454#2,5:207\n774#2:213\n865#2,2:214\n1557#2:216\n1628#2,3:217\n1755#2,3:220\n1755#2,3:223\n1053#2:226\n1611#2,9:227\n1863#2:236\n1864#2:238\n1620#2:239\n1755#2,3:240\n1734#2,2:243\n1755#2,3:245\n1736#2:248\n1062#2:249\n1557#2:250\n1628#2,3:251\n1#3:212\n1#3:237\n*S KotlinDebug\n*F\n+ 1 TextSpeller.kt\nai/grazie/spell/text/TextSpeller\n*L\n38#1:206\n38#1:207,5\n56#1:213\n56#1:214,2\n57#1:216\n57#1:217,3\n87#1:220,3\n95#1:223,3\n132#1:226\n172#1:227,9\n172#1:236\n172#1:238\n172#1:239\n173#1:240,3\n179#1:243,2\n179#1:245,3\n179#1:248\n186#1:249\n186#1:250\n186#1:251,3\n172#1:237\n*E\n"})
public class TextSpeller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Speller> spellers;
    @NotNull
    private final List<LanguageWithVariant> languages;
    @Nullable
    private final LanguageWithVariant german;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> spellCacheSplit;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> spellCachePlain;
    @NotNull
    private final ConcurrentHashMap<String, Suggestions[]> sugCache;
    @NotNull
    private static final PatternRetokenizer tokenizer = new PatternRetokenizer(LikelyPatterns.PythonString, new QuotesRetokenizer(new HeuristicWordTokenizer(false, false)));
    @NotNull
    private static final AggregatedPattern ignorePattern = new AggregatedPattern(PatternRetokenizers.INSTANCE.getDefaultIgnorePatterns());
    @NotNull
    private static final IgnoreRuleDictionary ignoreDict = IgnoreRuleDictionary.Companion.standard(2);
    @NotNull
    private static final Regex shortenedArticle = new Regex("n(e[mnsr]?)?");
    @NotNull
    private static final Regex versionAbbr = new Regex("[_-][vV]\\d");
    @NotNull
    private static final Regex looksLikeGermanWord = new Regex("[a-z\u00e4\u00f6\u00fc\u00df]+", RegexOption.IGNORE_CASE);
    @NotNull
    private static final Pattern anySnakeKebabName = LikelyPatterns.INSTANCE.snakeKebabName(1);

    /*
     * WARNING - void declaration
     */
    public TextSpeller(@NotNull List<? extends Speller> spellers) {
        Object v0;
        block2: {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Intrinsics.checkNotNullParameter(spellers, (String)"spellers");
            this.spellers = spellers;
            Iterable iterable = this.spellers;
            TextSpeller textSpeller = this;
            boolean $i$f$flatMap = false;
            Iterator iterator = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Speller it = (Speller)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.languages();
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            textSpeller.languages = kotlin.collections.CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            iterable = this.languages;
            textSpeller = this;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                LanguageWithVariant it = (LanguageWithVariant)t;
                boolean bl = false;
                if (!(it.getBase() == Language.GERMAN)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        textSpeller.german = v0;
        this.spellCacheSplit = new ConcurrentHashMap();
        this.spellCachePlain = new ConcurrentHashMap();
        this.sugCache = new ConcurrentHashMap();
    }

    @NotNull
    protected final List<Speller> getSpellers() {
        return this.spellers;
    }

    protected int getSuggestionLimit() {
        return 3;
    }

    @NotNull
    public final List<Typo> checkText(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.checkText(this.tokenize(text2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Typo> checkText(@NotNull TokenizedText text2) {
        void $this$mapTo$iv$iv;
        Tokenizer.Token it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Set unknownWords = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)text2.getTokensToSpellCheck()), TextSpeller::checkText$lambda$2)), arg_0 -> TextSpeller.checkText$lambda$3(this, arg_0)));
        Iterable $this$filter$iv = text2.getTokensToSpellCheck();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tokenizer.Token)element$iv$iv;
            boolean bl = false;
            if (!(unknownWords.contains(it.getToken()) && !this.ignoreInContext(it, text2.getText()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tokenizer.Token)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.lazyTypo(it));
        }
        return (List)destination$iv$iv;
    }

    private final Typo lazyTypo(Tokenizer.Token token) {
        return new Typo(token, this){
            final /* synthetic */ Tokenizer.Token $token;
            final /* synthetic */ TextSpeller this$0;
            {
                this.$token = $token;
                this.this$0 = $receiver;
            }

            public String getWord() {
                return this.$token.getToken();
            }

            public TextRange getRange() {
                return TextRange.Companion.invoke(this.$token.getRange());
            }

            public LinkedHashSet<String> getFixes() {
                return this.this$0.suggestions(this.$token.getToken());
            }

            public String toString() {
                return this.getWord();
            }
        };
    }

    protected boolean ignoreInContext(@NotNull Tokenizer.Token word, @NotNull CharSequence text2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.isOkWithPunctuationAround(word, text2) || this.german != null && looksLikeGermanWord.matches(charSequence = (CharSequence)word.getText()) && this.ignoreGerman(word, text2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean ignoreGerman(Tokenizer.Token word, CharSequence text2) {
        if (this.isShortenedGermanForm(word, text2)) return true;
        if (new GermanCompoundChecker((Function1<? super String, Boolean>)((Function1)arg_0 -> TextSpeller.ignoreGerman$lambda$6(this, arg_0))).isNonDictCompound(word.getText().getValue())) return true;
        LanguageWithVariant languageWithVariant = this.german;
        if ((languageWithVariant != null ? languageWithVariant.getVariant() : null) != null) return false;
        if (StringsKt.contains$default((CharSequence)text2, (CharSequence)"\u00df", (boolean)false, (int)2, null)) return false;
        if (!this.mayBeCorrectForSwiss(word.getToken())) return false;
        return true;
    }

    private final boolean isShortenedGermanForm(Tokenizer.Token word, CharSequence text2) {
        CharSequence charSequence;
        return word.getRange().getFirst() > 0 && Symbols.INSTANCE.getApostrophes().contains(Character.valueOf(text2.charAt(word.getRange().getFirst() - 1))) && shortenedArticle.matches(charSequence = (CharSequence)word.getText().getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean mayBeCorrectForSwiss(String word) {
        String it;
        if (!StringsKt.contains$default((CharSequence)word, (CharSequence)"ss", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = this.suggestions(word);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)it, (String)"\u00df", (String)"ss", (boolean)false, (int)4, null), (Object)word));
        return true;
    }

    private final boolean isLowerCaseWithDifferentCaseSuggestions(Tokenizer.Token word, CharSequence text2) {
        boolean bl;
        TextRange range;
        block8: {
            Object v0;
            block7: {
                if (!TextKt.isLowercase(word.getToken())) {
                    return false;
                }
                Iterable iterable = anySnakeKebabName.find(text2);
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    TextRange it = (TextRange)t;
                    boolean bl2 = false;
                    if (!it.contains(word.getInterval())) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            TextRange textRange = v0;
            if (textRange == null) {
                return false;
            }
            range = textRange;
            Iterable $this$any$iv = this.spellers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Speller it = (Speller)element$iv;
                    boolean bl3 = false;
                    String string = word.getToken().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    if (!(!it.isMisspelled(string, false))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        return Regex.find$default((Regex)versionAbbr, (CharSequence)text2.subSequence(range.getStart(), range.getEndExclusive()), (int)0, (int)2, null) != null && this.suggestions(word.getToken()).isEmpty();
    }

    private final boolean isOkWithPunctuationAround(Tokenizer.Token word, CharSequence text2) {
        block4: {
            block6: {
                char prev;
                block5: {
                    char next;
                    if (word.getRange().getLast() + 1 < text2.length() && (((next = text2.charAt(word.getRange().getLast() + 1)) == '-' || Symbols.INSTANCE.getApostrophes().contains(Character.valueOf(next))) && !this.isMisspelled(word.getText().getValue() + next, false) || StringsKt.contains$default((CharSequence)"-_*", (char)next, (boolean)false, (int)2, null) && this.isLowerCaseWithDifferentCaseSuggestions(word, text2))) {
                        return true;
                    }
                    if (word.getRange().getFirst() <= 0) break block4;
                    prev = text2.charAt(word.getRange().getFirst() - 1);
                    if (prev != '-') break block5;
                    char c = prev;
                    String string = word.getText().getValue();
                    if (!this.isMisspelled(c + string, false)) break block6;
                }
                if (!StringsKt.contains$default((CharSequence)"-_*", (char)prev, (boolean)false, (int)2, null) || !this.isLowerCaseWithDifferentCaseSuggestions(word, text2)) break block4;
            }
            return true;
        }
        return false;
    }

    @NotNull
    protected final TokenizedText tokenize(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<Tokenizer.Token> tokens = tokenizer.tokenize(new Text(text2));
        List<TextRange> ignoreRanges = ignorePattern.find(text2);
        List<Tokenizer.Token> tokensToCheck = this.nonIgnoredTokens(tokens, ignoreRanges);
        return new TokenizedText(text2, tokens, tokensToCheck);
    }

    private final List<Tokenizer.Token> nonIgnoredTokens(List<Tokenizer.Token> tokens, List<TextRange> ignoreRanges) {
        if (ignoreRanges.isEmpty()) {
            return tokens;
        }
        Iterable $this$sortedBy$iv = ignoreRanges;
        boolean $i$f$sortedBy = false;
        List<TextRange> sortedRanges = this.mergeIntersectingRanges(kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        }));
        ArrayList<Tokenizer.Token> result2 = new ArrayList<Tokenizer.Token>();
        int ignoredIndex = 0;
        for (Tokenizer.Token token : tokens) {
            while (ignoredIndex < sortedRanges.size() && sortedRanges.get(ignoredIndex).getEndExclusive() <= token.getInterval().getStart()) {
                ++ignoredIndex;
            }
            if (ignoredIndex < sortedRanges.size() && sortedRanges.get(ignoredIndex).intersects(token.getInterval())) continue;
            result2.add(token);
        }
        return result2;
    }

    private final List<TextRange> mergeIntersectingRanges(List<TextRange> sorted) {
        if (sorted.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        TextRange current = sorted.get(0);
        int n = sorted.size();
        for (int i = 1; i < n; ++i) {
            TextRange next = sorted.get(i);
            if (current.getEndExclusive() >= next.getStart()) {
                current = new TextRange(current.getStart(), Math.max(current.getEndExclusive(), next.getEndExclusive()));
                continue;
            }
            result2.add(current);
            current = next;
        }
        result2.add(current);
        return result2;
    }

    public boolean isMisspelled(@NotNull String word, boolean allowSplitting) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        ConcurrentHashMap<String, Boolean> cache = allowSplitting ? this.spellCacheSplit : this.spellCachePlain;
        Boolean bl = cache.computeIfAbsent(word, arg_0 -> TextSpeller.isMisspelled$lambda$12(arg_0 -> TextSpeller.isMisspelled$lambda$11(this, word, allowSplitting, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    private final boolean computeIsMisspelled(String word, boolean allowSplitting) {
        String normalized;
        List applicable;
        block19: {
            block18: {
                boolean bl;
                block15: {
                    Iterator $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = this.spellers;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Speller it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        Speller it = (Speller)element$iv$iv;
                        boolean bl3 = false;
                        if ((it.isAlien(word) ? null : (!allowSplitting && it instanceof GrazieSplittingSpeller ? ((GrazieSplittingSpeller)it).getSpeller() : it)) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    applicable = (List)destination$iv$iv;
                    if (applicable.isEmpty()) break block18;
                    Iterable $this$any$iv = applicable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Speller it = (Speller)element$iv;
                            boolean bl5 = false;
                            if (!(!Speller.isMisspelled$default(it, word, false, 2, null))) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block19;
            }
            return false;
        }
        if (this.languages.get(0).getBase() == Language.ENGLISH && !Intrinsics.areEqual((Object)(normalized = TextKt.normalizeAccents(word)), (Object)word)) {
            boolean bl;
            block17: {
                Iterable $this$all$iv = applicable;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl6;
                        Speller it;
                        block16: {
                            it = (Speller)element$iv;
                            boolean bl7 = false;
                            Iterable $this$any$iv = it.languages();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl6 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    LanguageWithVariant lwv = (LanguageWithVariant)element$iv2;
                                    boolean bl8 = false;
                                    if (!(lwv.getBase() == Language.ENGLISH)) continue;
                                    bl6 = true;
                                    break block16;
                                }
                                bl6 = false;
                            }
                        }
                        if (bl6 && Speller.isMisspelled$default(it, normalized, false, 2, null)) continue;
                        bl = false;
                        break block17;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinkedHashSet<String> suggestions(@NotNull String word) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Suggestions suggestions = this.rankedSuggestions(word);
        Map map = suggestions != null ? suggestions.getRanked() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable $this$sortedByDescending$iv = map.entrySet();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return CollectionsKt.toLinkedSet((List)destination$iv$iv);
    }

    @Nullable
    protected final Suggestions rankedSuggestions(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Suggestions[] suggestionsArray = this.sugCache.computeIfAbsent(word, arg_0 -> TextSpeller.rankedSuggestions$lambda$20(arg_0 -> TextSpeller.rankedSuggestions$lambda$19(this, word, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)suggestionsArray, (String)"computeIfAbsent(...)");
        return (Suggestions)ArraysKt.firstOrNull((Object[])suggestionsArray);
    }

    private static final String checkText$lambda$2(Tokenizer.Token it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getToken();
    }

    private static final boolean checkText$lambda$3(TextSpeller this$0, String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return !ignoreDict.matches(word) && this$0.isMisspelled(word, true);
    }

    private static final boolean ignoreGerman$lambda$6(TextSpeller this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isMisspelled(it, false);
    }

    private static final Boolean isMisspelled$lambda$11(TextSpeller this$0, String $word, boolean $allowSplitting, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.computeIsMisspelled($word, $allowSplitting);
    }

    private static final Boolean isMisspelled$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Suggestions[] rankedSuggestions$lambda$19(TextSpeller this$0, String $word, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (Speller speller : this$0.spellers) {
            Map<String, Double> suggest;
            if (speller.isAlien($word) || !(!(suggest = speller.suggestAndRank($word, this$0.getSuggestionLimit())).isEmpty())) continue;
            Suggestions[] suggestionsArray = new Suggestions[]{new Suggestions(speller, suggest)};
            return suggestionsArray;
        }
        return new Suggestions[0];
    }

    private static final Suggestions[] rankedSuggestions$lambda$20(Function1 $tmp0, Object p0) {
        return (Suggestions[])$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/grazie/spell/text/TextSpeller$Companion;", "", "<init>", "()V", "tokenizer", "Lai/grazie/nlp/tokenizer/retokenizer/PatternRetokenizer;", "ignorePattern", "Lai/grazie/nlp/patterns/AggregatedPattern;", "ignoreDict", "Lai/grazie/spell/dictionary/rule/IgnoreRuleDictionary;", "shortenedArticle", "Lkotlin/text/Regex;", "versionAbbr", "looksLikeGermanWord", "anySnakeKebabName", "Lai/grazie/nlp/patterns/Pattern;", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lai/grazie/spell/text/TextSpeller$Suggestions;", "", "speller", "Lai/grazie/spell/Speller;", "ranked", "", "", "", "<init>", "(Lai/grazie/spell/Speller;Ljava/util/Map;)V", "getSpeller", "()Lai/grazie/spell/Speller;", "getRanked", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "gec-spell-engine-local"})
    protected static final class Suggestions {
        @NotNull
        private final Speller speller;
        @NotNull
        private final Map<String, Double> ranked;

        public Suggestions(@NotNull Speller speller, @NotNull Map<String, Double> ranked) {
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            Intrinsics.checkNotNullParameter(ranked, (String)"ranked");
            this.speller = speller;
            this.ranked = ranked;
        }

        @NotNull
        public final Speller getSpeller() {
            return this.speller;
        }

        @NotNull
        public final Map<String, Double> getRanked() {
            return this.ranked;
        }

        @NotNull
        public final Speller component1() {
            return this.speller;
        }

        @NotNull
        public final Map<String, Double> component2() {
            return this.ranked;
        }

        @NotNull
        public final Suggestions copy(@NotNull Speller speller, @NotNull Map<String, Double> ranked) {
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            Intrinsics.checkNotNullParameter(ranked, (String)"ranked");
            return new Suggestions(speller, ranked);
        }

        public static /* synthetic */ Suggestions copy$default(Suggestions suggestions, Speller speller, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                speller = suggestions.speller;
            }
            if ((n & 2) != 0) {
                map = suggestions.ranked;
            }
            return suggestions.copy(speller, map);
        }

        @NotNull
        public String toString() {
            return "Suggestions(speller=" + this.speller + ", ranked=" + this.ranked + ")";
        }

        public int hashCode() {
            int result2 = this.speller.hashCode();
            result2 = result2 * 31 + ((Object)this.ranked).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Suggestions)) {
                return false;
            }
            Suggestions suggestions = (Suggestions)other;
            if (!Intrinsics.areEqual((Object)this.speller, (Object)suggestions.speller)) {
                return false;
            }
            return Intrinsics.areEqual(this.ranked, suggestions.ranked);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lai/grazie/spell/text/TextSpeller$TokenizedText;", "", "text", "", "allTokens", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "tokensToSpellCheck", "<init>", "(Ljava/lang/CharSequence;Ljava/util/List;Ljava/util/List;)V", "getText", "()Ljava/lang/CharSequence;", "getAllTokens", "()Ljava/util/List;", "getTokensToSpellCheck", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gec-spell-engine-local"})
    protected static final class TokenizedText {
        @NotNull
        private final CharSequence text;
        @NotNull
        private final List<Tokenizer.Token> allTokens;
        @NotNull
        private final List<Tokenizer.Token> tokensToSpellCheck;

        public TokenizedText(@NotNull CharSequence text2, @NotNull List<Tokenizer.Token> allTokens, @NotNull List<Tokenizer.Token> tokensToSpellCheck) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(allTokens, (String)"allTokens");
            Intrinsics.checkNotNullParameter(tokensToSpellCheck, (String)"tokensToSpellCheck");
            this.text = text2;
            this.allTokens = allTokens;
            this.tokensToSpellCheck = tokensToSpellCheck;
        }

        @NotNull
        public final CharSequence getText() {
            return this.text;
        }

        @NotNull
        public final List<Tokenizer.Token> getAllTokens() {
            return this.allTokens;
        }

        @NotNull
        public final List<Tokenizer.Token> getTokensToSpellCheck() {
            return this.tokensToSpellCheck;
        }

        @NotNull
        public final CharSequence component1() {
            return this.text;
        }

        @NotNull
        public final List<Tokenizer.Token> component2() {
            return this.allTokens;
        }

        @NotNull
        public final List<Tokenizer.Token> component3() {
            return this.tokensToSpellCheck;
        }

        @NotNull
        public final TokenizedText copy(@NotNull CharSequence text2, @NotNull List<Tokenizer.Token> allTokens, @NotNull List<Tokenizer.Token> tokensToSpellCheck) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(allTokens, (String)"allTokens");
            Intrinsics.checkNotNullParameter(tokensToSpellCheck, (String)"tokensToSpellCheck");
            return new TokenizedText(text2, allTokens, tokensToSpellCheck);
        }

        public static /* synthetic */ TokenizedText copy$default(TokenizedText tokenizedText, CharSequence charSequence, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                charSequence = tokenizedText.text;
            }
            if ((n & 2) != 0) {
                list = tokenizedText.allTokens;
            }
            if ((n & 4) != 0) {
                list2 = tokenizedText.tokensToSpellCheck;
            }
            return tokenizedText.copy(charSequence, list, list2);
        }

        @NotNull
        public String toString() {
            return "TokenizedText(text=" + this.text + ", allTokens=" + this.allTokens + ", tokensToSpellCheck=" + this.tokensToSpellCheck + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + ((Object)this.allTokens).hashCode();
            result2 = result2 * 31 + ((Object)this.tokensToSpellCheck).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenizedText)) {
                return false;
            }
            TokenizedText tokenizedText = (TokenizedText)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)tokenizedText.text)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allTokens, tokenizedText.allTokens)) {
                return false;
            }
            return Intrinsics.areEqual(this.tokensToSpellCheck, tokenizedText.tokensToSpellCheck);
        }
    }
}

