/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references.extensions;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.spring.security.references.extensions.SpringSecurityRolesProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public abstract class SpringSecurityRoleMethodInvocation
implements SpringSecurityRolesProvider {
    @Override
    @NotNull
    public UExpressionPattern<UExpression, ?> getUastPattern() {
        UExpressionPattern uExpressionPattern = UastPatterns.injectionHostOrReferenceExpression().inCall((ElementPattern)UastPatterns.callExpression().withMethodNames(Arrays.asList(this.getMethodNames())).withReceiver((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName(this.getClassName())));
        if (uExpressionPattern == null) {
            SpringSecurityRoleMethodInvocation.$$$reportNull$$$0(0);
        }
        return uExpressionPattern;
    }

    @NotNull
    protected abstract String[] getMethodNames();

    @NotNull
    protected abstract String getClassName();

    @Override
    public boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            SpringSecurityRoleMethodInvocation.$$$reportNull$$$0(1);
        }
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)this.getClassName());
    }

    @Override
    @NotNull
    public Set<String> getRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleMethodInvocation.$$$reportNull$$$0(2);
        }
        HashSet<String> allRoles = new HashSet<String>();
        GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(this.getClassName(), scope);
        if (psiClass != null) {
            for (String methodName : this.getMethodNames()) {
                for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
                    Set rolesDefinitionExpressions = MethodReferencesSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)false).findAll().stream().map(reference -> (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)reference.getElement(), UCallExpression.class)).filter(Objects::nonNull).map(expr -> expr.getArgumentForParameter(0)).filter(Objects::nonNull).collect(Collectors.toSet());
                    for (UExpression uExpression : rolesDefinitionExpressions) {
                        if (uExpression instanceof UExpressionList) {
                            for (UExpression roleDefinitionExpression : ((UExpressionList)uExpression).getExpressions()) {
                                ContainerUtil.addIfNotNull(allRoles, (Object)UastUtils.evaluateString((UExpression)roleDefinitionExpression));
                            }
                            continue;
                        }
                        ContainerUtil.addIfNotNull(allRoles, (Object)UastUtils.evaluateString((UExpression)uExpression));
                    }
                }
            }
        }
        HashSet<String> hashSet = allRoles;
        if (hashSet == null) {
            SpringSecurityRoleMethodInvocation.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/extensions/SpringSecurityRoleMethodInvocation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUastPattern";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/extensions/SpringSecurityRoleMethodInvocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRoles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

