/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.cassandra.generator.producers.CassTableProducersKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassTrigger;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.dialects.cassandra.model.defaults.CassTablePropertyKind;
import com.intellij.database.dialects.cassandra.model.properties.CassKeyColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.types.DasType;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.cassandra.CassTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlWhereClauseImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0014J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020'2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020)2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J \u0010.\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020/2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020!012\u0006\u00102\u001a\u000203H\u0002J\u001e\u00104\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020+\u0018\u0001052\u0006\u0010\b\u001a\u000203H\u0002J \u00106\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J+\u00108\u001a\u0004\u0018\u00010#2\u0006\u0010\"\u001a\u00020#2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0:\"\u00020;H\u0002\u00a2\u0006\u0002\u0010<J\u0010\u0010=\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010\t2\u0006\u0010,\u001a\u00020-H\u0002J\u0019\u0010?\u001a\u0004\u0018\u00010@2\b\u0010\b\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010AJ\u0014\u0010B\u001a\u0004\u0018\u00010!2\b\u0010\b\u001a\u0004\u0018\u00010#H\u0002J \u0010C\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020D2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006E"}, d2={"Lcom/intellij/database/dialects/cassandra/CassObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "finalizeKey", "Lcom/intellij/database/model/basic/BasicModKey;", "finalizeIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "buildSchema", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "buildRole", "Lcom/intellij/database/dialects/cassandra/model/CassRole;", "buildTrigger", "Lcom/intellij/database/dialects/cassandra/model/CassTrigger;", "buildAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "findReferenceNameInNextSiblings", "", "element", "Lcom/intellij/psi/PsiElement;", "buildFunction", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "buildTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "buildLikeTable", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "getClusteringOrder", "Lcom/intellij/database/dialects/cassandra/model/properties/CassKeyColumn$Companion$ClusteringOrder;", "ref", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "buildKey", "Lcom/intellij/database/dialects/cassandra/model/CassKey;", "clusteringColNames", "", "key", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "getClusteringColOrder", "", "buildIndex", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "findPrevSibling", "skip", "", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/psi/PsiElement;", "getName", "resolve", "findDouble", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Double;", "findMap", "buildMatView", "Lcom/intellij/database/dialects/cassandra/model/CassMatView;", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassObjectBuilder.kt\ncom/intellij/database/dialects/cassandra/CassObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,375:1\n614#2,7:376\n621#2,3:384\n625#2,5:387\n614#2,10:392\n625#2,5:402\n614#2,10:407\n625#2,5:417\n614#2,10:422\n625#2,5:432\n614#2,7:437\n660#2,6:444\n621#2,3:450\n615#2:453\n625#2,5:454\n614#2,10:459\n637#2:469\n625#2,5:470\n614#2,10:475\n625#2,5:485\n625#2,5:511\n625#2,5:520\n1#3:383\n1563#4:490\n1634#4,3:491\n1563#4:494\n1634#4,3:495\n1563#4:498\n1634#4,3:499\n295#4,2:503\n1193#4,2:505\n1267#4,4:507\n1563#4:516\n1634#4,3:517\n455#5:502\n*S KotlinDebug\n*F\n+ 1 CassObjectBuilder.kt\ncom/intellij/database/dialects/cassandra/CassObjectBuilder\n*L\n80#1:376,7\n80#1:384,3\n91#1:387,5\n100#1:392,10\n114#1:402,5\n120#1:407,10\n131#1:417,5\n144#1:422,10\n175#1:432,5\n184#1:437,7\n195#1:444,6\n184#1:450,3\n184#1:453\n211#1:454,5\n218#1:459,10\n228#1:469\n228#1:470,5\n231#1:475,10\n265#1:485,5\n309#1:511,5\n361#1:520,5\n272#1:490\n272#1:491,3\n273#1:494\n273#1:495,3\n287#1:498\n287#1:499,3\n299#1:503,2\n302#1:505,2\n302#1:507,4\n315#1:516\n315#1:517,3\n298#1:502\n*E\n"})
public final class CassObjectBuilder
extends SqlObjectBuilderImpl {
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof CassTable) {
            this.buildLikeTable((CassLikeTable)obj, source, context);
        } else if (basicModElement instanceof CassTableColumn) {
            this.buildTableColumn((CassTableColumn)obj, source, context);
        } else if (basicModElement instanceof CassMatView) {
            this.buildMatView((CassMatView)obj, source, context);
        } else if (basicModElement instanceof CassKey) {
            this.buildKey((CassKey)obj, source, context);
        } else if (basicModElement instanceof CassFunction) {
            this.buildFunction((CassFunction)obj, source, context);
        } else if (basicModElement instanceof CassAggregate) {
            this.buildAggregate((CassAggregate)obj, source, context);
        } else if (basicModElement instanceof CassTrigger) {
            this.buildTrigger((CassTrigger)obj, source, context);
        } else if (basicModElement instanceof CassRole) {
            this.buildRole((CassRole)obj, source, context);
        } else if (basicModElement instanceof CassSchema) {
            this.buildSchema((CassSchema)obj, source, context);
        } else if (basicModElement instanceof CassIndex) {
            this.buildIndex((CassIndex)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    protected void finalizeKey(@NotNull BasicModKey obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
    }

    protected void finalizeIndex(@NotNull BasicModIndex obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
    }

    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)path.kind, (Object)ObjectKind.MAT_VIEW) ? TextRange.EMPTY_RANGE : super.getCompactDefinition(path, text, def);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSchema(CassSchema obj, DasObject source, SqlObjectBuilder.Context context) {
        void this_$iv;
        super.buildNamespace((BasicModNamespace)obj, source, context);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        Map properties = new LinkedHashMap();
        PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)source), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
        if (psiElement == null) {
            return;
        }
        PsiElement optionsClause = psiElement;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        PsiElement el$iv = optionsClause;
        boolean $i$f$forEachChild = false;
        void var9_9 = this_$iv;
        PsiElement first$iv$iv = el$iv.getFirstChild();
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            IElementType iElementType;
            PsiElement el = tmp$iv$iv;
            boolean bl = false;
            PsiElement psiElement2 = el.getFirstChild();
            Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_REPLICATION)) {
                if (this.findMap(el) != null) {
                    String replication;
                    boolean bl2 = false;
                    properties.put(CassSchemaPropertyKind.REPLICATION, replication);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DURABLE_WRITES)) continue;
            Boolean bl3 = this.findBoolean(el);
            if (bl3 == null) continue;
            boolean durable_writes = bl3;
            boolean bl4 = false;
            properties.put(CassSchemaPropertyKind.DURABLE_WRITES, CassTableProducersKt.toLiteral(durable_writes));
        }
        obj.setProperties(properties);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRole(CassRole obj, DasObject source, SqlObjectBuilder.Context context) {
        CassRole stubbed;
        BasicElement basicElement;
        super.buildBasicElement((BasicModElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof CassRole) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassRole)) {
                object = null;
            }
            basicElement = (BasicElement)((CassRole)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassRole)basicElement) != null) {
            obj.setSuperRole(stubbed.isSuperRole());
            obj.setCanLogin(stubbed.isCanLogin());
        } else {
            void this_$iv;
            boolean isSuperRole = false;
            boolean isCanLogin = false;
            PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)(source instanceof PsiElement ? (PsiElement)source : null), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
            if (psiElement == null) {
                return;
            }
            PsiElement optionsClause = psiElement;
            dasObject = this;
            PsiElement el$iv = optionsClause;
            boolean $i$f$forEachChild = false;
            void var11_14 = this_$iv;
            PsiElement first$iv$iv = el$iv.getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                boolean it;
                IElementType iElementType;
                PsiElement c;
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement2 = c = it2.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SUPERUSER)) {
                    Boolean bl2 = this.findBoolean(c);
                    if (bl2 != null) {
                        it = bl2;
                        boolean bl3 = false;
                        isSuperRole = it;
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LOGIN)) continue;
                Boolean bl4 = this.findBoolean(c);
                if (bl4 == null) continue;
                it = bl4;
                boolean bl5 = false;
                isCanLogin = it;
            }
            obj.setSuperRole(isSuperRole);
            obj.setCanLogin(isCanLogin);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTrigger(CassTrigger obj, DasObject source, SqlObjectBuilder.Context context) {
        String string;
        StubElement stubElement;
        BasicElement basicElement;
        super.buildTrigger((BasicModTrigger)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof CassTrigger) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassTrigger)) {
                object = null;
            }
            basicElement = (BasicElement)((CassTrigger)object);
        } else {
            basicElement = null;
        }
        CassTrigger stubbed = (CassTrigger)basicElement;
        CassTrigger cassTrigger = obj;
        if (stubbed != null) {
            string = stubbed.getClassName();
        } else {
            void el$iv;
            void this_$iv;
            String className = null;
            $this$stubbed$iv = this;
            PsiElement $i$f$stubbed2 = source instanceof PsiElement ? (PsiElement)source : null;
            CassTrigger cassTrigger2 = cassTrigger;
            boolean $i$f$forEachChild = false;
            stubElement = this_$iv;
            void v5 = el$iv;
            PsiElement first$iv$iv = v5 != null ? v5.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                String it;
                PsiElement e = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement = e.getFirstChild();
                if (!Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)CassTypes.CASS_USING)) continue;
                if (this.findString(e.getFirstChild()) == null) continue;
                boolean bl2 = false;
                className = it;
            }
            cassTrigger = cassTrigger2;
            string = className;
        }
        cassTrigger.setClassName(string);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAggregate(CassAggregate obj, DasObject source, SqlObjectBuilder.Context context) {
        CassAggregate stubbed;
        StubElement stubElement;
        BasicElement basicElement;
        super.buildRoutine((BasicModRoutine)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof CassAggregate) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassAggregate)) {
                object = null;
            }
            basicElement = (BasicElement)((CassAggregate)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassAggregate)basicElement) != null) {
            obj.setStateFunc(stubbed.getStateFunc());
            obj.setFinalFunc(stubbed.getFinalFunc());
            obj.setStateStoredType(stubbed.getStateType());
            obj.setInitCond(stubbed.getInitCond());
        } else {
            String stateFunc = null;
            String finalFunc = null;
            DasType stateType = null;
            DasType dasType = ModelConsts.NO_DAS_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"NO_DAS_TYPE");
            stateType = dasType;
            String initCond = null;
            if (source instanceof SqlCreateStatement) {
                void this_$iv;
                stubElement = this;
                PsiElement el$iv = (PsiElement)source;
                boolean $i$f$forEachChild = false;
                void var12_13 = this_$iv;
                PsiElement first$iv$iv = el$iv.getFirstChild();
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    SqlExpression expression;
                    String funcName;
                    IElementType iElementType;
                    PsiElement it = tmp$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement = it.getFirstChild();
                    Object object = iElementType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SFUNC)) {
                        PsiElement psiElement2 = it.getFirstChild();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
                        if (this.findReferenceNameInNextSiblings(psiElement2) != null) {
                            boolean bl2 = false;
                            stateFunc = funcName;
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_FINALFUNC)) {
                        PsiElement psiElement3 = it.getFirstChild();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                        if (this.findReferenceNameInNextSiblings(psiElement3) != null) {
                            boolean bl3 = false;
                            finalFunc = funcName;
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_STYPE)) {
                        SqlTypeElement typeElement = (SqlTypeElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)it.getFirstChild(), SqlTypeElement.class);
                        if (typeElement == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)typeElement.getDasType(), (String)"getDasType(...)");
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_INITCOND) || (expression = (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)it.getFirstChild(), SqlExpression.class)) == null) continue;
                    initCond = expression.getText();
                }
            }
            obj.setStateFunc(stateFunc);
            obj.setFinalFunc(finalFunc);
            obj.setStateStoredType(stateType);
            obj.setInitCond(initCond);
        }
    }

    private final String findReferenceNameInNextSiblings(PsiElement element) {
        SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        DasObject dasObject = this.resolve(ref);
        return dasObject != null ? dasObject.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFunction(CassFunction obj, DasObject source, SqlObjectBuilder.Context context) {
        CassFunction stubbed;
        BasicElement basicElement;
        super.buildRoutine((BasicModRoutine)obj, source, context);
        if (!(source instanceof SqlCreateFunctionStatementImpl)) {
            return;
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof CassFunction) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassFunction)) {
                object = null;
            }
            basicElement = (BasicElement)((CassFunction)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassFunction)basicElement) != null) {
            obj.setCalledOnNullInput(stubbed.isCalledOnNullInput());
            obj.setLanguage(stubbed.getLanguage());
        } else {
            void this_$iv;
            Ref.ObjectRef sourceText = new Ref.ObjectRef();
            boolean isCalledOnNullInput = false;
            String language = null;
            dasObject = this;
            PsiElement el$iv = (PsiElement)source;
            boolean $i$f$forEachChild = false;
            void var11_13 = this_$iv;
            PsiElement first$iv$iv = el$iv.getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement lang;
                block12: {
                    PsiElement psiElement;
                    SqlObjectBuilderImpl range;
                    IElementType iElementType;
                    PsiElement it = tmp$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement2 = it.getFirstChild();
                    Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_AS)) {
                        String string;
                        SqlStringLiteralExpression stringLiteral = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)it, SqlStringLiteralExpression.class);
                        if (stringLiteral == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)ElementManipulators.getValueTextRange((PsiElement)((PsiElement)stringLiteral)), (String)"getValueTextRange(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringLiteral.getText(), (String)"getText(...)");
                        int n = range.getStartOffset();
                        int n2 = range.getEndOffset();
                        String string2 = string.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        sourceText.element = this.asComposite(string2, CompositeText.Kind.ORIGINAL_TEXT);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CALLED)) {
                        isCalledOnNullInput = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LANGUAGE)) continue;
                    range = this;
                    PsiElement element$iv = it.getFirstChild();
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv = element$iv; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it2 = tmp$iv;
                        boolean bl2 = false;
                        IElementType type = PsiTreeUtilKt.getElementType((PsiElement)it2);
                        if (!(Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_IDENT) || type instanceof SqlIdentifierKeywordTokenType)) continue;
                        psiElement = tmp$iv;
                        break block12;
                    }
                    psiElement = lang = null;
                }
                if (lang == null) continue;
                language = lang.getText();
            }
            this.assignSources(obj, context, () -> CassObjectBuilder.buildFunction$lambda$1(sourceText));
            obj.setCalledOnNullInput(isCalledOnNullInput);
            obj.setLanguage(language);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTableColumn(CassTableColumn obj, DasObject source, SqlObjectBuilder.Context context) {
        CassTableColumn stubbed;
        StubElement stubElement;
        BasicElement basicElement;
        super.build((BasicModElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof CassTableColumn) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassTableColumn)) {
                object = null;
            }
            basicElement = (BasicElement)((CassTableColumn)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassTableColumn)basicElement) != null) {
            obj.setStaticColumn(stubbed.isStaticColumn());
        } else {
            boolean isStatic = false;
            if (source instanceof SqlColumnDefinition) {
                void this_$iv;
                $this$stubbed$iv = this;
                PsiElement el$iv = (PsiElement)source;
                boolean $i$f$forEachChild = false;
                stubElement = this_$iv;
                PsiElement first$iv$iv = el$iv.getFirstChild();
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it = tmp$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)CassTypes.CASS_STATIC)) continue;
                    isStatic = true;
                }
            }
            obj.setStaticColumn(isStatic);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLikeTable(CassLikeTable obj, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbedOrBuild$iv;
        void this_$iv;
        super.buildBasicElement((BasicModElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject dasObject = source;
        BasicElement tgt$iv = (BasicElement)obj;
        boolean $i$f$stubbedOrBuild = false;
        BasicElement basicElement2 = this_$iv;
        void $this$stubbed$iv$iv = $this$stubbedOrBuild$iv;
        boolean $i$f$stubbed = false;
        void var12_11 = $this$stubbed$iv$iv;
        if (var12_11 instanceof CassLikeTable) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var12_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassLikeTable)) {
                object = null;
            }
            basicElement = (BasicElement)((CassLikeTable)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement3 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            BasicElement basicElement4 = ((BasicObjectNode)tgt$iv).getMetaObject().newDataObject();
            if (basicElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.cassandra.model.CassLikeTable");
            }
            basicElement2 = (BasicElement)((CassLikeTable)basicElement4);
            CassLikeTable $this$buildLikeTable_u24lambda_u240 = (CassLikeTable)basicElement2;
            boolean bl = false;
            PsiElement optionsClause = SqlImplUtil.getChildOfType((PsiElement)(source instanceof PsiElement ? (PsiElement)source : null), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
            Map prop = new LinkedHashMap();
            SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
            PsiElement el$iv = optionsClause;
            boolean $i$f$forEachChild = false;
            void var21_20 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                String v;
                double v2;
                PsiElement el = tmp$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)SqlCompositeElementTypes.SQL_CLAUSE)) continue;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)el.getFirstChild());
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMMENT)) {
                    $this$buildLikeTable_u24lambda_u240.setComment(this.findString(el.getFirstChild()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_BLOOM_FILTER_FP_CHANCE)) {
                    Double d = this.findDouble(el);
                    if (d != null) {
                        v2 = ((Number)d).doubleValue();
                        boolean bl3 = false;
                        prop.put(CassTablePropertyKind.BLOOM_FILTER_FP_CHANCE, CassTableProducersKt.toLiteral(v2));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CACHING)) {
                    if (this.findMap(el) != null) {
                        String v3;
                        boolean bl4 = false;
                        prop.put(CassTablePropertyKind.CACHING, v3);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CDC)) {
                    Boolean bl5 = this.findBoolean(el);
                    if (bl5 != null) {
                        boolean v4 = bl5;
                        boolean bl6 = false;
                        prop.put(CassTablePropertyKind.CDC, CassTableProducersKt.toLiteral(v4));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMPACTION)) {
                    if (this.findMap(el) != null) {
                        String v5;
                        boolean bl7 = false;
                        prop.put(CassTablePropertyKind.COMPACTION, v5);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMPRESSION)) {
                    if (this.findMap(el) != null) {
                        String v6;
                        boolean bl8 = false;
                        prop.put(CassTablePropertyKind.COMPRESSION, v6);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CRC_CHECK_CHANCE)) {
                    Double d = this.findDouble(el);
                    if (d != null) {
                        v2 = ((Number)d).doubleValue();
                        boolean bl9 = false;
                        prop.put(CassTablePropertyKind.CRC_CHECK_CHANCE, CassTableProducersKt.toLiteral(v2));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DCLOCAL_READ_REPAIR_CHANCE)) {
                    Double d = this.findDouble(el);
                    if (d != null) {
                        v2 = ((Number)d).doubleValue();
                        boolean bl10 = false;
                        prop.put(CassTablePropertyKind.DCLOCAL_READ_REPAIR_CHANCE, CassTableProducersKt.toLiteral(v2));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DEFAULT_TIME_TO_LIVE)) {
                    Integer n = this.findInt(el);
                    if (n != null) {
                        int v7 = ((Number)n).intValue();
                        boolean bl11 = false;
                        prop.put(CassTablePropertyKind.DEFAULT_TIME_TO_LIVE, CassTableProducersKt.toLiteral(v7));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_GC_GRACE_SECONDS)) {
                    Integer n = this.findInt(el);
                    if (n != null) {
                        int v8 = ((Number)n).intValue();
                        boolean bl12 = false;
                        prop.put(CassTablePropertyKind.GC_GRACE_SECONDS, CassTableProducersKt.toLiteral(v8));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MAX_INDEX_INTERVAL)) {
                    Integer n = this.findInt(el);
                    if (n != null) {
                        int v9 = ((Number)n).intValue();
                        boolean bl13 = false;
                        prop.put(CassTablePropertyKind.MAX_INDEX_INTERVAL, CassTableProducersKt.toLiteral(v9));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MEMTABLE_FLUSH_PERIOD_IN_MS)) {
                    Integer n = this.findInt(el);
                    if (n != null) {
                        int v10 = ((Number)n).intValue();
                        boolean bl14 = false;
                        prop.put(CassTablePropertyKind.MEMTABLE_FLUSH_PERIOD_IN_MS, CassTableProducersKt.toLiteral(v10));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MIN_INDEX_INTERVAL)) {
                    Integer n = this.findInt(el);
                    if (n != null) {
                        int v11 = ((Number)n).intValue();
                        boolean bl15 = false;
                        prop.put(CassTablePropertyKind.MIN_INDEX_INTERVAL, CassTableProducersKt.toLiteral(v11));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_READ_REPAIR_CHANCE)) {
                    Double d = this.findDouble(el);
                    if (d != null) {
                        v2 = ((Number)d).doubleValue();
                        boolean bl16 = false;
                        prop.put(CassTablePropertyKind.READ_REPAIR_CHANCE, CassTableProducersKt.toLiteral(v2));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SPECULATIVE_RETRY)) {
                    if (this.findString(el.getFirstChild()) != null) {
                        String v12;
                        boolean bl17 = false;
                        prop.put(CassTablePropertyKind.SPECULATIVE_RETRY, v12);
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_ADDITIONAL_WRITE_POLICY)) continue;
                if (this.findString(el.getFirstChild()) == null) continue;
                boolean bl18 = false;
                prop.put(CassTablePropertyKind.ADDITIONAL_WRITE_POLICY, v);
            }
            $this$buildLikeTable_u24lambda_u240.setProperties(prop);
            basicElement3 = basicElement2;
        }
        CassLikeTable src = (CassLikeTable)basicElement3;
        obj.setComment(src.getComment());
        obj.setProperties(src.getProperties());
    }

    private final CassKeyColumn.Companion.ClusteringOrder getClusteringOrder(SqlReferenceExpression ref) {
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((PsiElement)ref));
        return Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)SqlCommonKeywords.SQL_DESC) ? CassKeyColumn.Companion.ClusteringOrder.DESC : CassKeyColumn.Companion.ClusteringOrder.ASC;
    }

    private final void buildKey(CassKey obj, DasObject source, SqlObjectBuilder.Context context) {
        List list;
        StubElement stubElement;
        BasicElement basicElement;
        obj.setPrimary(true);
        if (!context.isStubBuilder()) {
            obj.setName("primary key");
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof CassKey) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassKey)) {
                object = null;
            }
            basicElement = (BasicElement)((CassKey)object);
        } else {
            basicElement = null;
        }
        CassKey stubbed = (CassKey)basicElement;
        CassKey cassKey = obj;
        CassKey cassKey2 = stubbed;
        if (cassKey2 != null) {
            list = cassKey2.getColumns();
        } else if (!(source instanceof SqlTableKeyDefinition)) {
            list = CollectionsKt.emptyList();
        } else {
            Collection<CassKeyColumn> collection;
            String it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List<String> clusteringColNames = this.clusteringColNames((SqlTableKeyDefinition)source);
            Map<String, CassKeyColumn.Companion.ClusteringOrder> clusteringColOrder = this.getClusteringColOrder((SqlTableKeyDefinition)source);
            Iterable $i$f$stubbed2 = clusteringColNames;
            CassKey cassKey3 = cassKey;
            boolean $i$f$map = false;
            stubElement = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                Object object = clusteringColOrder;
                if (object == null || (object = object.get(it)) == null) {
                    object = CassKeyColumn.Companion.ClusteringOrder.ASC;
                }
                collection2.add(new CassKeyColumn(it, (CassKeyColumn.Companion.ClusteringOrder)((Object)object)));
            }
            Collection collection3 = (List)destination$iv$iv;
            MultiRef multiRef = ((SqlTableKeyDefinition)source).getColumnsRef();
            Intrinsics.checkNotNullExpressionValue((Object)multiRef, (String)"getColumnsRef(...)");
            $this$map$iv = this.collectNames(multiRef);
            collection2 = collection3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CassKeyColumn(it, null));
            }
            collection = (List)destination$iv$iv;
            cassKey = cassKey3;
            list = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        }
        cassKey.setColumns(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> clusteringColNames(SqlTableKeyDefinition key) {
        SqlColumnDefinitionImpl column = (SqlColumnDefinitionImpl)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)key), SqlColumnDefinitionImpl.class);
        if (column != null) {
            return CollectionsKt.emptyList();
        }
        SqlReferenceList[] referenceLists = (SqlReferenceList[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)key), SqlReferenceList.class);
        if (referenceLists != null && referenceLists.length > 1) {
            void $this$mapTo$iv$iv;
            List list = SqlImplUtil.getReferenceList((SqlReferenceList)referenceLists[1]);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getReferenceList(...)");
            List list2 = list;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(this.getName((SqlReferenceExpression)it));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, CassKeyColumn.Companion.ClusteringOrder> getClusteringColOrder(SqlTableKeyDefinition source) {
        Object v3;
        block6: {
            void $this$firstOrNull$iv;
            PsiElement optionsClause;
            SqlTableDefinition sqlTableDefinition = (SqlTableDefinition)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)source), SqlTableDefinition.class);
            if (sqlTableDefinition == null) {
                return null;
            }
            SqlTableDefinition tableDef = sqlTableDefinition;
            PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)tableDef), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
            if (psiElement == null) {
                return null;
            }
            Object $this$childrenOfType$iv = optionsClause = psiElement;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlClause.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            $this$childrenOfType$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlClause it = (SqlClause)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it.getFirstChild()), (Object)CassTypes.CASS_CLUSTERING)) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        SqlClause sqlClause = v3;
        if (sqlClause != null) {
            SqlClause el = sqlClause;
            boolean bl = false;
            SqlReferenceList referenceList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)el), SqlReferenceList.class);
            Object object = referenceList;
            if (object != null && (object = object.getReferenceList()) != null) {
                void $this$associateTo$iv$iv;
                Iterable $this$associate$iv = (Iterable)object;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    SqlReferenceExpression ref = (SqlReferenceExpression)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)ref);
                    Pair pair = new Pair((Object)this.getName(ref), (Object)this.getClusteringOrder(ref));
                    map.put(pair.getFirst(), pair.getSecond());
                }
                return destination$iv$iv;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildIndex(CassIndex obj, DasObject source, SqlObjectBuilder.Context context) {
        List list;
        BasicElement basicElement;
        this.buildNamedElement((BasicModNamedElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        Object $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof CassIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((CassIndex)object);
        } else {
            basicElement = null;
        }
        CassIndex stubbed = (CassIndex)basicElement;
        CassIndex cassIndex = obj;
        if (stubbed != null) {
            list = stubbed.getColumns();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list2 = SqlImplUtil.getReferenceList((SqlReferenceList)((SqlReferenceList)PsiTreeUtil.findChildOfType((PsiElement)(source instanceof PsiElement ? (PsiElement)source : null), SqlReferenceList.class)));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getReferenceList(...)");
            List list3 = list2;
            $this$stubbed$iv = list3;
            CassIndex cassIndex2 = cassIndex;
            boolean $i$f$map = false;
            dasObject = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IElementType iElementType;
                void expression;
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)expression);
                PsiElement psiElement = (PsiElement)expression;
                IElementType[] iElementTypeArray = new IElementType[2];
                Intrinsics.checkNotNullExpressionValue((Object)CassTypes.CASS_LEFT_PAREN, (String)"CASS_LEFT_PAREN");
                Intrinsics.checkNotNullExpressionValue((Object)TokenType.WHITE_SPACE, (String)"WHITE_SPACE");
                PsiElement prevSibling = this.findPrevSibling(psiElement, iElementTypeArray);
                String modifier = prevSibling == null ? null : (Intrinsics.areEqual((Object)(iElementType = PsiTreeUtilKt.getElementType((PsiElement)prevSibling)), (Object)CassTypes.CASS_FULL) ? "full" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_KEYS) ? "keys" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_ENTRIES) ? "entries" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_VALUES) ? "values" : null))));
                collection.add(new IndexColumn(this.getName((SqlReferenceExpression)expression), modifier));
            }
            list = (List)destination$iv$iv;
            cassIndex = cassIndex2;
        }
        cassIndex.setColumns(list);
    }

    private final PsiElement findPrevSibling(PsiElement element, IElementType ... skip) {
        PsiElement prevSibling;
        for (prevSibling = element.getPrevSibling(); prevSibling != null && ArraysKt.contains((Object[])skip, (Object)PsiTreeUtilKt.getElementType((PsiElement)prevSibling)); prevSibling = prevSibling.getPrevSibling()) {
        }
        return prevSibling;
    }

    private final String getName(SqlReferenceExpression ref) {
        Object object = this.resolve(ref);
        if (object == null || (object = object.getName()) == null) {
            String string = ref.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return object;
    }

    private final DasObject resolve(SqlReferenceExpression ref) {
        ResolveResult[] resolveResultArray = ref.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        for (ResolveResult result : resolveResultArray) {
            PsiElement element = result.getElement();
            if (!(element instanceof DasObject)) continue;
            return (DasObject)element;
        }
        return null;
    }

    private final Double findDouble(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toDoubleOrNull((String)object) : null;
    }

    private final String findMap(PsiElement source) {
        IElementType iElementType = CassTypes.CASS_SET_OR_MAP_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CASS_SET_OR_MAP_LITERAL");
        PsiElement psiElement = this.findChild(source, iElementType);
        return psiElement != null ? psiElement.getText() : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void buildMatView(CassMatView obj, DasObject source, SqlObjectBuilder.Context context) {
        block8: {
            block7: {
                this.buildLikeTable(obj, source, context);
                var5_4 = this;
                $this$stubbed$iv = source;
                $i$f$stubbed = false;
                var8_8 = $this$stubbed$iv;
                if (var8_8 instanceof CassMatView) {
                    v0 = (BasicElement)$this$stubbed$iv;
                } else if (var8_8 instanceof SqlStubbedElement) {
                    var9_9 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    v1 = var9_9 instanceof SqlDefinitionStub != false ? (SqlDefinitionStub)var9_9 : null;
                    v2 /* !! */  = v1 != null ? v1.getElement() : null;
                    if (!(v2 /* !! */  instanceof CassMatView)) {
                        v2 /* !! */  = null;
                    }
                    v0 = (BasicElement)((CassMatView)v2 /* !! */ );
                } else {
                    v0 = null;
                }
                if ((stubbed = (CassMatView)v0) == null) break block7;
                obj.setBaseTableName(stubbed.getBaseTableName());
                obj.setWhereClause(stubbed.getWhereClause());
                break block8;
            }
            stmt = source instanceof SqlCreateViewStatement != false ? (SqlCreateViewStatement)source : null;
            fromClause = (SqlFromClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)stmt), SqlFromClause.class);
            v3 = fromClause;
            obj.setBaseTableName(v3 != null && (v3 = v3.getFromExpression()) != null ? v3.getText() : null);
            whereClause = (SqlWhereClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)stmt), SqlWhereClauseImpl.class);
            v4 = whereClause;
            if (v4 == null || (v4 = v4.getText()) == null) ** GOTO lbl-1000
            v5 = v4.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
            v4 = v5;
            if (v5 != null) {
                v6 = StringsKt.trim((CharSequence)((CharSequence)v4)).toString();
            } else lbl-1000:
            // 2 sources

            {
                v6 = null;
            }
            obj.setWhereClause(v6);
        }
    }

    private static final CompositeText buildFunction$lambda$1(Ref.ObjectRef $sourceText) {
        return (CompositeText)$sourceText.element;
    }
}

