/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafPsiCompositeElementImpl;
import com.intellij.thymeleaf.lang.support.ThymeleafBundleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThymeleafMessageReferenceImpl
extends ThymeleafPsiCompositeElementImpl {
    public ThymeleafMessageReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            ThymeleafMessageReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PsiReference getReference() {
        return new PropertyReference(this.getText(), this, null, false){

            @NotNull
            protected List<PropertiesFile> getPropertiesFiles() {
                HashSet<PropertiesFile> files = new HashSet<PropertiesFile>();
                for (ThymeleafBundleProvider provider : ThymeleafBundleProvider.EP_NAME.getExtensionList()) {
                    files.addAll(provider.getPropertiesFile(ThymeleafMessageReferenceImpl.this));
                }
                return new ArrayList<PropertiesFile>(files);
            }

            public Object @NotNull [] getVariants() {
                HashSet allVariants = new HashSet();
                List<PropertiesFile> files = this.getPropertiesFiles();
                for (PropertiesFile propertiesFile : files) {
                    PropertiesPsiCompletionUtil.addVariantsFromFile((PropertyReferenceBase)this, (PropertiesFile)propertiesFile, allVariants);
                }
                HashMap<String, LookupElementBuilder> filtered = new HashMap<String, LookupElementBuilder>();
                for (Object variant : allVariants) {
                    IProperty property;
                    String propertyKey;
                    if (variant instanceof String) {
                        filtered.put((String)variant, LookupElementBuilder.create((String)((String)variant)).withIcon(PlatformIcons.PROPERTY_ICON));
                    }
                    if (!(variant instanceof IProperty) || (propertyKey = (property = (IProperty)variant).getKey()) == null) continue;
                    filtered.put(propertyKey, LookupElementBuilder.create((String)propertyKey).withIcon(PlatformIcons.PROPERTY_ICON));
                }
                Object[] objectArray = ArrayUtil.toObjectArray(filtered.values());
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
                return new LocalQuickFix[]{PropertiesQuickFixFactory.getInstance().createCreatePropertyFix(this.myElement, this.myKey, this.getPropertiesFiles())};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafMessageReferenceImpl$1", "getVariants"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafMessageReferenceImpl", "<init>"));
    }
}

