/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.sql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.sqlite.sql.SqliteDdlParsing;
import com.intellij.database.dialects.sqlite.sql.SqliteDialect;
import com.intellij.database.dialects.sqlite.sql.SqliteDmlParsing;
import com.intellij.database.dialects.sqlite.sql.SqliteExpressionParsing;
import com.intellij.database.dialects.sqlite.sql.SqliteGeneratedParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public class SqliteParser
extends SqlParser {
    public SqliteParser() {
        super((SqlLanguageDialectEx)SqliteDialect.INSTANCE);
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return SqliteGeneratedParser.statement(builder, level);
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return SqliteGeneratedParser.parse_root_(root, builder, level);
    }

    protected boolean parseArgumentListInner(PsiBuilder builder) {
        if (PsiTreeUtil.getParentOfType((PsiElement)SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder), SqlCreateIndexStatement.class) != null) {
            SqlGeneratedParserUtil.setOn((PsiBuilder)builder, (int)0, (String)"FORBID_QUALIFICATION");
        }
        return super.parseArgumentListInner(builder);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return SqliteGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return SqliteDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? SqliteDdlParsing.type_element_ext(builder, level) : SqliteDdlParsing.type_element(builder, level);
    }

    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        return super.parseParameterReferenceInner(builder, (IElementType)SQL_PARAMETER_REFERENCE);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, SqliteExpressionParsing::evaluable_expression);
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result = super.consumeCustomParameterReference(builder);
        if (result != null) {
            return result;
        }
        if (!SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_DOLLAR)) {
            return null;
        }
        IElementType type = builder.rawLookup(1);
        if (!this.isIdentifierToken(builder, type, true, false)) {
            return null;
        }
        builder.advanceLexer();
        builder.advanceLexer();
        while (SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SQL_COLON)) {
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_COLON);
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_IDENT);
        }
        if (SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SQL_LEFT_PAREN)) {
            SqlParserUtil.consumeAllTokensUpTo((PsiBuilder)builder, (IElementType[])new IElementType[]{SQL_RIGHT_PAREN, SQL_SEMICOLON});
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
        }
        return SQL_PARAMETER_REFERENCE;
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = SqliteExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        boolean res = super.parseFunctionCallTail(builder, level);
        if (res) {
            SqliteGeneratedParser.analytic_clause(builder, level);
        }
        return res;
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, SqliteExpressionParsing::parenthesized_query_or_values, SqliteDmlParsing::top_query_expression, SqliteParser::parseTopQueryExpressionTail, SqliteExpressionParsing::row_element_list, (b, l) -> SqliteExpressionParsing.root_expr_0(b, l, -1) && SqliteExpressionParsing.row_element_list_separator(b, l) && SqliteExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, SqliteDmlParsing::parenthesized_aliased_join_expression, SqliteDmlParsing::top_query_expression, SqliteParser::parseTopQueryExpressionTail, SqliteDmlParsing::comma_join_expression, (b, l) -> SqliteDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return SqliteGeneratedParser.table_opt_column_list(builder, level);
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        SqliteDmlParsing.query_expression_0(builder, level, -1);
        return SqliteDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

