/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions.convert;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.notebooks.visualization.NotebookCellLines;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J0\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002J\"\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0002J\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/py/actions/convert/PythonCellLinesEditHelper;", "Lcom/intellij/jupyter/core/core/api/actions/NotebookCellLinesEditHelper;", "<init>", "()V", "makeCell", "", "source", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "customHeader", "makeInsertedCells", "notebookCellsContents", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellsContents;", "targetOrdinal", "", "getContent", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "rawIntervalText", "splitCells", "", "Lkotlin/Pair;", "rawText", "intervals", "addHeader", "getHeader", "startsWithHeader", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nPythonCellLinesEditHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonCellLinesEditHelper.kt\ncom/intellij/jupyter/py/actions/convert/PythonCellLinesEditHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1563#2:76\n1634#2,3:77\n*S KotlinDebug\n*F\n+ 1 PythonCellLinesEditHelper.kt\ncom/intellij/jupyter/py/actions/convert/PythonCellLinesEditHelper\n*L\n55#1:76\n55#1:77,3\n*E\n"})
public final class PythonCellLinesEditHelper
implements NotebookCellLinesEditHelper {
    @NotNull
    public String makeCell(@NotNull String source, @NotNull NotebookCellLines.CellType cellType, @Nullable String customHeader) {
        String string;
        boolean isPythonCode;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        boolean bl = isPythonCode = cellType == NotebookCellLines.CellType.CODE && customHeader == null;
        if (isPythonCode) {
            string = source;
        } else {
            String[] stringArray = new String[]{"\n"};
            string = SequencesKt.joinToString$default((Sequence)StringsKt.splitToSequence$default((CharSequence)source, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, PythonCellLinesEditHelper::makeCell$lambda$0, (int)30, null);
        }
        String mayBeCommentedSource = string;
        return this.addHeader(cellType, mayBeCommentedSource, customHeader);
    }

    @NotNull
    public String makeInsertedCells(@NotNull NotebookCellsContents notebookCellsContents, int targetOrdinal) {
        List list;
        Intrinsics.checkNotNullParameter((Object)notebookCellsContents, (String)"notebookCellsContents");
        List intervals = notebookCellsContents.getCopiedIntervals();
        if (Intrinsics.areEqual((Object)notebookCellsContents.getLanguage(), (Object)JupyterLanguage.INSTANCE) && intervals != null) {
            List<Pair<String, NotebookCellLines.Interval>> cells = this.splitCells(notebookCellsContents.getRawText(), intervals);
            return CollectionsKt.joinToString$default((Iterable)cells, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> PythonCellLinesEditHelper.makeInsertedCells$lambda$0(this, arg_0), (int)30, null);
        }
        String source = notebookCellsContents.getRawText();
        return targetOrdinal == 0 ? source : (((list = notebookCellsContents.getCopiedIntervals()) != null && (list = (NotebookCellLines.Interval)CollectionsKt.firstOrNull((List)list)) != null && (list = list.getMarkers()) != null ? list.getHasTopLine() : false) ? source : (this.startsWithHeader(source) ? source : this.addHeader(NotebookCellLines.CellType.CODE, source, null)));
    }

    private final String getContent(NotebookCellLines.Interval interval, String rawIntervalText) {
        String text = rawIntervalText;
        if (interval.getMarkers().getHasTopLine()) {
            text = StringsKt.substringAfter$default((String)text, (char)'\n', null, (int)2, null);
        }
        if (interval.getMarkers().getHasBottomLine()) {
            text = StringsKt.substringBeforeLast$default((String)text, (char)'\n', null, (int)2, null);
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, NotebookCellLines.Interval>> splitCells(String rawText, List<NotebookCellLines.Interval> intervals) {
        void $this$mapTo$iv$iv;
        char[] cArray = new char[]{'\n'};
        Iterator rawLinesIterator = StringsKt.split$default((CharSequence)rawText, (char[])cArray, (boolean)false, (int)0, (int)6, null).iterator();
        Iterable $this$map$iv = intervals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void interval;
            NotebookCellLines.Interval interval2 = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int linesCount = interval.getLines().getLast() - interval.getLines().getFirst() + 1;
            String text = SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)SequencesKt.asSequence(rawLinesIterator), (int)linesCount), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            collection.add(new Pair((Object)text, (Object)interval));
        }
        return (List)destination$iv$iv;
    }

    private final String addHeader(NotebookCellLines.CellType cellType, String source, String customHeader) {
        return this.getHeader(cellType, customHeader) + "\n" + source;
    }

    private final String getHeader(NotebookCellLines.CellType cellType, String customHeader) {
        if (customHeader != null) {
            return "#%% " + customHeader;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[cellType.ordinal()]) {
            case 1 -> "#%%";
            case 2 -> "#%% md";
            case 3 -> "#%% raw";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean startsWithHeader(String source) {
        return StringsKt.startsWith$default((String)source, (String)"#%%", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)source, (String)"# %%", (boolean)false, (int)2, null);
    }

    private static final CharSequence makeCell$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "# " + it;
    }

    private static final CharSequence makeInsertedCells$lambda$0(PythonCellLinesEditHelper this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String text = (String)pair.component1();
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)pair.component2();
        String content = this$0.getContent(interval, text);
        return NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)this$0, (String)content, (NotebookCellLines.CellType)interval.getType(), null, (int)4, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookCellLines.CellType.values().length];
            try {
                nArray[NotebookCellLines.CellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.RAW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

