/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.py.connections.server.JupyterlabServer;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterOpenNotebookInBrowserAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "appendNotebookPath", "Ljava/net/URI;", "suffix", "", "isItLocalFileConnectedToRemoteServer", "", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "Companion", "intellij.jupyter.py"})
public final class JupyterOpenNotebookInBrowserAction
extends JupyterEditorActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    protected JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive(arg_0 -> JupyterOpenNotebookInBrowserAction.createActionUpdater$lambda$0(this, arg_0));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)e);
        if (editor == null || (editor = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor)) == null) {
            return;
        }
        Editor jupyterFile = editor;
        JupyterNotebookSession session = JupyterExecutionManager.Companion.getInstance(project2, (BackedNotebookVirtualFile)jupyterFile).getSession();
        if (session == null) {
            LOG.warn("Can't open a notebook since no session is running");
            return;
        }
        URI uri = this.appendNotebookPath(session.getJupyterServer().getConnectionParameters().getHttpParams().toURI(), session.getPathFromRoot());
        BrowserUtil.open((String)uri.toASCIIString());
    }

    private final URI appendNotebookPath(URI $this$appendNotebookPath, String suffix) {
        URIBuilder uRIBuilder = new URIBuilder($this$appendNotebookPath);
        String string = $this$appendNotebookPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        char[] cArray = new char[]{'/'};
        URI uRI = uRIBuilder.setPath(StringsKt.trimEnd((String)string, (char[])cArray) + "/notebooks/" + suffix).build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        return uRI;
    }

    private final boolean isItLocalFileConnectedToRemoteServer(JupyterNotebookSession $this$isItLocalFileConnectedToRemoteServer) {
        return StringsKt.startsWith$default((String)$this$isItLocalFileConnectedToRemoteServer.getPathFromRoot(), (String)"localFileConnectedToRemoteServer", (boolean)false, (int)2, null);
    }

    private static final Unit createActionUpdater$lambda$0(JupyterOpenNotebookInBrowserAction this$0, JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider((arg_0, arg_1) -> JupyterOpenNotebookInBrowserAction.createActionUpdater$lambda$0$0(this$0, arg_0, arg_1));
        $this$derive.addVisualCustomizer(JupyterOpenNotebookInBrowserAction::createActionUpdater$lambda$0$1);
        return Unit.INSTANCE;
    }

    private static final boolean createActionUpdater$lambda$0$0(JupyterOpenNotebookInBrowserAction this$0, JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        JupyterNotebookSession notebookSession;
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)event);
        if (editor == null || (editor = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor)) == null) {
            return false;
        }
        Editor jupyterFile = editor;
        if (!event.getPresentation().isVisible()) {
            return false;
        }
        JupyterNotebookSession jupyterNotebookSession = notebookSession = JupyterExecutionManager.Companion.getInstance(project2, (BackedNotebookVirtualFile)jupyterFile).getSession();
        return (jupyterNotebookSession != null ? jupyterNotebookSession.getJupyterServer() : null) instanceof JupyterlabServer && !this$0.isItLocalFileConnectedToRemoteServer(notebookSession);
    }

    private static final Unit createActionUpdater$lambda$0$1(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getPresentation().isEnabled() ? JupyterPyBundle.message("action.JupyterOpenNotebookInBrowserAction.text", new Object[0]) : JupyterPyBundle.message("action.JupyterOpenNotebookInBrowserAction.remote.not.started", new Object[0]);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterOpenNotebookInBrowserAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

