/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteServerNode;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.jupyter.ui.BalloonStyle;
import com.intellij.jupyter.py.connections.JupyterConnectionSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/py/connections/actions/OpenJupyterSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateSelectedForFile", "config", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "project", "Lcom/intellij/openapi/project/Project;", "update", "askUserConfirmation", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getConfigForNode", "getConfigForFile", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nOpenJupyterSettingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenJupyterSettingsAction.kt\ncom/intellij/jupyter/py/connections/actions/OpenJupyterSettingsAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class OpenJupyterSettingsAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "OpenJupyterSettingsAction";

    public void actionPerformed(@NotNull AnActionEvent e) {
        JupyterServerConfig config;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JupyterServerConfig jupyterServerConfig = this.getConfigForNode(e);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getConfigForFile(e);
        }
        JupyterServerConfig jupyterServerConfig2 = config = jupyterServerConfig;
        String string = JupyterConnectionSettings.INSTANCE.open(project2, jupyterServerConfig2 != null ? jupyterServerConfig2.getId() : null);
        if (string == null) {
            return;
        }
        String serverConfigId = string;
        JupyterServerConfig jupyterServerConfig3 = JupyterConnectionSettingsManager.Companion.getInstance().getConfig(serverConfigId);
        if (jupyterServerConfig3 == null) {
            return;
        }
        JupyterServerConfig selectedConfig = jupyterServerConfig3;
        this.updateSelectedForFile(e, selectedConfig, project2);
    }

    private final void updateSelectedForFile(AnActionEvent e, JupyterServerConfig config, Project project) {
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        VirtualFile virtualFile = notebookFile.getFile();
        if (virtualFile instanceof JupyterRemoteVirtualFile) {
            return;
        }
        if (!this.askUserConfirmation(project, virtualFile, config)) {
            return;
        }
        JupyterConnectionSettingsManager.Companion.getInstance().setConfigForFile(virtualFile, config.getId());
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object object = ArraysKt.firstOrNull((Object[])fileEditorArray);
        JupyterFileEditor jupyterFileEditor = object instanceof JupyterFileEditor ? (JupyterFileEditor)object : null;
        if (jupyterFileEditor == null) {
            return;
        }
        JupyterFileEditor fileEditor = jupyterFileEditor;
        fileEditor.showServerBalloon(JupyterRemoteBundle.message((String)"connection.settings.changed", (Object[])new Object[0]), BalloonStyle.INFO);
        JupyterConnectionSettingsManager.Companion.getInstance().setConfigForFile(virtualFile, config);
        JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, notebookFile, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ BackedNotebookVirtualFile $notebookFile;
            {
                this.$project = $project;
                this.$notebookFile = $notebookFile;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = JupyterExecutionManager.Companion.getInstance(this.$project, this.$notebookFile).killExecution((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JupyterServerConfig jupyterServerConfig = this.getConfigForNode(e);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getConfigForFile(e);
        }
        JupyterServerConfig config = jupyterServerConfig;
        e.getPresentation().setEnabledAndVisible(config != null);
    }

    private final boolean askUserConfirmation(Project project, VirtualFile virtualFile, JupyterServerConfig config) {
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = JupyterExecutionManager.Companion.getInstance(project, virtualFile).getRuntimeSettings();
        if (jupyterNotebookRuntimeSettings == null) {
            return true;
        }
        JupyterNotebookRuntimeSettings runtime = jupyterNotebookRuntimeSettings;
        JupyterServerConfig runtimeConnection = runtime.getConnectionSettings();
        if (JupyterConnectionSettingsManager.Companion.getInstance().getConfig(runtimeConnection.getId()) == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)config.getId(), (Object)runtimeConnection.getId())) {
            return true;
        }
        Object[] objectArray = new Object[]{config.getName(), runtimeConnection.getName()};
        boolean isOk = Messages.showOkCancelDialog((Project)project, (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.after.apply.message", (Object[])objectArray), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.title", (Object[])new Object[0]), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.after.apply.ok", (Object[])new Object[0]), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.after.apply.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
        return isOk;
    }

    private final JupyterServerConfig getConfigForNode(AnActionEvent e) {
        Navigatable[] navigatableArray;
        block8: {
            block7: {
                Navigatable[] navigatableArray2;
                block6: {
                    Navigatable[] selectedFiles;
                    navigatableArray = selectedFiles = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
                    if (selectedFiles == null) break block7;
                    for (Navigatable it : navigatableArray) {
                        boolean bl = false;
                        navigatableArray2 = it instanceof JupyterRemoteServerNode ? (Navigatable[])it : null;
                        if (navigatableArray2 == null) {
                            continue;
                        }
                        break block6;
                    }
                    navigatableArray2 = navigatableArray = null;
                }
                if (navigatableArray2 != null) break block8;
            }
            return null;
        }
        Navigatable[] serverNode = navigatableArray;
        String authority = serverNode.getRemotePath().getAuthority();
        return (JupyterServerConfig)JupyterConnectionSettingsManager.Companion.getInstance().getConnectionSettingsForAuthority(authority);
    }

    private final JupyterServerConfig getConfigForFile(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        BackedNotebookVirtualFile virtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        JupyterServerConfig config = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFile(virtualFile, project2);
        return config;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/py/connections/actions/OpenJupyterSettingsAction$Companion;", "", "<init>", "()V", "ID", "", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

