/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.ipykernel;

import com.intellij.jupyter.core.jupyter.connections.fus.JupyterConnectionsCollector;
import com.intellij.jupyter.execution.listeners.KernelProcessListener;
import com.intellij.jupyter.execution.listeners.events.KernelInfoReplyReceivedEvent;
import com.intellij.jupyter.execution.listeners.events.KernelNotificationStartedEvent;
import com.intellij.jupyter.execution.listeners.events.KernelProcessEvent;
import com.intellij.jupyter.py.connections.ipykernel.toolwindow.IPyKernelToolWindowCoordinator;
import com.intellij.jupyter.py.connections.ipykernel.toolwindow.IPyKernelToolWindowCoordinatorRegistry;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/connections/ipykernel/IPyKernelProcessListener;", "Lcom/intellij/jupyter/execution/listeners/KernelProcessListener;", "project", "Lcom/intellij/openapi/project/Project;", "startTime", "", "<init>", "(Lcom/intellij/openapi/project/Project;J)V", "beforeNotificationStarted", "", "event", "Lcom/intellij/jupyter/execution/listeners/events/KernelNotificationStartedEvent;", "kernelInfoReplyReceived", "Lcom/intellij/jupyter/execution/listeners/events/KernelInfoReplyReceivedEvent;", "kernelTerminated", "Lcom/intellij/jupyter/execution/listeners/events/KernelProcessEvent;", "intellij.jupyter.py"})
public final class IPyKernelProcessListener
implements KernelProcessListener {
    @NotNull
    private final Project project;
    private final long startTime;

    public IPyKernelProcessListener(@NotNull Project project, long startTime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.startTime = startTime;
    }

    public void beforeNotificationStarted(@NotNull KernelNotificationStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ActionsKt.runInEdt$default(null, () -> IPyKernelProcessListener.beforeNotificationStarted$lambda$0(this, event), (int)1, null);
    }

    public void kernelInfoReplyReceived(@NotNull KernelInfoReplyReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        long startDurationMs = (System.nanoTime() - this.startTime) / (long)1000000;
        JupyterConnectionsCollector.INSTANCE.logManagedServerInitTime(startDurationMs, JupyterConnectionsCollector.JupyterKernelKind.IPYKERNEL);
    }

    public void kernelTerminated(@NotNull KernelProcessEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            IPyKernelToolWindowCoordinator iPyKernelToolWindowCoordinator = IPyKernelToolWindowCoordinatorRegistry.INSTANCE.get(this.project, event.getEventSource().getNotebookVirtualFile());
            if (iPyKernelToolWindowCoordinator == null) break block0;
            iPyKernelToolWindowCoordinator.onTerminated(event);
        }
    }

    private static final Unit beforeNotificationStarted$lambda$0(IPyKernelProcessListener this$0, KernelNotificationStartedEvent $event) {
        IPyKernelToolWindowCoordinatorRegistry.INSTANCE.getOrCreate(this$0.project, $event.getEventSource().getNotebookVirtualFile()).onStarted($event.getEventSource());
        return Unit.INSTANCE;
    }
}

