/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.JupyterCellTypeProvider;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.executor.task.JupyterExecutionTask;
import com.intellij.jupyter.core.extensions.JupyterPsiCellExt;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterExecutionException;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugRunnerProvider;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterSessionPath;
import com.intellij.jupyter.core.jupyter.debugger.common.NotebookDebugRunner;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.py.debugger.JupyterDebugCellIdManager;
import com.intellij.jupyter.py.debugger.JupyterDebugCellTask;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugAction.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n23#2:104\n*S KotlinDebug\n*F\n+ 1 JupyterDebugAction.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugAction\n*L\n73#1:104\n*E\n"})
public final class JupyterDebugAction
extends JupyterEditorActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private JupyterDebugAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        JupyterCellType jupyterCellType;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (project2.isDisposed()) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor((DataContext)dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getSelectedPsiCell(dataContext2);
        if (jupyterPsiCell == null) {
            return;
        }
        JupyterPsiCell jupyterPsiCell2 = jupyterPsiCell;
        NotebookIntervalPointer notebookIntervalPointer = NotebookMarkdownEditorManagerKt.getIntervalPointer((Editor)((Editor)editor), (JupyterPsiCell)jupyterPsiCell2);
        if (notebookIntervalPointer == null) {
            return;
        }
        NotebookIntervalPointer cellPointer = notebookIntervalPointer;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)event);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile3 = JupyterHelper.INSTANCE.getJupyterFile((Editor)editor);
        if (backedNotebookVirtualFile3 == null) {
            return;
        }
        BackedNotebookVirtualFile jupyterFile = backedNotebookVirtualFile3;
        DataContext dataContext3 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext3);
        if (interval != null) {
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            jupyterCellType = JupyterCellLinesExtensionsKt.toJupyterCellType((NotebookCellLines.Interval)interval, (Document)((Document)documentEx));
        } else {
            jupyterCellType = null;
        }
        if (!Intrinsics.areEqual(jupyterCellType, (Object)JupyterCellType.Companion.getCODE())) {
            return;
        }
        if (JupyterDebugger.INSTANCE.showWarningIfUnderDebugger(project2, jupyterFile)) {
            return;
        }
        JupyterDebugCellIdManager.Companion.getInstance(project2).updatePositions(project2, backedNotebookVirtualFile2, jupyterPsiCell2);
        JupyterSessionPath sessionPath = new JupyterSessionPath(backedNotebookVirtualFile2);
        try {
            JupyterDebugSessionManager.Companion.getInstance(project2).debugInSessionStarted(sessionPath);
            NotebookDebugRunner debugRunner = JupyterDebugRunnerProvider.Companion.getSuitableDebugRunner(project2, backedNotebookVirtualFile2);
            debugRunner.createDebugSession(project2, jupyterPsiCell2, cellPointer, backedNotebookVirtualFile2.getFile(), debugRunner.getConnectionNotifier(), () -> JupyterDebugAction.actionPerformed$lambda$0(project2, sessionPath));
        }
        catch (JupyterExecutionException e) {
            JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, e, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ JupyterExecutionException $e;
                {
                    this.$project = $project;
                    this.$e = $e;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JupyterNotification.INSTANCE.displayAndLogError(this.$project, (Throwable)this.$e, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Exception e) {
            JupyterDebugAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterDebugAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
    }

    @NotNull
    protected JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive(JupyterDebugAction::createActionUpdater$lambda$0);
    }

    private static final Unit actionPerformed$lambda$0(Project $project, JupyterSessionPath $sessionPath) {
        JupyterDebugSessionManager.Companion.getInstance($project).debugInSessionFinished($sessionPath);
        return Unit.INSTANCE;
    }

    private static final Unit createActionUpdater$lambda$0(JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider(JupyterDebugAction::createActionUpdater$lambda$0$0);
        $this$derive.addEnabledProvider(JupyterDebugAction::createActionUpdater$lambda$0$1);
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createActionUpdater$lambda$0$0(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        NotebookCellLines.Interval interval;
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval2 = interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (!Intrinsics.areEqual((Object)(interval2 != null ? interval2.getLanguage() : null), (Object)PythonLanguage.INSTANCE)) return false;
        JupyterCellTypeProvider jupyterCellTypeProvider = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellTypeProvider(interval);
        if (jupyterCellTypeProvider == null) return false;
        if (!jupyterCellTypeProvider.isDebugActionSupported()) return false;
        return true;
    }

    private static final boolean createActionUpdater$lambda$0$1(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return true;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)event);
        if (backedNotebookVirtualFile == null) {
            return true;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        return !JupyterDebugger.INSTANCE.isUnderDebugger(project2, notebookFile);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugAction$Companion;", "", "<init>", "()V", "executeCell", "", "project", "Lcom/intellij/openapi/project/Project;", "jupyterCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/xdebugger/XDebugSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object executeCell(@NotNull Project project, @NotNull JupyterPsiCell jupyterCell, @NotNull NotebookIntervalPointer cellPointer, @NotNull XDebugSession debugSession, @NotNull Continuation<? super Unit> $completion) {
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFile(jupyterCell);
            if (backedNotebookVirtualFile == null) {
                return Unit.INSTANCE;
            }
            BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
            JupyterDebugCellTask task = new JupyterDebugCellTask(project, notebookVirtualFile, jupyterCell, debugSession, cellPointer);
            Object object = JupyterExecutionManager.Companion.getInstance(project, notebookVirtualFile).submitTask((JupyterExecutionTask)task, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

