/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.executor.JupyterExecutionManagerExtensionsKt;
import com.intellij.jupyter.core.executor.kernel.JupyterKernelTask;
import com.intellij.jupyter.core.executor.task.JupyterTaskPurpose;
import com.intellij.jupyter.core.extensions.JupyterPsiCellExt;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskPriority;
import com.intellij.jupyter.core.jupyter.debugger.common.DebugConnectionNotifier;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.py.connections.execution.core.PyJupyterRemoteVariables;
import com.intellij.jupyter.py.debugger.JupyterDebugLibs;
import com.intellij.jupyter.py.debugger.JupyterDebugProcessHandler;
import com.intellij.jupyter.py.debugger.JupyterPositionConverter;
import com.intellij.jupyter.py.variables.PythonVariablesUtil;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlineService;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u00017BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0016\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010%\u001a\u00020\u0012H\u0014J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0006\u0010,\u001a\u00020\u0012J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0012H\u0016J\u0012\u00100\u001a\u00020\u00122\b\u00101\u001a\u0004\u0018\u000102H\u0016J\r\u00103\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u0002022\u0006\u00106\u001a\u00020\"H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugProcess;", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "serverSocket", "Ljava/net/ServerSocket;", "executionConsole", "Lcom/intellij/execution/ui/ExecutionConsole;", "jupyterDebugProcessHandler", "Lcom/intellij/jupyter/py/debugger/JupyterDebugProcessHandler;", "jupyterPsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "connectionNotifier", "Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "afterCellExecuted", "Lkotlin/Function0;", "", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Ljava/net/ServerSocket;Lcom/intellij/execution/ui/ExecutionConsole;Lcom/intellij/jupyter/py/debugger/JupyterDebugProcessHandler;Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;Lkotlin/jvm/functions/Function0;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "latestExecutedCell", "Lkotlin/Pair;", "getLatestExecutedCell", "()Lkotlin/Pair;", "setLatestExecutedCell", "(Lkotlin/Pair;)V", "inlineCallback", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "myLocalPort", "", "connect", "cell", "afterConnect", "getCurrentScopeOwner", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "loadFrame", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "executeAfterCell", "isSimplifiedView", "", "sessionInitialized", "showWarning", "warningId", "", "getConsolePromptCount", "()Ljava/lang/Integer;", "createPydevConnectionCommand", "portToConnect", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugProcess.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,314:1\n23#2:315\n*S KotlinDebug\n*F\n+ 1 JupyterDebugProcess.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugProcess\n*L\n179#1:315\n*E\n"})
public final class JupyterDebugProcess
extends PyDebugProcess {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JupyterPsiCell jupyterPsiCell;
    @NotNull
    private final NotebookIntervalPointer cellPointer;
    @NotNull
    private final DebugConnectionNotifier connectionNotifier;
    @NotNull
    private final Function0<Unit> afterCellExecuted;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private Pair<? extends JupyterPsiCell, ? extends NotebookIntervalPointer> latestExecutedCell;
    @Nullable
    private JupyterInlineCallback inlineCallback;
    private final int myLocalPort;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PYDEV_COMMAND_PREFIX = "# pydev_util_command\n";
    @NotNull
    private static final String GET_CONSOLE_PROMPT_COUNT_COMMAND = "get_ipython().execution_count";
    @NotNull
    public static final String DONT_WRITE_BYTECODE = "import sys;sys.dont_write_bytecode = True\n";

    public JupyterDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @NotNull JupyterDebugProcessHandler jupyterDebugProcessHandler, @NotNull JupyterPsiCell jupyterPsiCell, @NotNull NotebookIntervalPointer cellPointer, @NotNull DebugConnectionNotifier connectionNotifier2, @NotNull Function0<Unit> afterCellExecuted, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterDebugProcessHandler), (String)"jupyterDebugProcessHandler");
        Intrinsics.checkNotNullParameter((Object)jupyterPsiCell, (String)"jupyterPsiCell");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)connectionNotifier2, (String)"connectionNotifier");
        Intrinsics.checkNotNullParameter(afterCellExecuted, (String)"afterCellExecuted");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        super(session, serverSocket, executionConsole, (ProcessHandler)jupyterDebugProcessHandler, false);
        this.jupyterPsiCell = jupyterPsiCell;
        this.cellPointer = cellPointer;
        this.connectionNotifier = connectionNotifier2;
        this.afterCellExecuted = afterCellExecuted;
        this.notebookFile = notebookFile;
        this.latestExecutedCell = new Pair((Object)this.jupyterPsiCell, (Object)this.cellPointer);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.myPositionConverter = (PyPositionConverter)new JupyterPositionConverter(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.inlineCallback = JupyterInlineService.Companion.getInstance(project2).getInlineCallback(this.notebookFile);
        this.myLocalPort = serverSocket.getLocalPort();
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    @NotNull
    public final Pair<JupyterPsiCell, NotebookIntervalPointer> getLatestExecutedCell() {
        return this.latestExecutedCell;
    }

    public final void setLatestExecutedCell(@NotNull Pair<? extends JupyterPsiCell, ? extends NotebookIntervalPointer> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"<set-?>");
        this.latestExecutedCell = pair;
    }

    public final void connect(@NotNull JupyterPsiCell cell, @NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        int portToConnect = this.myLocalPort;
        BackedNotebookVirtualFile notebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFileOrThrow(cell);
        JupyterTaskPurpose jupyterTaskPurpose = JupyterTaskPurpose.SERVICE;
        JupyterTaskPriority jupyterTaskPriority = JupyterTaskPriority.Companion.getHIGH();
        JupyterKernelTask.Options jupyterTaskOption = new JupyterKernelTask.Options(jupyterTaskPurpose, jupyterTaskPriority, cellPointer, false, false, true, true, null, 128, null);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterExecutionManager executor = JupyterExecutionManager.Companion.getInstance(project, notebookVirtualFile);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ExecutorService executorService = JupyterDebugSessionManager.Companion.getInstance(project2).getExecutorService();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.forProject(this.getProject())), (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, portToConnect, executor, jupyterTaskOption, null){
            Object L$0;
            int label;
            final /* synthetic */ JupyterDebugProcess this$0;
            final /* synthetic */ int $portToConnect;
            final /* synthetic */ JupyterExecutionManager $executor;
            final /* synthetic */ JupyterKernelTask.Options $jupyterTaskOption;
            {
                this.this$0 = $receiver;
                this.$portToConnect = $portToConnect;
                this.$executor = $executor;
                this.$jupyterTaskOption = $jupyterTaskOption;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String codeToExec = JupyterDebugProcess.access$createPydevConnectionCommand(this.this$0, this.$portToConnect);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)codeToExec);
                        this.label = 1;
                        Object object2 = JupyterExecutionManagerExtensionsKt.submitAndWait((JupyterExecutionManager)this.$executor, (String)codeToExec, (JupyterKernelTask.Options)this.$jupyterTaskOption, (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        String codeToExec = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    protected void afterConnect() {
        super.afterConnect();
        if (this.isConnected()) {
            CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ JupyterDebugProcess this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            DebugConnectionNotifier debugConnectionNotifier = JupyterDebugProcess.access$getConnectionNotifier$p(this.this$0);
                            Project project = this.this$0.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            JupyterPsiCell jupyterPsiCell = JupyterDebugProcess.access$getJupyterPsiCell$p(this.this$0);
                            NotebookIntervalPointer notebookIntervalPointer = JupyterDebugProcess.access$getCellPointer$p(this.this$0);
                            XDebugSession xDebugSession = this.this$0.getSession();
                            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
                            this.label = 1;
                            Object object2 = debugConnectionNotifier.executeAfterConnection(project, jupyterPsiCell, notebookIntervalPointer, xDebugSession, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final ScopeOwner getCurrentScopeOwner() {
        XSourcePosition xSourcePosition = this.getCurrentFrameSourcePosition();
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition position = xSourcePosition;
        return (ScopeOwner)ReadAction.compute(() -> JupyterDebugProcess.getCurrentScopeOwner$lambda$0(this, position));
    }

    @Nullable
    public XValueChildrenList loadFrame(@Nullable XStackFrame frame) {
        XValueChildrenList frameVariables = super.loadFrame(frame);
        ApplicationManager.getApplication().invokeLater(() -> JupyterDebugProcess.loadFrame$lambda$0(frameVariables, this));
        return frameVariables;
    }

    public final void executeAfterCell() {
        block0: {
            this.afterCellExecuted.invoke();
            ProcessHandler processHandler = this.doGetProcessHandler();
            if (processHandler == null) break block0;
            processHandler.destroyProcess();
        }
    }

    public boolean isSimplifiedView() {
        return PyDebuggerSettings.getInstance().isSimplifiedView();
    }

    public void sessionInitialized() {
        boolean bl = PyDebuggerOptionsProvider.getInstance((Project)this.getProject()).isRunDebuggerInServerMode() && Registry.Companion.is("python.debug.use.single.port");
        if (bl) {
            this.waitForConnection(this.getConnectionMessage(), this.getConnectionTitle());
        } else {
            super.sessionInitialized();
        }
    }

    public void showWarning(@Nullable String warningId) {
        super.showWarning(warningId);
        if (Intrinsics.areEqual((Object)warningId, (Object)"jupyter")) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JupyterDebugProcess.Companion.showCellEditedBetweenSessions(project);
        }
    }

    @Nullable
    public final Integer getConsolePromptCount() {
        Integer result2 = null;
        try {
            String string = this.evaluate(GET_CONSOLE_PROMPT_COUNT_COMMAND, false, false).getValue();
            result2 = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        return result2;
    }

    private final String createPydevConnectionCommand(int portToConnect) {
        StringBuilder command = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        command.append(Companion.createHelpersCommand(project, this.notebookFile));
        if (LOG.isDebugEnabled()) {
            command.append("import os\n");
            command.append("os.environ['PYCHARM_DEBUG'] = 'True'\n");
        }
        command.append(StringsKt.trimMargin$default((String)("\n        |import pydev_jupyter_utils\n        |pydev_jupyter_utils.attach_to_debugger(" + portToConnect + ")\n        |"), null, (int)1, null));
        String string = command.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final ScopeOwner getCurrentScopeOwner$lambda$0(JupyterDebugProcess this$0, XSourcePosition $position) {
        PsiFile psiFile2;
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = $position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        PsiFile psiFile3 = psiFile2 = PythonVariablesUtil.INSTANCE.getPythonJupyterPsiFile(project, virtualFile);
        PsiElement currentElement = psiFile3 != null ? psiFile3.findElementAt($position.getOffset()) : null;
        return ScopeUtil.getScopeOwner((PsiElement)currentElement);
    }

    private static final void loadFrame$lambda$0(XValueChildrenList $frameVariables, JupyterDebugProcess this$0) {
        block2: {
            XValueChildrenList xValueChildrenList = $frameVariables;
            if (xValueChildrenList == null) break block2;
            XValueChildrenList it = xValueChildrenList;
            boolean bl = false;
            ScopeOwner scopeOwner = this$0.getCurrentScopeOwner();
            if (scopeOwner != null) {
                ScopeOwner scopeOwner2 = scopeOwner;
                boolean bl2 = false;
                JupyterInlineCallback jupyterInlineCallback = this$0.inlineCallback;
                if (jupyterInlineCallback != null) {
                    jupyterInlineCallback.frameChanged(it, scopeOwner2);
                }
            }
        }
    }

    public static final /* synthetic */ String access$createPydevConnectionCommand(JupyterDebugProcess $this, int portToConnect) {
        return $this.createPydevConnectionCommand(portToConnect);
    }

    public static final /* synthetic */ DebugConnectionNotifier access$getConnectionNotifier$p(JupyterDebugProcess $this) {
        return $this.connectionNotifier;
    }

    public static final /* synthetic */ JupyterPsiCell access$getJupyterPsiCell$p(JupyterDebugProcess $this) {
        return $this.jupyterPsiCell;
    }

    public static final /* synthetic */ NotebookIntervalPointer access$getCellPointer$p(JupyterDebugProcess $this) {
        return $this.cellPointer;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u001a\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PYDEV_COMMAND_PREFIX", "", "GET_CONSOLE_PROMPT_COUNT_COMMAND", "DONT_WRITE_BYTECODE", "showCellEditedBetweenSessions", "", "project", "Lcom/intellij/openapi/project/Project;", "showCellEditedDuringSession", "createHelpersCommand", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "initRemoteServerCommand", "command", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getHelpersPaths", "Lkotlin/Pair;", "enableTracingCommand", "disableTracingCommand", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final void showCellEditedBetweenSessions(Project project) {
            PyDebugProcess.getNotificationGroup().createNotification(JupyterBundle.message((String)"Jupyter.debugger.cell.changed.warning", (Object[])new Object[0]), NotificationType.WARNING).setDisplayId("jupyter.cell.edited.between.sessions").notify(project);
        }

        public final void showCellEditedDuringSession(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PyDebugProcess.getNotificationGroup().createNotification(JupyterBundle.message((String)"Jupyter.debugger.cell.changed.error", (Object[])new Object[0]), NotificationType.ERROR).setDisplayId("jupyter.cell.edited.during.sessions").notify(project);
        }

        @NotNull
        public final String createHelpersCommand(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(JupyterDebugProcess.DONT_WRITE_BYTECODE);
            if (JupyterConnectionSettingsUtilKt.isRemoteRemoteJupyterServerSettings((Project)project, (BackedNotebookVirtualFile)virtualFile)) {
                this.initRemoteServerCommand(virtualFile, command);
            } else {
                String string = StringUtil.escapeCharCharacters((String)JupyterDebugLibs.INSTANCE.getPythonHelper());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharCharacters(...)");
                String helpersPath = string;
                String string2 = StringUtil.escapeCharCharacters((String)JupyterDebugLibs.INSTANCE.getJupyterHelper());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeCharCharacters(...)");
                String helpersProPath = string2;
                command.append(StringsKt.trimMargin$default((String)("\n        |import sys\n        |if '" + helpersPath + "' not in sys.path:\n        |    sys.path.insert(0, '" + helpersPath + "')\n        |    sys.path.insert(0, '" + helpersProPath + "')\n        |"), null, (int)1, null));
            }
            command.append("from pydev_jupyter_utils import remove_imported_pydev_package\nremove_imported_pydev_package()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void initRemoteServerCommand(BackedNotebookVirtualFile virtualFile, StringBuilder command) {
            Pair<String, String> pair = this.getHelpersPaths(virtualFile);
            String helpersPath = (String)pair.component1();
            String helpersProPath = (String)pair.component2();
            command.append(StringsKt.trimMargin$default((String)("\n            |import sys\n            |import os\n            |os_normed_helpers_path = os.path.normpath('" + helpersPath + "')\n            |os_normed_helpers_pro_path = os.path.normpath('" + helpersProPath + "')\n            |os_valid_helpers_path = os.path.normpath(os.path.join(os.getcwd(), os_normed_helpers_path))\n            |os_valid_helpers_pro_path = os.path.normpath(os.path.join(os.getcwd(), os_normed_helpers_pro_path))\n            |if os_valid_helpers_path not in sys.path:\n            |    sys.path.insert(0, os_valid_helpers_path)\n            |    sys.path.insert(0, os_valid_helpers_pro_path)\n            |del os_normed_helpers_path\n            |del os_normed_helpers_pro_path\n            |del os_valid_helpers_path\n            |del os_valid_helpers_pro_path\n            |"), null, (int)1, null));
        }

        private final Pair<String, String> getHelpersPaths(BackedNotebookVirtualFile virtualFile) {
            String string = StringUtil.escapeCharCharacters((String)PyJupyterRemoteVariables.INSTANCE.remoteLibName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharCharacters(...)");
            String helpersLibDirectoryName = string;
            String helpersPath = null;
            String helpersProPath = null;
            VirtualFile file = virtualFile.getFile();
            if (!(file instanceof JupyterRemoteVirtualFile)) {
                String[] stringArray = new String[]{helpersLibDirectoryName, "pydev"};
                String string2 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
                helpersPath = string2;
                stringArray = new String[]{helpersLibDirectoryName, "jupyter_debug"};
                String string3 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
                helpersProPath = string3;
            } else {
                Path relativePathToNotebook = Path.of(((JupyterRemoteVirtualFile)file).getRemotePath().getJupyterPath(), new String[0]);
                String subDirPrefix = relativePathToNotebook.getNameCount() == 1 ? "" : StringsKt.repeat((CharSequence)"../", (int)(relativePathToNotebook.getNameCount() - 1));
                String helpersLibDirectoryPath = StringUtil.escapeCharCharacters((String)subDirPrefix) + helpersLibDirectoryName;
                String[] stringArray = new String[]{helpersLibDirectoryPath, "pydev"};
                String string4 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"join(...)");
                helpersPath = string4;
                stringArray = new String[]{helpersLibDirectoryPath, "jupyter_debug"};
                String string5 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"join(...)");
                helpersProPath = string5;
            }
            return new Pair((Object)FileUtil.toSystemIndependentName((String)helpersPath), (Object)FileUtil.toSystemIndependentName((String)helpersProPath));
        }

        @NotNull
        public final String enableTracingCommand() {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(JupyterDebugProcess.DONT_WRITE_BYTECODE);
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.enable_tracing()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String disableTracingCommand() {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(JupyterDebugProcess.DONT_WRITE_BYTECODE);
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.disable_tracing()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

