/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterExecutionException;
import com.intellij.jupyter.py.variables.toolwindow.JupyterVarsSorter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.values.CannotRetrieveColumnDataException;
import com.jetbrains.python.debugger.values.DataFrameDebugValue;
import com.jetbrains.python.debugger.values.DataFrameDebugValueUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00140\u00132\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVarsFrameParser;", "", "<init>", "()V", "parseVar", "Lcom/jetbrains/python/debugger/PyDebugValue;", "result", "", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "parseFrameVars", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "parentValue", "handleDataFrameDebugValue", "", "dataFrameDebugValue", "Lcom/jetbrains/python/debugger/values/DataFrameDebugValue;", "parseAsyncValues", "vars", "", "Lcom/jetbrains/python/debugger/PyFrameAccessor$PyAsyncValue;", "parseArrayChunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "varName", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterVarsFrameParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVarsFrameParser.kt\ncom/intellij/jupyter/py/variables/JupyterVarsFrameParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n23#2:99\n23#2:101\n23#2:102\n1#3:100\n*S KotlinDebug\n*F\n+ 1 JupyterVarsFrameParser.kt\ncom/intellij/jupyter/py/variables/JupyterVarsFrameParser\n*L\n29#1:99\n55#1:101\n70#1:102\n*E\n"})
public final class JupyterVarsFrameParser {
    @NotNull
    public static final JupyterVarsFrameParser INSTANCE = new JupyterVarsFrameParser();

    private JupyterVarsFrameParser() {
    }

    @NotNull
    public final PyDebugValue parseVar(@NotNull String result2, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (((CharSequence)result2).length() == 0) {
            Object[] objectArray = new Object[]{result2};
            throw new JupyterExecutionException(JupyterBundle.message((String)"jupyter.failed.to.evaluate.expression", (Object[])objectArray));
        }
        try {
            PyDebugValue pyDebugValue = ProtocolParser.parseValue((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)pyDebugValue, (String)"parseValue(...)");
            return pyDebugValue;
        }
        catch (Exception exception) {
            throw new Exception("Failed to evaluate expression: " + result2);
        }
    }

    @Nullable
    public final XValueChildrenList parseFrameVars(@NotNull String result2, @Nullable PyDebugValue parentValue, @NotNull PyFrameAccessor frameAccessor) {
        XValueChildrenList xValueChildrenList;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (((CharSequence)result2).length() == 0) {
            JupyterVarsFrameParser $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterVarsFrameParser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to load Jupyter variables: result is empty");
            return null;
        }
        try {
            List<PyDebugValue> list = ProtocolParser.parseValues((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parseValues(...)");
            List<PyDebugValue> values = list;
            Project project = frameAccessor.getProject();
            List<PyDebugValue> sortedValues = parentValue == null && project != null ? JupyterVarsSorter.INSTANCE.sort((List<? extends PyDebugValue>)values, project) : values;
            XValueChildrenList variables2 = new XValueChildrenList(sortedValues.size());
            for (PyDebugValue value : sortedValues) {
                if (parentValue != null) {
                    PyDebugValue it;
                    boolean bl = false;
                    value.setParent(it);
                }
                if (value instanceof DataFrameDebugValue && !(parentValue instanceof DataFrameDebugValue)) {
                    this.handleDataFrameDebugValue((DataFrameDebugValue)value);
                }
                value.setFrameAccessor(frameAccessor);
                variables2.add(value.getVisibleName(), (XValue)value);
            }
            xValueChildrenList = variables2;
        }
        catch (Exception e) {
            JupyterVarsFrameParser $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterVarsFrameParser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to load Jupyter variables: " + result2, (Throwable)e);
            xValueChildrenList = null;
        }
        return xValueChildrenList;
    }

    private final void handleDataFrameDebugValue(DataFrameDebugValue dataFrameDebugValue) {
        try {
            DataFrameDebugValue.InformationColumns columns;
            String string = dataFrameDebugValue.getValue();
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = DataFrameDebugValueUtilKt.getInformationColumns((String)it);
            } else {
                v1 = columns = null;
            }
            if (columns != null) {
                dataFrameDebugValue.setColumns(columns);
                return;
            }
        }
        catch (CannotRetrieveColumnDataException cannotRetrieveColumnDataException) {
            JupyterVarsFrameParser $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterVarsFrameParser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't retrieve column data. Columns' completion won't be available.");
        }
    }

    public final void parseAsyncValues(@NotNull String result2, @NotNull List<? extends PyFrameAccessor.PyAsyncValue<String>> vars, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        try {
            List list = ProtocolParser.parseValues((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parseValues(...)");
            List debugValues = list;
            int n = ((Collection)debugValues).size();
            for (int i = 0; i < n; ++i) {
                PyDebugValue resultValue = (PyDebugValue)debugValues.get(i);
                vars.get(i).getCallback().ok((Object)resultValue.getValue());
            }
        }
        catch (Exception exception) {
            for (PyFrameAccessor.PyAsyncValue<String> pyAsyncValue : vars) {
                pyAsyncValue.getCallback().error(new PyDebuggerException(result2));
            }
        }
    }

    @NotNull
    public final ArrayChunk parseArrayChunk(@NotNull String result2, @NotNull String varName, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (((CharSequence)result2).length() == 0) {
            Object[] objectArray = new Object[]{varName};
            throw new JupyterExecutionException(JupyterBundle.message((String)"jupyter.failed.to.load.variable", (Object[])objectArray));
        }
        try {
            ArrayChunk arrayChunk = ProtocolParser.parseArrayValues((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)arrayChunk, (String)"parseArrayValues(...)");
            return arrayChunk;
        }
        catch (Exception exception) {
            throw new Exception("Failed to load array: " + result2);
        }
    }
}

