/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables.inline;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterSettingsKt;
import com.intellij.jupyter.core.editor.settings.JupyterShowInlineValuesSettingMode;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterInlineDebugRenderer;
import com.intellij.jupyter.core.premium.JupyterLicence;
import com.intellij.jupyter.py.editor.completion.JupyterRuntimeEnvService;
import com.intellij.jupyter.py.variables.PythonVariablesUtil;
import com.intellij.jupyter.py.variables.inline.JupyterDebuggerInlayListener;
import com.intellij.jupyter.py.variables.inline.JupyterFrameValues;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlinePainter;
import com.intellij.jupyter.py.variables.inline.JupyterInlineValueVisitor;
import com.intellij.jupyter.py.variables.inline.JupyterNotebookXDebugSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.debugger.PyStackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0016H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0016H\u0002J\b\u0010*\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u0014\u001aB\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00180\u0018 \u0017* \u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u00190\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlinePainter;", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "Lcom/jetbrains/python/debugger/PyStackFrame$PyStackFrameRefreshedListener;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "frameValues", "Lcom/intellij/jupyter/py/variables/inline/JupyterFrameValues;", "caretListener", "Lcom/intellij/openapi/editor/event/CaretListener;", "debugSession", "Lcom/intellij/jupyter/py/variables/inline/JupyterNotebookXDebugSession;", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "lastLineByEditor", "", "Lcom/intellij/openapi/editor/Editor;", "kotlin.jvm.PlatformType", "", "", "frameChanged", "", "frameVars", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "scopeOwner", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "stackFrameRefreshed", "isMyEditor", "", "ed", "initSettingsListener", "ensureCaretListenerOn", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "repaint", "clearInlayValues", "repaintAll", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterInlinePainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterInlinePainter.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlinePainter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n4225#2,11:164\n13805#2:178\n13806#2:181\n4225#2,11:182\n4225#2,11:200\n295#3,2:175\n1869#3,2:179\n774#3:193\n865#3,2:194\n1869#3,2:196\n1869#3,2:198\n774#3:211\n865#3,2:212\n1869#3,2:214\n1#4:177\n*S KotlinDebug\n*F\n+ 1 JupyterInlinePainter.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlinePainter\n*L\n62#1:164,11\n145#1:178\n145#1:181\n91#1:182,11\n157#1:200,11\n62#1:175,2\n146#1:179,2\n91#1:193\n91#1:194,2\n99#1:196,2\n96#1:198,2\n158#1:211\n158#1:212,2\n159#1:214,2\n*E\n"})
public final class JupyterInlinePainter
implements JupyterInlineCallback,
PyStackFrame.PyStackFrameRefreshedListener,
Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private JupyterFrameValues frameValues;
    @Nullable
    private CaretListener caretListener;
    @NotNull
    private final JupyterNotebookXDebugSession debugSession;
    @NotNull
    private final JupyterSettings settings;
    @Nullable
    private MessageBusConnection connection;
    private final Map<Editor, Integer> lastLineByEditor;

    /*
     * WARNING - void declaration
     */
    public JupyterInlinePainter(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile) {
        Object v2;
        MessageBusConnection messageBusConnection;
        block3: {
            Iterator $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Object[] it;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            this.project = project;
            this.notebookFile = notebookFile;
            this.frameValues = new JupyterFrameValues(null);
            this.debugSession = new JupyterNotebookXDebugSession(this.project, this.notebookFile.getFile());
            this.settings = JupyterSettings.Companion.getInstance();
            this.lastLineByEditor = Collections.synchronizedMap(new WeakHashMap());
            JupyterDebuggerInlayListener.Companion.getInstance(this.project).startListening();
            MessageBusConnection messageBusConnection2 = messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
            JupyterInlinePainter jupyterInlinePainter = this;
            boolean bl = false;
            Topic topic = PyStackFrame.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            it.subscribe(topic, (Object)this);
            jupyterInlinePainter.connection = messageBusConnection;
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorCreated(EditorFactoryEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Editor editor = event.getEditor();
                    EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
                    if (editorImpl == null) {
                        return;
                    }
                    EditorImpl editor2 = editorImpl;
                    if (this.isMyEditor((Editor)editor2)) {
                        this.repaint(editor2);
                    }
                }
            }, (Disposable)this);
            Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
            it = editorArray;
            boolean $i$f$filterIsInstance = false;
            void var6_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof EditorImpl)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Editor p0 = (Editor)element$iv;
                boolean bl2 = false;
                if (!this.isMyEditor(p0)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        messageBusConnection = v2;
        if (messageBusConnection != null) {
            MessageBusConnection p0 = messageBusConnection;
            boolean bl = false;
            this.ensureCaretListenerOn((EditorImpl)p0);
        }
        this.initSettingsListener();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void frameChanged(@NotNull XValueChildrenList frameVars, @NotNull ScopeOwner scopeOwner) {
        void it;
        JupyterFrameValues jupyterFrameValues;
        Intrinsics.checkNotNullParameter((Object)frameVars, (String)"frameVars");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        JupyterFrameValues jupyterFrameValues2 = jupyterFrameValues = new JupyterFrameValues(scopeOwner);
        JupyterInlinePainter jupyterInlinePainter = this;
        boolean bl = false;
        it.update(frameVars);
        jupyterInlinePainter.frameValues = jupyterFrameValues;
        this.repaintAll();
    }

    public void stackFrameRefreshed() {
        if (this.project.isDisposed()) {
            return;
        }
        XValueChildrenList xValueChildrenList = JupyterRuntimeEnvService.Companion.getInstance(this.project).getXValueChildrenList(this.notebookFile.getFile());
        if (xValueChildrenList == null) {
            return;
        }
        XValueChildrenList values = xValueChildrenList;
        ApplicationManager.getApplication().runReadAction(() -> JupyterInlinePainter.stackFrameRefreshed$lambda$0(this, values));
    }

    private final boolean isMyEditor(Editor ed) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(ed.getDocument());
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vf = virtualFile;
        return Intrinsics.areEqual((Object)vf, (Object)this.notebookFile.getOriginFile()) || Intrinsics.areEqual((Object)vf, (Object)this.notebookFile.getFile());
    }

    private final void initSettingsListener() {
        block0: {
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(JupyterSettingsKt.getJUPYTER_SETTINGS_TOPIC(), (arg_0, arg_1) -> JupyterInlinePainter.initSettingsListener$lambda$0(this, arg_0, arg_1));
        }
    }

    private final void ensureCaretListenerOn(EditorImpl editor) {
        if (this.caretListener != null) {
            return;
        }
        CaretListener listener2 = new CaretListener(this){
            final /* synthetic */ JupyterInlinePainter this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(CaretEvent e) {
                Integer prev;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!JupyterInlinePainter.access$getSettings$p(this.this$0).getShowInlineValues()) {
                    return;
                }
                if (JupyterInlinePainter.access$getSettings$p(this.this$0).getShowInlineValuesMode() == JupyterShowInlineValuesSettingMode.ENTIRE_NOTEBOOK) {
                    return;
                }
                if (JupyterInlinePainter.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                Editor editor = e.getEditor();
                EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
                if (editorImpl == null) {
                    return;
                }
                EditorImpl ed = editorImpl;
                if (!JupyterInlinePainter.access$isMyEditor(this.this$0, (Editor)ed)) {
                    return;
                }
                int line = e.getCaret().getLogicalPosition().line;
                Integer n = prev = (Integer)JupyterInlinePainter.access$getLastLineByEditor$p(this.this$0).get(ed);
                int n2 = line;
                if (n != null && n == n2) {
                    return;
                }
                Map map = JupyterInlinePainter.access$getLastLineByEditor$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"access$getLastLineByEditor$p(...)");
                Map map2 = map;
                Integer n3 = line;
                map2.put(ed, n3);
                ApplicationManager.getApplication().runReadAction(() -> ensureCaretListenerOn.listener.1.caretPositionChanged$lambda$0(this.this$0, ed));
            }

            private static final void caretPositionChanged$lambda$0(JupyterInlinePainter this$0, EditorImpl $ed) {
                if (JupyterInlinePainter.access$getProject$p(this$0).isDisposed()) {
                    return;
                }
                JupyterInlinePainter.access$repaint(this$0, $ed);
            }
        };
        editor.getCaretModel().addCaretListener(listener2, (Disposable)this);
        this.caretListener = listener2;
    }

    private final void repaint(EditorImpl editor) {
        ApplicationManager.getApplication().invokeLater(() -> JupyterInlinePainter.repaint$lambda$0(this, editor));
    }

    private final void clearInlayValues(Editor editor) {
        Class[] types;
        InlayModel inlayModel = editor.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
        InlayModel inlayModel2 = inlayModel;
        Class[] classArray = new Class[]{InlineDebugRenderer.class, JupyterInlineDebugRenderer.class};
        Class[] $this$forEach$iv = types = classArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Class element$iv;
            Class cls = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            List list = inlayModel2.getAfterLineEndElementsInRange(0, editor.getDocument().getTextLength(), cls);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAfterLineEndElementsInRange(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Inlay d = (Inlay)element$iv2;
                boolean bl2 = false;
                Inlay inlay = d;
                Intrinsics.checkNotNull((Object)inlay);
                Disposer.dispose((Disposable)((Disposable)inlay));
            }
        }
    }

    private final void repaintAll() {
        if (!this.settings.getShowInlineValues()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> JupyterInlinePainter.repaintAll$lambda$0(this));
    }

    private static final void stackFrameRefreshed$lambda$0(JupyterInlinePainter this$0, XValueChildrenList $values) {
        PsiFile psiFile2 = PythonVariablesUtil.INSTANCE.getPythonJupyterPsiFile(this$0.project, this$0.notebookFile.getOriginFile());
        ScopeOwner scopeOwner = psiFile2 instanceof ScopeOwner ? (ScopeOwner)psiFile2 : null;
        if (scopeOwner == null) {
            return;
        }
        ScopeOwner scopeOwner2 = scopeOwner;
        this$0.frameChanged($values, scopeOwner2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void initSettingsListener$lambda$0(JupyterInlinePainter this$0, JupyterSettings before, JupyterSettings after) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        if (this$0.project.isDisposed()) {
            return;
        }
        boolean modeUpdated = before.getShowInlineValuesMode() != after.getShowInlineValuesMode();
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        Object $this$filterIsInstance$iv = editorArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EditorImpl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Editor p0 = (Editor)element$iv$iv;
            boolean bl = false;
            if (!this$0.isMyEditor(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List editors = (List)destination$iv$iv;
        if (after.getShowInlineValues() && (modeUpdated || !before.getShowInlineValues())) {
            ApplicationManager.getApplication().runReadAction(() -> JupyterInlinePainter.initSettingsListener$lambda$0$0(this$0, editors));
        } else {
            Iterable $this$forEach$iv = editors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Editor p0 = (Editor)element$iv;
                boolean bl = false;
                this$0.clearInlayValues(p0);
            }
        }
    }

    private static final void initSettingsListener$lambda$0$0(JupyterInlinePainter this$0, List $editors) {
        if (this$0.project.isDisposed()) {
            return;
        }
        Iterable $this$forEach$iv = $editors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorImpl p0 = (EditorImpl)element$iv;
            boolean bl = false;
            this$0.repaint(p0);
        }
    }

    private static final void repaint$lambda$0(JupyterInlinePainter this$0, EditorImpl $editor) {
        if (this$0.project.isDisposed()) {
            return;
        }
        this$0.clearInlayValues((Editor)$editor);
        if (JupyterLicence.INSTANCE.isUnpaidVersion()) {
            return;
        }
        PsiFile psiFile2 = PythonVariablesUtil.INSTANCE.getPythonJupyterPsiFile(this$0.project, this$0.notebookFile.getOriginFile());
        if (psiFile2 == null) {
            return;
        }
        PsiFile psi = psiFile2;
        psi.accept((PsiElementVisitor)new JupyterInlineValueVisitor($editor, this$0.frameValues, this$0.debugSession));
    }

    /*
     * WARNING - void declaration
     */
    private static final void repaintAll$lambda$0(JupyterInlinePainter this$0) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        if (this$0.project.isDisposed()) {
            return;
        }
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        Object[] $this$filterIsInstance$iv = editorArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EditorImpl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Editor p0 = (Editor)element$iv$iv;
            boolean bl = false;
            if (!this$0.isMyEditor(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorImpl p0 = (EditorImpl)element$iv;
            boolean bl = false;
            this$0.repaint(p0);
        }
    }

    public static final /* synthetic */ JupyterSettings access$getSettings$p(JupyterInlinePainter $this) {
        return $this.settings;
    }

    public static final /* synthetic */ Project access$getProject$p(JupyterInlinePainter $this) {
        return $this.project;
    }

    public static final /* synthetic */ Map access$getLastLineByEditor$p(JupyterInlinePainter $this) {
        return $this.lastLineByEditor;
    }
}

