/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables.inline;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.completion.JupyterVariablesListener;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.py.editor.completion.JupyterRuntimeEnvService;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.jupyter.py.variables.JupyterXStandaloneVariablesViewStore;
import com.intellij.jupyter.py.variables.PythonVariablesUtil;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlinePainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService;", "Lcom/intellij/jupyter/core/jupyter/editor/completion/JupyterVariablesListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "runtimeEnvService", "Lcom/intellij/jupyter/py/editor/completion/JupyterRuntimeEnvService;", "painters", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlinePainter;", "dispose", "", "notebookSessionEnvironmentUpdated", "virtualFile", "values", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "getInlineCallback", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "pushInline", "notebook", "Companion", "intellij.jupyter.py"})
public final class JupyterInlineService
implements JupyterVariablesListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JupyterRuntimeEnvService runtimeEnvService;
    @NotNull
    private ConcurrentHashMap<VirtualFile, JupyterInlinePainter> painters;

    public JupyterInlineService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.runtimeEnvService = JupyterRuntimeEnvService.Companion.getInstance(this.project);
        this.painters = new ConcurrentHashMap();
        this.project.getMessageBus().connect((Disposable)this).subscribe(JupyterVariablesListener.Companion.getTOPIC(), (Object)this);
    }

    public void dispose() {
        this.painters = new ConcurrentHashMap();
    }

    public void notebookSessionEnvironmentUpdated(@NotNull VirtualFile virtualFile, @Nullable XValueChildrenList values) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (this.project.isDisposed()) {
            return;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
        JupyterNotebook jupyterNotebook = notebookVirtualFile.getNotebookOrNull();
        if (!Intrinsics.areEqual((Object)(jupyterNotebook != null ? jupyterNotebook.getLanguage() : null), (Object)JupyterPyDialect.INSTANCE)) {
            return;
        }
        JupyterCoroutineKt.launchEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, notebookVirtualFile, null){
            int label;
            final /* synthetic */ JupyterInlineService this$0;
            final /* synthetic */ BackedNotebookVirtualFile $notebookVirtualFile;
            {
                this.this$0 = $receiver;
                this.$notebookVirtualFile = $notebookVirtualFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        XStandaloneVariablesView view;
                        ResultKt.throwOnFailure((Object)$result);
                        XStandaloneVariablesView xStandaloneVariablesView = view = JupyterXStandaloneVariablesViewStore.Companion.getInstance(JupyterInlineService.access$getProject$p(this.this$0)).getOrCreate(this.$notebookVirtualFile);
                        if (xStandaloneVariablesView != null) {
                            xStandaloneVariablesView.rebuildView();
                        }
                        this.this$0.pushInline(this.$notebookVirtualFile);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public final JupyterInlineCallback getInlineCallback(@NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        VirtualFile originalFile = notebookFile.getOriginFile();
        if (this.project.isDisposed()) {
            return null;
        }
        return this.painters.computeIfAbsent(originalFile, arg_0 -> JupyterInlineService.getInlineCallback$lambda$1(arg_0 -> JupyterInlineService.getInlineCallback$lambda$0(this, notebookFile, originalFile, arg_0), arg_0));
    }

    public final void pushInline(@NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        JupyterInlineCallback jupyterInlineCallback = this.getInlineCallback(notebook);
        if (jupyterInlineCallback == null) {
            return;
        }
        JupyterInlineCallback callback = jupyterInlineCallback;
        XValueChildrenList xValueChildrenList = this.runtimeEnvService.getXValueChildrenList(notebook.getFile());
        if (xValueChildrenList == null) {
            return;
        }
        XValueChildrenList values = xValueChildrenList;
        PythonVariablesUtil.INSTANCE.callJupyterInlineCallback(this.project, notebook, values, callback);
    }

    private static final JupyterInlinePainter getInlineCallback$lambda$0(JupyterInlineService this$0, BackedNotebookVirtualFile $notebookFile, VirtualFile $originalFile, VirtualFile it) {
        JupyterInlinePainter jupyterInlinePainter;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JupyterInlinePainter it2 = jupyterInlinePainter = new JupyterInlinePainter(this$0.project, $notebookFile);
        boolean bl = false;
        Disposable disposable = $notebookFile.getFileDisposable();
        if (disposable == null) {
            disposable = (Disposable)this$0.project;
        }
        Disposable fileDisposable = disposable;
        Disposer.register((Disposable)((Disposable)it2), () -> JupyterInlineService.getInlineCallback$lambda$0$0$0(this$0, $originalFile));
        Disposer.register((Disposable)fileDisposable, (Disposable)((Disposable)it2));
        return jupyterInlinePainter;
    }

    private static final void getInlineCallback$lambda$0$0$0(JupyterInlineService this$0, VirtualFile $originalFile) {
        this$0.painters.remove($originalFile);
    }

    private static final JupyterInlinePainter getInlineCallback$lambda$1(Function1 $tmp0, Object p0) {
        return (JupyterInlinePainter)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final JupyterInlineService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(JupyterInlineService $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService;", "project", "Lcom/intellij/openapi/project/Project;", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterInlineService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterInlineService.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,76:1\n30#2,2:77\n*S KotlinDebug\n*F\n+ 1 JupyterInlineService.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineService$Companion\n*L\n68#1:77,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterInlineService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterInlineService> serviceClass$iv = JupyterInlineService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterInlineService)object;
        }

        public final void install(@NotNull Editor editor, @NotNull BackedNotebookVirtualFile notebookFile) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            this.getInstance(project2).getInlineCallback(notebookFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

