/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables.inline;

import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterShowInlineValuesSettingMode;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterInlineDebugRenderer;
import com.intellij.jupyter.py.variables.inline.JupyterFrameValues;
import com.intellij.jupyter.py.variables.inline.JupyterInlineValueCustomizer;
import com.intellij.jupyter.py.variables.inline.JupyterInlineValuePosition;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxyKeeperKt;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor;", "Lcom/jetbrains/python/psi/PyRecursiveElementVisitor;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "frameValues", "Lcom/intellij/jupyter/py/variables/inline/JupyterFrameValues;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/jupyter/py/variables/inline/JupyterFrameValues;Lcom/intellij/xdebugger/XDebugSession;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "lines", "", "", "variablesWithLineNumber", "", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor$LineVariable;", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "selectedLine", "getSelectedLine", "()I", "selectedLine$delegate", "Lkotlin/Lazy;", "visitPyAssignmentStatement", "", "node", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "addInlinePreview", "lineNumber", "nodeName", "", "Lcom/jetbrains/python/psi/PyElement;", "LineVariable", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterInlineValueVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterInlineValueVisitor.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,83:1\n13805#2,2:84\n*S KotlinDebug\n*F\n+ 1 JupyterInlineValueVisitor.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor\n*L\n33#1:84,2\n*E\n"})
public final class JupyterInlineValueVisitor
extends PyRecursiveElementVisitor {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final JupyterFrameValues frameValues;
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final List<Integer> lines;
    @NotNull
    private final Set<LineVariable> variablesWithLineNumber;
    @NotNull
    private final JupyterSettings settings;
    @NotNull
    private final Lazy selectedLine$delegate;

    public JupyterInlineValueVisitor(@NotNull EditorImpl editor, @NotNull JupyterFrameValues frameValues, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)frameValues, (String)"frameValues");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.editor = editor;
        this.frameValues = frameValues;
        this.session = session;
        this.lines = new ArrayList();
        this.variablesWithLineNumber = new LinkedHashSet();
        this.settings = JupyterSettings.Companion.getInstance();
        this.selectedLine$delegate = LazyKt.lazy(() -> JupyterInlineValueVisitor.selectedLine_delegate$lambda$0(this));
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    private final int getSelectedLine() {
        Lazy lazy = this.selectedLine$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.editor.isDisposed()) {
            return;
        }
        if (node.getAssignedValue() instanceof PyLiteralExpression) {
            return;
        }
        PyExpression[] pyExpressionArray = node.getTargets();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getTargets(...)");
        Object[] $this$forEach$iv = pyExpressionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String nodeName;
            PyExpression target = (PyExpression)element$iv;
            boolean bl = false;
            if (target.getName() == null) continue;
            boolean bl2 = false;
            int textOffset = target.getTextOffset();
            if (textOffset < 0 || textOffset >= this.editor.getDocument().getTextLength()) {
                return;
            }
            int lineNumber = this.editor.getDocument().getLineNumber(textOffset);
            if (this.settings.getShowInlineValuesMode() == JupyterShowInlineValuesSettingMode.CURRENT_LINE && lineNumber != this.getSelectedLine()) {
                return;
            }
            if (this.lines.contains(lineNumber)) {
                return;
            }
            this.lines.add(lineNumber);
            this.addInlinePreview(lineNumber, nodeName, (PyElement)node);
        }
        super.visitPyAssignmentStatement(node);
    }

    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.editor.isDisposed()) {
            return;
        }
        super.visitPyReferenceExpression(node);
        if (!Intrinsics.areEqual((Object)ScopeUtil.getScopeOwner((PsiElement)((PsiElement)node)), (Object)this.frameValues.getScopeOwner())) {
            return;
        }
        String string = node.getName();
        if (string == null) {
            return;
        }
        String nodeName = string;
        int textOffset = node.getTextOffset();
        if (textOffset < 0 || textOffset >= this.editor.getDocument().getTextLength()) {
            return;
        }
        int lineNumber = this.editor.getDocument().getLineNumber(textOffset);
        if (lineNumber != this.getSelectedLine()) {
            return;
        }
        this.addInlinePreview(lineNumber, nodeName, (PyElement)node);
    }

    private final void addInlinePreview(int lineNumber, String nodeName, PyElement node) {
        LineVariable lineVariable = new LineVariable(lineNumber, nodeName);
        if (this.variablesWithLineNumber.contains(lineVariable)) {
            return;
        }
        this.variablesWithLineNumber.add(lineVariable);
        PyDebugValue pyDebugValue = this.frameValues.getValue(nodeName);
        if (pyDebugValue == null) {
            return;
        }
        PyDebugValue value = pyDebugValue;
        List list = value.getValueNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueNodes(...)");
        XValueNode xValueNode = (XValueNode)CollectionsKt.firstOrNull((List)list);
        if (xValueNode == null) {
            return;
        }
        XValueNode valueNode = xValueNode;
        if (valueNode instanceof XValueNodeImpl) {
            JupyterInlineValueCustomizer.INSTANCE.customize(value);
            XDebugSessionProxy proxy = XDebugSessionProxyKeeperKt.asProxy((XDebugSession)this.session);
            InlineDebugRendererBase renderer = switch (WhenMappings.$EnumSwitchMapping$0[this.settings.getShowInlineValuesMode().ordinal()]) {
                case 1 -> (InlineDebugRendererBase)new InlineDebugRenderer((XValueNodeImpl)valueNode, node.getContainingFile().getVirtualFile(), 0, proxy);
                case 2 -> {
                    XValueNodeImpl v4 = (XValueNodeImpl)valueNode;
                    VirtualFile v5 = node.getContainingFile().getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getVirtualFile(...)");
                    yield (InlineDebugRendererBase)new JupyterInlineDebugRenderer(v4, (XSourcePosition)new JupyterInlineValuePosition(v5), this.session);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            int textOffset = node.getTextOffset();
            this.editor.getInlayModel().addAfterLineEndElement(textOffset + 1, new InlayProperties().disableSoftWrapping(true), (EditorCustomElementRenderer)renderer);
        }
    }

    private static final int selectedLine_delegate$lambda$0(JupyterInlineValueVisitor this$0) {
        CaretModelImpl caretModelImpl = this$0.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModelImpl, (String)"getCaretModel(...)");
        CaretModel caretModel = (CaretModel)caretModelImpl;
        return this$0.editor.getDocument().getLineNumber(caretModel.getOffset());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor$LineVariable;", "", "lineNumber", "", "varName", "", "<init>", "(ILjava/lang/String;)V", "getLineNumber", "()I", "getVarName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.jupyter.py"})
    private static final class LineVariable {
        private final int lineNumber;
        @NotNull
        private final String varName;

        public LineVariable(int lineNumber, @NotNull String varName) {
            Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
            this.lineNumber = lineNumber;
            this.varName = varName;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final String getVarName() {
            return this.varName;
        }

        public final int component1() {
            return this.lineNumber;
        }

        @NotNull
        public final String component2() {
            return this.varName;
        }

        @NotNull
        public final LineVariable copy(int lineNumber, @NotNull String varName) {
            Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
            return new LineVariable(lineNumber, varName);
        }

        public static /* synthetic */ LineVariable copy$default(LineVariable lineVariable, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = lineVariable.lineNumber;
            }
            if ((n2 & 2) != 0) {
                string = lineVariable.varName;
            }
            return lineVariable.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "LineVariable(lineNumber=" + this.lineNumber + ", varName=" + this.varName + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.lineNumber);
            result2 = result2 * 31 + this.varName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineVariable)) {
                return false;
            }
            LineVariable lineVariable = (LineVariable)other;
            if (this.lineNumber != lineVariable.lineNumber) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.varName, (Object)lineVariable.varName);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterShowInlineValuesSettingMode.values().length];
            try {
                nArray[JupyterShowInlineValuesSettingMode.ENTIRE_NOTEBOOK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterShowInlineValuesSettingMode.CURRENT_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

