/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemProvider;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.WslIjentAvailabilityService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.impl.fs.EelEarlyAccessChecker;
import com.intellij.platform.eel.impl.fs.telemetry.TracingFileSystem;
import com.intellij.platform.eel.impl.fs.telemetry.TracingFileSystemProvider;
import com.intellij.platform.eel.provider.MultiRoutingFileSystemBackend;
import com.intellij.platform.ide.impl.wsl.WslEelDescriptor;
import com.intellij.platform.ide.impl.wsl.WslEelProvider;
import com.intellij.platform.ide.impl.wsl.WslEelProviderKt;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystemProvider;
import com.intellij.platform.ijent.community.impl.IjentFailSafeFileSystemPosixApiKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import com.intellij.util.containers.ContainerUtil;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a'\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/ide/impl/wsl/EelWslMrfsBackend;", "Lcom/intellij/platform/eel/provider/MultiRoutingFileSystemBackend;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "providersCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/nio/file/FileSystem;", "reportedNonExistentWslIds", "Ljava/util/concurrent/atomic/AtomicReference;", "", "compute", "localFS", "sanitizedPath", "getCustomRoots", "", "getCustomFileStores", "Ljava/nio/file/FileStore;", "Companion", "intellij.platform.ide.impl.wsl"})
@ApiStatus.Internal
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nWslEelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslEelProvider.kt\ncom/intellij/platform/ide/impl/wsl/EelWslMrfsBackend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,335:1\n1563#2:336\n1634#2,2:337\n230#2,2:339\n1636#2:341\n1374#2:342\n1460#2,5:343\n1374#2:348\n1460#2,5:349\n42#3,3:354\n13#4:357\n*S KotlinDebug\n*F\n+ 1 WslEelProvider.kt\ncom/intellij/platform/ide/impl/wsl/EelWslMrfsBackend\n*L\n147#1:336\n147#1:337,2\n148#1:339,2\n147#1:341\n156#1:342\n156#1:343,5\n157#1:348\n157#1:349,5\n78#1:354,3\n161#1:357\n*E\n"})
public final class EelWslMrfsBackend
implements MultiRoutingFileSystemBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentMap<String, FileSystem> providersCache;
    @NotNull
    private final AtomicReference<List<String>> reportedNonExistentWslIds;
    @NotNull
    private static final Logger LOG;

    public EelWslMrfsBackend(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.providersCache = concurrentMap;
        this.reportedNonExistentWslIds = new AtomicReference<List>(CollectionsKt.emptyList());
    }

    @Nullable
    public FileSystem compute(@NotNull FileSystem localFS, @NotNull String sanitizedPath) {
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Intrinsics.checkNotNullParameter((Object)sanitizedPath, (String)"sanitizedPath");
        Pair<String, String> pair = WslEelProvider.Companion.parsePath$intellij_platform_ide_impl_wsl(sanitizedPath);
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String wslRoot = (String)pair2.component1();
        String distributionId = (String)pair2.component2();
        try {
            if (!WslIjentAvailabilityService.Companion.getInstance().useIjentForWslNioFileSystem()) {
                return null;
            }
        }
        catch (Exception err) {
            if (err instanceof ControlFlowException) {
                return null;
            }
            throw err;
        }
        String key = WslEelProviderKt.access$getUseNewFileSystem$p() ? wslRoot : distributionId;
        return this.providersCache.computeIfAbsent(key, arg_0 -> EelWslMrfsBackend.compute$lambda$1(arg_0 -> EelWslMrfsBackend.compute$lambda$0(sanitizedPath, distributionId, this, wslRoot, localFS, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getCustomRoots() {
        void $this$mapTo$iv$iv;
        List list = WslDistributionManager.getInstance().getInstalledDistributionsFuture().getNow(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNow(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object element$iv2;
            Collection collection;
            block2: {
                void wsl;
                WSLDistribution wSLDistribution = (WSLDistribution)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)wsl);
                Iterable $this$first$iv = WslEelProviderKt.access$getRoots((WSLDistribution)wsl);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    String root = (String)element$iv2;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)root, (CharSequence)"wsl.localhost", (boolean)false, (int)2, null)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            collection.add((String)element$iv2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Collection<FileStore> getCustomFileStores(@NotNull FileSystem localFS) {
        Iterable<FileStore> list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        List list = WslDistributionManager.getInstance().getInstalledDistributionsFuture().getNow(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNow(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (WSLDistribution)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            list$iv$iv = WslEelProviderKt.access$getRoots(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            FileSystem fileSystem = this.compute(localFS, (String)it);
            Intrinsics.checkNotNull((Object)fileSystem);
            Intrinsics.checkNotNullExpressionValue(fileSystem.getFileStores(), (String)"getFileStores(...)");
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final FileSystem compute$lambda$0(String $sanitizedPath, String $distributionId, EelWslMrfsBackend this$0, String $wslRoot, FileSystem $localFS, String it) {
        FileSystem fileSystem;
        TracingFileSystem fs2;
        boolean $i$f$service = false;
        Class<EelEarlyAccessChecker> serviceClass$iv = EelEarlyAccessChecker.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((EelEarlyAccessChecker)object).check($sanitizedPath);
        URI ijentUri = new URI("ijent", "wsl", "/" + $distributionId, null, null);
        TracingFileSystemProvider ijentFsProvider = new TracingFileSystemProvider((FileSystemProvider)IjentNioFileSystemProvider.Companion.getInstance(), null, 2, null);
        try {
            IjentFileSystemApi ijentFs = IjentFailSafeFileSystemPosixApiKt.IjentFailSafeFileSystemPosixApi((CoroutineScope)this$0.coroutineScope, (EelDescriptor)((EelDescriptor)new WslEelDescriptor(new WSLDistribution($distributionId), $wslRoot)));
            fs2 = (TracingFileSystem)ijentFsProvider.newFileSystem(ijentUri, IjentNioFileSystemProvider.Companion.newFileSystemMap(ijentFs));
            JobKt.getJob((CoroutineContext)this$0.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> EelWslMrfsBackend.compute$lambda$0$0(fs2, arg_0));
        }
        catch (FileSystemAlreadyExistsException fs2) {
            // empty catch block
        }
        try {
            FileSystem fileSystem2;
            if (WslEelProviderKt.access$getUseNewFileSystem$p()) {
                Path path = Paths.get($wslRoot, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                FileSystemProvider fileSystemProvider = (FileSystemProvider)ijentFsProvider;
                FileSystemProvider fileSystemProvider2 = $localFS.provider();
                Intrinsics.checkNotNullExpressionValue((Object)fileSystemProvider2, (String)"provider(...)");
                fs2 = new IjentEphemeralRootAwareFileSystemProvider(path, fileSystemProvider, (FileSystemProvider)new TracingFileSystemProvider(fileSystemProvider2, null, 2, null), true).getFileSystem(ijentUri);
                Intrinsics.checkNotNull((Object)fs2);
                fileSystem2 = (FileSystem)fs2;
            } else {
                FileSystemProvider fileSystemProvider = (FileSystemProvider)ijentFsProvider;
                FileSystemProvider fileSystemProvider3 = $localFS.provider();
                Intrinsics.checkNotNullExpressionValue((Object)fileSystemProvider3, (String)"provider(...)");
                IjentWslNioFileSystemProvider ijentWslNioFileSystemProvider = new IjentWslNioFileSystemProvider($distributionId, fileSystemProvider, (FileSystemProvider)new TracingFileSystemProvider(fileSystemProvider3, null, 2, null));
                URI uRI = Path.of($wslRoot, new String[0]).toUri();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
                fileSystem2 = ijentWslNioFileSystemProvider.getFileSystem(uRI);
            }
            FileSystem fileSystem3 = fileSystem2;
            LOG.info("Switching " + $distributionId + " to IJent WSL nio.FS: " + fileSystem3);
            fileSystem = fileSystem3;
        }
        catch (FileSystemNotFoundException err) {
            if (!this$0.reportedNonExistentWslIds.getAndUpdate(arg_0 -> EelWslMrfsBackend.compute$lambda$0$1($distributionId, arg_0)).contains($distributionId)) {
                LOG.warn("Attempt to get IJent WSL nio.FS for non-existing WSL distribution " + $wslRoot, (Throwable)err);
            }
            fileSystem = null;
        }
        return fileSystem;
    }

    private static final Unit compute$lambda$0$0(TracingFileSystem $fs, Throwable it) {
        block0: {
            TracingFileSystem tracingFileSystem = $fs;
            if (tracingFileSystem == null) break block0;
            tracingFileSystem.close();
        }
        return Unit.INSTANCE;
    }

    private static final List compute$lambda$0$1(String $distributionId, List prev) {
        List list;
        if (prev.contains($distributionId)) {
            list = prev;
        } else {
            Intrinsics.checkNotNull((Object)prev);
            list = CollectionsKt.plus((Collection)prev, (Object)$distributionId);
        }
        return list;
    }

    private static final FileSystem compute$lambda$1(Function1 $tmp0, Object p0) {
        return (FileSystem)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EelWslMrfsBackend.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/ide/impl/wsl/EelWslMrfsBackend$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl.wsl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

