/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.oracle.generator.dml.OraMultiInsertRowsGenerator;
import com.intellij.database.dialects.oracle.generator.dml.OraWrapInSelectGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.MultiInsertRowsTask;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J0\u0010\b\u001a\u0016\u0012\u0004\u0012\u0002H\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u000b\u0018\u00010\t\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\u000bH\u0014J:\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/database/dialects/oracle/OraDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/LimitPlace;", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "OUT", "Lcom/intellij/database/script/generator/dml/DmlTask;", "task", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/DasObject;", "builder", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "", "hasRowId", "Lcom/intellij/database/model/DasTable;", "version", "Lcom/intellij/database/util/Version;", "appendRowId", "alias", "", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.oracle"})
public final class OraDmlHelper
extends BaseDmlHelper {
    public OraDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @NotNull
    public LimitPlace getPlaceForLimit() {
        return LimitPlace.BOTH;
    }

    @Nullable
    protected <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlTask<? extends OUT> dmlTask = task;
        DmlGenerator dmlGenerator = dmlTask instanceof MultiInsertRowsTask ? (DmlGenerator)new OraMultiInsertRowsGenerator((MultiInsertRowsTask)task, this.getDbms()) : (dmlTask instanceof WrapInSelectTask ? (DmlGenerator)new OraWrapInSelectGenerator((WrapInSelectTask)task, this.getDbms()) : super.getGenerator(task));
        return dmlGenerator instanceof DmlGenerator ? dmlGenerator : null;
    }

    @NotNull
    public DdlBuilder appendLimit(@Nullable DasObject table, @NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return GridUtilCore.isPageSizeUnlimited((int)limit) ? builder : this.rowNumLimit(builder, limit, atBeginning);
    }

    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return true;
    }

    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("ROWID");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"literal(...)");
        return ddlBuilder;
    }

    public boolean isEditableTable(@Nullable ObjectKind kind) {
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) ? true : super.isEditableTable(kind);
    }
}

