/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.oracle.OraDdlParsing;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.OraDmlParsing;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.dialects.oracle.OraExpressionParsing;
import com.intellij.sql.dialects.oracle.OraGeneratedParser;
import com.intellij.sql.dialects.oracle.OraPlParsing;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlCreateIndexStatementImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import org.jetbrains.annotations.Nullable;

public class OraParser
extends SqlParser {
    public static final SqlSuggestedInjection ORACLE_INJECTION = new SqlSuggestedInjection("Oracle");

    public OraParser() {
        super((SqlLanguageDialectEx)OraDialect.INSTANCE);
    }

    protected OraParser(SqlLanguageDialectEx language) {
        super(language);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return OraGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseReferenceExpression(PsiBuilder builder, SqlReferenceElementType refType) {
        if (refType == OraElementTypes.All.ORA_PACKAGE_BODY_REFERENCE) {
            OraGeneratedParser.package_body_ref(builder, 0);
            return true;
        }
        if (refType == OraElementTypes.All.ORA_TYPE_BODY_REFERENCE) {
            OraGeneratedParser.type_body_ref(builder, 0);
            return true;
        }
        return super.parseReferenceExpression(builder, refType);
    }

    private static boolean parseDbLinkReference(PsiBuilder builder) {
        PsiBuilder.Marker m = builder.mark();
        if (SqlGeneratedParserUtil.parseMultiIdentifier((PsiBuilder)builder, (int)0)) {
            m.done((IElementType)OraElementTypes.Extra.ORA_DATABASE_LINK_REFERENCE);
            return true;
        }
        m.drop();
        return false;
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (OraGeneratedParser.conditional(builder, 0, (b, l) -> this.parseReferenceExpressionInner(b, false, force, refType))) {
            return true;
        }
        if (refType == SQL_GENERIC_AT_REFERENCE || refType == OraElementTypes.Extra.ORA_DATABASE_LINK_REFERENCE) {
            return OraParser.parseDbLinkReference(builder);
        }
        return super.parseReferenceExpressionInner(builder, optional, force, refType);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return OraGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return OraGeneratedParser.statement(builder, level);
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return OraDmlParsing.any_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? OraPlParsing.type_element_ext(builder, level) : OraDdlParsing.type_element(builder, level);
    }

    protected boolean parseStatementInsideJdbcCall(PsiBuilder builder, int level) {
        return OraPlParsing.statement_inside_jdbc_call(builder, level);
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    protected boolean parseArgumentListInner(PsiBuilder builder) {
        PsiElement chameleon = SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder);
        if (PsiTreeUtil.getParentOfType((PsiElement)chameleon, SqlCreateTriggerStatement.class) != null) {
            SqlGeneratedParserUtil.setOn((PsiBuilder)builder, (int)0, (String)"TRIGGER_BODY");
            SqlGeneratedParserUtil.setOn((PsiBuilder)builder, (int)0, (String)"PL_DIALECT");
            this.updatePlContext(builder);
        } else if (PsiTreeUtil.getParentOfType((PsiElement)chameleon, SqlQueryExpression.class) == null) {
            boolean pl;
            SqlCreateStatement cs = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)chameleon, SqlCreateStatement.class);
            if (cs != null) {
                ObjectKind kind = cs.getKind();
                pl = kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY || kind == ObjectKind.ROUTINE;
            } else {
                boolean bl = pl = PsiTreeUtil.getParentOfType((PsiElement)chameleon, SqlBlockStatement.class) != null;
            }
            if (pl) {
                SqlGeneratedParserUtil.setOn((PsiBuilder)builder, (int)0, (String)"PL_DIALECT");
                this.updatePlContext(builder);
            }
        }
        return super.parseArgumentListInner(builder);
    }

    @Nullable
    protected IElementType getVariableType(PsiBuilder builder) {
        if (builder.getTokenType() == SQL_DOLLAR && builder.rawLookup(1) == SQL_DOLLAR) {
            return OraElementTypes.Extra.ORA_CONDITIONAL_FLAG_REFERENCE;
        }
        if (builder.getTokenType() == SQL_COLON && SqlGeneratedParserUtil.isOn((PsiBuilder)builder, (int)0, (String)"TRIGGER_BODY")) {
            return SQL_VARIABLE_REFERENCE;
        }
        return super.getVariableType(builder);
    }

    protected void consumeParameterReferenceInner(PsiBuilder builder) {
        if (builder.getTokenType() == SQL_DOLLAR && builder.rawLookup(1) == SQL_DOLLAR) {
            builder.advanceLexer();
            builder.advanceLexer();
            this.parseIdentifier(builder, false);
        } else {
            super.consumeParameterReferenceInner(builder);
        }
    }

    public void parseJdbcProcedureCallBody(PsiBuilder builder, int level, boolean refAlreadyParsed) {
        this.parseJdbcProcedureCallBody(builder, level, refAlreadyParsed, new SqlTokenType[]{SQL_OP_EQ, SQL_OP_ASSIGN});
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, OraExpressionParsing::evaluable_expression);
    }

    public boolean isReservedKeywordHere(PsiBuilder builder, IElementType type) {
        SqlLanguageDialectEx language = this.getLanguage();
        return type instanceof SqlKeywordTokenType && OraParser.isPl(builder) ? language.isReservedKeywordPL(type) : language.isReservedKeyword(type);
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        SqlTableKeyStub stub;
        PsiElement ctx = SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder);
        if (ctx instanceof SqlFile) {
            ctx = ctx.getContext();
        }
        SqlTableKeyStub sqlTableKeyStub = stub = ctx instanceof SqlCreateIndexStatementImpl ? (SqlTableKeyStub)((SqlCreateIndexStatementImpl)ctx).getStub() : null;
        if (stub != null && stub.getElement().getMetaObject().getParentKind(1) == ObjectKind.CLUSTER) {
            PsiBuilder.Marker m = builder.mark();
            this.parseReferenceExpression(builder, OraElementTypes.Extra.ORA_CLUSTER_REFERENCE);
            m.done((IElementType)SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST);
            return true;
        }
        return OraGeneratedParser.table_opt_column_list(builder, level);
    }

    protected static boolean isPl(PsiBuilder builder) {
        return SqlGeneratedParserUtil.isOn((PsiBuilder)builder, (int)0, (String)"PL_DIALECT");
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result;
        boolean bl = result = !allowBoolean ? OraExpressionParsing.root_expr(builder, level, 2) : OraExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        return this.parseNamedFunctionArgumentPrefixImpl(builder, (IElementType)SqlCommonTokens.ORA_OP_NAMED_PARAM_BINDING);
    }

    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return OraGeneratedParser.statement_recover_prefix(builder, level);
    }

    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return ORACLE_INJECTION;
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        OraGeneratedParser.aggregate_clause(builder, level);
        OraGeneratedParser.keep_clause(builder, level);
        OraGeneratedParser.analytic_clause(builder, level);
        return OraExpressionParsing.opt_dblink_ref(builder, level);
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, OraExpressionParsing::parenthesized_values_expr, OraDmlParsing::any_query_expression, OraParser::parseTopQueryExpressionTail, OraExpressionParsing::row_element_list, (b, l) -> OraExpressionParsing.root_expr_0(b, l, -1) && OraExpressionParsing.row_element_list_tail(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, OraDmlParsing::parenthesized_aliased_join_expression, OraDmlParsing::any_query_expression, OraParser::parseTopQueryExpressionTail, (b, l) -> OraDmlParsing.join_expression(b, l, -1), (b, l) -> OraDmlParsing.join_expression_0(b, l, -1));
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        OraDmlParsing.query_expression_0(builder, level, -1);
        return OraDmlParsing.left_inner_table_op_tail(builder, level);
    }

    public void updatePlContext(PsiBuilder b) {
    }
}

