/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.domains.AttributesInfo;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;

public class StmtPrint
extends Stmt {
    public static final int RELATION = 0;
    public static final int RELVAR = 1;
    public static final int STRING = 2;
    public static final int INTEGER = 3;
    public static final int BOOLEAN = 4;
    public static final int REGEXP = 5;
    public static final int SIZE = 6;
    public static final int CUSTOM = 7;
    private final List<?> printValues;
    private final List<Integer> printTypes;

    public StmtPrint(List<Integer> printTypes, List<?> printValues, Context context) {
        super(context, new QueryNode[0]);
        this.printValues = printValues;
        this.printTypes = printTypes;
    }

    public List<Integer> getPrintTypes() {
        return this.printTypes;
    }

    public List<?> getPrintValues() {
        return this.printValues;
    }

    @Override
    public void accept(StmtVisitor visitor2) {
        if (visitor2.visitPrintStart(this)) {
            for (Object value : this.printValues) {
                if (!(value instanceof RelationPrintBundle)) continue;
                ((RelationPrintBundle)value).expr.accept(visitor2);
            }
        }
        visitor2.visitPrintEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        return this;
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        cancellation.checkCancelled();
        for (int i = 0; i < this.printTypes.size(); ++i) {
            int type = this.printTypes.get(i);
            Object value = this.printValues.get(i);
            if (type == 2) {
                uiInstancesProvider.getConsole().print((String)value);
                continue;
            }
            if (type == 1) {
                IRelation relation = variablesManager.getRelation((String)value, cancellation);
                uiInstancesProvider.getRelationsConsole().print(relation, (String)value, symbolTable);
                continue;
            }
            if (type == 6) {
                IRelation relation = variablesManager.getRelation((String)value, cancellation);
                uiInstancesProvider.getConsole().print(Messages.getString(StmtPrint.class.getName() + "-0") + String.valueOf(value) + Messages.getString(StmtPrint.class.getName() + "-1") + " " + relation.getNumOfTuples());
                continue;
            }
            if (type == 0) {
                int j;
                RelationPrintBundle bundle = (RelationPrintBundle)value;
                Domain[] domains = new Domain[bundle.domainNames.size()];
                for (int j2 = 0; j2 < bundle.domainNames.size(); ++j2) {
                    String name = bundle.domainNames.get(j2);
                    domains[j2] = domainsPool.getDomain(this, name);
                    variablesManager.storeDomain(name, domains[j2]);
                }
                DomainType[] map2 = new HashMap();
                int len = 0;
                int[] sortPermutation = new int[domains.length];
                for (j = 0; j < domains.length; ++j) {
                    map2.put(bundle.domainNames.get(j), j);
                }
                for (j = 0; j < bundle.sortOrder.size(); ++j) {
                    String domain = bundle.sortOrder.get(j);
                    sortPermutation[len++] = (Integer)map2.get(domain);
                    map2.remove(domain);
                }
                for (j = 0; j < domains.length; ++j) {
                    if (!map2.containsKey(bundle.domainNames.get(j))) continue;
                    sortPermutation[len++] = j;
                }
                IRelation relation = bundle.expr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2).reorderDomains(domains);
                uiInstancesProvider.getRelationsConsole().print(relation, Messages.getString(StmtPrint.class.getName() + "-2"), bundle.maxTuples, sortPermutation, symbolTable, false);
                for (int j3 = bundle.domainNames.size() - 1; j3 >= 0; --j3) {
                    variablesManager.removeDomain(bundle.domainNames.get(j3));
                }
                continue;
            }
            if (type == 5) {
                DomainType[] types;
                uiInstancesProvider.getConsole().println(Messages.getString(StmtPrint.class.getName() + "-3") + String.valueOf(value) + "\"");
                Pattern pattern = Pattern.compile((String)value);
                for (DomainType domType : types = symbolTable.getAvailableDomainTypes()) {
                    AttributesInfo info = symbolTable.getAttributesInfo(domType);
                    for (int j = 0; j < info.getNumOfAttributes(); ++j) {
                        Attribute attribute = symbolTable.getAttribute(domType, j);
                        if (!pattern.matcher(attribute.getKey()).matches()) continue;
                        uiInstancesProvider.getConsole().print(domType.getName() + ": ");
                        uiInstancesProvider.getConsole().print(attribute.getKey() + ": \"" + String.valueOf(attribute) + "\"");
                        uiInstancesProvider.getConsole().println();
                    }
                }
                continue;
            }
            if (type == 7) {
                String relName = (String)((Pair)value).component1();
                Function2 function2 = (Function2)((Pair)value).component2();
                IRelation relation = variablesManager.getRelation(relName, cancellation);
                uiInstancesProvider.getConsole().print((String)function2.invoke((Object)relName, (Object)relation));
                continue;
            }
            int numValue = variablesManager.getVariable((String)value);
            if (type == 3) {
                uiInstancesProvider.getConsole().print(Integer.toString(numValue));
                continue;
            }
            uiInstancesProvider.getConsole().print(Boolean.toString(numValue == 1));
        }
    }

    @Override
    public String toLongString() {
        return "StmtPrint{printValues=" + String.valueOf(this.printValues) + ", printTypes=" + String.valueOf(this.printTypes) + "}";
    }

    public static class RelationPrintBundle {
        public int maxTuples = -1;
        public RelExpr expr;
        public List<String> domainNames = new ArrayList<String>();
        public List<Object> domainTypes = new ArrayList<Object>();
        public List<String> sortOrder = new ArrayList<String>();
    }
}

