/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics.file;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.statistics.file.Printer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/file/TextTable;", "", "columnNames", "", "", "<init>", "([Ljava/lang/String;)V", "rows", "Ljava/util/ArrayList;", "", "columnsCount", "", "maxLengths", "", "addRow", "", "row", "printTo", "p", "Lorg/jetbrains/kotlin/build/report/statistics/file/Printer;", "kotlin-build-statistics"})
@SourceDebugExtension(value={"SMAP\nPlainTextBuildReportWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainTextBuildReportWriter.kt\norg/jetbrains/kotlin/build/report/statistics/file/TextTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class TextTable {
    @NotNull
    private final ArrayList<List<String>> rows;
    private final int columnsCount;
    @NotNull
    private final int[] maxLengths;

    public TextTable(String ... columnNames) {
        Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
        this.rows = new ArrayList();
        this.columnsCount = columnNames.length;
        int n = 0;
        int n2 = this.columnsCount;
        int[] nArray = new int[n2];
        TextTable textTable = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = columnNames[n3].length();
        }
        textTable.maxLengths = nArray;
        this.rows.add(ArraysKt.toList((Object[])columnNames));
    }

    public final void addRow(String ... row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(row.length == this.columnsCount)) {
            boolean bl = false;
            String string = "Row size " + row.length + " differs from columns count " + this.columnsCount;
            throw new IllegalStateException(string.toString());
        }
        this.rows.add(ArraysKt.toList((Object[])row));
        int n = row.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            String col = row[i];
            this.maxLengths[i2] = Math.max(this.maxLengths[i2], col.length());
        }
    }

    public final void printTo(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Iterator<List<String>> iterator2 = this.rows.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<List<String>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            List<String> row;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), (String)"next(...)");
            String rowStr = CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)row), (CharSequence)"|", null, null, (int)0, null, arg_0 -> TextTable.printTo$lambda$0(this, arg_0), (int)30, null);
            String[] stringArray = new String[]{rowStr};
            p.println(stringArray);
        }
    }

    private static final CharSequence printTo$lambda$0(TextTable this$0, IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int i = indexedValue.component1();
        String col = (String)indexedValue.component2();
        return StringsKt.padEnd((String)col, (int)this$0.maxLengths[i], (char)' ');
    }
}

