/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.loader;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImplKt;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;
import org.jetbrains.kotlin.library.loader.KlibLoaderSpec;
import org.jetbrains.kotlin.library.loader.KlibPlatformChecker;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001e\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibLoader;", "", "init", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderSpec;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "libraryPaths", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "maxPermittedAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "platformChecker", "Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "zipFileSystemAccessor", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "load", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult;", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKlibLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibLoader.kt\norg/jetbrains/kotlin/library/loader/KlibLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1863#2,2:169\n*S KotlinDebug\n*F\n+ 1 KlibLoader.kt\norg/jetbrains/kotlin/library/loader/KlibLoader\n*L\n91#1:169,2\n*E\n"})
public final class KlibLoader {
    @NotNull
    private final ArrayList<String> libraryPaths;
    @Nullable
    private KlibPlatformChecker platformChecker;
    @Nullable
    private KotlinAbiVersion maxPermittedAbiVersion;
    @Nullable
    private ZipFileSystemAccessor zipFileSystemAccessor;

    public KlibLoader(@NotNull Function1<? super KlibLoaderSpec, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this.libraryPaths = new ArrayList();
        init.invoke((Object)new KlibLoaderSpec(){

            @Override
            public void libraryPaths(List<String> paths) {
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                libraryPaths.addAll((Collection)paths);
            }

            @Override
            public void libraryPaths(String ... paths) {
                Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
                CollectionsKt.addAll((Collection)libraryPaths, (Object[])paths);
            }

            @Override
            public void platformChecker(KlibPlatformChecker checker) {
                Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
                platformChecker = checker;
            }

            @Override
            public void maxPermittedAbiVersion(KotlinAbiVersion abiVersion) {
                Intrinsics.checkNotNullParameter((Object)abiVersion, (String)"abiVersion");
                maxPermittedAbiVersion = abiVersion;
            }

            @Override
            public void zipFileSystemAccessor(ZipFileSystemAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                zipFileSystemAccessor = accessor;
            }
        });
    }

    @NotNull
    public final KlibLoaderResult load() {
        LinkedHashSet uniqueLibraryPaths = new LinkedHashSet(this.libraryPaths);
        HashSet<Path> visitedCanonicalPaths = new HashSet<Path>(uniqueLibraryPaths.size());
        ArrayList problematicLibraries = new ArrayList(uniqueLibraryPaths.size());
        ArrayList<KotlinLibrary> loadedLibrariesStdlibFirst = new ArrayList<KotlinLibrary>(uniqueLibraryPaths.size());
        KotlinAbiVersion maxPermittedAbiVersion = this.maxPermittedAbiVersion;
        Iterable $this$forEach$iv = uniqueLibraryPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinAbiVersion libraryAbiVersion;
            KotlinLibraryVersioning kotlinLibraryVersioning;
            Path canonicalPath2;
            Path validPath;
            String rawPath;
            block15: {
                block14: {
                    Path path;
                    rawPath = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)rawPath, (String)"rawPath");
                    if (((CharSequence)rawPath).length() == 0) {
                        path = null;
                    } else {
                        Path path2;
                        try {
                            path2 = Paths.get(rawPath, new String[0]);
                        }
                        catch (InvalidPathException _) {
                            path2 = null;
                        }
                        path = validPath = path2;
                    }
                    if (validPath == null) break block14;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(validPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block15;
                }
                ((Collection)problematicLibraries).add(new KlibLoaderResult.ProblematicLibrary(rawPath, KlibLoaderResult.ProblemCase.LibraryNotFound.INSTANCE));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)validPath.toRealPath(new LinkOption[0]), (String)"validPath.toRealPath()");
            if (!visitedCanonicalPaths.add(canonicalPath2)) continue;
            KotlinLibrary library = KotlinLibraryImplKt.createKotlinLibrary$default(new File(validPath), "default", false, this.zipFileSystemAccessor, 4, null);
            try {
                kotlinLibraryVersioning = library.getVersions();
            }
            catch (Exception _) {
                ((Collection)problematicLibraries).add(new KlibLoaderResult.ProblematicLibrary(rawPath, KlibLoaderResult.ProblemCase.InvalidLibraryFormat.INSTANCE));
                continue;
            }
            KotlinLibraryVersioning libraryVersions = kotlinLibraryVersioning;
            Object object = this.platformChecker;
            if (object != null && (object = object.check(library)) != null) {
                Object platformCheckMismatch = object;
                boolean bl = false;
                ((Collection)problematicLibraries).add(new KlibLoaderResult.ProblematicLibrary(rawPath, (KlibLoaderResult.ProblemCase)platformCheckMismatch));
                continue;
            }
            if (!(maxPermittedAbiVersion == null || (libraryAbiVersion = libraryVersions.getAbiVersion()) != null && libraryAbiVersion.isAtMost(maxPermittedAbiVersion))) {
                ((Collection)problematicLibraries).add(new KlibLoaderResult.ProblematicLibrary(rawPath, new KlibLoaderResult.ProblemCase.IncompatibleAbiVersion(libraryVersions, null, maxPermittedAbiVersion)));
                continue;
            }
            if (KotlinLibraryKt.isAnyPlatformStdlib(library)) {
                loadedLibrariesStdlibFirst.add(0, library);
                continue;
            }
            loadedLibrariesStdlibFirst.add(library);
        }
        return new KlibLoaderResult((List<? extends KotlinLibrary>)loadedLibrariesStdlibFirst, problematicLibraries);
    }
}

