/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.stubs.KotlinClassifierStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u0010\f\u001a\u0004\u0018\u00010\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0081\u0010\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\t*\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u0012*\u00020\u0007H\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001d\u001a\u00020\u001e*\u00020\u0007H\u0001\u00a2\u0006\u0002\b\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/psi/stubs/StubUtils;", "", "<init>", "()V", "deserializeClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "serializeClassId", "", "Lcom/intellij/psi/stubs/StubOutputStream;", "classId", "createNestedClassId", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "currentDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "isDeclaredInsideValueArgument", "", "node", "Lcom/intellij/lang/ASTNode;", "isDeclaredInsideValueArgument$psi_impl", "writeNullableBoolean", "value", "writeNullableBoolean$psi_impl", "(Lcom/intellij/psi/stubs/StubOutputStream;Ljava/lang/Boolean;)V", "readNullableBoolean", "readNullableBoolean$psi_impl", "(Lcom/intellij/psi/stubs/StubInputStream;)Ljava/lang/Boolean;", "readFqName", "Lorg/jetbrains/kotlin/name/FqName;", "readFqName$psi_impl", "psi-impl"})
public final class StubUtils {
    @NotNull
    public static final StubUtils INSTANCE = new StubUtils();

    private StubUtils() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId deserializeClassId(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            return null;
        }
        StringRef classId = stringRef;
        String string = classId.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return ClassId.Companion.fromString$default(ClassId.Companion, string, false, 2, null);
    }

    @JvmStatic
    public static final void serializeClassId(@NotNull StubOutputStream dataStream, @Nullable ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        ClassId classId2 = classId;
        dataStream.writeName(classId2 != null ? classId2.asString() : null);
    }

    @JvmStatic
    @Nullable
    public static final ClassId createNestedClassId(@NotNull StubElement<?> parentStub, @NotNull KtClassLikeDeclaration currentDeclaration) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        Intrinsics.checkNotNullParameter((Object)currentDeclaration, (String)"currentDeclaration");
        if (currentDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)currentDeclaration).isObjectLiteral()) {
            return null;
        }
        StubElement<?> stubElement = parentStub;
        if (stubElement instanceof KotlinFileStub) {
            FqName fqName = ((KotlinFileStub)parentStub).getPackageFqName();
            Name name2 = currentDeclaration.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
            classId = new ClassId(fqName, name2);
        } else if (stubElement instanceof KotlinScriptStub) {
            StubElement stubElement2 = ((KotlinScriptStub)parentStub).getParentStub();
            Intrinsics.checkNotNullExpressionValue((Object)stubElement2, (String)"getParentStub(...)");
            classId = StubUtils.createNestedClassId(stubElement2, currentDeclaration);
        } else if (stubElement instanceof KotlinPlaceHolderStub && Intrinsics.areEqual((Object)((KotlinPlaceHolderStub)parentStub).getStubType(), KtStubElementTypes.CLASS_BODY)) {
            KotlinClassifierStub containingClassStub;
            StubElement stubElement3 = ((KotlinPlaceHolderStub)parentStub).getParentStub();
            KotlinClassifierStub kotlinClassifierStub = containingClassStub = stubElement3 instanceof KotlinClassifierStub ? (KotlinClassifierStub)stubElement3 : null;
            if (containingClassStub != null && !(currentDeclaration instanceof KtEnumEntry)) {
                ClassId classId2 = containingClassStub.getClassId();
                if (classId2 != null) {
                    Name name3 = currentDeclaration.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getNameAsSafeName(...)");
                    classId = classId2.createNestedClassId(name3);
                } else {
                    classId = null;
                }
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }

    @JvmStatic
    public static final boolean isDeclaredInsideValueArgument$psi_impl(@Nullable ASTNode node) {
        boolean bl;
        while (true) {
            IElementType iElementType;
            ASTNode parent;
            ASTNode aSTNode = node;
            ASTNode aSTNode2 = parent = aSTNode != null ? aSTNode.getTreeParent() : null;
            Object object = iElementType = aSTNode2 != null ? aSTNode2.getElementType() : null;
            if (Intrinsics.areEqual((Object)iElementType, KtStubElementTypes.VALUE_ARGUMENT)) {
                bl = true;
                break;
            }
            if (iElementType == null || KtTokenSets.DECLARATION_TYPES.contains(iElementType)) {
                bl = false;
                break;
            }
            node = parent;
        }
        return bl;
    }

    @JvmStatic
    public static final void writeNullableBoolean$psi_impl(@NotNull StubOutputStream $this$writeNullableBoolean, @Nullable Boolean value2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$writeNullableBoolean, (String)"<this>");
        Boolean bl = value2;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            n = 1;
        } else if (bl == null) {
            n = 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int n2 = n;
        $this$writeNullableBoolean.writeByte(n2);
    }

    @JvmStatic
    @Nullable
    public static final Boolean readNullableBoolean$psi_impl(@NotNull StubInputStream $this$readNullableBoolean) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$readNullableBoolean, (String)"<this>");
        switch ($this$readNullableBoolean.readByte()) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final FqName readFqName$psi_impl(@NotNull StubInputStream $this$readFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$readFqName, (String)"<this>");
        String string = $this$readFqName.readNameString();
        Intrinsics.checkNotNull((Object)string);
        return new FqName(string);
    }
}

