/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J$\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/quarkus/config/QsConfigKeyNameBinder;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "<init>", "()V", "bindsTo", "", "key", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "configKeyText", "", "matchesPrefix", "prefixText", "matchesPart", "keyPart", "text", "bindsToKeyProperty", "keyProperty", "matchesFirstChar", "keyName", "intellij.quarkus"})
public final class QsConfigKeyNameBinder
implements MetaConfigKeyManager.ConfigKeyNameBinder {
    @NotNull
    public static final QsConfigKeyNameBinder INSTANCE = new QsConfigKeyNameBinder();

    private QsConfigKeyNameBinder() {
    }

    public boolean bindsTo(@NotNull MetaConfigKey key, @NotNull String configKeyText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.matchesFirstChar(string, configKeyText)) {
            return false;
        }
        boolean exactMatch = Intrinsics.areEqual((Object)key.getName(), (Object)configKeyText);
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
        if (key.isAccessType(accessTypeArray)) {
            return exactMatch;
        }
        accessTypeArray = MetaConfigKey.AccessType.MAP_GROUP;
        if (key.isAccessType(Arrays.copyOf(accessTypeArray, accessTypeArray.length))) {
            return exactMatch || StringUtil.startsWith((CharSequence)configKeyText, (CharSequence)(key.getName() + "."));
        }
        accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED};
        if (key.isAccessType(accessTypeArray)) {
            if (exactMatch) {
                return true;
            }
            if (!StringUtil.containsChar((String)configKeyText, (char)'[')) {
                return false;
            }
            String string2 = StringUtil.substringBefore((String)configKeyText, (String)"[");
            Intrinsics.checkNotNull((Object)string2);
            String beforeIndexAccess = string2;
            beforeIndexAccess = StringsKt.removeSuffix((String)beforeIndexAccess, (CharSequence)".");
            return Intrinsics.areEqual((Object)key.getName(), (Object)beforeIndexAccess);
        }
        throw new IllegalArgumentException("unknown access type for " + key);
    }

    public boolean matchesPrefix(@NotNull MetaConfigKey key, @NotNull String prefixText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        return StringUtil.startsWith((CharSequence)key.getName(), (CharSequence)prefixText);
    }

    public boolean matchesPart(@NotNull String keyPart, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)keyPart, (String)"keyPart");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)keyPart, (Object)text);
    }

    @Nullable
    public String bindsToKeyProperty(@NotNull MetaConfigKey key, @Nullable String keyProperty, @NotNull String configKeyText) {
        ConfigKeyParts parts;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
        if (key.isAccessType(accessTypeArray)) {
            return null;
        }
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String keyName = string;
        if (!this.matchesFirstChar(keyName, configKeyText)) {
            return null;
        }
        ConfigKeyParts configKeyParts = parts = ConfigKeyParts.splitToParts((MetaConfigKey)key, (String)configKeyText, (boolean)false);
        return configKeyParts != null ? configKeyParts.getKeyIndexIfMatches(keyName, keyProperty, QsConfigKeyNameBinder::bindsToKeyProperty$lambda$0) : null;
    }

    private final boolean matchesFirstChar(String keyName, String configKeyText) {
        return ((CharSequence)configKeyText).length() > 0 && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(0), (char)configKeyText.charAt(0));
    }

    private static final boolean bindsToKeyProperty$lambda$0(String name, String text) {
        return Intrinsics.areEqual((Object)name, (Object)text);
    }
}

