/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.yaml.QsYamlKeyMetaConfigKeyReference;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlKeyReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.quarkus.config.yaml"})
public final class QsYamlKeyReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference profileReference;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
        if (yamlKeyValue.getKey() == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement psiElement = yamlKeyValue.getParent();
        if ((psiElement != null ? psiElement.getParent() : null) instanceof YAMLDocument && (profileReference = QsConfigUtils.INSTANCE.createProfileReference((PsiElement)yamlKeyValue)) != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{profileReference};
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new QsYamlKeyMetaConfigKeyReference(yamlKeyValue)};
        return psiReferenceArray;
    }
}

