/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.maven.extensions;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.run.extensions.QsExtensionsManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/quarkus/maven/extensions/QsMavenExtensionsManager;", "Lcom/intellij/quarkus/run/extensions/QsExtensionsManager;", "<init>", "()V", "supports", "", "module", "Lcom/intellij/openapi/module/Module;", "addDependency", "", "dependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "addDependencies", "dependencies", "", "refresh", "Lorg/jetbrains/concurrency/Promise;", "adjustScope", "intellij.quarkus.maven"})
public final class QsMavenExtensionsManager
implements QsExtensionsManager {
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MavenProjectsManager.getInstance((Project)module.getProject()).isMavenizedModule(module);
    }

    public void addDependency(@NotNull Module module, @NotNull UnifiedDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.addDependencies(module, CollectionsKt.listOf((Object)dependency));
    }

    public void addDependencies(@NotNull Module module, @NotNull Collection<UnifiedDependency> dependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DependencyModifierService modifierService = DependencyModifierService.Companion.getInstance(project);
        for (UnifiedDependency dependency : dependencies) {
            modifierService.addDependency(module, this.adjustScope(dependency));
        }
    }

    @NotNull
    public Promise<?> refresh(@NotNull Module module) {
        Promise promise;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
        MavenProject mavenProject = projectsManager.findProject(module);
        if (mavenProject == null) {
            promise = Promises.rejectedPromise();
        } else {
            AsyncPromise asyncPromise = projectsManager.forceUpdateProjects((Collection)SetsKt.setOf((Object)mavenProject));
            Intrinsics.checkNotNullExpressionValue((Object)asyncPromise, (String)"forceUpdateProjects(...)");
            promise = (Promise)asyncPromise;
        }
        return promise;
    }

    private final UnifiedDependency adjustScope(UnifiedDependency dependency) {
        return Intrinsics.areEqual((Object)"compile", (Object)dependency.getScope()) ? new UnifiedDependency(dependency.getCoordinates(), null) : dependency;
    }
}

