/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.impl.NumberTypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.math.QuantileEstimationMethod;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0006\u001aX\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u0002H\u0002\u0012\u0002\b\u00030\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u001aX\u0010\u000f\u001a\u00020\u0006\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u0002H\u0002\u0012\u0002\b\u00030\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u001a7\u0010\u0010\u001a\u0002H\u0002\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u0014\u001a(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00160\f\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\u00020\u0011H\u0000\u001a5\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u0019*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00180\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\u0010\u001b\u001a/\u0010\u001c\u001a\u0002H\u0002\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"quantileOrNull", "", "T", "", "Lkotlin/sequences/Sequence;", "p", "", "type", "Lkotlin/reflect/KType;", "skipNaN", "", "method", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod;", "name", "", "quantileIndexEstimation", "quantile", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting;", "values", "", "(Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting;DLjava/util/List;)Ljava/lang/Comparable;", "cast", "", "indexOfQuantile", "IndexType", "", "count", "(Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod;DI)Ljava/lang/Number;", "quickSelect", "k", "(Ljava/util/List;I)Ljava/lang/Comparable;", "core"})
@SourceDebugExtension(value={"SMAP\nquantile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 quantile.kt\norg/jetbrains/kotlinx/dataframe/math/QuantileKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Nulls.kt\norg/jetbrains/kotlinx/dataframe/api/NullsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,328:1\n1255#2:329\n1256#2:331\n1255#2:336\n1256#2:338\n107#3:330\n107#3:337\n107#3:339\n107#3:340\n1563#4:332\n1634#4,3:333\n*S KotlinDebug\n*F\n+ 1 quantile.kt\norg/jetbrains/kotlinx/dataframe/math/QuantileKt\n*L\n63#1:329\n63#1:331\n146#1:336\n146#1:338\n63#1:330\n146#1:337\n71#1:339\n149#1:340\n96#1:332\n96#1:333,3\n*E\n"})
public final class QuantileKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T extends Comparable<? super T>> Object quantileOrNull(@NotNull Sequence<? extends Object> $this$quantileOrNull, double p, @NotNull KType type, boolean skipNaN, @NotNull QuantileEstimationMethod<T, ?> method, @NotNull String name) {
        Object object;
        List list;
        int size;
        Object $this$isNaN$iv;
        QuantileEstimationMethod<T, ?> quantileEstimationMethod;
        Intrinsics.checkNotNullParameter($this$quantileOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(0.0 <= p ? p <= 1.0 : false)) {
            throw new IllegalStateException("Quantile must be in range [0, 1]".toString());
        }
        if (type.isMarkedNullable()) {
            throw new IllegalStateException(("Encountered nullable type " + RenderingKt.renderType(type) + " in " + name + " function. This should not occur.").toString());
        }
        if (Intrinsics.areEqual((Object)type, (Object)TypeUtilsKt.getNothingType())) {
            return null;
        }
        if (!TypeUtilsKt.isIntraComparable(type)) {
            throw new IllegalStateException(("Unable to compute the " + name + " for " + RenderingKt.renderType(type) + ". Only primitive numbers or self-comparables are supported.").toString());
        }
        if (Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(BigDecimal.class)) || Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(BigInteger.class))) {
            throw new IllegalArgumentException("Cannot calculate the " + name + " for big numbers in DataFrame. Only primitive numbers are supported.");
        }
        if (TypeUtilsKt.getCanBeNaN(type) && !skipNaN) {
            boolean bl;
            block21: {
                Sequence $this$any$iv = $this$quantileOrNull;
                boolean $i$f$any = false;
                quantileEstimationMethod = $this$any$iv.iterator();
                while (quantileEstimationMethod.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = quantileEstimationMethod.next();
                    boolean bl2 = false;
                    $this$isNaN$iv = it;
                    boolean $i$f$isNaN = false;
                    boolean bl3 = $this$isNaN$iv instanceof Double && Double.isNaN(((Number)$this$isNaN$iv).doubleValue()) || $this$isNaN$iv instanceof Float && Float.isNaN(((Number)$this$isNaN$iv).floatValue());
                    if (!bl3) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
            if (bl) {
                if (Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(Float.TYPE)) && method instanceof QuantileEstimationMethod.Selecting) {
                    return Float.valueOf(Float.NaN);
                }
                return Double.NaN;
            }
        }
        if ((size = (list = SequencesKt.toList(TypeUtilsKt.getCanBeNaN(type) ? SequencesKt.filter($this$quantileOrNull, QuantileKt::quantileOrNull$lambda$1) : $this$quantileOrNull)).size()) == 0) {
            return null;
        }
        if (size == 1) {
            Object object2;
            Object single = CollectionsKt.single((List)list);
            if (NumberTypeUtilsKt.isPrimitiveNumber(type)) {
                Intrinsics.checkNotNull((Object)single, (String)"null cannot be cast to non-null type kotlin.Number");
                object2 = ((Number)single).doubleValue();
            } else {
                object2 = single;
            }
            return object2;
        }
        quantileEstimationMethod = method;
        if (quantileEstimationMethod instanceof QuantileEstimationMethod.Selecting) {
            QuantileEstimationMethod.Selecting selecting = (QuantileEstimationMethod.Selecting)method;
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<T of org.jetbrains.kotlinx.dataframe.math.QuantileKt.quantileOrNull>");
            object = QuantileKt.quantile(selecting, p, list);
        } else if (quantileEstimationMethod instanceof QuantileEstimationMethod.Interpolating) {
            List list2;
            if (!NumberTypeUtilsKt.isPrimitiveNumber(type)) {
                boolean $i$a$-require-QuantileKt$quantileOrNull$32 = false;
                String $i$a$-require-QuantileKt$quantileOrNull$32 = "Cannot calculate the " + name + " for non-primitive numbers with estimation method " + method + '.';
                throw new IllegalArgumentException($i$a$-require-QuantileKt$quantileOrNull$32.toString());
            }
            if (Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(Double.TYPE))) {
                Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
                list2 = list;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                $this$isNaN$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Number");
                    collection.add(((Number)it).doubleValue());
                }
                list2 = (List)destination$iv$iv;
            }
            List convertedList = list2;
            object = ((QuantileEstimationMethod.Interpolating)method).quantile(p, convertedList);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static /* synthetic */ Object quantileOrNull$default(Sequence sequence, double d, KType kType, boolean bl, QuantileEstimationMethod quantileEstimationMethod, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = "quantile";
        }
        return QuantileKt.quantileOrNull((Sequence<? extends Object>)sequence, d, kType, bl, quantileEstimationMethod, string);
    }

    public static final <T extends Comparable<? super T>> double quantileIndexEstimation(@NotNull Sequence<? extends Object> $this$quantileIndexEstimation, double p, @NotNull KType type, boolean skipNaN, @NotNull QuantileEstimationMethod<T, ?> method, @NotNull String name) {
        List list;
        int size;
        Intrinsics.checkNotNullParameter($this$quantileIndexEstimation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        KType nonNullType = KTypes.withNullability((KType)type, (boolean)false);
        if (!(0.0 <= p ? p <= 1.0 : false)) {
            throw new IllegalStateException("Quantile must be in range [0, 1]".toString());
        }
        if (type.isMarkedNullable()) {
            throw new IllegalStateException(("Encountered nullable type " + RenderingKt.renderType(type) + " in " + name + " function. This should not occur.").toString());
        }
        if (Intrinsics.areEqual((Object)type, (Object)TypeUtilsKt.getNothingType())) {
            return -1.0;
        }
        if (!TypeUtilsKt.isIntraComparable(nonNullType)) {
            throw new IllegalStateException(("Unable to compute the " + name + " for " + RenderingKt.renderType(type) + ". Only primitive numbers or self-comparables are supported.").toString());
        }
        if (method instanceof QuantileEstimationMethod.Interpolating && !NumberTypeUtilsKt.isPrimitiveNumber(nonNullType)) {
            throw new IllegalStateException(("Cannot calculate the " + name + " for type " + RenderingKt.renderType(type) + " with estimation method " + method + ".For piecewise linear methods, only primitive numbers are supported").toString());
        }
        if (TypeUtilsKt.getCanBeNaN(nonNullType) && !skipNaN) {
            boolean bl;
            block10: {
                Sequence $this$any$iv = $this$quantileIndexEstimation;
                boolean $i$f$any = false;
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Object $this$isNaN$iv = it;
                    boolean $i$f$isNaN = false;
                    boolean bl3 = $this$isNaN$iv instanceof Double && Double.isNaN(((Number)$this$isNaN$iv).doubleValue()) || $this$isNaN$iv instanceof Float && Float.isNaN(((Number)$this$isNaN$iv).floatValue());
                    if (!bl3) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                return Double.NaN;
            }
        }
        if ((size = (list = SequencesKt.toList(TypeUtilsKt.getCanBeNaN(nonNullType) ? SequencesKt.filterNot($this$quantileIndexEstimation, QuantileKt::quantileIndexEstimation$lambda$5) : $this$quantileIndexEstimation)).size()) == 0) {
            return -1.0;
        }
        if (size == 1) {
            return 0.0;
        }
        return ((Number)QuantileKt.indexOfQuantile(method, p, size)).doubleValue();
    }

    public static /* synthetic */ double quantileIndexEstimation$default(Sequence sequence, double d, KType kType, boolean bl, QuantileEstimationMethod quantileEstimationMethod, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = "quantile";
        }
        return QuantileKt.quantileIndexEstimation((Sequence<? extends Object>)sequence, d, kType, bl, quantileEstimationMethod, string);
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T quantile(@NotNull QuantileEstimationMethod.Selecting $this$quantile, double p, @NotNull List<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)$this$quantile, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        T t = $this$quantile.quantile(p, values);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.math.QuantileKt.quantile");
        return t;
    }

    @NotNull
    public static final <T extends Comparable<? super T>> QuantileEstimationMethod<T, Integer> cast(@NotNull QuantileEstimationMethod.Selecting $this$cast) {
        Intrinsics.checkNotNullParameter((Object)$this$cast, (String)"<this>");
        return $this$cast;
    }

    @NotNull
    public static final <IndexType extends Number> IndexType indexOfQuantile(@NotNull QuantileEstimationMethod<?, IndexType> $this$indexOfQuantile, double p, int count2) {
        Number number;
        Intrinsics.checkNotNullParameter($this$indexOfQuantile, (String)"<this>");
        IndexType oneBased = $this$indexOfQuantile.oneBasedIndexOfQuantile(p, count2);
        QuantileEstimationMethod<?, IndexType> quantileEstimationMethod = $this$indexOfQuantile;
        if (quantileEstimationMethod instanceof QuantileEstimationMethod.Interpolating) {
            Intrinsics.checkNotNull(oneBased, (String)"null cannot be cast to non-null type kotlin.Double");
            number = (Double)oneBased - 1.0;
        } else if (quantileEstimationMethod instanceof QuantileEstimationMethod.Selecting) {
            Intrinsics.checkNotNull(oneBased, (String)"null cannot be cast to non-null type kotlin.Int");
            number = (Integer)oneBased - 1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (IndexType)number;
    }

    @PublishedApi
    @NotNull
    public static final <T extends Comparable<? super T>> T quickSelect(@NotNull List<? extends T> $this$quickSelect, int k) {
        Intrinsics.checkNotNullParameter($this$quickSelect, (String)"<this>");
        if (k < 0 || k >= $this$quickSelect.size()) {
            throw new IndexOutOfBoundsException("k = " + k + ", size = " + $this$quickSelect.size());
        }
        List list = $this$quickSelect;
        List temp = new ArrayList();
        List less = new ArrayList();
        int k2 = k;
        List greater = new ArrayList();
        while (list.size() > 1) {
            int equal = 0;
            Comparable x = (Comparable)CollectionsKt.random((Collection)list, (Random)((Random)Random.Default));
            greater.clear();
            less.clear();
            for (Comparable v : list) {
                int comp = v.compareTo(x);
                if (comp < 0) {
                    less.add(v);
                    continue;
                }
                if (comp > 0) {
                    greater.add(v);
                    continue;
                }
                ++equal;
            }
            if (k2 < less.size()) {
                list = less;
                less = temp;
                temp = list;
                continue;
            }
            if (k2 < less.size() + equal) {
                return (T)x;
            }
            list = greater;
            greater = temp;
            temp = list;
            k2 -= less.size() + equal;
        }
        return (T)((Comparable)list.get(0));
    }

    private static final boolean quantileOrNull$lambda$1(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object $this$isNaN$iv = it;
        boolean $i$f$isNaN = false;
        return !($this$isNaN$iv instanceof Double && Double.isNaN(((Number)$this$isNaN$iv).doubleValue()) || $this$isNaN$iv instanceof Float && Float.isNaN(((Number)$this$isNaN$iv).floatValue()));
    }

    private static final boolean quantileIndexEstimation$lambda$5(Object it) {
        Object $this$isNaN$iv = it;
        boolean $i$f$isNaN = false;
        return $this$isNaN$iv instanceof Double && Double.isNaN(((Number)$this$isNaN$iv).doubleValue()) || $this$isNaN$iv instanceof Float && Float.isNaN(((Number)$this$isNaN$iv).floatValue());
    }
}

