/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.plugins;

import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ktor.initializr.json.KtorPluginSearchResult;
import com.intellij.ktor.initializr.plugins.KtorPluginEventHandler;
import com.intellij.ktor.initializr.plugins.KtorPluginsGroup;
import com.intellij.ktor.initializr.plugins.ListKtorPluginComponent;
import com.intellij.ktor.initializr.plugins.UIKtorPluginGroup;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u0000 82\u00020\u0001:\u00018B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\tJ\u0014\u0010\u001b\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0012J\u001a\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"H\u0007J&\u0010#\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(J&\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"H\u0002J.\u0010+\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\"H\u0002J\u0016\u0010+\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u00020\bJ\u000e\u00100\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u0016\u00101\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u00020\bJ\u0010\u00102\u001a\u00020\"2\u0006\u0010\u001c\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0016H\u0016J\u0012\u00105\u001a\u00020\u00162\b\b\u0002\u00106\u001a\u000207H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\u00a8\u00069"}, d2={"Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroupComponent;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "layout", "Ljava/awt/LayoutManager;", "myEventHandler", "Lcom/intellij/ktor/initializr/plugins/KtorPluginEventHandler;", "myFunction", "Lkotlin/Function1;", "Lcom/intellij/ktor/initializr/json/KtorPluginSearchResult;", "Lcom/intellij/ktor/initializr/plugins/ListKtorPluginComponent;", "<init>", "(Ljava/awt/LayoutManager;Lcom/intellij/ktor/initializr/plugins/KtorPluginEventHandler;Lkotlin/jvm/functions/Function1;)V", "getMyEventHandler", "()Lcom/intellij/ktor/initializr/plugins/KtorPluginEventHandler;", "myGroups", "", "Lcom/intellij/ktor/initializr/plugins/UIKtorPluginGroup;", "groups", "", "getGroups", "()Ljava/util/List;", "setSelectionListener", "", "listener", "Ljava/util/function/Consumer;", "selection", "getSelection", "setSelection", "component", "components", "addGroup", "group", "Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroup;", "groupIndex", "", "addLazyGroup", "scrollBar", "Ljavax/swing/JScrollBar;", "gapSize", "uiCallback", "Ljava/lang/Runnable;", "descriptors", "getEventIndexForGroup", "addToGroup", "features", "index", "eventIndex", "feature", "removeGroup", "removeFromGroup", "getComponentIndex", "Ljava/awt/Component;", "clear", "initialSelection", "scrollAndFocus", "", "Companion", "intellij.ktor"})
public class KtorPluginsGroupComponent
extends JBPanelWithEmptyText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtorPluginEventHandler myEventHandler;
    @NotNull
    private final Function1<KtorPluginSearchResult, ListKtorPluginComponent> myFunction;
    @NotNull
    private final List<UIKtorPluginGroup> myGroups;
    @NotNull
    private static final Color SECTION_HEADER_FOREGROUND;
    @NotNull
    private static final Color SECTION_HEADER_BACKGROUND;

    public KtorPluginsGroupComponent(@NotNull LayoutManager layout, @NotNull KtorPluginEventHandler myEventHandler, @NotNull Function1<? super KtorPluginSearchResult, ListKtorPluginComponent> myFunction) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)myEventHandler, (String)"myEventHandler");
        Intrinsics.checkNotNullParameter(myFunction, (String)"myFunction");
        super(layout);
        this.myEventHandler = myEventHandler;
        this.myFunction = myFunction;
        this.myGroups = new ArrayList();
        this.myEventHandler.connect(this);
        this.setOpaque(true);
        this.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
    }

    @NotNull
    public final KtorPluginEventHandler getMyEventHandler() {
        return this.myEventHandler;
    }

    @NotNull
    public final List<UIKtorPluginGroup> getGroups() {
        return this.myGroups;
    }

    public final void setSelectionListener(@NotNull Consumer<KtorPluginsGroupComponent> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.myEventHandler.setSelectionListener(listener2);
    }

    @NotNull
    public final List<ListKtorPluginComponent> getSelection() {
        return this.myEventHandler.getSelection();
    }

    public final void setSelection(@NotNull ListKtorPluginComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.myEventHandler.setSelection(component);
    }

    public final void setSelection(@NotNull List<ListKtorPluginComponent> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.myEventHandler.setSelection(components);
    }

    @JvmOverloads
    public final void addGroup(@NotNull KtorPluginsGroup group, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.addGroup(group, group.getElements(), groupIndex);
    }

    public static /* synthetic */ void addGroup$default(KtorPluginsGroupComponent ktorPluginsGroupComponent, KtorPluginsGroup ktorPluginsGroup, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addGroup");
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        ktorPluginsGroupComponent.addGroup(ktorPluginsGroup, n);
    }

    public final void addLazyGroup(@NotNull KtorPluginsGroup group, @NotNull JScrollBar scrollBar, int gapSize, @NotNull Runnable uiCallback) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)scrollBar, (String)"scrollBar");
        Intrinsics.checkNotNullParameter((Object)uiCallback, (String)"uiCallback");
        if (group.getElements().size() <= gapSize) {
            KtorPluginsGroupComponent.addGroup$default(this, group, 0, 2, null);
        } else {
            this.addGroup(group, group.getElements().subList(0, gapSize), -1);
            AdjustmentListener listener2 = new AdjustmentListener(scrollBar, group, gapSize, this, uiCallback){
                final /* synthetic */ JScrollBar $scrollBar;
                final /* synthetic */ KtorPluginsGroup $group;
                final /* synthetic */ int $gapSize;
                final /* synthetic */ KtorPluginsGroupComponent this$0;
                final /* synthetic */ Runnable $uiCallback;
                {
                    this.$scrollBar = $scrollBar;
                    this.$group = $group;
                    this.$gapSize = $gapSize;
                    this.this$0 = $receiver;
                    this.$uiCallback = $uiCallback;
                }

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.$scrollBar.getValue() + this.$scrollBar.getVisibleAmount() >= this.$scrollBar.getMaximum()) {
                        UIKtorPluginGroup uIKtorPluginGroup = this.$group.getUi();
                        Intrinsics.checkNotNull((Object)uIKtorPluginGroup);
                        int fromIndex = uIKtorPluginGroup.getFeatures().size();
                        int toIndex = Math.min(fromIndex + this.$gapSize, this.$group.getElements().size());
                        UIKtorPluginGroup uIKtorPluginGroup2 = this.$group.getUi();
                        Intrinsics.checkNotNull((Object)uIKtorPluginGroup2);
                        ListKtorPluginComponent lastComponent = uIKtorPluginGroup2.getFeatures().get(fromIndex - 1);
                        int uiIndex = KtorPluginsGroupComponent.access$getComponentIndex(this.this$0, lastComponent);
                        int eventIndex = this.this$0.getMyEventHandler().getCellIndex(lastComponent);
                        KtorPluginsGroupComponent.access$addToGroup(this.this$0, this.$group, this.$group.getElements().subList(fromIndex, toIndex), uiIndex, eventIndex);
                        int n = this.$group.getElements().size();
                        UIKtorPluginGroup uIKtorPluginGroup3 = this.$group.getUi();
                        Intrinsics.checkNotNull((Object)uIKtorPluginGroup3);
                        if (n == uIKtorPluginGroup3.getFeatures().size()) {
                            this.$scrollBar.removeAdjustmentListener(this);
                        }
                        this.$uiCallback.run();
                    }
                }
            };
            scrollBar.addAdjustmentListener(listener2);
        }
    }

    private final void addGroup(KtorPluginsGroup group, List<KtorPluginSearchResult> descriptors, int groupIndex) {
        UIKtorPluginGroup uiGroup = new UIKtorPluginGroup();
        group.setUi(uiGroup);
        this.myGroups.add(groupIndex == -1 ? this.myGroups.size() : groupIndex, uiGroup);
        OpaquePanel panel = new OpaquePanel((LayoutManager)new BorderLayout(), SECTION_HEADER_BACKGROUND);
        panel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        String string = group.getGroupTitle();
        JLabel title2 = new JLabel(string){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Container parent = this.getParent();
                Insets insets = parent.getInsets();
                size.width = Math.min(parent.getWidth() - insets.left - insets.right - (parent.getComponentCount() == 2 ? parent.getComponent(1).getWidth() + JBUIScale.scale((int)20) : 0), size.width);
                Intrinsics.checkNotNull((Object)size);
                return size;
            }

            public String getToolTipText() {
                return super.getPreferredSize().width > this.getWidth() ? super.getToolTipText() : null;
            }
        };
        title2.setToolTipText(group.getGroupTitle());
        title2.setForeground(SECTION_HEADER_FOREGROUND);
        panel.add((Component)title2, (Object)"West");
        group.setTitleLabel(title2);
        int index = 0;
        int eventIndex = 0;
        switch (groupIndex) {
            case 0: {
                this.add((Component)panel, 0);
                index = 1;
                eventIndex = 0;
                break;
            }
            case -1: {
                this.add((Component)panel);
                index = eventIndex = -1;
                break;
            }
            default: {
                boolean bl;
                boolean bl2 = bl = groupIndex < this.myGroups.size();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                Component component = this.myGroups.get(groupIndex + 1).getPanel();
                Intrinsics.checkNotNull((Object)component);
                index = this.getComponentIndex(component);
                boolean bl3 = bl = index != -1;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                this.add((Component)panel, index++);
                eventIndex = this.getEventIndexForGroup(groupIndex + 1);
            }
        }
        uiGroup.setPanel((Component)panel);
        this.addToGroup(group, descriptors, index, eventIndex);
    }

    private final int getEventIndexForGroup(int groupIndex) {
        for (int i = groupIndex; -1 < i; --i) {
            List<ListKtorPluginComponent> plugins = this.myGroups.get(i).getFeatures();
            if (plugins.isEmpty()) continue;
            return this.myEventHandler.getCellIndex(plugins.get(0));
        }
        return -1;
    }

    private final void addToGroup(KtorPluginsGroup group, List<KtorPluginSearchResult> features, int index, int eventIndex) {
        int index2 = index;
        int eventIndex2 = eventIndex;
        for (KtorPluginSearchResult feature : features) {
            ListKtorPluginComponent featureComponent = (ListKtorPluginComponent)this.myFunction.invoke((Object)feature);
            UIKtorPluginGroup uIKtorPluginGroup = group.getUi();
            Intrinsics.checkNotNull((Object)uIKtorPluginGroup);
            uIKtorPluginGroup.getFeatures().add(featureComponent);
            this.add(featureComponent, index2);
            this.myEventHandler.addCell(featureComponent, eventIndex2);
            featureComponent.setListeners(this.myEventHandler);
            if (index2 != -1) {
                ++index2;
            }
            if (eventIndex2 == -1) continue;
            ++eventIndex2;
        }
    }

    public final void addToGroup(@NotNull KtorPluginsGroup group, @NotNull KtorPluginSearchResult feature) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        int index = group.addWithIndex(feature);
        ListKtorPluginComponent anchor = null;
        int uiIndex = -1;
        UIKtorPluginGroup uIKtorPluginGroup = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorPluginGroup);
        if (index == uIKtorPluginGroup.getFeatures().size()) {
            UIKtorPluginGroup uIKtorPluginGroup2 = group.getUi();
            Intrinsics.checkNotNull((Object)uIKtorPluginGroup2);
            int groupIndex = this.myGroups.indexOf(uIKtorPluginGroup2);
            if (groupIndex < this.myGroups.size() - 1) {
                UIKtorPluginGroup nextGroup = this.myGroups.get(groupIndex + 1);
                anchor = nextGroup.getFeatures().get(0);
                Component component = nextGroup.getPanel();
                Intrinsics.checkNotNull((Object)component);
                uiIndex = this.getComponentIndex(component);
            }
        } else {
            UIKtorPluginGroup uIKtorPluginGroup3 = group.getUi();
            Intrinsics.checkNotNull((Object)uIKtorPluginGroup3);
            anchor = uIKtorPluginGroup3.getFeatures().get(index);
            uiIndex = this.getComponentIndex(anchor);
        }
        ListKtorPluginComponent pluginComponent = (ListKtorPluginComponent)this.myFunction.invoke((Object)feature);
        UIKtorPluginGroup uIKtorPluginGroup4 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorPluginGroup4);
        uIKtorPluginGroup4.getFeatures().add(index, pluginComponent);
        this.add(pluginComponent, uiIndex);
        this.myEventHandler.addCell(pluginComponent, anchor);
        pluginComponent.setListeners(this.myEventHandler);
    }

    public final void removeGroup(@NotNull KtorPluginsGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Collection collection = this.myGroups;
        UIKtorPluginGroup uIKtorPluginGroup = group.getUi();
        TypeIntrinsics.asMutableCollection((Object)collection).remove(uIKtorPluginGroup);
        UIKtorPluginGroup uIKtorPluginGroup2 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorPluginGroup2);
        this.remove(uIKtorPluginGroup2.getPanel());
        UIKtorPluginGroup uIKtorPluginGroup3 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorPluginGroup3);
        for (ListKtorPluginComponent plugin : uIKtorPluginGroup3.getFeatures()) {
            this.remove(plugin);
            this.myEventHandler.removeCell(plugin);
        }
        this.myEventHandler.updateSelection();
    }

    public final void removeFromGroup(@NotNull KtorPluginsGroup group, @NotNull KtorPluginSearchResult feature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        UIKtorPluginGroup uIKtorPluginGroup = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorPluginGroup);
        int index = ContainerUtil.indexOf(uIKtorPluginGroup.getFeatures(), arg_0 -> KtorPluginsGroupComponent.removeFromGroup$lambda$1(arg_0 -> KtorPluginsGroupComponent.removeFromGroup$lambda$0(feature, arg_0), arg_0));
        boolean bl2 = bl = index != -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        UIKtorPluginGroup uIKtorPluginGroup2 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorPluginGroup2);
        ListKtorPluginComponent component = uIKtorPluginGroup2.getFeatures().remove(index);
        this.remove(component);
        this.myEventHandler.removeCell(component);
        if (component.getSelection() == EventHandler.SelectionType.SELECTION) {
            this.myEventHandler.updateSelection();
        }
        group.getElements().remove(feature);
    }

    private final int getComponentIndex(Component component) {
        int components = this.getComponentCount();
        for (int i = 0; i < components; ++i) {
            if (this.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.myGroups.clear();
        this.myEventHandler.clear();
        this.removeAll();
    }

    @JvmOverloads
    public final void initialSelection(boolean scrollAndFocus) {
        SwingUtilities.invokeLater(() -> KtorPluginsGroupComponent.initialSelection$lambda$0(this, scrollAndFocus));
    }

    public static /* synthetic */ void initialSelection$default(KtorPluginsGroupComponent ktorPluginsGroupComponent, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialSelection");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        ktorPluginsGroupComponent.initialSelection(bl);
    }

    @JvmOverloads
    public final void addGroup(@NotNull KtorPluginsGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        KtorPluginsGroupComponent.addGroup$default(this, group, 0, 2, null);
    }

    @JvmOverloads
    public final void initialSelection() {
        KtorPluginsGroupComponent.initialSelection$default(this, false, 1, null);
    }

    private static final boolean removeFromGroup$lambda$0(KtorPluginSearchResult $feature, ListKtorPluginComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component.getFeatureId() == $feature.getId();
    }

    private static final boolean removeFromGroup$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void initialSelection$lambda$0(KtorPluginsGroupComponent this$0, boolean $scrollAndFocus) {
        this$0.myEventHandler.initialSelection($scrollAndFocus);
        if (!((Collection)this$0.myGroups).isEmpty()) {
            Component component = this$0.myGroups.get(0).getPanel();
            Intrinsics.checkNotNull((Object)component);
            this$0.scrollRectToVisible(component.getBounds());
        }
    }

    public static final /* synthetic */ int access$getComponentIndex(KtorPluginsGroupComponent $this, Component component) {
        return $this.getComponentIndex(component);
    }

    public static final /* synthetic */ void access$addToGroup(KtorPluginsGroupComponent $this, KtorPluginsGroup group, List features, int index, int eventIndex) {
        $this.addToGroup(group, features, index, eventIndex);
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"Plugins.SectionHeader.foreground", (Color)((Color)new JBColor(0x787878, 0x999999)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        SECTION_HEADER_FOREGROUND = (Color)jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"Plugins.SectionHeader.background", (Color)((Color)new JBColor(0xF7F7F7, 3948353)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        SECTION_HEADER_BACKGROUND = (Color)jBColor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroupComponent$Companion;", "", "<init>", "()V", "SECTION_HEADER_FOREGROUND", "Ljava/awt/Color;", "getSECTION_HEADER_FOREGROUND", "()Ljava/awt/Color;", "SECTION_HEADER_BACKGROUND", "intellij.ktor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getSECTION_HEADER_FOREGROUND() {
            return SECTION_HEADER_FOREGROUND;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

