/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.plugins;

import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ktor.initializr.KtorModuleInfoMinimal;
import com.intellij.ktor.initializr.plugins.AddButton;
import com.intellij.ktor.initializr.plugins.KtorPluginEventHandler;
import com.intellij.ktor.initializr.plugins.KtorPluginModel;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 B2\u00020\u0001:\u0002ABB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010'\u001a\u00020,2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020,H\u0002J\b\u00100\u001a\u00020,H\u0002J\u000e\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u001dJ\b\u00103\u001a\u00020,H\u0002J\u001d\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u00012\u000b\u00106\u001a\u00070)\u00a2\u0006\u0002\b7H\u0002J\u0010\u00108\u001a\u00020,2\u0006\u0010$\u001a\u00020\u001fH\u0004J\u0018\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0004J\b\u0010<\u001a\u00020,H\u0004J\u001c\u0010=\u001a\u00020,2\u0006\u0010>\u001a\u00020?2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00000@R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010!\"\u0004\b'\u0010#R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006C"}, d2={"Lcom/intellij/ktor/initializr/plugins/ListKtorPluginComponent;", "Ljavax/swing/JPanel;", "featureModel", "Lcom/intellij/ktor/initializr/plugins/KtorPluginModel;", "moduleInfoMinimal", "Lcom/intellij/ktor/initializr/KtorModuleInfoMinimal;", "<init>", "(Lcom/intellij/ktor/initializr/plugins/KtorPluginModel;Lcom/intellij/ktor/initializr/KtorModuleInfoMinimal;)V", "getFeatureModel", "()Lcom/intellij/ktor/initializr/plugins/KtorPluginModel;", "myNameComponent", "Ljavax/swing/JLabel;", "myIconComponent", "myLayout", "Lcom/intellij/ktor/initializr/plugins/ListKtorPluginComponent$BaselineLayout;", "myAddButton", "Lcom/intellij/ktor/initializr/plugins/AddButton;", "getMyAddButton", "()Lcom/intellij/ktor/initializr/plugins/AddButton;", "setMyAddButton", "(Lcom/intellij/ktor/initializr/plugins/AddButton;)V", "myAlignButton", "Ljavax/swing/JComponent;", "myShortDescription", "myErrorPanel", "myErrorComponent", "myIndicator", "Lcom/intellij/ide/plugins/newui/OneLineProgressIndicator;", "myEventHandler", "Lcom/intellij/ktor/initializr/plugins/KtorPluginEventHandler;", "mySelection", "Lcom/intellij/ide/plugins/newui/EventHandler$SelectionType;", "getMySelection", "()Lcom/intellij/ide/plugins/newui/EventHandler$SelectionType;", "setMySelection", "(Lcom/intellij/ide/plugins/newui/EventHandler$SelectionType;)V", "type", "selection", "getSelection", "setSelection", "featureId", "", "getFeatureId", "()Ljava/lang/String;", "", "scrollAndFocus", "", "scrollToVisible", "createButtons", "setListeners", "eventHandler", "createDescriptionPanel", "createDescriptionLabel", "panel", "shortDescription", "Lcom/intellij/openapi/util/NlsSafe;", "updateColors", "grayedFg", "Ljava/awt/Color;", "background", "updateIcon", "handleKeyAction", "keyCode", "", "", "BaselineLayout", "Companion", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nListKtorPluginComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListKtorPluginComponent.kt\ncom/intellij/ktor/initializr/plugins/ListKtorPluginComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public final class ListKtorPluginComponent
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtorPluginModel featureModel;
    @NotNull
    private final KtorModuleInfoMinimal moduleInfoMinimal;
    @NotNull
    private final JLabel myNameComponent;
    @NotNull
    private final JLabel myIconComponent;
    @NotNull
    private final BaselineLayout myLayout;
    protected AddButton myAddButton;
    private JComponent myAlignButton;
    private JLabel myShortDescription;
    private JPanel myErrorPanel;
    private JComponent myErrorComponent;
    private OneLineProgressIndicator myIndicator;
    private KtorPluginEventHandler myEventHandler;
    @NotNull
    private EventHandler.SelectionType mySelection;
    @NotNull
    private static final Color DisabledColor;
    @NotNull
    private static final Color GRAY_COLOR;
    @NotNull
    private static final Color HOVER_COLOR;
    private static boolean HANDLE_FOCUS_ON_SELECTION;

    public ListKtorPluginComponent(@NotNull KtorPluginModel featureModel, @NotNull KtorModuleInfoMinimal moduleInfoMinimal) {
        Intrinsics.checkNotNullParameter((Object)featureModel, (String)"featureModel");
        Intrinsics.checkNotNullParameter((Object)moduleInfoMinimal, (String)"moduleInfoMinimal");
        this.featureModel = featureModel;
        this.moduleInfoMinimal = moduleInfoMinimal;
        this.myNameComponent = new JLabel();
        this.myIconComponent = new JLabel();
        this.myLayout = new BaselineLayout();
        this.mySelection = EventHandler.SelectionType.NONE;
        this.featureModel.onSelect((Function0<Unit>)((Function0)() -> ListKtorPluginComponent._init_$lambda$0(this)));
        this.featureModel.onUnselect((Function0<Unit>)((Function0)() -> ListKtorPluginComponent._init_$lambda$1(this)));
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)20));
        this.setLayout((LayoutManager)((Object)this.myLayout));
        this.updateIcon();
        this.myLayout.setIconComponent(this.myIconComponent);
        this.myNameComponent.setText(this.featureModel.getName());
        Component component = RelativeFont.BOLD.install((Component)this.myNameComponent);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"install(...)");
        this.myLayout.setNameComponent((JLabel)component);
        this.createButtons();
        this.createDescriptionPanel();
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    @NotNull
    public final KtorPluginModel getFeatureModel() {
        return this.featureModel;
    }

    @NotNull
    protected final AddButton getMyAddButton() {
        AddButton addButton = this.myAddButton;
        if (addButton != null) {
            return addButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myAddButton");
        return null;
    }

    protected final void setMyAddButton(@NotNull AddButton addButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)addButton), (String)"<set-?>");
        this.myAddButton = addButton;
    }

    @NotNull
    protected final EventHandler.SelectionType getMySelection() {
        return this.mySelection;
    }

    protected final void setMySelection(@NotNull EventHandler.SelectionType selectionType) {
        Intrinsics.checkNotNullParameter((Object)selectionType, (String)"<set-?>");
        this.mySelection = selectionType;
    }

    @NotNull
    public final EventHandler.SelectionType getSelection() {
        return this.mySelection;
    }

    public final void setSelection(@NotNull EventHandler.SelectionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.setSelection(type, type == EventHandler.SelectionType.SELECTION);
    }

    @NotNull
    public final String getFeatureId() {
        return this.featureModel.getId();
    }

    public final void setSelection(@NotNull EventHandler.SelectionType type, boolean scrollAndFocus) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.mySelection = type;
        if (scrollAndFocus) {
            this.scrollToVisible();
            if (this.getParent() != null && type == EventHandler.SelectionType.SELECTION && HANDLE_FOCUS_ON_SELECTION) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> ListKtorPluginComponent.setSelection$lambda$0(this));
            }
        }
        this.updateColors(type);
        this.repaint();
    }

    private final void scrollToVisible() {
        Container container = this.getParent();
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent parent = (JComponent)container;
        Rectangle bounds = this.getBounds();
        if (!parent.getVisibleRect().contains(bounds)) {
            parent.scrollRectToVisible(bounds);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createButtons() {
        void it;
        AddButton addButton;
        AddButton addButton2 = addButton = new AddButton(this.featureModel);
        BaselineLayout baselineLayout = this.myLayout;
        boolean bl = false;
        this.setMyAddButton((AddButton)it);
        BaselineLayout.addButtonComponent$default(baselineLayout, (JComponent)((Object)addButton), 0, 2, null);
    }

    public final void setListeners(@NotNull KtorPluginEventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.myEventHandler = eventHandler;
        eventHandler.addAll(this);
    }

    private final void createDescriptionPanel() {
        JPanel panel = (JPanel)new NonOpaquePanel((LayoutManager)new TextHorizontalLayout(JBUIScale.scale((int)7)));
        panel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myLayout.addLineComponent(panel);
        this.myShortDescription = this.createDescriptionLabel(panel, this.featureModel.getShortDescription());
    }

    private final JLabel createDescriptionLabel(JPanel panel, String shortDescription) {
        JLabel label = new JLabel(shortDescription, 0);
        label.setOpaque(false);
        label.setIconTextGap(2);
        panel.add(PluginManagerConfigurable.setTinyFont((Component)label), null);
        return label;
    }

    protected final void updateColors(@NotNull EventHandler.SelectionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Color color = type == EventHandler.SelectionType.NONE ? PluginManagerConfigurable.MAIN_BG_COLOR : HOVER_COLOR;
        Intrinsics.checkNotNull((Object)color);
        this.updateColors(GRAY_COLOR, color);
    }

    protected final void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        JLabel jLabel;
        JLabel jLabel2;
        Color color;
        Intrinsics.checkNotNullParameter((Object)grayedFg, (String)"grayedFg");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.setBackground(background);
        Color nameForeground = null;
        Color otherForeground = grayedFg;
        boolean calcColor = true;
        if (this.mySelection != EventHandler.SelectionType.NONE && (color = UIManager.getColor("Plugins.selectionForeground")) != null) {
            nameForeground = otherForeground = color;
            calcColor = false;
        }
        if (calcColor && !this.featureModel.getSelected()) {
            otherForeground = DisabledColor;
        }
        if ((jLabel2 = this.myShortDescription) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myShortDescription");
            jLabel2 = null;
        }
        if ((jLabel = this.myShortDescription) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myShortDescription");
            jLabel = null;
        }
        jLabel.setForeground(otherForeground);
    }

    protected final void updateIcon() {
        this.myIconComponent.setIcon(this.featureModel.getIcon());
        this.myIconComponent.setDisabledIcon(this.featureModel.getIcon());
        this.myIconComponent.setEnabled(this.featureModel.getSelected());
        this.myIconComponent.setVerticalAlignment(1);
        this.myIconComponent.setOpaque(false);
        this.featureModel.onSelect((Function0<Unit>)((Function0)() -> ListKtorPluginComponent.updateIcon$lambda$0(this)));
        this.featureModel.onUnselect((Function0<Unit>)((Function0)() -> ListKtorPluginComponent.updateIcon$lambda$1(this)));
    }

    public final void handleKeyAction(int keyCode, @NotNull List<ListKtorPluginComponent> selection) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        switch (keyCode) {
            case 10: 
            case 32: {
                for (ListKtorPluginComponent component : selection) {
                    AddButton addButton = component.getMyAddButton();
                    if (addButton == null) continue;
                    addButton.doClick();
                }
                break;
            }
        }
    }

    private static final void setSelection$lambda$0(ListKtorPluginComponent this$0) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0, true);
    }

    private static final Unit _init_$lambda$0(ListKtorPluginComponent this$0) {
        this$0.moduleInfoMinimal.getSelectedPluginIds().add(this$0.featureModel.getId());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ListKtorPluginComponent this$0) {
        this$0.moduleInfoMinimal.getSelectedPluginIds().remove(this$0.featureModel.getId());
        return Unit.INSTANCE;
    }

    private static final Unit updateIcon$lambda$0(ListKtorPluginComponent this$0) {
        this$0.myIconComponent.setEnabled(true);
        this$0.myIconComponent.repaint();
        return Unit.INSTANCE;
    }

    private static final Unit updateIcon$lambda$1(ListKtorPluginComponent this$0) {
        this$0.myIconComponent.setEnabled(false);
        this$0.myIconComponent.repaint();
        return Unit.INSTANCE;
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"Plugins.disabledForeground", (Color)((Color)new JBColor(0xB1B1B1, 0x696969)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        DisabledColor = (Color)jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"Label.infoForeground", (Color)((Color)new JBColor((Color)Gray._120, (Color)Gray._135)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        GRAY_COLOR = (Color)jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"Plugins.lightSelectionBackground", (Color)((Color)new JBColor(0xF5F9FF, 3553595)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
        HOVER_COLOR = (Color)jBColor3;
        HANDLE_FOCUS_ON_SELECTION = true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\tJ\u001a\u0010$\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ktor/initializr/plugins/ListKtorPluginComponent$BaselineLayout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "<init>", "(Lcom/intellij/ktor/initializr/plugins/ListKtorPluginComponent;)V", "myHGap", "Lcom/intellij/util/ui/JBValue;", "myHOffset", "myButtonOffset", "myIconComponent", "Ljavax/swing/JComponent;", "myNameComponent", "Ljavax/swing/JLabel;", "myButtonComponents", "", "myLineComponents", "myButtonEnableStates", "", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "layoutContainer", "", "calculateNameWidth", "", "setBaselineBounds", "x", "y", "component", "Ljava/awt/Component;", "size", "setIconComponent", "iconComponent", "setNameComponent", "nameComponent", "addLineComponent", "addButtonComponent", "index", "intellij.ktor"})
    @SourceDebugExtension(value={"SMAP\nListKtorPluginComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListKtorPluginComponent.kt\ncom/intellij/ktor/initializr/plugins/ListKtorPluginComponent$BaselineLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public final class BaselineLayout
    extends AbstractLayoutManager {
        @NotNull
        private final JBValue myHGap = (JBValue)new JBValue.Float(10.0f);
        @NotNull
        private final JBValue myHOffset = (JBValue)new JBValue.Float(8.0f);
        @NotNull
        private final JBValue myButtonOffset = (JBValue)new JBValue.Float(6.0f);
        @Nullable
        private JComponent myIconComponent;
        @Nullable
        private JLabel myNameComponent;
        @NotNull
        private final List<JComponent> myButtonComponents = new ArrayList();
        @NotNull
        private final List<JComponent> myLineComponents = new ArrayList();
        @Nullable
        private boolean[] myButtonEnableStates;

        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            JLabel jLabel = this.myNameComponent;
            Intrinsics.checkNotNull((Object)jLabel);
            Dimension result = new Dimension(jLabel.getPreferredSize());
            int count = this.myButtonComponents.size();
            if (count > 0) {
                int visibleCount = 0;
                for (JComponent component : this.myButtonComponents) {
                    if (!component.isVisible()) continue;
                    Dimension size = component.getPreferredSize();
                    result.width += size.width;
                    result.height = Math.max(result.height, size.height);
                    ++visibleCount;
                }
                if (visibleCount > 0) {
                    result.width += this.myHOffset.get();
                    result.width += (visibleCount - 1) * this.myButtonOffset.get();
                }
            }
            for (JComponent component : this.myLineComponents) {
                if (!component.isVisible()) continue;
                Dimension size = component.getPreferredSize();
                result.width = Math.max(result.width, size.width);
                result.height += size.height;
            }
            JComponent jComponent = this.myIconComponent;
            Intrinsics.checkNotNull((Object)jComponent);
            Dimension iconSize = jComponent.getPreferredSize();
            result.width += iconSize.width + this.myHGap.get();
            result.height = Math.max(result.height, iconSize.height);
            JBInsets.addTo((Dimension)result, (Insets)ListKtorPluginComponent.this.getInsets());
            return result;
        }

        public void layoutContainer(@NotNull Container parent) {
            String string;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Insets insets = ListKtorPluginComponent.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            JComponent jComponent = this.myIconComponent;
            Intrinsics.checkNotNull((Object)jComponent);
            Dimension iconSize = jComponent.getPreferredSize();
            JComponent jComponent2 = this.myIconComponent;
            Intrinsics.checkNotNull((Object)jComponent2);
            jComponent2.setBounds(x, y, iconSize.width, iconSize.height);
            x += iconSize.width + this.myHGap.get();
            y += JBUIScale.scale((int)2);
            int calcNameWidth = this.calculateNameWidth();
            JLabel jLabel = this.myNameComponent;
            Intrinsics.checkNotNull((Object)jLabel);
            Dimension nameSize = jLabel.getPreferredSize();
            JLabel jLabel2 = this.myNameComponent;
            Intrinsics.checkNotNull((Object)jLabel2);
            int baseline = y + jLabel2.getBaseline(nameSize.width, nameSize.height);
            JLabel jLabel3 = this.myNameComponent;
            Intrinsics.checkNotNull((Object)jLabel3);
            if (calcNameWidth < nameSize.width) {
                JLabel jLabel4 = this.myNameComponent;
                Intrinsics.checkNotNull((Object)jLabel4);
                string = jLabel4.getText();
            } else {
                string = null;
            }
            jLabel3.setToolTipText(string);
            nameSize.width = Math.min(nameSize.width, calcNameWidth);
            JLabel jLabel5 = this.myNameComponent;
            Intrinsics.checkNotNull((Object)jLabel5);
            jLabel5.setBounds(x, y, nameSize.width, nameSize.height);
            y += nameSize.height;
            int width = ListKtorPluginComponent.this.getWidth();
            int lastX = width - insets.right;
            int n = ((Collection)this.myButtonComponents).size() + -1;
            if (0 <= n) {
                do {
                    int i;
                    Component component;
                    if (!(component = (Component)this.myButtonComponents.get(i = n--)).isVisible()) continue;
                    Dimension size = component.getPreferredSize();
                    Intrinsics.checkNotNull((Object)size);
                    this.setBaselineBounds(lastX -= size.width, baseline, component, size);
                    lastX -= this.myButtonOffset.get();
                } while (0 <= n);
            }
            int lineWidth = width - x - insets.right;
            for (JComponent jComponent3 : this.myLineComponents) {
                if (!jComponent3.isVisible()) continue;
                int lineHeight = jComponent3.getPreferredSize().height;
                jComponent3.setBounds(x, y, lineWidth, lineHeight);
                y += lineHeight;
            }
        }

        private final int calculateNameWidth() {
            Insets insets = ListKtorPluginComponent.this.getInsets();
            int n = ListKtorPluginComponent.this.getWidth() - insets.left - insets.right;
            JComponent jComponent = this.myIconComponent;
            Intrinsics.checkNotNull((Object)jComponent);
            int width = n - jComponent.getPreferredSize().width - this.myHGap.get();
            int visibleCount = 0;
            for (JComponent component : this.myButtonComponents) {
                if (!component.isVisible()) continue;
                width -= component.getPreferredSize().width;
                ++visibleCount;
            }
            width -= this.myButtonOffset.get() * (visibleCount - 1);
            if (visibleCount > 0) {
                width -= this.myHOffset.get();
            }
            return width;
        }

        private final void setBaselineBounds(int x, int y, Component component, Dimension size) {
            component.setBounds(x, y - component.getBaseline(size.width, size.height), size.width, size.height);
        }

        public final void setIconComponent(@NotNull JComponent iconComponent) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)iconComponent, (String)"iconComponent");
            boolean bl2 = bl = this.myIconComponent == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.myIconComponent = iconComponent;
            ListKtorPluginComponent.this.add(iconComponent);
        }

        /*
         * WARNING - void declaration
         */
        public final void setNameComponent(@NotNull JLabel nameComponent) {
            void it;
            JLabel jLabel;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)nameComponent, (String)"nameComponent");
            boolean bl2 = bl = this.myNameComponent == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            JLabel jLabel2 = jLabel = nameComponent;
            ListKtorPluginComponent listKtorPluginComponent = ListKtorPluginComponent.this;
            boolean bl3 = false;
            this.myNameComponent = it;
            listKtorPluginComponent.add(jLabel);
        }

        public final void addLineComponent(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.myLineComponents.add(component);
            ListKtorPluginComponent.this.add(component);
        }

        @JvmOverloads
        public final void addButtonComponent(@NotNull JComponent component, int index) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            if (this.myButtonComponents.isEmpty() || index == -1) {
                this.myButtonComponents.add(component);
            } else {
                this.myButtonComponents.add(index, component);
            }
            ListKtorPluginComponent.this.add(component);
        }

        public static /* synthetic */ void addButtonComponent$default(BaselineLayout baselineLayout, JComponent jComponent, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = -1;
            }
            baselineLayout.addButtonComponent(jComponent, n);
        }

        @JvmOverloads
        public final void addButtonComponent(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            BaselineLayout.addButtonComponent$default(this, component, 0, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ktor/initializr/plugins/ListKtorPluginComponent$Companion;", "", "<init>", "()V", "DisabledColor", "Ljava/awt/Color;", "getDisabledColor", "()Ljava/awt/Color;", "GRAY_COLOR", "getGRAY_COLOR", "HOVER_COLOR", "getHOVER_COLOR", "HANDLE_FOCUS_ON_SELECTION", "", "getHANDLE_FOCUS_ON_SELECTION", "()Z", "setHANDLE_FOCUS_ON_SELECTION", "(Z)V", "intellij.ktor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getDisabledColor() {
            return DisabledColor;
        }

        @NotNull
        public final Color getGRAY_COLOR() {
            return GRAY_COLOR;
        }

        @NotNull
        public final Color getHOVER_COLOR() {
            return HOVER_COLOR;
        }

        public final boolean getHANDLE_FOCUS_ON_SELECTION() {
            return HANDLE_FOCUS_ON_SELECTION;
        }

        public final void setHANDLE_FOCUS_ON_SELECTION(boolean bl) {
            HANDLE_FOCUS_ON_SELECTION = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

