/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.settings;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.starters.shared.TextValidationFunction;
import com.intellij.ide.starters.shared.ValidationFunctions;
import com.intellij.ide.util.NameGeneratorUtilKt;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.UIWizardUtil;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.initializr.KtorGeneratorWebAPI;
import com.intellij.ktor.initializr.KtorModuleBuilderKt;
import com.intellij.ktor.initializr.KtorModuleInfo;
import com.intellij.ktor.initializr.NameUtilsKt;
import com.intellij.ktor.initializr.json.KtorBuildSystem;
import com.intellij.ktor.initializr.json.KtorConfiguration;
import com.intellij.ktor.initializr.json.KtorEngine;
import com.intellij.ktor.initializr.json.KtorSettingOption;
import com.intellij.ktor.initializr.json.KtorVersion;
import com.intellij.ktor.initializr.json.ProjectSettings;
import com.intellij.ktor.initializr.json.ProjectSettingsTemplate;
import com.intellij.ktor.initializr.json.ProjectSettingsTemplateKt;
import com.intellij.ktor.initializr.settings.KtorProjectSettingsStep;
import com.intellij.ktor.initializr.settings.KtorProjectSettingsStepUtilsKt;
import com.intellij.ktor.utils.ComponentWithFieldValidation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.observable.util.BindUtil;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderDescriptor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cd\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001P\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u000eH\u0016J\u0010\u0010=\u001a\u00020;2\u0006\u0010\u000b\u001a\u00020\fH\u0002J;\u0010>\u001a\u00020;*\u00020?2-\u0010@\u001a)\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0B\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0B0Aj\b\u0012\u0004\u0012\u00020C`E\u00a2\u0006\u0002\bDH\u0002J\r\u0010F\u001a\u00070\u000e\u00a2\u0006\u0002\bGH\u0002J\b\u0010H\u001a\u00020\u000eH\u0002J\b\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020;H\u0016J\b\u0010L\u001a\u00020&H\u0016J\b\u0010M\u001a\u00020\u000eH\u0002J\b\u0010N\u001a\u00020;H\u0016J8\u0010O\u001a\u00020P\"\b\b\u0000\u0010Q*\u00020R2\u0006\u0010S\u001a\u00020\u000e2\u0017\u0010T\u001a\u0013\u0012\u0004\u0012\u0002HQ\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\bG0AH\u0002\u00a2\u0006\u0002\u0010UR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020&0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\"04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020$04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020(04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/ktor/initializr/settings/KtorProjectSettingsStep;", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "Lcom/intellij/ktor/utils/ComponentWithFieldValidation;", "moduleInfo", "Lcom/intellij/ktor/initializr/KtorModuleInfo;", "generatorAPI", "Lcom/intellij/ktor/initializr/KtorGeneratorWebAPI;", "wizardContext", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "<init>", "(Lcom/intellij/ktor/initializr/KtorModuleInfo;Lcom/intellij/ktor/initializr/KtorGeneratorWebAPI;Lcom/intellij/ide/util/projectWizard/WizardContext;)V", "projectSettingsTemplate", "Lcom/intellij/ktor/initializr/json/ProjectSettingsTemplate;", "baseDir", "", "getBaseDir", "()Ljava/lang/String;", "baseDir$delegate", "Lkotlin/Lazy;", "initialProjectName", "getInitialProjectName", "initialProjectName$delegate", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "projectNameProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "locationProperty", "canonicalPathProperty", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "buildSystemProperty", "Lcom/intellij/ktor/initializr/json/KtorBuildSystem;", "groupProperty", "artifactProperty", "ktorVersionProperty", "Lcom/intellij/ktor/initializr/json/KtorVersion;", "engineProperty", "Lcom/intellij/ktor/initializr/json/KtorEngine;", "addSamplesProperty", "", "configurationProperty", "Lcom/intellij/ktor/initializr/json/KtorConfiguration;", "gitProperty", "validatedTextComponents", "", "Ljavax/swing/JTextField;", "getValidatedTextComponents", "()Ljava/util/List;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "ktorVersionModel", "Ljavax/swing/DefaultComboBoxModel;", "serverEngineModel", "configurationModel", "mainPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "isDisposed", "disposeUIResources", "", "getHelpId", "createAppSettingsPanel", "createLocationField", "Lcom/intellij/ui/dsl/builder/Panel;", "withValidation", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "Lkotlin/ExtensionFunctionType;", "Lcom/intellij/ktor/initializr/settings/Validator;", "getLocationComment", "Lorg/jetbrains/annotations/Nls;", "calculateArtifactName", "getComponent", "Ljavax/swing/JComponent;", "updateDataModel", "validate", "getLocation", "updateStep", "createComboboxOptionRenderer", "com/intellij/ktor/initializr/settings/KtorProjectSettingsStep$createComboboxOptionRenderer$1", "T", "Lcom/intellij/ktor/initializr/json/KtorSettingOption;", "defaultId", "render", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lcom/intellij/ktor/initializr/settings/KtorProjectSettingsStep$createComboboxOptionRenderer$1;", "intellij.ktor"})
public final class KtorProjectSettingsStep
extends ModuleWizardStep
implements ComponentWithFieldValidation {
    @NotNull
    private final KtorModuleInfo moduleInfo;
    @NotNull
    private final KtorGeneratorWebAPI generatorAPI;
    @NotNull
    private final WizardContext wizardContext;
    private ProjectSettingsTemplate projectSettingsTemplate;
    @NotNull
    private final Lazy baseDir$delegate;
    @NotNull
    private final Lazy initialProjectName$delegate;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private final GraphProperty<String> projectNameProperty;
    @NotNull
    private final GraphProperty<String> locationProperty;
    @NotNull
    private final ObservableProperty<String> canonicalPathProperty;
    @NotNull
    private final GraphProperty<KtorBuildSystem> buildSystemProperty;
    @NotNull
    private final GraphProperty<String> groupProperty;
    @NotNull
    private final GraphProperty<String> artifactProperty;
    @NotNull
    private final GraphProperty<KtorVersion> ktorVersionProperty;
    @NotNull
    private final GraphProperty<KtorEngine> engineProperty;
    @NotNull
    private final GraphProperty<Boolean> addSamplesProperty;
    @NotNull
    private final GraphProperty<KtorConfiguration> configurationProperty;
    @NotNull
    private final GraphProperty<Boolean> gitProperty;
    @NotNull
    private final List<JTextField> validatedTextComponents;
    @NotNull
    private final DefaultComboBoxModel<KtorVersion> ktorVersionModel;
    @NotNull
    private final DefaultComboBoxModel<KtorEngine> serverEngineModel;
    @NotNull
    private final DefaultComboBoxModel<KtorConfiguration> configurationModel;
    @NotNull
    private final JBLoadingPanel mainPanel;
    private boolean isDisposed;

    public KtorProjectSettingsStep(@NotNull KtorModuleInfo moduleInfo, @NotNull KtorGeneratorWebAPI generatorAPI, @NotNull WizardContext wizardContext) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)generatorAPI, (String)"generatorAPI");
        Intrinsics.checkNotNullParameter((Object)wizardContext, (String)"wizardContext");
        this.moduleInfo = moduleInfo;
        this.generatorAPI = generatorAPI;
        this.wizardContext = wizardContext;
        this.baseDir$delegate = LazyKt.lazy(() -> KtorProjectSettingsStep.baseDir_delegate$lambda$0(this));
        this.initialProjectName$delegate = LazyKt.lazy(() -> KtorProjectSettingsStep.initialProjectName_delegate$lambda$0(this));
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.projectNameProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.projectNameProperty$lambda$0(this));
        this.locationProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.locationProperty$lambda$0(this));
        ObservableProperty[] observablePropertyArray = new ObservableProperty[]{this.projectNameProperty};
        this.canonicalPathProperty = PropertyOperationUtil.joinSystemDependentPath((ObservableProperty)((ObservableProperty)this.locationProperty), (ObservableProperty[])observablePropertyArray);
        this.buildSystemProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.buildSystemProperty$lambda$0(this));
        this.groupProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.groupProperty$lambda$0(this));
        this.artifactProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.artifactProperty$lambda$0(this));
        this.ktorVersionProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.ktorVersionProperty$lambda$0(this));
        this.engineProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.engineProperty$lambda$0(this));
        this.addSamplesProperty = this.propertyGraph.property((Object)true);
        this.configurationProperty = this.propertyGraph.lazyProperty(() -> KtorProjectSettingsStep.configurationProperty$lambda$0(this));
        this.gitProperty = (GraphProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)this.propertyGraph.property((Object)false)), (String)"NewProjectWizard.gitState");
        this.validatedTextComponents = new ArrayList();
        this.ktorVersionModel = new DefaultComboBoxModel();
        this.serverEngineModel = new DefaultComboBoxModel();
        this.configurationModel = new DefaultComboBoxModel();
        this.mainPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getParentDisposable(), 300L);
    }

    private final String getBaseDir() {
        Lazy lazy = this.baseDir$delegate;
        return (String)lazy.getValue();
    }

    private final String getInitialProjectName() {
        Lazy lazy = this.initialProjectName$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public List<JTextField> getValidatedTextComponents() {
        return this.validatedTextComponents;
    }

    @Override
    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.wizardContext.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        return disposable;
    }

    public void disposeUIResources() {
        this.isDisposed = true;
    }

    @NotNull
    public String getHelpId() {
        return "new_ktor_plugin";
    }

    private final void createAppSettingsPanel(ProjectSettingsTemplate projectSettingsTemplate) {
        this.artifactProperty.dependsOn((ObservableProperty)this.projectNameProperty, () -> KtorProjectSettingsStep.createAppSettingsPanel$lambda$0(this));
        this.artifactProperty.dependsOn((ObservableProperty)this.groupProperty, () -> KtorProjectSettingsStep.createAppSettingsPanel$lambda$1(this));
        DialogPanel panelWithComponents = UIWizardUtil.withVisualPadding((DialogPanel)BuilderKt.panel(arg_0 -> KtorProjectSettingsStep.createAppSettingsPanel$lambda$2(this, projectSettingsTemplate, arg_0)), (boolean)true);
        this.mainPanel.add((Component)panelWithComponents, (Object)"North");
    }

    private final void createLocationField(Panel $this$createLocationField, Function1<? super Cell<? extends TextFieldWithBrowseButton>, ? extends Cell<? extends TextFieldWithBrowseButton>> withValidation) {
        String string = UIBundle.message((String)"label.project.wizard.new.project.location", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createLocationField.row(string, arg_0 -> KtorProjectSettingsStep.createLocationField$lambda$0(this, withValidation, arg_0));
        $this$createLocationField.row("", arg_0 -> KtorProjectSettingsStep.createLocationField$lambda$1(this, arg_0)).bottomGap(BottomGap.SMALL);
    }

    private final String getLocationComment() {
        String string = StringUtil.shortenPathWithEllipsis((String)UiUtils.getPresentablePath((String)((String)this.canonicalPathProperty.get())), (int)60);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenPathWithEllipsis(...)");
        String shortPath = string;
        Object[] objectArray = new Object[]{this.wizardContext.isCreatingNewProjectInt(), shortPath};
        String string2 = UIBundle.message((String)"label.project.wizard.new.project.path.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private final String calculateArtifactName() {
        return this.groupProperty.get() + "." + NameUtilsKt.calculateMavenName((String)this.projectNameProperty.get());
    }

    @NotNull
    public JComponent getComponent() {
        this.mainPanel.getContentPanel().removeAll();
        this.mainPanel.startLoading();
        return (JComponent)this.mainPanel;
    }

    public void updateDataModel() {
        String projectName = (String)this.projectNameProperty.get();
        String string = NameUtilsKt.reversedDomain((String)this.groupProperty.get());
        Object object = this.engineProperty.get();
        Intrinsics.checkNotNull((Object)object);
        String string2 = ((KtorEngine)object).getId();
        String string3 = ((KtorBuildSystem)this.buildSystemProperty.get()).getId();
        Object object2 = this.ktorVersionProperty.get();
        Intrinsics.checkNotNull((Object)object2);
        this.moduleInfo.setProjectSettings(new ProjectSettings(projectName, string, string2, string3, ((KtorVersion)object2).getId(), "LAST_KOTLIN_VERSION"));
        String location = this.getLocation();
        File locationFile = new File(location);
        this.moduleInfo.setOutputLocation(locationFile);
        this.moduleInfo.setAddSamples((Boolean)this.addSamplesProperty.get());
        Object object3 = this.configurationProperty.get();
        Intrinsics.checkNotNull((Object)object3);
        this.moduleInfo.setConfigurationOption(((KtorConfiguration)object3).getId());
        this.moduleInfo.setGitIntegration((Boolean)this.gitProperty.get());
        this.wizardContext.setProjectFileDirectory(locationFile.getAbsolutePath());
        this.wizardContext.setProjectName(projectName);
    }

    public boolean validate() {
        if (!this.validateFields()) {
            return false;
        }
        File dir = new File(this.getLocation());
        if (dir.isDirectory()) {
            String[] stringArray = dir.list();
            if (stringArray == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(((Object[])stringArray).length == 0)) {
                boolean bl;
                Component component = (Component)this.mainPanel;
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)dir.getPath(), (String)"getPath(...)");
                if (Messages.showYesNoDialog((Component)component, (String)KtorStarterBundle.INSTANCE.message("ktor.folder.not.empty", objectArray), (String)KtorStarterBundle.INSTANCE.message("ktor.folder.not.empty.title", new Object[0]), (Icon)Messages.getWarningIcon()) == 0) {
                    FilesKt.deleteRecursively((File)dir);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }
        return true;
    }

    private final String getLocation() {
        String[] stringArray = new String[]{this.locationProperty.get(), this.projectNameProperty.get()};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    public void updateStep() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> KtorProjectSettingsStep.updateStep$lambda$0(this));
    }

    private final <T extends KtorSettingOption> createComboboxOptionRenderer.1 createComboboxOptionRenderer(String defaultId, Function1<? super T, String> render) {
        return new ColoredListCellRenderer<T>(render, defaultId){
            final /* synthetic */ Function1<T, String> $render;
            final /* synthetic */ String $defaultId;
            {
                this.$render = $render;
                this.$defaultId = $defaultId;
            }

            protected void customizeCellRenderer(JList<? extends T> list, T option, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter(option, (String)"option");
                this.append((String)this.$render.invoke(option));
                if (Intrinsics.areEqual((Object)option.getId(), (Object)this.$defaultId)) {
                    this.append(" ");
                    this.append(KtorStarterBundle.INSTANCE.message("ktor.wizard.combobox.default.tip", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        };
    }

    private static final String baseDir_delegate$lambda$0(KtorProjectSettingsStep this$0) {
        String string = this$0.wizardContext.getProjectFileDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectFileDirectory(...)");
        return string;
    }

    private static final String initialProjectName_delegate$lambda$0(KtorProjectSettingsStep this$0) {
        String string = this$0.wizardContext.getProjectName();
        if (string == null) {
            String string2 = this$0.getBaseDir();
            ProjectSettingsTemplate projectSettingsTemplate = this$0.projectSettingsTemplate;
            if (projectSettingsTemplate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsTemplate");
                projectSettingsTemplate = null;
            }
            string = ProjectWizardUtil.findNonExistingFileName((String)string2, (String)projectSettingsTemplate.getName().getDefault(), (String)"");
        }
        return string;
    }

    private static final String projectNameProperty$lambda$0(KtorProjectSettingsStep this$0) {
        return this$0.getInitialProjectName();
    }

    private static final String locationProperty$lambda$0(KtorProjectSettingsStep this$0) {
        String string = this$0.wizardContext.getProjectFileDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectFileDirectory(...)");
        return string;
    }

    private static final KtorBuildSystem buildSystemProperty$lambda$0(KtorProjectSettingsStep this$0) {
        ProjectSettingsTemplate projectSettingsTemplate = this$0.projectSettingsTemplate;
        if (projectSettingsTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsTemplate");
            projectSettingsTemplate = null;
        }
        return ProjectSettingsTemplateKt.defaultOption(projectSettingsTemplate.getBuildSystem());
    }

    private static final String groupProperty$lambda$0(KtorProjectSettingsStep this$0) {
        ProjectSettingsTemplate projectSettingsTemplate = this$0.projectSettingsTemplate;
        if (projectSettingsTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsTemplate");
            projectSettingsTemplate = null;
        }
        return NameUtilsKt.reversedDomain(projectSettingsTemplate.getCompanyWebsite().getDefault());
    }

    private static final String artifactProperty$lambda$0(KtorProjectSettingsStep this$0) {
        return this$0.calculateArtifactName();
    }

    private static final KtorVersion ktorVersionProperty$lambda$0(KtorProjectSettingsStep this$0) {
        ProjectSettingsTemplate projectSettingsTemplate = this$0.projectSettingsTemplate;
        if (projectSettingsTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsTemplate");
            projectSettingsTemplate = null;
        }
        return ProjectSettingsTemplateKt.defaultOption(projectSettingsTemplate.getKtorVersion());
    }

    private static final KtorEngine engineProperty$lambda$0(KtorProjectSettingsStep this$0) {
        ProjectSettingsTemplate projectSettingsTemplate = this$0.projectSettingsTemplate;
        if (projectSettingsTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsTemplate");
            projectSettingsTemplate = null;
        }
        return ProjectSettingsTemplateKt.defaultOption(projectSettingsTemplate.getEngine());
    }

    private static final KtorConfiguration configurationProperty$lambda$0(KtorProjectSettingsStep this$0) {
        ProjectSettingsTemplate projectSettingsTemplate = this$0.projectSettingsTemplate;
        if (projectSettingsTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsTemplate");
            projectSettingsTemplate = null;
        }
        return ProjectSettingsTemplateKt.defaultOption(projectSettingsTemplate.getConfiguration());
    }

    private static final String createAppSettingsPanel$lambda$0(KtorProjectSettingsStep this$0) {
        return this$0.calculateArtifactName();
    }

    private static final String createAppSettingsPanel$lambda$1(KtorProjectSettingsStep this$0) {
        return this$0.calculateArtifactName();
    }

    private static final Unit createAppSettingsPanel$lambda$2(KtorProjectSettingsStep this$0, ProjectSettingsTemplate $projectSettingsTemplate, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = UIBundle.message((String)"label.project.wizard.new.project.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> KtorProjectSettingsStep.createAppSettingsPanel$lambda$2$0(this$0, arg_0)).bottomGap(BottomGap.SMALL);
        if (this$0.wizardContext.isCreatingNewProject()) {
            this$0.createLocationField($this$panel, (Function1<? super Cell<? extends TextFieldWithBrowseButton>, ? extends Cell<? extends TextFieldWithBrowseButton>>)((Function1)arg_0 -> KtorProjectSettingsStep.createAppSettingsPanel$lambda$2$1(this$0, arg_0)));
        }
        KtorProjectSettingsStepUtilsKt.createTextField$default($this$panel, KtorStarterBundle.INSTANCE.message("label.group", new Object[0]), this$0.groupProperty, false, false, null, arg_0 -> KtorProjectSettingsStep.createAppSettingsPanel$lambda$2$2(this$0, arg_0), 28, null);
        KtorProjectSettingsStepUtilsKt.createTextField$default($this$panel, KtorStarterBundle.INSTANCE.message("label.artifact", new Object[0]), this$0.artifactProperty, false, false, null, null, 52, null);
        KtorProjectSettingsStepUtilsKt.createCombobox$default($this$panel, KtorStarterBundle.INSTANCE.message("label.server.engine", new Object[0]), this$0.serverEngineModel, $projectSettingsTemplate.getEngine().getOptions(), this$0.engineProperty, (ListCellRenderer)((Object)this$0.createComboboxOptionRenderer($projectSettingsTemplate.getEngine().getDefaultId(), KtorProjectSettingsStep::createAppSettingsPanel$lambda$2$3)), null, 32, null);
        String string2 = UIBundle.message((String)"label.project.wizard.new.project.add.sample.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        KtorProjectSettingsStepUtilsKt.createCheckbox$default($this$panel, string2, this$0.addSamplesProperty, null, 4, null);
        KtorProjectSettingsStepUtilsKt.createDocumentationLink($this$panel);
        Panel.collapsibleGroup$default((Panel)$this$panel, (String)KtorStarterBundle.INSTANCE.message("label.advanced.settings", new Object[0]), (boolean)false, arg_0 -> KtorProjectSettingsStep.createAppSettingsPanel$lambda$2$4($projectSettingsTemplate, this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createAppSettingsPanel$lambda$2$0(KtorProjectSettingsStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new TextValidationFunction[]{ValidationFunctions.CHECK_NOT_EMPTY, ValidationFunctions.CHECK_NO_RESERVED_WORDS, ValidationFunctions.CHECK_SIMPLE_NAME_FORMAT};
        this$0.withSpecialValidation(TextFieldKt.bindText((Cell)TextFieldKt.columns((Cell)$this$row.textField(), (int)25), (ObservableMutableProperty)((ObservableMutableProperty)this$0.projectNameProperty)), CollectionsKt.listOf((Object[])objectArray), ValidationFunctions.createLocationWarningValidator(this$0.locationProperty)).focused();
        NameGeneratorUtilKt.installNameGenerators((Row)$this$row, (String)KtorModuleBuilderKt.getModuleBuilderId(), (ObservableMutableProperty)((ObservableMutableProperty)this$0.projectNameProperty));
        return Unit.INSTANCE;
    }

    private static final Cell createAppSettingsPanel$lambda$2$1(KtorProjectSettingsStep this$0, Cell $this$createLocationField) {
        Intrinsics.checkNotNullParameter((Object)$this$createLocationField, (String)"$this$createLocationField");
        TextValidationFunction[] textValidationFunctionArray = new TextValidationFunction[2];
        Intrinsics.checkNotNullExpressionValue((Object)ValidationFunctions.CHECK_NOT_EMPTY, (String)"CHECK_NOT_EMPTY");
        Intrinsics.checkNotNullExpressionValue((Object)ValidationFunctions.CHECK_LOCATION_FOR_ERROR, (String)"CHECK_LOCATION_FOR_ERROR");
        return this$0.withSpecialValidation($this$createLocationField, textValidationFunctionArray);
    }

    private static final Cell createAppSettingsPanel$lambda$2$2(KtorProjectSettingsStep this$0, Cell $this$createTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$createTextField, (String)"$this$createTextField");
        TextValidationFunction[] textValidationFunctionArray = new TextValidationFunction[4];
        Intrinsics.checkNotNullExpressionValue((Object)ValidationFunctions.CHECK_NOT_EMPTY, (String)"CHECK_NOT_EMPTY");
        Intrinsics.checkNotNullExpressionValue((Object)ValidationFunctions.CHECK_NO_WHITESPACES, (String)"CHECK_NO_WHITESPACES");
        Intrinsics.checkNotNullExpressionValue((Object)ValidationFunctions.CHECK_GROUP_FORMAT, (String)"CHECK_GROUP_FORMAT");
        Intrinsics.checkNotNullExpressionValue((Object)ValidationFunctions.CHECK_NO_RESERVED_WORDS, (String)"CHECK_NO_RESERVED_WORDS");
        return this$0.withSpecialValidation($this$createTextField, textValidationFunctionArray);
    }

    private static final String createAppSettingsPanel$lambda$2$3(KtorEngine option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return option.getTitle();
    }

    private static final Unit createAppSettingsPanel$lambda$2$4(ProjectSettingsTemplate $projectSettingsTemplate, KtorProjectSettingsStep this$0, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        KtorProjectSettingsStepUtilsKt.createSelector($this$collapsibleGroup, KtorStarterBundle.INSTANCE.message("label.build.system", new Object[0]), (Collection)$projectSettingsTemplate.getBuildSystem().getOptions(), this$0.buildSystemProperty, KtorProjectSettingsStep::createAppSettingsPanel$lambda$2$4$0);
        KtorProjectSettingsStepUtilsKt.createCombobox$default($this$collapsibleGroup, KtorStarterBundle.INSTANCE.message("label.ktor.version", new Object[0]), this$0.ktorVersionModel, $projectSettingsTemplate.getKtorVersion().getOptions(), this$0.ktorVersionProperty, (ListCellRenderer)((Object)this$0.createComboboxOptionRenderer($projectSettingsTemplate.getKtorVersion().getDefaultId(), KtorProjectSettingsStep::createAppSettingsPanel$lambda$2$4$1)), null, 32, null);
        KtorProjectSettingsStepUtilsKt.createCombobox$default($this$collapsibleGroup, KtorStarterBundle.INSTANCE.message("label.configuration.in", new Object[0]), this$0.configurationModel, $projectSettingsTemplate.getConfiguration().getOptions(), this$0.configurationProperty, (ListCellRenderer)((Object)this$0.createComboboxOptionRenderer($projectSettingsTemplate.getConfiguration().getDefaultId(), KtorProjectSettingsStep::createAppSettingsPanel$lambda$2$4$2)), null, 32, null);
        return Unit.INSTANCE;
    }

    private static final String createAppSettingsPanel$lambda$2$4$0(KtorBuildSystem option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return option.getTitle();
    }

    private static final String createAppSettingsPanel$lambda$2$4$1(KtorVersion option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return option.getTitle();
    }

    private static final String createAppSettingsPanel$lambda$2$4$2(KtorConfiguration option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return option.getTitle();
    }

    private static final Unit createLocationField$lambda$0(KtorProjectSettingsStep this$0, Function1 $withValidation, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Object[] objectArray = new Object[1];
        String string = this$0.wizardContext.getPresentationName();
        if (string == null) {
            string = "project";
        }
        objectArray[0] = string;
        FileChooserDescriptor fileChooserDescriptor3 = fileChooserDescriptor2.withTitle(IdeBundle.message((String)"title.select.project.file.directory", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor3, (String)"withTitle(...)");
        BrowseFolderDescriptor fileChooserDescriptor4 = BrowseFolderDescriptor.Companion.withTextToPathConvertor((FileChooserDescriptor)BrowseFolderDescriptor.Companion.withPathToTextConvertor(fileChooserDescriptor3, (Function1)createLocationField.1.fileChooserDescriptor.1.INSTANCE), (Function1)createLocationField.1.fileChooserDescriptor.2.INSTANCE);
        ObservableMutableProperty property2 = PropertyOperationUtil.transform((ObservableMutableProperty)((ObservableMutableProperty)this$0.locationProperty), (Function1)createLocationField.1.property.1.INSTANCE, (Function1)createLocationField.1.property.2.INSTANCE);
        JEditorPane jEditorPane = Cell.comment$default((Cell)((Cell)$withValidation.invoke((Object)TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)((FileChooserDescriptor)fileChooserDescriptor4), (Project)this$0.wizardContext.getProject(), null, (int)4, null), (ObservableMutableProperty)property2).align((Align)AlignX.FILL.INSTANCE))), (String)this$0.getLocationComment(), (int)100, null, (int)4, null).getComment();
        Intrinsics.checkNotNull((Object)jEditorPane);
        JEditorPane commentLabel = jEditorPane;
        this$0.projectNameProperty.afterChange(arg_0 -> KtorProjectSettingsStep.createLocationField$lambda$0$1(commentLabel, this$0, arg_0));
        this$0.locationProperty.afterChange(arg_0 -> KtorProjectSettingsStep.createLocationField$lambda$0$2(commentLabel, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createLocationField$lambda$0$1(JEditorPane $commentLabel, KtorProjectSettingsStep this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $commentLabel.setText(this$0.getLocationComment());
        return Unit.INSTANCE;
    }

    private static final Unit createLocationField$lambda$0$2(JEditorPane $commentLabel, KtorProjectSettingsStep this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $commentLabel.setText(this$0.getLocationComment());
        return Unit.INSTANCE;
    }

    private static final Unit createLocationField$lambda$1(KtorProjectSettingsStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = UIBundle.message((String)"label.project.wizard.new.project.git.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (ObservableMutableProperty)((ObservableMutableProperty)this$0.gitProperty));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void updateStep$lambda$0(KtorProjectSettingsStep this$0) {
        try {
            ProjectSettingsTemplate projectSettingsTemplate;
            if (this$0.generatorAPI.getSettingsTemplate() == null) {
                return;
            }
            this$0.projectSettingsTemplate = projectSettingsTemplate;
            SwingUtilities.invokeLater(() -> KtorProjectSettingsStep.updateStep$lambda$0$0(this$0));
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(() -> KtorProjectSettingsStep.updateStep$lambda$0$1(e));
        }
        finally {
            SwingUtilities.invokeLater(() -> KtorProjectSettingsStep.updateStep$lambda$0$2(this$0));
        }
    }

    private static final void updateStep$lambda$0$0(KtorProjectSettingsStep this$0) {
        if (this$0.isDisposed) {
            return;
        }
        ProjectSettingsTemplate projectSettingsTemplate = this$0.projectSettingsTemplate;
        if (projectSettingsTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsTemplate");
            projectSettingsTemplate = null;
        }
        this$0.createAppSettingsPanel(projectSettingsTemplate);
    }

    private static final void updateStep$lambda$0$1(IOException $e) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)$e.getMessage());
        Messages.showErrorDialog((String)KtorStarterBundle.INSTANCE.message("message.failed.to.connect.start.ktor.io", objectArray), (String)KtorStarterBundle.INSTANCE.message("title.error", new Object[0]));
    }

    private static final void updateStep$lambda$0$2(KtorProjectSettingsStep this$0) {
        this$0.mainPanel.stopLoading();
        this$0.mainPanel.revalidate();
    }
}

