/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run;

import com.intellij.application.options.ModulesCombo;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.application.JavaSettingsEditorBase;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.CommonJavaFragments;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.TagButton;
import com.intellij.execution.ui.TargetPathFragment;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.run.KtorRunConfiguration;
import com.intellij.ktor.run.KtorRunConfigurationFragmentEditor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationEditor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0014J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\nH\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\nH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ktor/run/KtorRunConfigurationFragmentEditor;", "Lcom/intellij/execution/application/JavaSettingsEditorBase;", "Lcom/intellij/ktor/run/KtorRunConfiguration;", "runConfiguration", "<init>", "(Lcom/intellij/ktor/run/KtorRunConfiguration;)V", "customizeFragments", "", "fragments", "", "Lcom/intellij/execution/ui/SettingsEditorFragment;", "moduleClasspath", "Lcom/intellij/execution/ui/ModuleClasspathCombo;", "commonParameterFragments", "Lcom/intellij/execution/ui/CommonParameterFragments;", "providedScopeEditorTag", "Lcom/intellij/execution/ui/TagButton;", "createMainClass", "Lcom/intellij/execution/application/ClassEditorField;", "modulesCombo", "Lcom/intellij/application/options/ModulesCombo;", "enableDevelopmentModeTag", "intellij.ktor"})
public final class KtorRunConfigurationFragmentEditor
extends JavaSettingsEditorBase<KtorRunConfiguration> {
    public KtorRunConfigurationFragmentEditor(@NotNull KtorRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        super((JavaRunConfigurationBase)runConfiguration);
    }

    protected void customizeFragments(@NotNull List<SettingsEditorFragment<KtorRunConfiguration, ?>> fragments, @NotNull SettingsEditorFragment<KtorRunConfiguration, ModuleClasspathCombo> moduleClasspath, @NotNull CommonParameterFragments<KtorRunConfiguration> commonParameterFragments) {
        List<SettingsEditorFragment<KtorRunConfiguration, ?>> list;
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter(moduleClasspath, (String)"moduleClasspath");
        Intrinsics.checkNotNullParameter(commonParameterFragments, (String)"commonParameterFragments");
        List<SettingsEditorFragment<KtorRunConfiguration, ?>> $this$customizeFragments_u24lambda_u240 = list = fragments;
        boolean bl = false;
        $this$customizeFragments_u24lambda_u240.add((SettingsEditorFragment<KtorRunConfiguration, ?>)new TargetPathFragment());
        SettingsEditorFragment settingsEditorFragment = commonParameterFragments.programArguments();
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment, (String)"programArguments(...)");
        $this$customizeFragments_u24lambda_u240.add(settingsEditorFragment);
        $this$customizeFragments_u24lambda_u240.add(this.enableDevelopmentModeTag());
        $this$customizeFragments_u24lambda_u240.add(this.providedScopeEditorTag());
        JComponent jComponent = moduleClasspath.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component(...)");
        SettingsEditorFragment<KtorRunConfiguration, ClassEditorField> mainClassFragment = this.createMainClass((ModulesCombo)jComponent);
        $this$customizeFragments_u24lambda_u240.add(mainClassFragment);
        JComponent jComponent2 = moduleClasspath.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"component(...)");
        ModuleClasspathCombo moduleClasspathCombo = (ModuleClasspathCombo)jComponent2;
        JComponent jComponent3 = mainClassFragment.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"component(...)");
        DefaultJreSelector jreSelector = DefaultJreSelector.Companion.fromSourceRootsDependencies(moduleClasspathCombo, (EditorTextField)jComponent3);
        SettingsEditorFragment settingsEditorFragment2 = CommonJavaFragments.createJrePath((DefaultJreSelector)jreSelector);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment2, (String)"createJrePath(...)");
        SettingsEditorFragment jrePath = settingsEditorFragment2;
        $this$customizeFragments_u24lambda_u240.add(jrePath);
    }

    private final SettingsEditorFragment<KtorRunConfiguration, TagButton> providedScopeEditorTag() {
        SettingsEditorFragment settingsEditorFragment = SettingsEditorFragment.createTag((String)"include.provided", (String)ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), arg_0 -> KtorRunConfigurationFragmentEditor.providedScopeEditorTag$lambda$0(providedScopeEditorTag.1.INSTANCE, arg_0), (arg_0, arg_1) -> KtorRunConfigurationFragmentEditor.providedScopeEditorTag$lambda$1(providedScopeEditorTag.2.INSTANCE, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment, (String)"createTag(...)");
        return settingsEditorFragment;
    }

    private final SettingsEditorFragment<KtorRunConfiguration, ClassEditorField> createMainClass(ModulesCombo modulesCombo) {
        SettingsEditorFragment mainClassFragment;
        SettingsEditorFragment settingsEditorFragment;
        ClassEditorField mainClass;
        ClassEditorField classEditorField;
        Project project = this.getProject();
        ConfigurationModuleSelector moduleSelector2 = new ConfigurationModuleSelector(modulesCombo, project){

            public boolean isModuleAccepted(Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return KtorLibraryUtilKt.hasKtorServerLibrary(module);
            }
        };
        JavaCodeFragment.VisibilityChecker visibilityChecker = KotlinRunConfigurationEditor.VISIBILITY_CHECKER;
        ClassBrowser.AppClassBrowser classBrowser = new ClassBrowser.AppClassBrowser(this.getProject(), moduleSelector2);
        ClassEditorField classEditorField2 = ClassEditorField.createClassField((Project)this.getProject(), null, (JavaCodeFragment.VisibilityChecker)visibilityChecker, (BrowseModuleValueActionListener)((BrowseModuleValueActionListener)classBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)classEditorField2, (String)"createClassField(...)");
        ClassEditorField $this$createMainClass_u24lambda_u240 = classEditorField = (mainClass = classEditorField2);
        boolean bl = false;
        $this$createMainClass_u24lambda_u240.setBackground(UIUtil.getTextFieldBackground());
        $this$createMainClass_u24lambda_u240.setShowPlaceholderWhenFocused(true);
        CommonParameterFragments.setMonospaced((Component)((Component)$this$createMainClass_u24lambda_u240));
        CommandLinePanel.setMinimumWidth((Component)((Component)$this$createMainClass_u24lambda_u240), (int)300);
        String string = ExecutionBundle.message((String)"application.configuration.main.class.placeholder", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String placeholder = string;
        $this$createMainClass_u24lambda_u240.setPlaceholder((CharSequence)placeholder);
        $this$createMainClass_u24lambda_u240.getAccessibleContext().setAccessibleName(placeholder);
        $this$createMainClass_u24lambda_u240.addDocumentListener(new DocumentListener($this$createMainClass_u24lambda_u240, mainClass, moduleSelector2, modulesCombo){
            final /* synthetic */ ClassEditorField $this_apply;
            final /* synthetic */ ClassEditorField $mainClass;
            final /* synthetic */ createMainClass.moduleSelector.1 $moduleSelector;
            final /* synthetic */ ModulesCombo $modulesCombo;
            {
                this.$this_apply = $receiver;
                this.$mainClass = $mainClass;
                this.$moduleSelector = $moduleSelector;
                this.$modulesCombo = $modulesCombo;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project = this.$this_apply.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (DumbService.Companion.getInstance(project).isDumb()) {
                    return;
                }
                String string = this.$mainClass.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String mainClassName = string;
                if (this.$moduleSelector.getModule() != null && this.$moduleSelector.findClass(mainClassName) != null) {
                    return;
                }
                JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.$this_apply.getProject(), false);
                PsiClass psiClass = configurationModule.findClass(mainClassName);
                if (psiClass == null) {
                    return;
                }
                PsiClass psiClass2 = psiClass;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass2));
                if (module != null && this.$moduleSelector.isModuleAccepted(module)) {
                    this.$modulesCombo.setSelectedModule(module);
                }
            }
        });
        SettingsEditorFragment $this$createMainClass_u24lambda_u247 = settingsEditorFragment = (mainClassFragment = new SettingsEditorFragment("mainClass", ExecutionBundle.message((String)"application.configuration.main.class", (Object[])new Object[0]), null, (JComponent)mainClass, 20, (arg_0, arg_1) -> KtorRunConfigurationFragmentEditor.createMainClass$lambda$2(KtorRunConfigurationFragmentEditor::createMainClass$lambda$1, arg_0, arg_1), (arg_0, arg_1) -> KtorRunConfigurationFragmentEditor.createMainClass$lambda$4(KtorRunConfigurationFragmentEditor::createMainClass$lambda$3, arg_0, arg_1), arg_0 -> KtorRunConfigurationFragmentEditor.createMainClass$lambda$6(KtorRunConfigurationFragmentEditor::createMainClass$lambda$5, arg_0)));
        boolean bl2 = false;
        $this$createMainClass_u24lambda_u247.setRemovable(false);
        $this$createMainClass_u24lambda_u247.setEditorGetter(arg_0 -> KtorRunConfigurationFragmentEditor.createMainClass$lambda$7$1(KtorRunConfigurationFragmentEditor::createMainClass$lambda$7$0, arg_0));
        $this$createMainClass_u24lambda_u247.setValidation(arg_0 -> KtorRunConfigurationFragmentEditor.createMainClass$lambda$7$3(arg_0 -> KtorRunConfigurationFragmentEditor.createMainClass$lambda$7$2(mainClass, arg_0), arg_0));
        return mainClassFragment;
    }

    private final SettingsEditorFragment<KtorRunConfiguration, TagButton> enableDevelopmentModeTag() {
        SettingsEditorFragment developmentModeTag2;
        SettingsEditorFragment settingsEditorFragment;
        SettingsEditorFragment $this$enableDevelopmentModeTag_u24lambda_u243 = settingsEditorFragment = (developmentModeTag2 = SettingsEditorFragment.createTag((String)"ktor.development.mode", (String)KtorStarterBundle.INSTANCE.message("ktor.run.config.enable.development.mode.tag", new Object[0]), (String)KtorStarterBundle.INSTANCE.message("ktor.run.config.fragment.group", new Object[0]), arg_0 -> KtorRunConfigurationFragmentEditor.enableDevelopmentModeTag$lambda$0((Function1)enableDevelopmentModeTag.developmentModeTag.1.INSTANCE, arg_0), (arg_0, arg_1) -> KtorRunConfigurationFragmentEditor.enableDevelopmentModeTag$lambda$2(KtorRunConfigurationFragmentEditor::enableDevelopmentModeTag$lambda$1, arg_0, arg_1)));
        boolean bl = false;
        $this$enableDevelopmentModeTag_u24lambda_u243.setActionDescription(KtorStarterBundle.INSTANCE.message("ktor.run.config.enable.development.mode.tag.description", new Object[0]));
        $this$enableDevelopmentModeTag_u24lambda_u243.setActionHint(KtorStarterBundle.INSTANCE.message("ktor.run.config.enable.development.mode.tag.hint", new Object[0]));
        Intrinsics.checkNotNull((Object)developmentModeTag2);
        return developmentModeTag2;
    }

    private static final boolean providedScopeEditorTag$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void providedScopeEditorTag$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit createMainClass$lambda$1(KtorRunConfiguration configuration, ClassEditorField component) {
        component.setClassName(configuration.getMainClassName());
        return Unit.INSTANCE;
    }

    private static final void createMainClass$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit createMainClass$lambda$3(KtorRunConfiguration configuration, ClassEditorField component) {
        configuration.setMainClassName(component.getText());
        return Unit.INSTANCE;
    }

    private static final void createMainClass$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final boolean createMainClass$lambda$5(KtorRunConfiguration it) {
        return true;
    }

    private static final boolean createMainClass$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final JComponent createMainClass$lambda$7$0(ClassEditorField it) {
        Object object = it.getEditor();
        if (object == null || (object = object.getContentComponent()) == null) {
            object = (JComponent)it;
        }
        return object;
    }

    private static final JComponent createMainClass$lambda$7$1(Function1 $tmp0, Object p0) {
        return (JComponent)$tmp0.invoke(p0);
    }

    private static final List createMainClass$lambda$7$2(ClassEditorField $mainClass, KtorRunConfiguration it) {
        JComponent jComponent = (JComponent)$mainClass;
        Intrinsics.checkNotNull((Object)((Object)it));
        return CollectionsKt.listOf((Object)RuntimeConfigurationException.validate((JComponent)jComponent, () -> it.checkClass()));
    }

    private static final List createMainClass$lambda$7$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean enableDevelopmentModeTag$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit enableDevelopmentModeTag$lambda$1(KtorRunConfiguration configuration, Boolean value) {
        Intrinsics.checkNotNull((Object)value);
        configuration.setKtorDevelopmentMode(value);
        return Unit.INSTANCE;
    }

    private static final void enableDevelopmentModeTag$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

